/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.client.util.IDispatchPeriodSource;
import com.kingdee.eas.fi.gr.weaverpt.FormatJobProcessSettingAction;
import com.kingdee.eas.fi.rpt.RptCalcSchemeFactory;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShowDispatchPeriodSettingUI {
    protected Object owner;
    protected IDispatchPeriodSource taDispatchPeriod;
    protected Logger logger;

    public ShowDispatchPeriodSettingUI(Object owner, IDispatchPeriodSource dispatchPeriodSource, Logger logger) {
        this.owner = owner;
        this.taDispatchPeriod = dispatchPeriodSource;
        this.logger = logger;
    }

    public boolean show() throws EASBizException, BOSException {
        String tempSchedule;
        if (!this.taDispatchPeriod.needShow()) {
            return false;
        }
        ScheduleDef previousScheduleInfo = this.taDispatchPeriod.getUserObject();
        String previousSchedule = null;
        if (previousScheduleInfo == null && this.taDispatchPeriod.getJobProcess() != null) {
            previousScheduleInfo = this.parseJobProcess(this.taDispatchPeriod.getJobProcess());
            this.taDispatchPeriod.setUserObject(previousScheduleInfo);
        }
        if (previousScheduleInfo != null) {
            previousSchedule = KpdlParser.scheduleToString((ScheduleDef)previousScheduleInfo);
        }
        if ((tempSchedule = ProcessSchedulePlan.open((Object)this.owner, (String)previousSchedule, (boolean)false)) == null) {
            return false;
        }
        try {
            ScheduleDef scheduleDef = KpdlParser.parseSchedule((String)tempSchedule);
            this.logger.error((Object)("[WEAVE]tempSchedule:" + tempSchedule));
            ScheduleDef oldSetting = this.taDispatchPeriod.getUserObject();
            if (scheduleDef == null || scheduleDef.getDefine() == null || oldSetting != null && scheduleDef.getType() == oldSetting.getType() && scheduleDef.getDefine().equals(oldSetting.getDefine())) {
                return false;
            }
            String newSetting = new FormatJobProcessSettingAction().action(scheduleDef);
            this.taDispatchPeriod.setText(newSetting);
            this.taDispatchPeriod.setUserObject(scheduleDef);
            return true;
        }
        catch (WfKpdlParseException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            return false;
        }
    }

    private ScheduleDef parseJobProcess(String jobProcess) throws EASBizException, BOSException {
        Map map = RptCalcSchemeFactory.getRemoteInstance().getProcessDef(jobProcess);
        ScheduleDef schdef = null;
        if (map == null || map.isEmpty()) {
            return null;
        }
        schdef = new ScheduleDef(null);
        String define = (String)map.get("rpt_cacl_scheme_define");
        String[] defines = define.split(":");
        schdef.setType(ScheduleType.getEnum((String)defines[0]));
        schdef.setDefine(defines[1]);
        schdef.setBeginTime((Date)map.get("rpt_cacl_scheme_begintime"));
        schdef.setUseCalendar(RptUtil.isTrue(map.get("rpt_cacl_scheme_is_use_calendar ")));
        schdef.setOrgUnitId((String)map.get("rpt_cacl_scheme_org"));
        schdef.setInstructionType(1);
        return schdef;
    }
}

