/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ITransition;
import com.kingdee.eas.fi.gr.dynamic.dynainnerexch.CompanyCheckHandler;
import com.kingdee.eas.fi.gr.dynamic.dynainnerexch.SortHelper;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DynaNumberTransition4ListAll
implements ITransition {
    private DynaParamInfo paramInfo;
    private Context ctx;
    private Map<Object, Object> number_nameMapping;
    private Map<Object, Object> gradeMapping;
    private DynaParameters param;
    private Map<String, String> name2NumberCmpcache;
    private Set<String> companyNumberCache;
    private Map<String, String> cmpNum2LongNumCache;
    private Map<String, String> number2FullNameCmpcache;
    private Set<String> inUnitCompanyNameCache;
    private String ext = null;
    private boolean isCached = false;

    public DynaNumberTransition4ListAll(DynaParamInfo paramInfo, Context ctx, DynaParameters param, Map<Object, Object> number_nameMapping, Map<Object, Object> gradeMapping) {
        this.paramInfo = paramInfo;
        this.ctx = ctx;
        this.number_nameMapping = number_nameMapping;
        this.gradeMapping = gradeMapping;
        this.param = param;
        this.name2NumberCmpcache = new HashMap<String, String>();
        this.cmpNum2LongNumCache = new HashMap<String, String>();
        this.number2FullNameCmpcache = new HashMap<String, String>();
        this.companyNumberCache = new HashSet<String>();
        this.inUnitCompanyNameCache = new HashSet<String>();
        this.ext = "_" + ctx.getLocale().getLanguage();
    }

    public DynaNumberTransition4ListAll reUsedTransition(DynaParameters param, Map<Object, Object> number_nameMapping, Map<Object, Object> gradeMapping) {
        this.number_nameMapping = number_nameMapping;
        this.gradeMapping = gradeMapping;
        this.param = param;
        return this;
    }

    @Override
    public String[] transition(String singleNumber, String dnumber, String oname, Map<Object, Object> row) throws BOSException, SQLException {
        DynaSumMethodEnum method;
        String[] rowVal = new String[2];
        String name = dnumber;
        DynaSumMethodEnum dynaSumMethodEnum = method = this.paramInfo.dynaCslRptParamInfo == null ? this.param.getSumMethod() : this.paramInfo.dynaCslRptParamInfo.getSumMethod();
        if (DynaSumMethodEnum.SUM_BY_COMPANY.equals((Object)method)) {
            String companyNumber = this.getNumberByCompanyName(dnumber);
            if (!StringUtils.isEmpty((String)companyNumber)) {
                return new String[]{companyNumber, dnumber};
            }
            return new String[]{this.paramInfo.report.getOrgUnit().getNumber(), this.paramInfo.report.getOrgUnit().getName()};
        }
        String number = this.getNumberByName(this.number_nameMapping, dnumber);
        if (StringUtils.isEmpty((String)number)) {
            String[] names = DynaNumberTransition4ListAll.decodeDNumber(dnumber);
            if (dnumber.indexOf(91) != -1 && dnumber.indexOf("]") != -1) {
                if (DynaSumMethodEnum.LIST_NAME_COMPANY.equals((Object)method)) {
                    String companyNumber = this.getNumberByCompanyName(names[0]);
                    dnumber = this.getNumberByName(this.number_nameMapping, names[names.length - 1]);
                    number = dnumber + "[" + companyNumber + "]";
                    name = names[names.length - 1] + "[" + names[0] + "]";
                } else if (DynaSumMethodEnum.LIST_COMPANY_NAME.equals((Object)method)) {
                    String companyNumber = this.getNumberByCompanyName(names[0]);
                    dnumber = this.getNumberByName(this.number_nameMapping, names[names.length - 1]);
                    number = companyNumber + "[" + (StringUtils.isEmpty((String)dnumber) ? names[names.length - 1] : dnumber) + "]";
                } else if (DynaSumMethodEnum.LIST_DETAIL_COMP_NAME.equals((Object)method)) {
                    if (names.length == 2) {
                        String companyNumber = this.getNumberByCompanyName(names[0]);
                        dnumber = this.getNumberByName(this.number_nameMapping, names[names.length - 1]);
                        number = this.getNumberByCompanyName(names[0]) + "[" + (StringUtils.isEmpty((String)dnumber) ? names[names.length - 1] : dnumber) + "]";
                        row.put("COMPANY_NAME", names[0]);
                    } else if (names.length > 2) {
                        int site = dnumber.indexOf("]");
                        number = this.getNumberByCompanyName(names[0]) + "[" + dnumber.substring(site + 1) + "]";
                    } else {
                        name = dnumber;
                        number = dnumber;
                        row.put("COMPANY_NAME", oname);
                    }
                }
            } else {
                name = dnumber;
                number = dnumber;
                row.put("COMPANY_NAME", oname);
            }
        } else {
            String[] names = DynaNumberTransition4ListAll.decodeDNumber(dnumber);
            String[] numbers = DynaNumberTransition4ListAll.decodeDNumber(number);
            if (dnumber.indexOf(91) != -1 && dnumber.indexOf("]") != -1) {
                if (DynaSumMethodEnum.LIST_NAME_COMPANY.equals((Object)method)) {
                    name = names[names.length - 1] + "[" + names[0] + "]";
                    number = numbers[numbers.length - 1] + "[" + numbers[0] + "]";
                }
            } else {
                name = dnumber;
                number = dnumber;
                row.put("COMPANY_NAME", oname);
            }
        }
        if (!StringUtils.isEmpty((String)singleNumber)) {
            singleNumber = singleNumber.trim();
        }
        String grade = (String)this.gradeMapping.get(singleNumber);
        row.put("GRADE_NUMBER", grade);
        rowVal[0] = number;
        rowVal[1] = name;
        return rowVal;
    }

    private String getNumberByCompanyName(String name) throws BOSException, SQLException {
        if (!this.isCached) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select flongnumber from t_org_structure s where ftreeid = ? and funitid = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.paramInfo.report.getOrgTree().getId().toString(), this.paramInfo.report.getOrgUnit().getId().toString()});
            if (rs.next()) {
                String longnumber = rs.getString("flongnumber");
                sql.setLength(0);
                sql.append(" select distinct unit.fnumber,unit.flongnumber,unit.fIsUnion,unit.FEnglishName,");
                sql.append(" unit.fname").append(this.ext).append(" fname ,unit.fsimpleName,s.flongnumber slongnumber");
                sql.append(" from t_org_baseUnit unit \n");
                sql.append(" join t_org_structure s on unit.fid = s.funitid \n");
                if (this.paramInfo.isSupportCrossMerger) {
                    Map<OrgTreeInfo, Set<String>> companyMap = this.paramInfo.dynaCslRptParamInfo.getCompanyMap();
                    if (companyMap != null) {
                        Iterator<OrgTreeInfo> iter = companyMap.keySet().iterator();
                        OrgTreeInfo orgTreeInfo = null;
                        Set<String> companyIdSet = null;
                        String orgTreeId = null;
                        String companyIDs = null;
                        boolean isfirst = true;
                        StringBuffer str = new StringBuffer();
                        while (iter.hasNext()) {
                            orgTreeInfo = iter.next();
                            companyIdSet = companyMap.get(orgTreeInfo);
                            companyIDs = CslRptUtil.changeIdSet2String(companyIdSet);
                            orgTreeId = orgTreeInfo.getId().toString();
                            if (this.param != null && this.param.isOnlyListCompany() && this.param.getSumMethod().equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME)) {
                                companyIDs = CslRptUtil.expandCompanys(this.ctx, orgTreeId, companyIDs, true);
                            }
                            if (!isfirst) {
                                str.append(",");
                            } else {
                                isfirst = false;
                            }
                            str.append(companyIDs);
                        }
                        if (str.length() > 0) {
                            String basicTreeId = this.getBasicOrgTreeidByReportDate(this.paramInfo);
                            if (!StringUtils.isEmpty((String)basicTreeId)) {
                                sql.append(" where s.ftreeid in (?,'" + basicTreeId + "') \n");
                                sql.append(" or (s.ftreeid ='").append(orgTreeId).append("' and ").append("unit.fid in (").append(str.toString()).append("))");
                                sql.append(" or (s.ftreeid ='").append(basicTreeId).append("' and ").append("unit.fid in (").append(str.toString()).append("))");
                            } else {
                                sql.append(" where s.ftreeid = ? \n");
                                sql.append(" or (s.ftreeid ='").append(orgTreeId).append("' and ").append("unit.fid in (").append(str.toString()).append("))");
                            }
                        } else {
                            sql.append(" where s.ftreeid = ? \n");
                        }
                    }
                } else {
                    sql.append(" where s.ftreeid = ? \n");
                }
                rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.paramInfo.report.getOrgTree().getId().toString()});
                while (rs.next()) {
                    this.name2NumberCmpcache.put(rs.getString("fname"), rs.getString("fnumber"));
                    this.number2FullNameCmpcache.put(rs.getString("fnumber"), rs.getString("fname"));
                    String englishName = rs.getString("FEnglishName");
                    String simpleName = rs.getString("fsimpleName");
                    if (!StringUtils.isEmpty((String)englishName)) {
                        this.name2NumberCmpcache.put(rs.getString("FEnglishName"), rs.getString("fnumber"));
                    }
                    if (!StringUtils.isEmpty((String)simpleName)) {
                        this.name2NumberCmpcache.put(rs.getString("fsimpleName"), rs.getString("fnumber"));
                    }
                    if (rs.getBoolean("FisUnion")) continue;
                    this.companyNumberCache.add(rs.getString("fnumber"));
                    this.cmpNum2LongNumCache.put(rs.getString("fnumber"), rs.getString("flongnumber"));
                    if (!rs.getString("slongnumber").startsWith(longnumber)) continue;
                    this.inUnitCompanyNameCache.add(rs.getString("fname"));
                    if (!StringUtils.isEmpty((String)englishName)) {
                        this.inUnitCompanyNameCache.add(englishName);
                    }
                    if (StringUtils.isEmpty((String)simpleName)) continue;
                    this.inUnitCompanyNameCache.add(simpleName);
                }
            }
            this.isCached = true;
        }
        return this.name2NumberCmpcache.containsKey(name) ? this.name2NumberCmpcache.get(name) : name;
    }

    private String getBasicOrgTreeidByReportDate(DynaParamInfo paramInfo) throws BOSException, SQLException {
        Date reportDate = paramInfo.report.getReportDate();
        Timestamp reportTime = new Timestamp(reportDate.getTime());
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid \n");
        sql.append(" from t_org_tree \n");
        sql.append(" where ftype = 8 and fisbasic = 1 \n");
        sql.append(" and ((FStartDate >= ? and FStartDate<= ?) or ( FEndDate >=? and FEndDate <= ? ) or ( FStartDate <=? and FEndDate >= ? ) \n");
        sql.append(" or (FStartDate <= ? and FEndDate is null)) \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{reportTime, reportTime, reportTime, reportTime, reportTime, reportTime, reportTime});
        if (rs.next()) {
            String id = rs.getString("fid");
            return id;
        }
        return null;
    }

    public String getOwnerCompany(String longName) throws BOSException, SQLException {
        DynaSumMethodEnum method;
        String[] names = DynaNumberTransition4ListAll.decodeDNumber(longName);
        String sureName = "";
        DynaSumMethodEnum dynaSumMethodEnum = method = this.paramInfo.dynaCslRptParamInfo == null ? this.param.getSumMethod() : this.paramInfo.dynaCslRptParamInfo.getSumMethod();
        if (longName.indexOf(91) != -1 && longName.indexOf("]") != -1 && (DynaSumMethodEnum.LIST_COMPANY_NAME.equals((Object)method) || DynaSumMethodEnum.LIST_DETAIL_COMP_NAME.equals((Object)method)) && names.length >= 2) {
            sureName = names[names.length - 2];
        }
        if (!this.companyNumberCache.contains(this.getNumberByCompanyName(sureName))) {
            sureName = "";
        }
        return this.getFullNameOfCompany(sureName);
    }

    public String getOwnerAndTargCompNumNoSpeceilSign(String dyItemStr) throws BOSException, SQLException {
        String[] names = DynaNumberTransition4ListAll.decodeDNumber(dyItemStr);
        if (names != null && names.length >= 2) {
            String ownerComp = names[names.length - 2];
            String targComp = names[names.length - 1];
            ownerComp = this.getNumberByCompanyName(this.getShortNumber(ownerComp));
            targComp = this.getNumberByCompanyName(this.getNoSpeceilSignNum(this.getShortNumber(targComp)));
            return ownerComp + "[" + targComp + "]";
        }
        return dyItemStr;
    }

    private String getNoSpeceilSignNum(String number) {
        if (number != null && number.indexOf("@") != -1) {
            return number.substring(0, number.indexOf("@"));
        }
        return number;
    }

    private String getFullNameOfCompany(String sureName) throws BOSException, SQLException {
        if (!StringUtils.isEmpty((String)sureName) && this.companyNumberCache.contains(this.getNumberByCompanyName(sureName))) {
            String companyNum = this.getNumberByCompanyName(sureName);
            sureName = this.number2FullNameCmpcache.get(companyNum);
        }
        return sureName;
    }

    public String getOwnerCompAndTargCompStr(String dyItemStr, boolean needConvt2Num) throws BOSException, SQLException {
        String[] names = DynaNumberTransition4ListAll.decodeDNumber(dyItemStr);
        if (names != null && names.length >= 2) {
            String ownerComp = names[names.length - 2];
            String targComp = names[names.length - 1];
            if (needConvt2Num) {
                ownerComp = this.getNumberByCompanyName(this.getShortNumber(ownerComp));
                targComp = this.getNumberByCompanyName(this.getShortNumber(targComp));
                return ownerComp + "[" + targComp + "]";
            }
            return dyItemStr;
        }
        return dyItemStr;
    }

    private String getShortNumber(String longNum) {
        if (StringUtils.isEmpty((String)longNum) || longNum.indexOf(33) == -1) {
            return longNum;
        }
        String[] split = longNum.split("!");
        return split[split.length - 1];
    }

    private String getLongNumberByNumber(String number) {
        return this.cmpNum2LongNumCache.get(number);
    }

    public int getBoundTypeOfTargCompany(String name) {
        String targCompanyName = CompanyCheckHandler.decodeCompanyName((String)name);
        if (StringUtils.isEmpty((String)targCompanyName)) {
            return SortHelper.OUTBOUND_COMPANY;
        }
        if (this.inUnitCompanyNameCache.contains(targCompanyName)) {
            return SortHelper.INUUNIT_COMPANY;
        }
        if (this.name2NumberCmpcache.containsKey(targCompanyName)) {
            return SortHelper.INBOUND_COMPANY;
        }
        return SortHelper.OUTBOUND_COMPANY;
    }

    public String convt2ShortNumber(String dynaNumber) {
        String[] splitArr = DynaNumberTransition4ListAll.decodeDNumber(dynaNumber);
        if (splitArr.length >= 2) {
            dynaNumber = splitArr[splitArr.length - 1];
            String[] shortNumArr = dynaNumber.split("!");
            String shortNum = shortNumArr[shortNumArr.length - 1];
            if (!this.companyNumberCache.contains(shortNum)) {
                try {
                    shortNum = this.getNumberByCompanyName(shortNum);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return splitArr[splitArr.length - 2] + "[" + shortNum + "]";
        }
        return dynaNumber;
    }

    private String getNumberByName(Map<Object, Object> number_nameMapping, String name) {
        if (number_nameMapping.containsValue(name)) {
            for (Map.Entry<Object, Object> entry : number_nameMapping.entrySet()) {
                if (!name.equals((String)entry.getValue())) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public static String[] decodeDNumber(String dnumber) {
        char[] chars = dnumber.toCharArray();
        ArrayList<String> arrs = new ArrayList<String>();
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if ((chars[i] == ']' || chars[i] == '[') && name.length() > 0) {
                arrs.add(name.toString());
                name.setLength(0);
                continue;
            }
            if (chars[i] == '[' || chars[i] == ']') continue;
            name.append(chars[i]);
        }
        if (name.length() > 0) {
            arrs.add(name.toString());
        }
        String[] names = new String[arrs.size()];
        return arrs.toArray(names);
    }
}

