/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.util.SortedSpanArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReference;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ElimReportUtils {
    public static final String RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.ElimReportResource";

    public static String getResource4Client(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }

    public static String getResource4Server(String resName, Context ctx) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    public static ReportType getCslReportType(ReportBaseInfo reportBaseInfo) {
        RptSrcTypeEnum rptSrcType = reportBaseInfo.getSourceType();
        return ElimReportUtils.getCslReportType(rptSrcType);
    }

    private static ReportType getCslReportType(RptSrcTypeEnum rptSrcType) {
        int rptSrcTypeVal = rptSrcType.getValue();
        switch (rptSrcTypeVal) {
            case 1: 
            case 7: 
            case 10: 
            case 13: {
                return ReportType.IS_SINGLE_REPORT;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 42: {
                return ReportType.IS_CSL_REPORT;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 43: {
                return ReportType.IS_FASTMERGE_REPORT;
            }
        }
        return ReportType.IS_NOT_DEFIND_REPORT;
    }

    public static boolean isSupportGenElimRptOfCslRpt(ReportBaseInfo reportBaseInfo) {
        RptSrcTypeEnum srcType = reportBaseInfo.getSourceType();
        return srcType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || srcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT) || srcType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || srcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT_FASTMERGE);
    }

    public static boolean isSingleReport(ReportBaseInfo reportBaseInfo) {
        return ReportType.IS_SINGLE_REPORT.equals((Object)ElimReportUtils.getCslReportType(reportBaseInfo));
    }

    public static boolean isCslReport(ReportBaseInfo reportBaseInfo) {
        return ReportType.IS_CSL_REPORT.equals((Object)ElimReportUtils.getCslReportType(reportBaseInfo));
    }

    public static boolean isFastMergeReport(ReportBaseInfo reportBaseInfo) {
        return ReportType.IS_FASTMERGE_REPORT.equals((Object)ElimReportUtils.getCslReportType(reportBaseInfo));
    }

    public static boolean isFastMergeReport(RptSrcTypeEnum rptSrcType) {
        return ReportType.IS_FASTMERGE_REPORT.equals((Object)ElimReportUtils.getCslReportType(rptSrcType));
    }

    public static void combineKey(StringBuffer key, String keyItem) {
        key.append("[").append(keyItem == null ? "NULL" : keyItem).append("]");
    }

    public static boolean isSumByName(DynaSumMethodEnum sumMethod) {
        return DynaSumMethodEnum.SUM_BY_NAME.equals((Object)sumMethod) || DynaSumMethodEnum.SUM_BY_TEMPLATE.equals((Object)sumMethod);
    }

    public static boolean isSumByListDetail(DynaSumMethodEnum sumMethod) {
        return DynaSumMethodEnum.LIST_DETAIL_COMP_NAME.equals((Object)sumMethod) || DynaSumMethodEnum.LIST_COMPANY_NAME.equals((Object)sumMethod) || DynaSumMethodEnum.SUM_BY_COMPANY.equals((Object)sumMethod) || DynaSumMethodEnum.LIST_NAME_COMPANY.equals((Object)sumMethod);
    }

    public static Set<Integer> getRptSrcTypeSetOfElimRptInStatMerger() {
        HashSet<Integer> sourceTypeSet = new HashSet<Integer>(2);
        sourceTypeSet.add(42);
        sourceTypeSet.add(45);
        return sourceTypeSet;
    }

    public static Set<Integer> getRptSrcTypeSetOfElimRptInFastMerger() {
        HashSet<Integer> sourceTypeSet = new HashSet<Integer>(2);
        sourceTypeSet.add(43);
        sourceTypeSet.add(46);
        return sourceTypeSet;
    }

    public static int insertRows(Book book, Point basePoint, int insertRows) {
        if (book == null || basePoint == null) {
            return -1;
        }
        Sheet sheet = book.getActiveSheet();
        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
        if (param == null) {
            return -1;
        }
        int x = basePoint.y;
        int colSize = param.getDefaultCounter();
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int sumFormulaCount = indexHandle.getSumRangeCount();
        int insertBegin = x + colSize + sumFormulaCount;
        Row selectRow = sheet.getRow(insertBegin, true);
        sheet.getSheetOption().getSelection().clear();
        CellBlock cellBlock = CellBlock.getNewCellBlock((int)selectRow.getRow(), (int)selectRow.getMaxIntMark());
        sheet.getSheetOption().getSelection().changeSelection(cellBlock, 1);
        Selection sel = sheet.getSheetOption().getSelection();
        Selection.SelectIterator si = sel.getSelectIterator();
        while (si.hasNext()) {
            CellBlock cb = si.next();
            if (cb.isCol()) {
                return -1;
            }
            cb.setRow2(cb.getRow() + insertRows - 1);
        }
        SortedSpanArray spans = sel.toRowSpans();
        if (spans == null) {
            return -1;
        }
        Span span = (Span)spans.get(0);
        UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(span.getStart(), 0, span.getEnd(), selectRow.getMaxIntMark())).insert(true);
        return insertBegin;
    }

    public static RptSrcTypeEnum getDynaCslElimRptSrcTypeByMergeSoluId(String soluId) {
        if (StringUtils.isEmpty((String)soluId)) {
            return RptSrcTypeEnum.DYNACSLELIMREPORT;
        }
        try {
            FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(soluId));
            if (soluInfo.isIsSupportGroupReport()) {
                return RptSrcTypeEnum.DYNACSLELIMREPORT;
            }
            return RptSrcTypeEnum.DYNACSLELIMREPORT_FASTMERGE;
        }
        catch (Exception e) {
            return RptSrcTypeEnum.DYNACSLELIMREPORT;
        }
    }

    public static RptSrcTypeEnum getElimRptSrcTypeBySrcReportInfo(CslReportInfo srcRptInfo) {
        if (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)srcRptInfo.getSourceType())) {
            return RptSrcTypeEnum.DYNACSLELIMREPORT;
        }
        if (RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)srcRptInfo.getSourceType())) {
            return RptSrcTypeEnum.DYNACSLELIMREPORT_FASTMERGE;
        }
        if (RptSrcTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)srcRptInfo.getSourceType())) {
            return RptSrcTypeEnum.MULTIDYNAMICCSLELIMREPORT;
        }
        if (RptSrcTypeEnum.MULTIDYNAMICCSLREPORT_FASTMERGE.equals((Object)srcRptInfo.getSourceType())) {
            return RptSrcTypeEnum.MULTIDYNAMICCSLELIMREPORT_FASTMERGE;
        }
        return null;
    }

    public static boolean isSupportSumMethod(boolean isDyRptSaveUpdateItem4CM, Book book) {
        if (isDyRptSaveUpdateItem4CM) {
            return true;
        }
        DynaSumMethodEnum sumMethod = null;
        for (int ibook = 0; ibook < book.getSheetCount(); ++ibook) {
            sumMethod = DynamicTemplateUtility.getSheetSumMethod((Sheet)book.getSheet(ibook));
            if (sumMethod == null || ElimReportUtils.isSumByName(sumMethod) || DynaSumMethodEnum.LIST_DETAIL_COMP_NAME.equals((Object)sumMethod)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSumByGrade(Book book) {
        for (int ibook = 0; ibook < book.getSheetCount(); ++ibook) {
            Sheet sheet = book.getSheet(ibook);
            ArrayList basePoints = DynamicTemplateUtility.getBasePointList((Sheet)book.getSheet(ibook));
            for (int i = 0; i < basePoints.size(); ++i) {
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)((Point)basePoints.get(i)));
                if (!param.isGrade()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isElimReport(CslReportInfo rptInfo) {
        return rptInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT) || rptInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT_FASTMERGE);
    }

    public static void checkSupportGenElimRptCondition(Component parentUI, CslReportCollection cslColl) throws Exception {
        boolean isDyRptSaveUpdateItem4CM = CSLParamUtil.isDyRptSaveUpdateItem4CM(null);
        int size = cslColl.size();
        for (int i = 0; i < size; ++i) {
            if (RptSrcTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)cslColl.get(i).getSourceType())) continue;
            if (!ElimReportUtils.isSupportSumMethod(isDyRptSaveUpdateItem4CM, cslColl.get(i).getBook())) {
                MsgBox.showWarning((Component)parentUI, (String)ElimReportUtils.getResource4Client("SupportSumMethod"));
                SysUtil.abort();
            }
            if (!ElimReportUtils.isSumByGrade(cslColl.get(i).getBook())) continue;
            MsgBox.showWarning((Component)parentUI, (String)ElimReportUtils.getResource4Client("NotSupportSumByGrade"));
            SysUtil.abort();
        }
    }

    public static Map<Object, Object> getTableMap(DynaSumMethodEnum selectedItem, boolean onlyList, boolean isShowTotal, boolean isOnlyListCompany, Book book) throws Exception {
        HashMap<Object, Object> tableValues = new HashMap<Object, Object>();
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            Map tableMap = SumHelper.scanDynaTable(sheet, selectedItem, onlyList, isShowTotal, isOnlyListCompany);
            DynamicTemplateUtility.setSheetSumMethod((Sheet)sheet, (DynaSumMethodEnum)selectedItem);
            if (sheet == null) continue;
            tableValues.put(sheet.getID(), tableMap);
        }
        return tableValues;
    }

    public static Map<String, Sheet> getSheetTableMap(Book book) {
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            tables.put(book.getSheet(i).getID(), book.getSheet(i));
        }
        return tables;
    }

    public static Map<String, AsstActTypeCollection> collectAsstActTypeMap(Context ctx, Book book) throws BOSException {
        HashSet<Object> attributeSet = new HashSet<Object>();
        StringBuffer key = new StringBuffer();
        HashMap<String, AsstActTypeCollection> asstActTypeResultMap = new HashMap<String, AsstActTypeCollection>();
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            ArrayList list = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            for (int j = 0; list != null && j < list.size(); ++j) {
                Point point = (Point)list.get(j);
                CellReference cellReference = new CellReference(point.y, point.x);
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)point);
                AsstAccountUtils asstAccount = param.getAsstAccount();
                key.setLength(0);
                key.append(sheet.getID()).append("|").append(cellReference.getCol()).append("|").append(cellReference.getRow());
                attributeSet.clear();
                if (asstAccount != null && asstAccount.getAsstActTypeList() != null) {
                    for (AsstActTypeUtils asstActTypeUtil : asstAccount.getAsstActTypeList()) {
                        attributeSet.add(asstActTypeUtil.asstHGAttribute);
                    }
                }
                if (attributeSet.size() <= 0) continue;
                AsstActTypeCollection asstActTypeCollection = ElimReportUtils.queryAsstActType(ctx, attributeSet);
                asstActTypeResultMap.put(key.toString(), asstActTypeCollection);
            }
        }
        return asstActTypeResultMap;
    }

    private static AsstActTypeCollection queryAsstActType(Context ctx, Set<Object> attributeSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", attributeSet, CompareType.INCLUDE));
        IAsstActType iAsstActType = ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)ctx);
        AsstActTypeCollection asstActTypeCollection = iAsstActType.getAsstActTypeCollection(view);
        return asstActTypeCollection;
    }

    public static boolean isMultiCslElimReport(RptSrcTypeEnum rptSrcTypeEnum) {
        if (rptSrcTypeEnum == null) {
            return false;
        }
        return rptSrcTypeEnum == RptSrcTypeEnum.MULTIDYNAMICCSLELIMREPORT || rptSrcTypeEnum == RptSrcTypeEnum.MULTIDYNAMICCSLELIMREPORT_FASTMERGE;
    }

    private static enum ReportType {
        IS_NOT_DEFIND_REPORT,
        IS_SINGLE_REPORT,
        IS_CSL_REPORT,
        IS_FASTMERGE_REPORT;

    }
}

