/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.BuildElimRptBookInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IElimReportGenerate;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.MultiRptFillDataUtils;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import java.util.Map;

public class MultiCslElimRptGenerate
implements IElimReportGenerate {
    @Override
    public void generateElimReportBookStructure(BuildElimRptBookInfo buildInfo) throws Exception {
        CslReportInfo srcReportInfo = buildInfo.getSrcCslRptInfo();
        int precision = RptCalcHelper.getPrecisionByCry(buildInfo.getCtx(), srcReportInfo.getCurrency());
        Book book = buildInfo.getElimRptInfo().getBook();
        this.removeBookProtect(book);
        Map<String, Sheet> tables = ElimReportUtils.getSheetTableMap(book);
        this.setValue2Null(buildInfo.getQueryResult());
        MultiRptFillDataUtils.fillDynaData(srcReportInfo.getSourceType(), tables, buildInfo.getTableScanValues(), buildInfo.getQueryResult(), precision, buildInfo);
        book.calc();
        buildInfo.getElimRptInfo().setBook(book);
    }

    private void removeBookProtect(Book book) {
        String proPass = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro == null || !pro.isProtected()) continue;
            proPass = pro.getEncryptedPassword();
            pro.setPassword(proPass);
            pro.stop(proPass);
        }
    }

    protected void setValue2Null(Map<Object, Object> queryResult) {
        if (queryResult == null || queryResult.size() == 0) {
            return;
        }
        for (Map.Entry<Object, Object> sheetEntry : queryResult.entrySet()) {
            Map sheetMap = (Map)sheetEntry.getValue();
            if (sheetMap == null) continue;
            for (Map.Entry pointEntry : sheetMap.entrySet()) {
                Map pointMap = (Map)pointEntry.getValue();
                if (pointMap == null) continue;
                for (Map.Entry rowEntry : pointMap.entrySet()) {
                    Map rowMap;
                    if (!(rowEntry.getValue() instanceof Map) || (rowMap = (Map)rowEntry.getValue()) == null) continue;
                    for (Map.Entry entry : rowMap.entrySet()) {
                        Map valueMap = (Map)entry.getValue();
                        if (valueMap == null) continue;
                        for (Map.Entry entry2 : valueMap.entrySet()) {
                            Object value = entry2.getValue();
                            if (value == null || !(value instanceof Number)) continue;
                            entry2.setValue(Variant.emptyVariant);
                        }
                    }
                }
            }
        }
    }
}

