/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel.export;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.ui.EventQueue;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.excel.export.MyXSSFWorksheetWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class MyXSSFWorkbookWrapper {
    public static final Logger log = LogUtil.getPackageLogger(MyXSSFWorkbookWrapper.class);
    public static boolean DEBUG = false;
    public static boolean NOTIFY = true;
    private AbstractDataWrapper _dataSource;
    private File _tmpBook;
    MyXSSFWorkbookAdapter _host;
    EventQueue _queue;
    Set context = new HashSet();
    long startTime_All;
    long startTime_Repack;
    File _tmpBookXml;
    FileOutputStream _tmpBookXmlStream;

    public MyXSSFWorkbookWrapper(AbstractDataWrapper dataSource) {
        this._host = new MyXSSFWorkbookAdapter();
        this._dataSource = dataSource;
        int sheetCount = dataSource.getSheetCount();
        int j = 0;
        boolean isExportHideSheet = true;
        for (int i = 0; i < sheetCount; ++i) {
            String sheetName = dataSource.sheetName(i);
            if (StringUtil.isEmptyString((String)sheetName)) {
                isExportHideSheet = false;
                ++j;
                continue;
            }
            this.createSheet(sheetName, i, i - j);
        }
        if (sheetCount - j > 1 && isExportHideSheet) {
            this._host.getCTWorkbook().getBookViews().getWorkbookViewArray(0).setFirstSheet((long)dataSource.getFirstVisibleSheetIndex());
        }
    }

    private void createSheet(String sheetname, int index, int j) {
        XSSFSheet sheet = this._host.createSheet(sheetname);
        String rId = this._host.getRelationId((POIXMLDocumentPart)sheet);
        this._host.removeHostRelation((POIXMLDocumentPart)sheet);
        this._host.setSheetHidden(j, this._dataSource.isHideSheet(index));
        if (sheetname.equals(this._dataSource.sheetName(this._dataSource.getActiveSheetIndex()))) {
            this._host.setActiveSheet(j);
            this._host.setFirstVisibleTab(j);
            this._host.setSelectedTab(j);
        }
        MyXSSFWorksheetWrapper wrapper = new MyXSSFWorksheetWrapper(this, sheet, this._dataSource, index);
        this._host.addRelation(rId, (POIXMLRelation)XSSFRelation.WORKSHEET, wrapper);
    }

    public XSSFSheet createSheet(String sheetName) {
        throw new UnsupportedOperationException("unsupported!");
    }

    public void removeSheetAt(int index) {
        throw new UnsupportedOperationException("unsupported!");
    }

    protected void commit() throws IOException {
        int i;
        List relations = this._host.getRelations();
        int size = relations.size();
        for (i = 0; i < size && !(relations.get(i) instanceof MyXSSFWorksheetWrapper); ++i) {
            this._host.removeHostRelation((POIXMLDocumentPart)relations.get(i));
        }
        for (i = 0; i < size && !(relations.get(i) instanceof MyXSSFWorksheetWrapper); ++i) {
            POIXMLDocumentPart part = (POIXMLDocumentPart)relations.get(i);
            String rId = this._host.getRelationId(part);
            this._host.addRelation(rId, (POIXMLRelation)XSSFRelation.WORKBOOK, part);
        }
        this._host.addRelation(String.valueOf(this._host.getRelations().size()), (POIXMLRelation)XSSFRelation.WORKBOOK, (POIXMLDocumentPart)this._host);
    }

    private boolean isSheetDataXml(ZipEntry entry) {
        if (!entry.isDirectory()) {
            String name = entry.getName().toLowerCase(Locale.getDefault());
            int len = this._dataSource.sheetCount();
            for (int i = 0; i < len; ++i) {
                if (!name.endsWith("sheet" + (i + 1) + ".xml")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isWorkbookXml(ZipEntry entry) {
        return !entry.isDirectory() && entry.getName().toLowerCase(Locale.ENGLISH).endsWith("workbook.xml");
    }

    private void addEmbed() {
        int sheetCount = this._dataSource.getSheetCount();
        int k = 0;
        for (int j = 0; j < sheetCount; ++j) {
            String sheetName = this._dataSource.sheetName(j);
            if (StringUtil.isEmptyString((String)sheetName)) {
                ++k;
                continue;
            }
            this._dataSource.setCurrentSheetIndex(j);
            int eoCount = this._dataSource.getEmbedObjectsCount();
            for (int i = 0; i < eoCount; ++i) {
                AbstractDataWrapper.EmbedObject eo = this._dataSource.getEmbedObject(i);
                if (eo == null || eo.getImageDatas() == null) continue;
                int pic = this._host.addPicture(eo.getImageDatas(), 6);
                XSSFDrawing drawing = this._host.getSheetAt(j - k).createDrawingPatriarch();
                XSSFClientAnchor anchor = new XSSFClientAnchor(eo.getDx1(), eo.getDy1(), eo.getDx2(), eo.getDy2(), eo.getCol(), eo.getRow(), eo.getCol2(), eo.getRow2());
                drawing.createPicture(anchor, pic);
                String rId = String.valueOf(this._host.getRelations().size());
                this._host.addRelation(rId, (POIXMLRelation)XSSFRelation.DRAWINGS, (POIXMLDocumentPart)drawing);
            }
        }
    }

    public void write(OutputStream os) throws IOException {
        this.startTime_All = System.currentTimeMillis();
        FileOutputStream out = null;
        try {
            if (this._queue != null && NOTIFY) {
                this._queue.enQueue(new ExportEvent("export workbook", "add embedObjects"));
            }
            this._dataSource.configSourceRepaint(false);
            this._tmpBook = File.createTempFile("tmp", ".xlsx");
            out = new FileOutputStream(this._tmpBook);
            this.writeToWorkbook();
            this.addEmbed();
            if (this._queue != null && NOTIFY) {
                this._queue.enQueue(new ExportEvent("export workbook", "fill sheet datas"));
            }
            this.commit();
            this._host.write(out);
            if (this._queue != null && NOTIFY) {
                this._queue.enQueue(new ExportEvent("export workbook", "merge sheet files"));
            }
            if (DEBUG) {
                this.startTime_Repack = System.currentTimeMillis();
            }
            this.close(os);
            if (DEBUG) {
                log.info((Object)("------------merge and repack file consuming " + (System.currentTimeMillis() - this.startTime_Repack) + " ms---------------"));
            }
            if (this._queue != null && NOTIFY) {
                this._queue.enQueue(new ExportEvent("export workbook", "delete garbages"));
            }
            this._tmpBook.delete();
            this._dataSource.configSourceRepaint(true);
            if (this._queue != null && NOTIFY) {
                this._queue.complete(new ExportEvent("export workbook", "(" + (System.currentTimeMillis() - this.startTime_All) + " ms consumed)!"));
            }
            this._tmpBook = null;
            out.flush();
        }
        catch (Throwable throwable) {
            CslRptUtil.close(out);
            throw throwable;
        }
        CslRptUtil.close(out);
        if (DEBUG) {
            log.info((Object)("------------export book consuming " + (System.currentTimeMillis() - this.startTime_All) + " ms---------------"));
        }
    }

    private void writeToWorkbook() throws IOException {
        XmlOptions options = new XmlOptions();
        options.setSaveSyntheticDocumentElement(new QName(CTWorksheet.type.getName().getNamespaceURI(), "workbook"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        options.setSaveSuggestedPrefixes(map);
        this._tmpBookXml = File.createTempFile("tmp_workbook", ".xml");
        this._tmpBookXmlStream = new FileOutputStream(this._tmpBookXml);
        this._tmpBookXmlStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
        this._tmpBookXmlStream.write(this._host.getCTWorkbook().newCursor().xmlText(options).getBytes("UTF-8"));
        this._tmpBookXmlStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(String filePath) throws IOException {
        File dst = new File(filePath);
        ZipFile zip = null;
        ZipOutputStream zos = null;
        FileOutputStream outs = null;
        try {
            zip = new ZipFile(this._tmpBook);
            outs = new FileOutputStream(dst);
            zos = new ZipOutputStream(outs);
            Enumeration<? extends ZipEntry> e = zip.entries();
            byte[] buffer = new byte[2048];
            int len = 0;
            List relations = this._host.getRelations();
            int size = relations.size();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (this.isSheetDataXml(entry) || this.isWorkbookXml(entry)) continue;
                zos.putNextEntry(entry);
                InputStream in = zip.getInputStream(entry);
                try {
                    while ((len = in.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                        zos.flush();
                    }
                }
                finally {
                    CslRptUtil.close(in);
                    this.closeOfZipOutputStream(zos);
                }
            }
            for (int i = 0; i < size; ++i) {
                Object obj = relations.get(i);
                if (obj instanceof MyXSSFWorksheetWrapper) {
                    MyXSSFWorksheetWrapper sheet = (MyXSSFWorksheetWrapper)((Object)obj);
                    File sheetTmp = sheet.getTmpFile();
                    FileInputStream in = null;
                    ZipEntry zipEntry = new ZipEntry("xl/worksheets/sheet" + (i + 1) + ".xml");
                    zos.putNextEntry(zipEntry);
                    try {
                        in = new FileInputStream(sheetTmp);
                        while ((len = in.read(buffer)) != -1) {
                            zos.write(buffer, 0, len);
                            zos.flush();
                        }
                    }
                    catch (Throwable throwable) {
                        CslRptUtil.close(in);
                        this.closeOfZipOutputStream(zos);
                        sheetTmp.delete();
                        throw throwable;
                    }
                    CslRptUtil.close(in);
                    this.closeOfZipOutputStream(zos);
                    sheetTmp.delete();
                    continue;
                }
                if (!(obj instanceof XSSFWorkbook)) continue;
                FileInputStream in = null;
                zos.putNextEntry(new ZipEntry("xl/workbook.xml"));
                try {
                    in = new FileInputStream(this._tmpBookXml);
                    while ((len = in.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                        zos.flush();
                    }
                }
                catch (Throwable throwable) {
                    CslRptUtil.close(in);
                    this.closeOfZipOutputStream(zos);
                    this._tmpBookXml.delete();
                    this._tmpBookXmlStream.close();
                    this._tmpBookXml = null;
                    this._tmpBookXmlStream = null;
                    throw throwable;
                }
                CslRptUtil.close(in);
                this.closeOfZipOutputStream(zos);
                this._tmpBookXml.delete();
                this._tmpBookXmlStream.close();
                this._tmpBookXml = null;
                this._tmpBookXmlStream = null;
            }
            zos.flush();
        }
        catch (Throwable throwable) {
            CslRptUtil.close(zos);
            CslRptUtil.close(outs);
            CslRptUtil.close(zip);
            throw throwable;
        }
        CslRptUtil.close(zos);
        CslRptUtil.close(outs);
        CslRptUtil.close(zip);
    }

    private void closeOfZipOutputStream(ZipOutputStream zos) throws IOException {
        try {
            zos.closeEntry();
        }
        finally {
            CslRptUtil.close(zos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(OutputStream os) throws IOException {
        ZipFile zip = null;
        ZipOutputStream zos = null;
        try {
            zip = new ZipFile(this._tmpBook);
            zos = new ZipOutputStream(os);
            Enumeration<? extends ZipEntry> e = zip.entries();
            byte[] buffer = new byte[2048];
            int len = 0;
            List relations = this._host.getRelations();
            int size = relations.size();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (this.isSheetDataXml(entry) || this.isWorkbookXml(entry)) continue;
                zos.putNextEntry(entry);
                InputStream in = zip.getInputStream(entry);
                try {
                    while ((len = in.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                        zos.flush();
                    }
                }
                finally {
                    CslRptUtil.close(in);
                    zos.closeEntry();
                }
            }
            for (int i = 0; i < size; ++i) {
                Object obj = relations.get(i);
                if (obj instanceof MyXSSFWorksheetWrapper) {
                    MyXSSFWorksheetWrapper sheet = (MyXSSFWorksheetWrapper)((Object)obj);
                    File sheetTmp = sheet.getTmpFile();
                    FileInputStream in = null;
                    ZipEntry zipEntry = new ZipEntry("xl/worksheets/sheet" + (i + 1) + ".xml");
                    zos.putNextEntry(zipEntry);
                    try {
                        in = new FileInputStream(sheetTmp);
                        while ((len = in.read(buffer)) != -1) {
                            zos.write(buffer, 0, len);
                            zos.flush();
                        }
                    }
                    catch (Throwable throwable) {
                        CslRptUtil.close(in);
                        zos.closeEntry();
                        sheetTmp.delete();
                        throw throwable;
                    }
                    CslRptUtil.close(in);
                    zos.closeEntry();
                    sheetTmp.delete();
                    continue;
                }
                if (!(obj instanceof XSSFWorkbook)) continue;
                FileInputStream in = null;
                zos.putNextEntry(new ZipEntry("xl/workbook.xml"));
                try {
                    in = new FileInputStream(this._tmpBookXml);
                    while ((len = in.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                        zos.flush();
                    }
                }
                catch (Throwable throwable) {
                    CslRptUtil.close(in);
                    zos.closeEntry();
                    this._tmpBookXml.delete();
                    this._tmpBookXmlStream.close();
                    this._tmpBookXml = null;
                    this._tmpBookXmlStream = null;
                    throw throwable;
                }
                CslRptUtil.close(in);
                zos.closeEntry();
                this._tmpBookXml.delete();
                this._tmpBookXmlStream.close();
                this._tmpBookXml = null;
                this._tmpBookXmlStream = null;
            }
            zos.flush();
            os.flush();
        }
        catch (Throwable throwable) {
            CslRptUtil.close(zos);
            CslRptUtil.close(zip);
            CslRptUtil.close(os);
            throw throwable;
        }
        CslRptUtil.close(zos);
        CslRptUtil.close(zip);
        CslRptUtil.close(os);
    }

    public void setQueue(EventQueue queue) {
        this._queue = queue;
    }

    class MyXSSFWorkbookAdapter
    extends XSSFWorkbook {
        MyXSSFWorkbookAdapter() {
        }

        public void removeHostRelation(POIXMLDocumentPart part) {
            super.removeRelation(part, false);
        }
    }
}

