/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.inspect.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFactory;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.inspect.client.AbstractCslInspectToolUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CslInspectToolUI
extends AbstractCslInspectToolUI {
    private static final Logger logger = CoreUIObject.getLogger(CslInspectToolUI.class);
    public String RES_PATH = "com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectToolResource.";
    private boolean isExecuteShow = true;
    private Map<String, List<Object>> results = new HashMap<String, List<Object>>();
    public String[] logs = new String[]{EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1"))};
    public int[] status = new int[]{0, 0, 0, 0, 0, 0, 0, 0};

    private OrgTreeInfo getOrgBound() {
        return (OrgTreeInfo)this.listOrgBound.getSelectedItem();
    }

    private int getYear() {
        return (Integer)this.year.getValue();
    }

    private int getMonth() {
        return (Integer)this.month.getValue();
    }

    private int getPeriodType() {
        return ((RptPeriodTypeEnum)this.listPeriodType.getSelectedItem()).getValue();
    }

    private IRow getSelectedRow(KDTable tblMain) {
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            return null;
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.useDescription.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        this.exeResult.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        this.fillTable();
        this.initDataValue();
        this.initVisable();
    }

    private void initVisable() {
        CslInspectInfo info = this.getSelectedCslInspectInfo();
        if (info != null) {
            this.kDLabelContainer4.setVisible(info.isIsPeriodTypeVisiable());
            this.kDLabelContainer2.setVisible(info.isIsPeriodVisiable());
            this.kDLabel1.setVisible(info.isIsPeriodVisiable());
            this.month.setVisible(info.isIsPeriodVisiable());
            this.kDLabel2.setVisible(info.isIsPeriodVisiable());
            this.kDLabelContainer1.setVisible(info.isIsOrgTreeVisiable());
            Rectangle periodTypeRect = this.kDLabelContainer4.getBounds();
            Rectangle periodRect1 = this.kDLabelContainer2.getBounds();
            Rectangle periodRect2 = this.kDLabel1.getBounds();
            Rectangle periodRect3 = this.month.getBounds();
            Rectangle periodRect4 = this.kDLabel2.getBounds();
            Rectangle orgTreeRect = this.kDLabelContainer1.getBounds();
            if (info.isIsPeriodTypeVisiable()) {
                int offSet = periodRect1.x - periodTypeRect.x;
                if (offSet <= 0) {
                    offSet = 148;
                    periodRect1.x += offSet;
                    this.kDLabelContainer2.setBounds(periodRect1);
                    periodRect2.x += offSet;
                    this.kDLabel1.setBounds(periodRect2);
                    periodRect3.x += offSet;
                    this.month.setBounds(periodRect3);
                    periodRect4.x += offSet;
                    this.kDLabel2.setBounds(periodRect4);
                    orgTreeRect.x += offSet;
                    this.kDLabelContainer1.setBounds(orgTreeRect);
                }
            } else {
                int offSet = periodRect1.x - periodTypeRect.x;
                if (offSet > 0) {
                    offSet = 148;
                    periodRect1.x -= offSet;
                    this.kDLabelContainer2.setBounds(periodRect1);
                    periodRect2.x -= offSet;
                    this.kDLabel1.setBounds(periodRect2);
                    periodRect3.x -= offSet;
                    this.month.setBounds(periodRect3);
                    periodRect4.x -= offSet;
                    this.kDLabel2.setBounds(periodRect4);
                    orgTreeRect.x -= offSet;
                    this.kDLabelContainer1.setBounds(orgTreeRect);
                }
            }
        }
    }

    private void fillTable() throws BOSException {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        CoreBaseCollection list = CslInspectFactory.getRemoteInstance().getCollection("select disabled,cslInspectDes,function,name,id,isPeriodTypeVisiable,isPeriodVisiable,isOrgTreeVisiable where disabled=1 ");
        this.tblMain.addRows(list.size());
        for (int i = 0; i < list.size(); ++i) {
            CslInspectInfo cslInspect = (CslInspectInfo)list.get(i);
            IRow row = this.tblMain.getRow(i);
            row.setUserObject((Object)cslInspect);
            row.getCell("caseCode").setValue((Object)cslInspect.getName());
            row.getCell("status").setValue((Object)CslInspectStatusEnum.getEnum(0).getAlias());
            row.getCell("id").setValue((Object)cslInspect.getIdentity().toString());
        }
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                CslInspectToolUI.this.proTableClicked();
            }
        });
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    private void initDataValue() throws EASBizException, BOSException {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        this.year.setModel((SpinnerModel)new SpinnerNumberModel(year, 1, 9999, 1));
        this.month.setModel((SpinnerModel)new SpinnerNumberModel(month, 1, 13, 1));
        this.listOrgBound.addItems(this.getInitOrgBound().toArray());
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        resultList.add(this.status);
        resultList.add(this.logs);
        this.results.put(this.getKey(), resultList);
        this.year.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    CslInspectToolUI.this.changeOrgBountAndExeSta();
                }
                catch (BOSException e1) {
                    logger.error((Object)("CslinspectToolUI " + (Object)((Object)e1)));
                }
            }
        });
        this.month.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                try {
                    CslInspectToolUI.this.changeOrgBountAndExeSta();
                }
                catch (BOSException e1) {
                    logger.error((Object)("CslinspectToolUI " + (Object)((Object)e1)));
                }
            }
        });
        this.listOrgBound.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (CslInspectToolUI.this.isExecuteShow) {
                    CslInspectToolUI.this.showStauesAndRes();
                }
            }
        });
        this.listPeriodType.addItem((Object)RptPeriodTypeEnum.getEnum((int)3));
    }

    private OrgTreeCollection getInitOrgBound() throws BOSException {
        String oql = "select * where type = 8 and status= 1";
        OrgTreeCollection allOrgTreeList = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(oql);
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.getYear(), this.getMonth() - 1, 1);
        Date date = calendar.getTime();
        OrgTreeCollection orgTreeList = new OrgTreeCollection();
        for (int i = 0; i < allOrgTreeList.size(); ++i) {
            OrgTreeInfo orgTree = allOrgTreeList.get(i);
            if (orgTree.getEndDate() == null && date.after(orgTree.getStartDate())) {
                orgTreeList.add(orgTree);
                continue;
            }
            if (orgTree.getEndDate() == null || !date.before(orgTree.getEndDate()) || !date.after(orgTree.getStartDate())) continue;
            orgTreeList.add(orgTree);
        }
        return orgTreeList;
    }

    private void proTableClicked() {
        this.initVisable();
        if (!this.executeReBtn.isEnabled()) {
            this.executeReBtn.setEnabled(true);
            this.eexcuteBtn.setEnabled(true);
        }
        IRow row = this.getSelectedRow(this.tblMain);
        CslInspectInfo info = (CslInspectInfo)row.getUserObject();
        String cslInspectDes = info.getCslInspectDes();
        String[] strs = cslInspectDes.split("@");
        cslInspectDes = "";
        for (int i = 0; i < strs.length; ++i) {
            cslInspectDes = cslInspectDes + strs[i];
            cslInspectDes = cslInspectDes + "\n";
        }
        this.useDescription.setSelectedItemData((Object)cslInspectDes);
        this.exeResult.setSelectedItemData((Object)this.logs[row.getRowIndex()]);
    }

    private CslInspectInfo getSelectedCslInspectInfo() {
        IRow row = this.getSelectedRow(this.tblMain);
        if (row != null) {
            return (CslInspectInfo)row.getUserObject();
        }
        return null;
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent e) {
        InspectThread thread = new InspectThread();
        thread.start();
    }

    private void modifyExeStatus(int exeStatus, IRow row) {
        String statusView = "";
        if (exeStatus == 0) {
            statusView = EASResource.getString((String)(this.RES_PATH + "exeStatus1"));
        } else if (exeStatus == 1) {
            statusView = EASResource.getString((String)(this.RES_PATH + "exeStatus2"));
        } else if (exeStatus == 2) {
            statusView = EASResource.getString((String)(this.RES_PATH + "exeStatus3"));
        }
        row.getCell("status").setValue((Object)statusView);
    }

    @Override
    public void actionExeResult_actionPerformed(ActionEvent e) throws Exception {
        this.kDTabbedPane1.setSelectedIndex(1);
    }

    private void showStauesAndRes() {
        int size = this.tblMain.getRowCount();
        this.logs = this.results.get(this.getKey()) != null ? (String[])this.results.get(this.getKey()).get(1) : new String[]{EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1")), EASResource.getString((String)(this.RES_PATH + "exeStatus1"))};
        for (int i = 0; i < size; ++i) {
            int status = 0;
            if (this.results.get(this.getKey()) != null) {
                status = ((int[])this.results.get(this.getKey()).get(0))[i];
            }
            this.modifyExeStatus(status, this.tblMain.getRow(i));
        }
        IRow row = this.getSelectedRow(this.tblMain);
        if (row != null) {
            this.exeResult.setSelectedItemData((Object)this.logs[row.getRowIndex()]);
        }
    }

    private void changeOrgBountAndExeSta() throws BOSException {
        this.isExecuteShow = false;
        if (this.getSelectedCslInspectInfo().isIsOrgTreeVisiable()) {
            this.listOrgBound.removeAllItems();
            this.listOrgBound.addItems(this.getInitOrgBound().toArray());
        }
        this.isExecuteShow = true;
        this.showStauesAndRes();
    }

    private Map<String, Object> getFilters() {
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("periodType", this.getPeriodType());
        filters.put("orgBound", this.getOrgBound());
        filters.put("year", this.getYear());
        filters.put("month", this.getMonth());
        filters.put("inspectId", (String)this.getSelectedRow(this.tblMain).getCell("id").getValue());
        return filters;
    }

    private String getKey() {
        String orgBoundId = "";
        if (this.getOrgBound() != null) {
            orgBoundId = this.getOrgBound().getId().toString();
        }
        return orgBoundId + this.getYear() + this.getMonth();
    }

    public class InspectThread
    extends Thread {
        @Override
        public void run() {
            IRow row = CslInspectToolUI.this.getSelectedRow(CslInspectToolUI.this.tblMain);
            CslInspectInfo info = (CslInspectInfo)row.getUserObject();
            String method = info.getFunction();
            CslInspectToolUI.this.modifyExeStatus(1, row);
            String result = "";
            try {
                result = CslInspectFactory.getRemoteInstance().exeFixData(CslInspectToolUI.this.getFilters(), method);
            }
            catch (Exception e) {
                logger.error((Object)("CslInspectFactory.getRemoteInstance().exeFixData error:" + e));
                result = "CslInspect getRemoteInstance error:" + e;
            }
            String[] logTemps = null;
            int[] statusTemps = null;
            if (CslInspectToolUI.this.results.get(CslInspectToolUI.this.getKey()) == null) {
                logTemps = new String[CslInspectToolUI.this.tblMain.getRowCount()];
                statusTemps = new int[CslInspectToolUI.this.tblMain.getRowCount()];
            } else {
                logTemps = (String[])((List)CslInspectToolUI.this.results.get(CslInspectToolUI.this.getKey())).get(1);
                statusTemps = (int[])((List)CslInspectToolUI.this.results.get(CslInspectToolUI.this.getKey())).get(0);
            }
            logTemps[row.getRowIndex()] = result;
            statusTemps[row.getRowIndex()] = 2;
            CslInspectToolUI.this.exeResult.setSelectedItemData((Object)result);
            ArrayList<Object[]> resultList = new ArrayList<Object[]>();
            resultList.add(statusTemps);
            resultList.add(logTemps);
            CslInspectToolUI.this.results.put(CslInspectToolUI.this.getKey(), resultList);
            CslInspectToolUI.this.modifyExeStatus(2, row);
        }
    }
}

