/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.maintaintool.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.ScheduleTimeMonthEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.ScheduleTimeWeekEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.ScheduleTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisFactory;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisInfo;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.client.AbstractStatisticsAnalysisDispatchUI;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.client.StatisticsAnalysisJobProcessDefHelp;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class StatisticsAnalysisDispatchUI
extends AbstractStatisticsAnalysisDispatchUI {
    private static final Logger logger = CoreUIObject.getLogger(StatisticsAnalysisDispatchUI.class);
    private StatisticsAnalysisJobProcessDefHelp statisticsAnalysisJobProcessDefHelp;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws BOSException, EASBizException {
        this.combScheduleType.addItems(ScheduleTypeEnum.getEnumList().toArray());
        this.combScheduleType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StatisticsAnalysisDispatchUI.this.itemChange(e);
            }
        });
        this.combScheduleType.setSelectedIndex(1);
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        Date startDate = c.getTime();
        c.set(11, 6);
        this.kdtpStartTime.setValue((Object)startDate);
        this.kdtpStopTime.setValue((Object)c.getTime());
        this.kdtpStartTime.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                StatisticsAnalysisDispatchUI.this.timeVerify(StatisticsAnalysisDispatchUI.this.kdtpStartTime, eventObj);
            }
        });
        this.kdtpStopTime.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                StatisticsAnalysisDispatchUI.this.timeVerify(StatisticsAnalysisDispatchUI.this.kdtpStopTime, eventObj);
            }
        });
        StatisticsAnalysisInfo info = StatisticsAnalysisFactory.getRemoteInstance().getFirstInfo();
        this.setDataObject((IObjectValue)info);
        this.statisticsAnalysisJobProcessDefHelp = new StatisticsAnalysisJobProcessDefHelp(this);
        this.statisticsAnalysisJobProcessDefHelp.initByJobProcessDef(info.getJobProcessDef());
    }

    private void timeVerify(KDTimePicker kDTimePicker, DataChangeEvent eventObj) {
        Date newDate = (Date)eventObj.getNewValue();
        Date oldDate = (Date)eventObj.getOldValue();
        int hours = newDate.getHours();
        int minutes = newDate.getMinutes();
        int seconds = newDate.getSeconds();
        if (hours > 8 && hours < 21) {
            kDTimePicker.setValue((Object)oldDate);
            return;
        }
        if (hours == 8 && (minutes > 0 || seconds > 0)) {
            kDTimePicker.setValue((Object)oldDate);
        }
    }

    private void itemChange(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (ScheduleTypeEnum.EVERYMONTH.equals(this.combScheduleType.getSelectedItem())) {
                this.combScheduleTime.removeAllItems();
                this.combScheduleTime.addItems(ScheduleTimeMonthEnum.getEnumList().toArray());
                this.txtExplain.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_monthExplain"));
            } else {
                this.combScheduleTime.removeAllItems();
                this.combScheduleTime.addItems(ScheduleTimeWeekEnum.getEnumList().toArray());
                this.txtExplain.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_weekExplain"));
            }
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        Date endDate;
        Date startDate = (Date)this.kdtpStartTime.getValue();
        if (this.isStartDateAfterEndDate(startDate, endDate = (Date)this.kdtpStopTime.getValue())) {
            return;
        }
        this.statisticsAnalysisJobProcessDefHelp.creatJobProcessDef();
        this.disposeUIWindow();
    }

    private boolean isStartDateAfterEndDate(Date startDate, Date endDate) {
        int sHours = startDate.getHours();
        int eHours = endDate.getHours();
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(11, sHours);
        c.set(12, startDate.getMinutes());
        c.set(13, startDate.getSeconds());
        startDate = c.getTime();
        c.clear();
        c.set(11, eHours);
        c.set(12, endDate.getMinutes());
        c.set(13, endDate.getSeconds());
        endDate = c.getTime();
        if (sHours >= 21 && eHours >= 21) {
            if (startDate.after(endDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_dispatchTimeError"));
                return true;
            }
        } else {
            if (sHours <= 8 && eHours >= 21) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_dispatchTimeError"));
                return true;
            }
            if (sHours <= 8 && eHours <= 8) {
                if (startDate.after(endDate)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_dispatchTimeError"));
                    return true;
                }
            } else if (sHours >= 21 && eHours <= 8) {
                c.add(5, 1);
                endDate = c.getTime();
            }
        }
        return endDate.getTime() - startDate.getTime() <= 300000L && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_timeIntervalTooShort")) != 0;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }
}

