/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.maintaintool.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.base.job.util.JobProcessUtil;
import com.kingdee.eas.base.job.util.ScheduleExpression;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.ScheduleTimeMonthEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.ScheduleTimeWeekEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.ScheduleTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisFactory;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisInfo;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisUtil;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.client.StatisticsAnalysisDispatchUI;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StatisticsAnalysisJobProcessDefHelp {
    private static final Logger logger = Logger.getLogger(StatisticsAnalysisJobProcessDefHelp.class);
    private EASWfServiceClient workflowClient;
    private StatisticsAnalysisDispatchUI ui;
    public static final String jobProcessDefTitle = "StatisticsAnalysis";
    private static final int OPERATION_DISPATCH = 0;
    private static final int OPERATION_RETRYDISPATCH = 1;

    public StatisticsAnalysisJobProcessDefHelp(StatisticsAnalysisDispatchUI ui) {
        this.ui = ui;
    }

    public void creatJobProcessDef() {
        try {
            String define;
            ScheduleDef schedule = new ScheduleDef(null);
            ScheduleTypeEnum scheduleType = (ScheduleTypeEnum)((Object)this.ui.combScheduleType.getSelectedItem());
            Date startDate = (Date)this.ui.kdtpStartTime.getValue();
            Date endDate = (Date)this.ui.kdtpStopTime.getValue();
            if (ScheduleTypeEnum.EVERYMONTH.equals((Object)scheduleType)) {
                schedule.setType(ScheduleType.EVERYMONTH);
                define = StatisticsAnalysisUtil.getMonthSchedule(startDate, ((ScheduleTimeMonthEnum)((Object)this.ui.combScheduleTime.getSelectedItem())).getValue());
            } else {
                schedule.setType(ScheduleType.EVERYWEEK);
                define = StatisticsAnalysisUtil.getWeekSchedule(startDate, ((ScheduleTimeWeekEnum)((Object)this.ui.combScheduleTime.getSelectedItem())).getValue());
            }
            schedule.setDefine(define);
            schedule.setInstructionType(1);
            StatisticsAnalysisInfo info = (StatisticsAnalysisInfo)this.ui.getDataObject();
            String jobProcessDef = info.getJobProcessDef();
            String retryJobProcessDef = info.getRetryJobProcessDef();
            Calendar c = Calendar.getInstance();
            int year = c.get(1);
            int month = c.get(2);
            int day = c.get(5);
            c.clear();
            c.set(1, year + 50);
            c.set(2, month);
            c.set(5, day);
            c.set(11, endDate.getHours());
            c.set(12, endDate.getMinutes());
            c.set(13, endDate.getSeconds());
            Date endTime = c.getTime();
            Date nextExecuteTime = StatisticsAnalysisUtil.getNextExecuteTime(schedule);
            if (jobProcessDef != null) {
                if (MsgBox.showConfirm2((Component)((Object)this.ui), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_reSetDispatch")) != 0) {
                    return;
                }
                this.getWorkflowClient().updateProcessSchedule(jobProcessDef, KpdlParser.scheduleToString((ScheduleDef)schedule));
                StatisticsAnalysisFactory.getRemoteInstance().batchUpdateJobProcessDef(jobProcessDef, null, endTime, nextExecuteTime);
                define = StatisticsAnalysisUtil.getEveryDaySchedule(startDate);
                schedule.setType(ScheduleType.EVERYDAY);
                schedule.setDefine(define);
                this.getWorkflowClient().updateProcessSchedule(retryJobProcessDef, KpdlParser.scheduleToString((ScheduleDef)schedule));
            } else {
                HashMap<String, Object> jobContext = new HashMap<String, Object>();
                jobContext.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                jobContext.put("scheduleType", scheduleType.getValue());
                FunctionObjectInfo function = this.buildFunctionObjectInfo();
                OperationInfo operation = this.buildOperationInfo(function, 0);
                String jobProcessDefID = this.getWorkflowClient().createJobProcessDef(jobProcessDefTitle, function, operation, jobContext, KpdlParser.scheduleToString((ScheduleDef)schedule), SysContext.getSysContext().getLocale());
                define = StatisticsAnalysisUtil.getEveryDaySchedule(startDate);
                schedule.setType(ScheduleType.EVERYDAY);
                schedule.setDefine(define);
                jobContext.put("jobProcessDefID", jobProcessDefID);
                operation = this.buildOperationInfo(function, 1);
                String retryJobProcessDefID = this.getWorkflowClient().createJobProcessDef("retryStatisticsAnalysis", function, operation, jobContext, KpdlParser.scheduleToString((ScheduleDef)schedule), SysContext.getSysContext().getLocale());
                StatisticsAnalysisFactory.getRemoteInstance().batchUpdateJobProcessDef(jobProcessDefID, retryJobProcessDefID, endTime, nextExecuteTime);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getJobProcessDef_error", (Throwable)e);
        }
    }

    private OperationInfo buildOperationInfo(FunctionObjectInfo function, int operationIndex) {
        return function.getOperation().get(operationIndex);
    }

    protected FunctionObjectInfo buildFunctionObjectInfo() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.maintaintool.app.StatisticsAnalysisFunction");
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
    }

    public void initByJobProcessDef(String jobProcessDefId) throws EASBizException, BOSException {
        if (jobProcessDefId == null) {
            return;
        }
        Map map = StatisticsAnalysisFactory.getRemoteInstance().getProcessDef(jobProcessDefId);
        if (map != null && !map.isEmpty()) {
            String define = (String)map.get("define");
            String[] defines = define.split(":");
            ScheduleType scheduleType = ScheduleType.getEnum((String)defines[0]);
            ScheduleExpression se = JobProcessUtil.parseSchedule((String)defines[1]);
            if (ScheduleType.EVERYMONTH.equals((Object)scheduleType)) {
                this.ui.combScheduleType.setSelectedItem((Object)ScheduleTypeEnum.EVERYMONTH);
                if (se != null) {
                    String dayofmonth = se.getDayofmonth();
                    this.ui.combScheduleTime.setSelectedItem((Object)ScheduleTimeMonthEnum.getEnum(dayofmonth));
                }
            } else {
                this.ui.combScheduleType.setSelectedItem((Object)ScheduleTypeEnum.EVERYWEEK);
                if (se != null) {
                    String dayofweek = se.getDayofweek();
                    this.ui.combScheduleTime.setSelectedItem((Object)ScheduleTimeWeekEnum.getEnum(dayofweek));
                }
            }
            Calendar c = Calendar.getInstance();
            c.set(11, Integer.parseInt(se.getHours()));
            c.set(12, Integer.parseInt(se.getMinutes()));
            c.set(13, Integer.parseInt(se.getSeconds()));
            this.ui.kdtpStartTime.setValue((Object)c.getTime());
            Date endTime = (Date)map.get("endTime");
            this.ui.kdtpStopTime.setValue((Object)endTime);
        }
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
        }
        return this.workflowClient;
    }
}

