/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.reportcalc;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.Map;

public class DynaRptStyle {
    private Map bookStyleMapForGrade = null;
    private Map bookStyleMap = null;
    private Book curSheets;
    private Context _ctx;
    private Book tmpBook = null;
    private boolean isByTemplate;
    private boolean isCalcSingle = false;

    public DynaRptStyle(Context ctx, CslReportInfo curReport, Book curSheets, DynaSumMethodEnum sumMethod, boolean isCalcSingle) throws Exception {
        this._ctx = ctx;
        this.curSheets = curSheets;
        this.isCalcSingle = isCalcSingle;
        this.tmpBook = this.getTemplateBook(curReport);
        this.isByTemplate = DynaSumMethodEnum.SUM_BY_TEMPLATE.equals((Object)sumMethod);
    }

    public void getDynaRptStyle() {
        if (this.isCalcSingle && this.tmpBook != null) {
            Sheet curSheet;
            if (!this.isByTemplate && (curSheet = this.tmpBook.getSheet(this.curSheets.getActiveSheet().getSheetName())) != null) {
                this.bookStyleMapForGrade = DynamicTemplateUtility.getOriginalGradeLineStyle((Sheet)curSheet);
                this.bookStyleMap = DynamicTemplateUtility.getSheetBasePointsFirstLineStyle((Sheet)curSheet);
            }
            DynamicTemplateUtility.clearGradeStyleBySheet((Sheet)this.curSheets.getActiveSheet());
        } else {
            if (!this.isByTemplate) {
                this.bookStyleMapForGrade = DynamicTemplateUtility.getOriginalGradeLineStyle((Book)this.tmpBook);
                this.bookStyleMap = DynamicTemplateUtility.getBookBasePointsFirstLineStyle((Book)this.tmpBook);
            }
            DynamicTemplateUtility.clearGradeStyle((Book)this.curSheets);
        }
    }

    public void resetDynaRptStyle() {
        if (this.isCalcSingle) {
            if (this.isByTemplate) {
                Sheet tmpSheet = this.tmpBook.getSheet(this.curSheets.getActiveSheet().getSheetName());
                if (tmpSheet != null) {
                    DynamicTemplateUtility.copyTemplateStyleToCurSheet((Sheet)tmpSheet, (Sheet)this.curSheets.getActiveSheet());
                }
            } else {
                DynamicTemplateUtility.restoreOriginalGradeLineStyle((Sheet)this.curSheets.getActiveSheet(), (Map)this.bookStyleMapForGrade, (boolean)this.isByTemplate);
                DynamicTemplateUtility.setSheetBasePointsFirstLineStyle((Map)this.bookStyleMap, (Sheet)this.curSheets.getActiveSheet());
                DynamicTemplateUtility.reAdjustSheetAlign((Sheet)this.curSheets.getActiveSheet());
            }
        } else if (this.isByTemplate) {
            Sheet tmpSheet = null;
            for (int i = 0; i < this.curSheets.getSheetCount(); ++i) {
                tmpSheet = this.tmpBook.getSheet(this.curSheets.getSheetName(i));
                if (tmpSheet == null) continue;
                DynamicTemplateUtility.copyTemplateStyleToCurSheet((Sheet)tmpSheet, (Sheet)this.curSheets.getSheet(i));
            }
        } else {
            DynamicTemplateUtility.restoreOriginalGradeLineStyle((Book)this.curSheets, (Map)this.bookStyleMapForGrade, (boolean)this.isByTemplate);
            DynamicTemplateUtility.setBookBasePointsFirstLine((Map)this.bookStyleMap, (Book)this.curSheets);
            DynamicTemplateUtility.reAdjustSheetAlign((Book)this.curSheets);
        }
    }

    private Book getTemplateBook(CslReportInfo cslreportInfo) throws Exception {
        Book tempBook = cslreportInfo.getTemplate().getBook();
        if (tempBook == null) {
            String id = cslreportInfo.getTemplate().getId().toString();
            TemplateInfo info = null;
            info = this._ctx == null ? TemplateFactory.getRemoteInstance().getTemplateInfo("select data where id='" + id + "'") : TemplateFactory.getLocalInstance((Context)this._ctx).getTemplateInfo("select data where id='" + id + "'");
            tempBook = info.getBook();
        }
        return tempBook;
    }
}

