/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUserLevelCollection;
import com.kingdee.eas.basedata.master.account.AccountUserLevelInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSLExportUtility {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.util.CSLExportUtility");
    public static final String FormatAadpter_K3KDF = "FormatAadpter_K3KDF";
    public static final String FormatAadpter_FakeTemplate = "FormatAadpter_FakeTemplate";
    public static final StringExpr NULL_STRING = new StringExpr("");

    public static void convertTable(Sheet sheet, AccountTableInfo accounttable) throws ReportException {
        sheet.getBook().setCalculate(false);
        int rowCount = sheet.getRows().getMaxIntMark() + 1;
        int colCount = sheet.getCols().getMaxIntMark() + 1;
        String expression = null;
        for (int k = 0; k < rowCount; ++k) {
            for (int l = 0; l < colCount; ++l) {
                DItemGradeInfo gradeInfo;
                Range range = sheet.getRange(k, l);
                ItemFormula itemFormula = UserObjectHelper.getItemFormula((Range)range);
                if (itemFormula != null && itemFormula.isBasePoint() && (gradeInfo = DynamicTemplateUtility.getGradeInfo((Range)range)) != null) {
                    for (int i = 0; i < gradeInfo.getEntries().size(); ++i) {
                        String n;
                        DItemGradeEntryInfo ge = (DItemGradeEntryInfo)gradeInfo.getEntries().get(i);
                        if (ge.getDetailAsstType() == null || ge.getDetailSource() == 0 || (n = ge.getDetailAsstType().asstHGAttribute) == null || n.toLowerCase().indexOf("company") >= 0) continue;
                        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"743_CSLExportUtility")});
                    }
                }
                if (!range.isHasFormula()) continue;
                if (range.getUserObject("0") != null) {
                    expression = range.getUserObject("0").toString();
                    range.setUserObject("0", (Object)CSLExportUtility.convertFormula(expression, accounttable));
                }
                if (range.getUserObject("1") != null) {
                    expression = range.getUserObject("1").toString();
                    range.setUserObject("1", (Object)CSLExportUtility.convertFormula(expression, accounttable));
                }
                if (range.getUserObject("0") == null && range.getUserObject("1") == null && !range.isHasFormula()) continue;
                expression = range.getFormula();
                range.setIgnoreProtected(true);
                range.setFormula(CSLExportUtility.convertFormula(expression, accounttable));
                range.setIgnoreProtected(false);
            }
        }
    }

    public static String convertFormula(String formulaLine, AccountTableInfo accounttable) {
        Expression stmt;
        if (formulaLine == null || formulaLine.length() < 1) {
            return formulaLine;
        }
        boolean hasEqual = false;
        if (formulaLine.charAt(0) == '=') {
            hasEqual = true;
        }
        String formulaString = null;
        formulaString = hasEqual ? formulaLine.substring(1) : formulaLine;
        FormulaExpressionHandler formulaExpressionHandler = new FormulaExpressionHandler(accounttable);
        try {
            stmt = ExcelFormulaPaserHelper.parse((String)formulaString);
            ExcelFormulaPaserHelper.walk((Expression)stmt, (IExpressionHandler)formulaExpressionHandler);
        }
        catch (Exception e) {
            logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"744_CSLExportUtility"), (Throwable)e);
            return formulaLine;
        }
        StringBuffer rsb = new StringBuffer();
        if (hasEqual) {
            rsb.append("=");
        }
        rsb.append(ExcelFormulaPaserHelper.toReducedBracketsString((Expression)stmt));
        String returnStr = rsb.toString();
        if (formulaExpressionHandler.map.size() > 0) {
            Iterator iterator = formulaExpressionHandler.map.keySet().iterator();
            while (iterator.hasNext()) {
                StringBuffer sb = new StringBuffer();
                String formula = (String)iterator.next();
                int i = 0;
                List list = (List)formulaExpressionHandler.map.get(formula);
                for (Expression expression : list) {
                    if (++i == 1) {
                        sb.append("(");
                    } else {
                        sb.append("+");
                    }
                    sb.append(ExcelFormulaPaserHelper.toReducedBracketsString((Expression)expression));
                }
                if (i > 0) {
                    sb.append(")");
                }
                StringBuffer newSeparator = new StringBuffer();
                int length = formula.length();
                for (int j = 0; j < length; ++j) {
                    char ch = formula.charAt(j);
                    if ('\'' == ch || '.' == ch || '+' == ch || '*' == ch || '(' == ch || ')' == ch || '{' == ch || '}' == ch || '\"' == ch) {
                        newSeparator.append("\\").append(ch);
                        continue;
                    }
                    newSeparator.append(ch);
                }
                returnStr = returnStr.replaceAll(newSeparator.toString(), sb.toString());
            }
        }
        return returnStr;
    }

    private static Object formatK3Account(Object exp, AccountTableInfo accounttable) {
        String src = null;
        StringExpr stringExpr = null;
        if (exp instanceof StringExpr) {
            stringExpr = (StringExpr)exp;
            src = stringExpr.value;
        }
        if (accounttable == null || src == null) {
            return src;
        }
        String[] accounts = src.split(",");
        String allAccount = "";
        for (int i = 0; i < accounts.length; ++i) {
            String account = accounts[i];
            String[] accountParts = account.split(":");
            String accountPart = "";
            for (int j = 0; j < accountParts.length; ++j) {
                int index = accountParts[j].indexOf("|");
                if (index != -1) {
                    String singleAccountPart = accountParts[j].substring(0, index);
                    singleAccountPart = CSLExportUtility.addeasSpToacctpart(accounttable, singleAccountPart);
                    String singleAsstPart = accountParts[j].substring(index);
                    String singleAccount = singleAccountPart + singleAsstPart;
                    if (j == 0) {
                        accountPart = accountPart + singleAccount;
                        continue;
                    }
                    accountPart = accountPart + ":" + singleAccount;
                    continue;
                }
                String singleAccount = CSLExportUtility.addeasSpToacctpart(accounttable, accountParts[j]);
                accountPart = j == 0 ? accountPart + singleAccount : accountPart + ":" + singleAccount;
            }
            allAccount = i == 0 ? allAccount + accountPart : allAccount + "," + accountPart;
        }
        if (stringExpr != null) {
            stringExpr.value = allAccount;
        }
        return stringExpr;
    }

    private static String addeasSpToacctpart(AccountTableInfo accounttable, String acctpart) {
        if (acctpart == null) {
            return "";
        }
        String easSp = accounttable.getSeparator();
        if (!accounttable.isIsUseSeparator() || StringUtils.isEmpty((String)easSp)) {
            AccountUserLevelCollection userLevel = accounttable.getUserLevel();
            int len = 0;
            acctpart = acctpart.replaceAll("\\.", "");
            for (int i = 0; i < userLevel.size(); ++i) {
                AccountUserLevelInfo info = userLevel.get(i);
                if (acctpart.length() > len + info.getLength()) {
                    String p1 = acctpart.substring(0, len + info.getLength());
                    String p2 = acctpart.substring(len + info.getLength());
                    acctpart = p1 + "." + p2;
                    len += 1 + info.getLength();
                    continue;
                }
                break;
            }
        } else {
            acctpart = StringUtils.replace((String)acctpart, (String)easSp, (String)".");
        }
        return acctpart;
    }

    private static void convertMethod(FunctionExpr mExpr, AccountTableInfo accounttable, Map map) {
        String methodName = mExpr.funcionName;
        List paramList = mExpr.parameters;
        ArrayList<FunctionExpr> list = new ArrayList<FunctionExpr>();
        if ("ACCT".equalsIgnoreCase(methodName) && paramList.size() == 9) {
            StringExpr account = (StringExpr)CSLExportUtility.formatK3Account(paramList.get(1), accounttable);
            String src = null;
            StringExpr stringExpr = null;
            if (account instanceof StringExpr) {
                stringExpr = account;
                src = stringExpr.value;
            }
            if (accounttable == null || src == null) {
                return;
            }
            String[] accounts = src.split(",");
            if (accounts.length > 1) {
                for (int i = 0; i < accounts.length; ++i) {
                    FunctionExpr tempmExpr = new FunctionExpr(methodName);
                    ArrayList<Object> paramListForK3 = new ArrayList<Object>();
                    stringExpr = new StringExpr(accounts[i]);
                    paramListForK3.add(0, stringExpr);
                    paramListForK3.add(1, paramList.get(2));
                    paramListForK3.add(2, paramList.get(7));
                    paramListForK3.add(3, paramList.get(5));
                    paramListForK3.add(4, paramList.get(4));
                    paramListForK3.add(5, paramList.get(6));
                    paramListForK3.add(6, NULL_STRING);
                    tempmExpr.parameters = paramListForK3;
                    list.add(tempmExpr);
                }
            }
            ArrayList<Object> paramListForK3 = new ArrayList<Object>();
            paramListForK3.add(0, CSLExportUtility.formatK3Account(paramList.get(1), accounttable));
            paramListForK3.add(1, paramList.get(2));
            paramListForK3.add(2, paramList.get(7));
            paramListForK3.add(3, paramList.get(5));
            paramListForK3.add(4, paramList.get(4));
            paramListForK3.add(5, paramList.get(6));
            paramListForK3.add(6, NULL_STRING);
            mExpr.parameters = paramListForK3;
            if (list.size() > 0) {
                map.put(mExpr.toString(), list);
            }
        } else if ("ACCTAC".equalsIgnoreCase(methodName) && paramList.size() == 9) {
            ArrayList<Object> paramListForK3 = new ArrayList<Object>();
            paramListForK3.add(0, CSLExportUtility.formatK3Account(paramList.get(2), accounttable));
            paramListForK3.add(1, paramList.get(3));
            paramListForK3.add(2, paramList.get(8));
            paramListForK3.add(3, paramList.get(6));
            paramListForK3.add(4, paramList.get(5));
            paramListForK3.add(5, paramList.get(7));
            paramListForK3.add(6, NULL_STRING);
            mExpr.parameters = paramListForK3;
            mExpr.funcionName = "ACCT";
        } else if ("ACCTEXT".equalsIgnoreCase(methodName) && paramList.size() == 8) {
            ArrayList<Object> paramListForK3 = new ArrayList<Object>();
            paramListForK3.add(0, CSLExportUtility.formatK3Account(paramList.get(1), accounttable));
            paramListForK3.add(1, paramList.get(2));
            paramListForK3.add(2, paramList.get(3));
            paramListForK3.add(3, paramList.get(4));
            paramListForK3.add(4, paramList.get(5));
            paramListForK3.add(5, paramList.get(6));
            paramListForK3.add(6, paramList.get(7));
            paramListForK3.add(7, NULL_STRING);
            mExpr.parameters = paramListForK3;
        } else if ("ACCTCASH".equalsIgnoreCase(methodName) && (paramList.size() == 8 || paramList.size() == 7)) {
            ArrayList paramListForK3 = new ArrayList();
            paramListForK3.add(0, paramList.get(6));
            paramListForK3.add(1, paramList.get(1));
            paramListForK3.add(2, paramList.get(2));
            paramListForK3.add(3, paramList.get(3));
            paramListForK3.add(4, paramList.get(4));
            paramListForK3.add(5, paramList.get(5));
            paramListForK3.add(6, NULL_STRING);
            mExpr.parameters = paramListForK3;
        } else if ("csref".equalsIgnoreCase(methodName) && paramList.size() >= 11) {
            ArrayList paramListForK3 = new ArrayList();
            paramListForK3.add(0, paramList.get(1));
            paramListForK3.add(1, paramList.get(2));
            paramListForK3.add(2, paramList.get(3));
            paramListForK3.add(3, paramList.get(4));
            paramListForK3.add(4, paramList.get(5));
            paramListForK3.add(5, paramList.get(6));
            paramListForK3.add(6, paramList.get(7));
            paramListForK3.add(7, paramList.get(8));
            paramListForK3.add(8, paramList.get(9));
            paramListForK3.add(9, paramList.get(10));
            Object strExpr = paramList.size() == 11 ? new StringExpr("") : paramList.get(11);
            paramListForK3.add(10, strExpr);
            mExpr.parameters = paramListForK3;
        } else if ("ref".equalsIgnoreCase(methodName) && paramList.size() == 4) {
            ArrayList paramListForK3 = new ArrayList();
            paramListForK3.add(0, paramList.get(1));
            paramListForK3.add(1, paramList.get(3));
            paramListForK3.add(2, paramList.get(2));
            paramListForK3.add(3, NULL_STRING);
            mExpr.parameters = paramListForK3;
            mExpr.funcionName = methodName.concat("_f");
        }
    }

    public static AccountTableInfo getDefaultAccountTableByCU() throws BOSException, ServerException {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null) {
            return null;
        }
        AccountTableInfo tableInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)companyOrgUnitInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Boolean(false)));
        evi.getSelector().add("accountTableID.*");
        evi.getSelector().add("accountTableID.userLevel.*");
        SorterItemCollection sorters = evi.getSorter();
        SorterItemInfo sort = new SorterItemInfo("accountTableID.userLevel.level");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
        Account_ControlCollection acctCtrlsCols = acctCtrl.getAccount_ControlCollection(evi);
        if (acctCtrlsCols != null && acctCtrlsCols.size() > 0) {
            tableInfo = acctCtrlsCols.get(0).getAccountTableID();
        }
        return tableInfo;
    }

    private static class FormulaExpressionHandler
    implements IExpressionHandler {
        private AccountTableInfo accounttable;
        public Map map = new HashMap();

        public FormulaExpressionHandler(AccountTableInfo accounttable) {
            this.accounttable = accounttable;
        }

        public void handle(Expression expr) {
            if (expr instanceof FunctionExpr) {
                CSLExportUtility.convertMethod((FunctionExpr)expr, this.accounttable, this.map);
            }
        }
    }
}

