/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.IParamCheck;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ParamException;
import org.apache.log4j.Logger;

public class CSLParamCheck001
implements IParamCheck {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.util.CSLParamCheck001");

    public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
        String number = model.getKeyID().getNumber();
        if (number.equals("GR_CSL_MergeByFiscalPeriod")) {
            this.checkMergeByFiscalPeriod(ctx, model);
        }
        if (number.equals("GR_CSL_SupportOtherDS")) {
            this.checkSupportOtherDS(ctx, model);
        }
        if (number.equals("GR_CSL_Support13Period")) {
            this.checkSupport13Period(ctx, model);
        }
    }

    private void checkSupport13Period(Context ctx, ParamItemInfo model) throws EASBizException, BOSException {
        boolean isSupport13Period = this.isSupport13Period(ctx);
        if (!isSupport13Period) {
            boolean isMergeByFiscalPeriod = this.isMergeByFiscalPeriod(ctx);
            if (isMergeByFiscalPeriod) {
                Object[] params = this.getExceptionParams(ctx, model, "GR_CSL_MergeByFiscalPeriod");
                throw new ParamException(ParamException.CANNOTBESAME, params);
            }
            logger.debug((Object)"checkSupport13Period: pass");
        }
    }

    private void checkSupportOtherDS(Context ctx, ParamItemInfo model) throws EASBizException, BOSException {
        boolean isSupportOtherDS = this.isSupportOtherDS(ctx);
        if (!isSupportOtherDS) {
            boolean isMergeByFiscalPeriod = this.isMergeByFiscalPeriod(ctx);
            if (isMergeByFiscalPeriod) {
                Object[] params = this.getExceptionParams(ctx, model, "GR_CSL_MergeByFiscalPeriod");
                throw new ParamException(ParamException.CANNOTBESAME, params);
            }
            logger.debug((Object)"checkSupportOtherDS: pass");
        }
    }

    private void checkMergeByFiscalPeriod(Context ctx, ParamItemInfo model) throws EASBizException, BOSException {
        boolean isMergeByFiscalYear = this.isMergeByFiscalPeriod(ctx);
        if (isMergeByFiscalYear) {
            throw new ParamException(ParamException.CANNOTUPDATE);
        }
        boolean isSupportOtherDS = this.isSupportOtherDS(ctx);
        if (isSupportOtherDS) {
            Object[] params = this.getExceptionParams(ctx, model, "GR_CSL_SupportOtherDS");
            throw new ParamException(ParamException.CANNOTBESAME, params);
        }
        boolean isSupport13Period = this.isSupport13Period(ctx);
        if (isSupport13Period) {
            Object[] params = this.getExceptionParams(ctx, model, "GR_CSL_Support13Period");
            throw new ParamException(ParamException.CANNOTBESAME, params);
        }
    }

    private Object[] getExceptionParams(Context ctx, ParamItemInfo model, String otherParamNumber) throws EASBizException, BOSException {
        String otherParam_name;
        String model_name;
        if (ctx == null) {
            model_name = model.getKeyID().getName();
            otherParam_name = ParamManager.getParamByNumber((Context)ctx, (String)otherParamNumber).getName();
        } else {
            model_name = model.getKeyID().getName(ctx.getLocale());
            otherParam_name = ParamManager.getParamByNumber((Context)ctx, (String)otherParamNumber).getName(ctx.getLocale());
        }
        return new Object[]{model_name, otherParam_name};
    }

    private boolean isSupportOtherDS(Context ctx) {
        if (ctx == null) {
            return CslRptUtil.isSupportOtherDSClient();
        }
        return CslRptUtil.isSupportOtherDSServer(ctx);
    }

    private boolean isMergeByFiscalPeriod(Context ctx) {
        return CslRptUtil.isMergeByFiscalPeriod(ctx);
    }

    private boolean isSupport13Period(Context ctx) {
        return CslRptUtil.isSupport13Period(ctx);
    }
}

