/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DispensePropertyHelperForItemDataInit {
    public static final String DISPENSE_RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource";
    public static final String CSLRPTAutoGenerate_Resource = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
    public static final int NO_DATA = 0;
    public static final int NUMBER = 1;
    public static final int STRING = 2;
    private int EXCEL_ITEM = 0;
    private int EXCEL_CURRENCY = 2;
    private int EXCEL_SOURCE_CURRENCY = 4;
    private int EXCEL_DEBIT = 6;
    private int EXCEL_CREDIT = 7;
    private int EXCEL_VALUE_TYPE = 8;
    private int EXCEL_COVERT_STATUES = 9;
    private int EXCEL_BASIC_LINE = 4;

    public Map output(File file, Map params) throws Exception {
        KDSBook kdBook;
        FileInputStream stream = new FileInputStream(file.getAbsolutePath());
        Map<String, String> result = new HashMap<String, String>();
        String errorKey = "excelErrorMsg";
        String detailKey = "detailMsg";
        try {
            kdBook = POIXlsReader.parse((InputStream)stream);
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            result.put(errorKey, EASResource.getString((String)CSLRPTAutoGenerate_Resource, (String)"763_DispensePropertyHelper"));
            return result;
        }
        if (kdBook == null) {
            result.put(errorKey, DispensePropertyHelperForItemDataInit.getString("Dispense_Import_Error_CreateKDF"));
            return result;
        }
        KDSSheet sheetParam = kdBook.getSheet((Object)"Import Table");
        if (sheetParam == null) {
            result.put(errorKey, DispensePropertyHelperForItemDataInit.getString("Dispense_Import_Error_NoParamSheet"));
            return result;
        }
        Book book = null;
        book = KDSBookToBook.traslate((KDSBook)kdBook);
        Sheet sheet = book.getSheet("Import Table");
        if (this.checkFileIsRepeat(params.get("companyMsg"), sheet, result)) {
            result.put(errorKey, DispensePropertyHelperForItemDataInit.getString("fileRepeatError"));
            return result;
        }
        Map bookDataMap = this.getBookData(sheet, params);
        if (bookDataMap == null) {
            result.put(errorKey, DispensePropertyHelperForItemDataInit.getString("excelNullData"));
            return result;
        }
        result = ItemDataYearInitFactory.getRemoteInstance().saveYearInitDataForExcel(bookDataMap);
        bookDataMap.putAll(result);
        return bookDataMap;
    }

    private boolean checkFileIsRepeat(Object object, Sheet sheet, Map result) {
        List company = (List)object;
        if (company != null && company.size() < 1) {
            return false;
        }
        for (int i = 0; i < company.size(); ++i) {
            Object[] companyMsg = (Object[])company.get(i);
            Object year = this.getCellValue(2, 1, sheet);
            Object companyNum = this.getCellValue(0, 1, sheet);
            if (year == null || !year.toString().equals(companyMsg[1].toString()) || companyNum == null || !companyNum.toString().equals(companyMsg[0].toString())) continue;
            result.put("excelYear", year);
            result.put("excelCompanyNum", companyNum);
            result.put("excelUnitName", companyMsg[2]);
            return true;
        }
        return false;
    }

    private Map getBookData(Sheet sheet, Map params) throws BOSException {
        int[] cols = new int[]{this.EXCEL_ITEM, this.EXCEL_CURRENCY, this.EXCEL_SOURCE_CURRENCY, this.EXCEL_DEBIT, this.EXCEL_CREDIT, this.EXCEL_VALUE_TYPE, this.EXCEL_COVERT_STATUES};
        int rowCount = sheet.getMaxRowIndex() - this.EXCEL_BASIC_LINE + 1;
        HashMap<String, Object> bookDataMap = new HashMap<String, Object>();
        if (rowCount < 1) {
            return null;
        }
        Object[][] bookValue = new Object[8][];
        for (int i = 0; i < 8; ++i) {
            bookValue[i] = new Object[rowCount];
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            bookValue[0][rowIndex] = rowIndex + this.EXCEL_BASIC_LINE + 1;
            for (int i = 1; i < 8; ++i) {
                bookValue[i][rowIndex] = this.getCellValue(rowIndex + this.EXCEL_BASIC_LINE, cols[i - 1], sheet);
            }
        }
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        bookDataMap.put("excelOrgTreeId", params.get("excelOrgTreeId"));
        DataCollectInfo dataCollectInfo = CSLContextHelper.getCSLContext().getCurDataCollect();
        if (dataCollectInfo == null) {
            dataCollectInfo = DataCollectConstant.getActualDC();
        }
        bookDataMap.put("excelCompanyNum", this.getCellValue(0, 1, sheet));
        bookDataMap.put("excelCompanyName", this.getCellValue(1, 1, sheet));
        bookDataMap.put("excelDataCollectInfo", dataCollectInfo);
        bookDataMap.put("excelYear", this.getCellValue(2, 1, sheet));
        bookDataMap.put("excelYearInit", bookValue);
        bookDataMap.put("excelUser", user);
        bookDataMap.put("orgParams", params);
        return bookDataMap;
    }

    private Object getCellValue(int row, int col, Sheet sheet) {
        Cell cell = sheet.getCell(row, col, false);
        return cell == null ? null : cell.getValue().getValue();
    }

    public static String getString(String resName) {
        return EASResource.getString((String)DISPENSE_RESOURCE, (String)resName);
    }

    public static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String getString(String resName, Context ctx) {
        if (ctx == null) {
            return EASResource.getString((String)DISPENSE_RESOURCE, (String)resName);
        }
        return ResourceBase.getString((String)DISPENSE_RESOURCE, (String)resName, (Locale)ctx.getOriginLocale());
    }
}

