/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.netfile.ftp.FTPClient;
import com.kingdee.bos.service.netfile.ftp.FTPTransferType;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FTPUpDown {
    private static final Logger logger = Logger.getLogger(FTPUpDown.class);
    private String ftpServer;
    private String ftpPort;
    private String ftpUserName;
    private String ftpPassword;
    private FTPClient ftpClient;
    private boolean isLogin = false;

    public FTPUpDown(String pFtpServer, String pFtpPort, String pFtpUserName, String pFtpPassword) throws Exception {
        this.ftpServer = pFtpServer;
        this.ftpPort = pFtpPort.trim().equals("") ? "21" : pFtpPort;
        this.ftpUserName = pFtpUserName.trim().equals("") ? "Anonymous" : pFtpUserName;
        this.ftpPassword = pFtpPassword;
        try {
            this.ftpClient = new FTPClient(this.ftpServer, Integer.parseInt(this.ftpPort));
            this.ftpClient.login(this.ftpUserName, this.ftpPassword);
            this.ftpClient.chdir("/");
            this.isLogin = true;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public String uploadFolder(String folderName, String ftpPath) throws Exception {
        if (this.isLogin) {
            String strMsg;
            block12: {
                strMsg = "";
                try {
                    File file = new File(folderName);
                    if (file.isDirectory()) {
                        this.ftpClient.chdir("/");
                        this.ftpClient.setType(FTPTransferType.BINARY);
                        if (this.checkFolderIsExist(ftpPath)) {
                            this.ftpClient.chdir(ftpPath);
                        } else {
                            this.createFolder(ftpPath);
                        }
                        if (!this.checkFolderIsExist(file.getName())) {
                            this.ftpClient.mkdir(file.getName());
                        }
                        this.ftpClient.chdir(file.getName());
                        ftpPath = ftpPath + "/" + file.getName();
                        File[] files = file.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                this.uploadFolder(files[i].getPath(), ftpPath);
                                continue;
                            }
                            if (!files[i].isFile()) continue;
                            try {
                                this.ftpClient.put(files[i].getPath(), files[i].getName());
                                continue;
                            }
                            catch (Exception ee) {
                                strMsg = strMsg + "upload file<<\uff1a" + files[i].getPath() + ">> error\uff01Message:" + ee.getMessage() + "\r\n";
                            }
                        }
                        if (!strMsg.equals("")) {
                            throw new Exception(strMsg);
                        }
                        break block12;
                    }
                    throw new Exception(folderName + " is not a folder'name!");
                }
                catch (Exception e) {
                    strMsg = strMsg + e.getMessage() + "\r\n";
                }
            }
            return strMsg;
        }
        throw new Exception("you didnot login remote ftp server!");
    }

    public void uploadAllFilesInFolder(String folderName, String ftpPath) throws Exception {
        block9: {
            if (this.isLogin) {
                String strMsg = "";
                try {
                    File file = new File(folderName);
                    if (file.isDirectory()) {
                        this.ftpClient.chdir("/");
                        this.ftpClient.setType(FTPTransferType.BINARY);
                        if (this.checkFolderIsExist(ftpPath)) {
                            this.ftpClient.chdir(ftpPath);
                        } else {
                            this.createFolder(ftpPath);
                        }
                        File[] files = file.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].isFile()) continue;
                            try {
                                this.ftpClient.put(files[i].getPath(), files[i].getName());
                                continue;
                            }
                            catch (Exception ee) {
                                strMsg = strMsg + "upload file<<\uff1a" + files[i].getPath() + ">> error\uff01Message:" + ee.getMessage() + "\r\n";
                                logger.info((Object)strMsg);
                            }
                        }
                        break block9;
                    }
                    throw new Exception(folderName + " is not a folder'name!");
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            }
            throw new Exception("you didnot login remote ftp server!");
        }
    }

    public void uploadFile(String clientFileName, String ftpPath) throws Exception {
        if (this.isLogin) {
            try {
                String filename = "";
                int index = clientFileName.lastIndexOf("\\");
                filename = clientFileName.substring(index + 1);
                this.ftpClient.chdir("/");
                this.ftpClient.setType(FTPTransferType.BINARY);
                if (this.checkFolderIsExist(ftpPath)) {
                    this.ftpClient.chdir(ftpPath);
                } else {
                    this.createFolder(ftpPath);
                }
                this.ftpClient.put(clientFileName, filename);
            }
            catch (Exception ex) {
                throw new Exception(ex.getMessage());
            }
        } else {
            throw new Exception("you didnot login remote ftp server!");
        }
    }

    public boolean checkFolderIsExist(String pFolder) throws Exception {
        if (this.isLogin) {
            String folder = pFolder.trim();
            if (folder.startsWith("/")) {
                folder = folder.substring(1);
            }
            if (folder.endsWith("/")) {
                folder = folder.substring(0, folder.length() - 1);
            }
            String strLayer = "..";
            if (folder.indexOf("/") > 0) {
                String[] folders = folder.split("/");
                for (int i = 1; i < folders.length; ++i) {
                    strLayer = strLayer + ",";
                }
            }
            boolean result = false;
            try {
                this.ftpClient.chdir(folder);
                this.ftpClient.chdir(strLayer);
                result = true;
            }
            catch (Exception ex) {
                result = false;
            }
            return result;
        }
        throw new Exception("you didnot login remote ftp server!");
    }

    public void createFolder(String pFolder) throws Exception {
        if (this.isLogin) {
            if (!this.checkFolderIsExist(pFolder)) {
                try {
                    this.ftpClient.chdir("/");
                    String[] folders = pFolder.split("/");
                    for (int i = 0; i < folders.length; ++i) {
                        try {
                            this.ftpClient.chdir(folders[i]);
                            continue;
                        }
                        catch (Exception ex) {
                            this.ftpClient.mkdir(folders[i]);
                            this.ftpClient.chdir(folders[i]);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new Exception(ex.getMessage());
                }
            }
        } else {
            throw new Exception("you didnot login remote ftp server!");
        }
    }

    public void downFile(String ftpPath, String ftpFileName, String localPath) throws Exception {
        try {
            this.ftpClient.setType(FTPTransferType.BINARY);
            if (!StringUtils.isEmpty((String)ftpPath) && this.checkFolderIsExist(ftpPath)) {
                this.ftpClient.chdir(ftpPath);
            }
            this.ftpClient.get(localPath + "/" + ftpFileName, ftpFileName);
            logger.info((Object)("download file '" + ftpFileName + "'successed!"));
        }
        catch (Exception e) {
            logger.info((Object)("down File Error:" + e.getMessage()));
            throw e;
        }
    }

    public List downFiles(Context ctx, String ftpPath, String[] ftpFileFilter, String localPath) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.ftpClient.setType(FTPTransferType.BINARY);
            if (!StringUtils.isEmpty((String)ftpPath) && this.checkFolderIsExist(ftpPath)) {
                this.ftpClient.chdir(ftpPath);
            }
            String[] files = this.ftpClient.dir();
            Object isSupportOtherDS = CslRptUtil.getParamValue(ctx, null, "GR_CSL_SupportOtherDS");
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                if (fileName.indexOf(ftpFileFilter[0]) < 0 && fileName.indexOf(ftpFileFilter[1]) < 0 && (!"true".equals(isSupportOtherDS) || fileName.indexOf(ftpFileFilter[2]) < 0)) continue;
                this.ftpClient.get(localPath + "/" + fileName, fileName);
                result.add(fileName);
            }
        }
        catch (Exception e) {
            logger.info((Object)("down File Error:" + e.getMessage()));
            throw e;
        }
        return result;
    }

    public boolean isExistFile(String ftpFileName) {
        try {
            this.ftpClient.setType(FTPTransferType.BINARY);
            this.ftpClient.modtime(ftpFileName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

