/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import java.util.ArrayList;

public class Location {
    private int tableIndex;
    private int rowIndex;
    private int colIndex;

    public Location(int tableIndex, int rowIndex, int colIndex) {
        this.tableIndex = tableIndex;
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getTableIndex() {
        return this.tableIndex;
    }

    public String getCellName() {
        return Location.getCellName(this.rowIndex, this.colIndex);
    }

    public static String getCellName(int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0) {
            return null;
        }
        return SheetBaseMath.getBlockA1Name((int)rowIndex, (int)colIndex, (boolean)false, (boolean)false);
    }

    public static int[] getBaseSeries(int number, int base) {
        if (number < 0 || base < 1) {
            return new int[0];
        }
        int n = number;
        ArrayList<Integer> result = new ArrayList<Integer>();
        do {
            result.add(0, new Integer(n - n / base * base));
        } while ((n /= base) > 0);
        int[] ret = new int[result.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)result.get(i);
        }
        return ret;
    }

    public static int[] getCellRowAndColumn(String cellName) {
        int[] array = new int[]{-1, -1};
        if (cellName == null) {
            return array;
        }
        if (!(cellName = cellName.toUpperCase()).matches("[A-Z]+\\d+")) {
            return array;
        }
        int rowIndex = 0;
        int columnIndex = 0;
        char z = 'Z';
        char a = 'A';
        int n = cellName.length();
        for (int i = 0; i < n; ++i) {
            char c = cellName.charAt(i);
            if (c < a || c > z) {
                rowIndex = Integer.parseInt(cellName.substring(i, n));
                break;
            }
            columnIndex = columnIndex * 26 + (c - a + 1);
        }
        array[0] = rowIndex - 1;
        array[1] = columnIndex - 1;
        return array;
    }
}

