/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.io.clipboard.ClipboardTransferHandler;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetActionColRow_Paste;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Paste;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.IMnsRptSeqSchemeFacade;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostMan;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostManManager;
import com.kingdee.eas.fi.gr.cslrpt.MnsRptSeqSchemeFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ClearCompanyItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptFillCondition;
import com.kingdee.eas.fi.newrpt.samecontrol.CslOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.samecontrol.DisposalType;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.util.StringUtils;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class MnsRptGuideHelper {
    public static final int CALC_TYPE_All = 0;
    public static final int CALC_TYPE_RPT = 1;
    public static final int CALC_TYPE_ELIM = 2;
    public static final String OrgUnitType_Company = "0";
    public static final String OrgUnitType_Unit = "1";
    private static boolean isOnlyDisplayFullName = false;

    private MnsRptGuideHelper() {
    }

    public static boolean isSupportCrossMerger(Context ctx, OrgTreeInfo orgtree) {
        return CSLParamUtil.isSupportCrossMerger(ctx, orgtree.getId().toString());
    }

    private static void isOnlyDisplayFullName(Context ctx) {
        isOnlyDisplayFullName = CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_PERFORMANCE_ISONLYDISPLAYFULLNAME");
    }

    public static Book fillMnsRptSheet(Context ctx, List companys, Book book) throws EASBizException, BOSException {
        MnsRptGuideHelper.isOnlyDisplayFullName(ctx);
        return MnsRptGuideHelper.prepareSheetData(ctx, companys, null, null, book);
    }

    public static Book fillMnsRptSheet(Context ctx, List companys, List excludeCompanys, Book book) throws EASBizException, BOSException {
        MnsRptGuideHelper.isOnlyDisplayFullName(ctx);
        return MnsRptGuideHelper.prepareSheetData(ctx, companys, excludeCompanys, null, book);
    }

    public static Book fillMnsRptSheet(MnsRptFillCondition condition) throws EASBizException, BOSException {
        MnsRptGuideHelper.isOnlyDisplayFullName(condition.getCtx());
        if (condition.companys == null) {
            condition.companys = MnsRptGuideHelper.getCompanys(condition.getCtx(), condition.getOrgTree(), condition.getOrgUnitGroup());
        }
        return MnsRptGuideHelper.prepareSheetData(condition.getCtx(), condition.companys, condition.excludeCompanys, condition, condition.book);
    }

    public static Book fillMnsRptSheet(Context ctx, OrgTreeInfo orgTree, OrgUnitInfo orgUnitGroup, Book book) throws EASBizException, BOSException {
        MnsRptGuideHelper.isOnlyDisplayFullName(ctx);
        List companys = MnsRptGuideHelper.getCompanys(ctx, orgTree, orgUnitGroup);
        return MnsRptGuideHelper.prepareSheetData(ctx, companys, null, null, book);
    }

    public static boolean isIncludeAdjust(Sheet sheet, Cell basePointCell) {
        ItemFormula basePointFormul;
        boolean isIncludeAdjust = false;
        if (basePointCell == null) {
            int left = CslRptUtil.getBasePosition_Left(sheet);
            int top = CslRptUtil.getBasePosition_Top(sheet);
            basePointCell = sheet.getCell(top, left, false);
        }
        if (basePointCell != null && (basePointFormul = (ItemFormula)basePointCell.getUserObjectValue("ITEM")) != null) {
            isIncludeAdjust = OrgUnitType_Unit.equals(basePointFormul.getExt("isIncludeAdjust"));
        }
        return isIncludeAdjust;
    }

    public static Integer[] getAdjustDataSrc(ItemFormula itemFormula) {
        String adjustDataSrcStr = itemFormula.getExt("DATASRCFORADJUST");
        if (!StringUtils.isEmpty((String)adjustDataSrcStr)) {
            String[] adjustDataSrcs = adjustDataSrcStr.split(",");
            Integer[] adjustDataSrcArr = new Integer[adjustDataSrcs.length];
            for (int i = 0; i < adjustDataSrcs.length; ++i) {
                adjustDataSrcArr[i] = Integer.valueOf(adjustDataSrcs[i].trim());
            }
            return adjustDataSrcArr;
        }
        return null;
    }

    public static void initPosRange(Map<Integer, List<Integer[]>> stylePosMap, Integer ixOriginal, Integer ixPos) {
        List<Integer[]> tmpPosRangeList = stylePosMap.get(ixOriginal);
        if (tmpPosRangeList == null) {
            tmpPosRangeList = new ArrayList<Integer[]>();
            stylePosMap.put(ixOriginal, tmpPosRangeList);
            tmpPosRangeList.add(new Integer[]{ixPos, ixPos});
        } else {
            Integer[] tmpPosRange = tmpPosRangeList.get(tmpPosRangeList.size() - 1);
            if (tmpPosRange[1] + 1 == ixPos) {
                tmpPosRange[1] = ixPos;
            } else {
                tmpPosRangeList.add(new Integer[]{ixPos, ixPos});
            }
        }
    }

    private static Book prepareSheetData(Context ctx, List companys, List excludeCompanys, MnsRptFillCondition condition, Book book) throws BOSException {
        if (companys == null) {
            return book;
        }
        List disposalCompanys = null;
        disposalCompanys = condition.isSupportCrossMerger ? new ArrayList() : SameControlUtil.getDisposalCompanys((Context)ctx, (List)companys, (MnsRptFillCondition)condition);
        boolean autoCalculate = book.isAutoCalculate();
        book.setCalculate(false);
        try {
            int x;
            book.getUndoManager().enable(false);
            book.getUndoManager().startGroup();
            book.setSkipListeners(true);
            for (x = 0; x < book.getSheetCount(); ++x) {
                book.getSheet(x);
            }
            for (x = 0; x < book.getSheetCount(); ++x) {
                Sheet sheet = book.getSheet(x);
                if (!sheet.isEnableCalculation()) continue;
                Protection pro = sheet.getSheetOption().getProtection(false);
                boolean willProtect = false;
                String proPass = null;
                if (pro != null && pro.isProtected()) {
                    proPass = pro.getEncryptedPassword();
                    pro.setPassword(proPass);
                    pro.stop(proPass);
                    willProtect = true;
                }
                Point basePoint = MnsRptGuideHelper.getBasePoint(sheet);
                int left = basePoint.x;
                int top = basePoint.y;
                ArrayList ls = new ArrayList();
                HashMap mapSumItem = new HashMap();
                ArrayList removeColList = new ArrayList();
                HashMap<Integer, List<Integer[]>> stylePosMap = new HashMap<Integer, List<Integer[]>>();
                ArrayList<Integer[]> mergeRange = new ArrayList<Integer[]>();
                MnsRptGuideHelper.initSheetCol(ctx, sheet, companys, disposalCompanys, condition, ls, removeColList, mapSumItem, left, top);
                MnsRptGuideHelper.fillSheetCol(ctx, sheet, ls, stylePosMap, mapSumItem, mergeRange, removeColList, top);
                MnsRptGuideHelper.setStyle(ctx, sheet, stylePosMap, mergeRange, removeColList, top);
                if (!willProtect) continue;
                pro.deleteOperation(32);
                pro.startWithEncryptedPassword(proPass);
            }
            MnsRptGuideHelper.clearCellFormulaByDataCollect(book);
            Book x2 = book;
            return x2;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            book.setSkipListeners(false);
            book.getUndoManager().enable(true);
            book.getUndoManager().endGroup();
            book.setCalculate(autoCalculate);
        }
    }

    public static void setStyle(Context ctx, Sheet sheet, Map<Integer, List<Integer[]>> stylePosMap, List<Integer[]> mergeRange, List removeColList, int top) throws Exception {
        List<Integer[]> tmpPosRangeList = null;
        if (!stylePosMap.isEmpty()) {
            int endR = sheet.getMaxRowIndex();
            for (int curOrginal : stylePosMap.keySet()) {
                tmpPosRangeList = stylePosMap.get(curOrginal);
                for (Integer[] curPosRange : tmpPosRangeList) {
                    if (curPosRange[0] == curPosRange[1] && curPosRange[1] == curOrginal) continue;
                    MnsRptGuideHelper.copyTo(ctx, sheet, top, curOrginal, endR, curOrginal, top, curPosRange[0], endR, curPosRange[1], new PasteMode(PasteMode.Formats | PasteMode.Formulas));
                    sheet.getRange(top, curOrginal, top, curPosRange[1].intValue()).setCellLocked(true);
                }
            }
        }
        stylePosMap.clear();
        for (Integer[] range : mergeRange) {
            sheet.getRange(range[0].intValue(), range[1].intValue(), range[2].intValue(), range[3].intValue()).merge();
            sheet.getRange(range[0].intValue(), range[1].intValue(), range[2].intValue(), range[3].intValue()).setCellLocked(true);
        }
        mergeRange.clear();
        for (int i = removeColList.size() - 1; i >= 0; --i) {
            int[] col = (int[])removeColList.get(i);
            UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(col[0], col[1])).delete();
        }
    }

    public static void getInsertCols(int startCol, int endCol, List<int[]> insertCols) throws Exception {
        if (insertCols != null) {
            int[] lastCols;
            int lastEndCol;
            boolean isMerge = false;
            if (!insertCols.isEmpty() && startCol == (lastEndCol = (lastCols = insertCols.get(insertCols.size() - 1))[1]) + 1) {
                isMerge = true;
                lastCols[1] = endCol;
            }
            if (!isMerge) {
                insertCols.add(new int[]{startCol, endCol});
            }
        }
    }

    public static void insertCols(Sheet sheet, List ls) throws Exception {
        int ixPos = 0;
        int step = 1;
        ItemFormula tmpFormula2 = null;
        ArrayList<int[]> insertCols = new ArrayList<int[]>();
        for (ItemFormula tmpFormula2 : ls) {
            ixPos = Integer.valueOf(tmpFormula2.getExt("Index"));
            step = tmpFormula2.getExt("step") != null ? Integer.valueOf(tmpFormula2.getExt("step")) : 1;
            if (Boolean.valueOf(tmpFormula2.getExt("Cover")).booleanValue()) continue;
            MnsRptGuideHelper.getInsertCols(ixPos, ixPos + step - 1, insertCols);
        }
        for (int[] insertCol : insertCols) {
            UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(insertCol[0], insertCol[1])).insert(false, InsertType.NOSTYLE);
        }
    }

    public static void fillSheetCol(Context ctx, Sheet sheet, List ls, Map<Integer, List<Integer[]>> stylePosMap, Map mapSumItem, List<Integer[]> mergeRange, List removeColList, int top) throws Exception {
        MnsRptGuideHelper.insertCols(sheet, ls);
        int ixPos = 0;
        int ixOriginal = 0;
        int step = 1;
        boolean isCover = false;
        boolean isIncludeAdjust = false;
        ItemFormula tmpFormula2 = null;
        for (ItemFormula tmpFormula2 : ls) {
            int i;
            ixPos = Integer.valueOf(tmpFormula2.getExt("Index"));
            ixOriginal = Integer.valueOf(tmpFormula2.getExt("Original"));
            step = tmpFormula2.getExt("step") != null ? Integer.valueOf(tmpFormula2.getExt("step")) : 1;
            isIncludeAdjust = tmpFormula2.getExt("DATASRCFORADJUST") != null;
            for (i = 0; i < step; ++i) {
                MnsRptGuideHelper.initPosRange(stylePosMap, ixOriginal + i, ixPos + i);
            }
            isCover = Boolean.valueOf(tmpFormula2.getExt("Cover"));
            if (!isCover) {
                for (i = 0; i < step; ++i) {
                    int colWidth = Sheet.getColWidth((Sheet)sheet, (int)(ixOriginal + i));
                    sheet.getColSpans().setSpanAttribute(new Span(ixPos + i, ixPos + i), null, Integer.valueOf(colWidth), null, null, null, null);
                    if (!isIncludeAdjust) continue;
                    sheet.getCell(top + 1, ixPos + i, true).setValue(sheet.getCell(top + 1, ixOriginal + i, true).getValue());
                    sheet.getCell(top + 1, ixPos + i, true).setUserObject("ITEM", sheet.getCell(top + 1, ixOriginal + i, true).getUserObjectValue("ITEM"));
                    sheet.getCell(top + 1, ixPos + i, true).setUserObject("DATASRCFORADJUST", sheet.getCell(top + 1, ixOriginal + i, true).getUserObjectValue("DATASRCFORADJUST"));
                }
                if (mapSumItem != null && !mapSumItem.isEmpty() && !StringUtils.isEmpty((String)tmpFormula2.getExt("Company"))) {
                    Iterator ite = mapSumItem.keySet().iterator();
                    Cell cell = null;
                    while (ite != null && ite.hasNext()) {
                        Integer row = (Integer)ite.next();
                        List lstTemp = (List)mapSumItem.get(row);
                        String strHeadKey = (String)lstTemp.get(0);
                        String strExp = (String)lstTemp.get(1);
                        String strHeadKeyNew = TableToolkit.int2pos((int)ixPos);
                        cell = sheet.getCell(row.intValue(), ixPos, true);
                        cell.setFormula(strExp.replaceAll(strHeadKey, strHeadKeyNew));
                        cell.setUserObject(OrgUnitType_Company, null);
                        cell.setUserObject(OrgUnitType_Unit, null);
                    }
                }
            }
            if (tmpFormula2.getExt("Company") != null) {
                Cell tmpCell = sheet.getCell(top, ixPos, true);
                if (tmpCell != null && tmpFormula2.getExt("CompanyName") != null) {
                    String columnValue = new StringBuffer(tmpFormula2.getExt("CompanyName")).append("(").append(MnsRptGuideHelper.getDataElementName(ctx, tmpFormula2.getDataElementNumber())).append(")").toString();
                    tmpCell.setValue(new Variant((Object)columnValue));
                    tmpFormula2.removeExt("CompanyName");
                }
                tmpFormula2.removeExt("Index");
                tmpFormula2.removeExt("Cover");
                tmpFormula2.removeExt("Original");
                if (tmpCell != null) {
                    tmpCell.setUserObject("ITEM", (Object)tmpFormula2);
                    if (!isIncludeAdjust) {
                        sheet.getRange(tmpCell).setCellLocked(true);
                    }
                }
                if (isIncludeAdjust) {
                    if (isCover) {
                        sheet.getRange(top, ixPos, top, ixPos + step - 1).merge();
                    }
                    mergeRange.add(new Integer[]{top, ixPos, top, ixPos + step - 1});
                }
            }
            ++ixPos;
        }
    }

    public static void initSheetCol(Context ctx, Sheet sheet, List companys, List disposalComanys, MnsRptFillCondition condition, List ls, List removeColList, Map mapSumItem, int left, int top) throws Exception {
        int curComIxpos = 0;
        int count = 0;
        int curOriginal = 0;
        List<ClearCompanyItemInfo> clearingCompanys = null;
        ArrayList<ItemFormula> dataElementList = new ArrayList<ItemFormula>();
        HashSet<String> dataElementSet = new HashSet<String>();
        ArrayList<Integer> creditAndDebitLine = new ArrayList<Integer>();
        int maxCol = sheet.getMaxColIndex();
        int singleColCount = 0;
        int clearSingleColCount = 0;
        int disposalColCount = 0;
        int mm = left;
        boolean isIncludeAdjust = MnsRptGuideHelper.isIncludeAdjust(sheet, sheet.getCell(top, left, false));
        ItemFormula tmpFormula2 = null;
        String clearStr = null;
        String disposalStr = null;
        int step = 1;
        int n = maxCol;
        for (int i = left; i <= n; ++i) {
            Cell curCell = sheet.getCell(top, i, false);
            if (curCell != null) {
                int j;
                ItemFormula nextCellItemFormula;
                Cell nextCell;
                Iterator iterDataElement;
                String currDataElementNumber;
                ItemFormula itemFormula = (ItemFormula)curCell.getUserObjectValue("ITEM");
                if (itemFormula == null) {
                    ++mm;
                }
                if (itemFormula == null || itemFormula.getExt("DataSrc") == null) continue;
                Integer dataSrc = Integer.valueOf(itemFormula.getExt("DataSrc"));
                if (dataSrc == 1) {
                    Integer nextItemDataSrc;
                    ItemFormula nextCellItemFormula2;
                    Cell nextCell2;
                    currDataElementNumber = itemFormula.getDataElementNumber();
                    if (!dataElementSet.contains(currDataElementNumber)) {
                        dataElementList.add(itemFormula);
                        dataElementSet.add(currDataElementNumber);
                        ++mm;
                    }
                    ++singleColCount;
                    Integer[] adjustDataSrc = null;
                    if (isIncludeAdjust) {
                        adjustDataSrc = MnsRptGuideHelper.getAdjustDataSrc(itemFormula);
                    }
                    if ((nextCell2 = sheet.getCell(top, i + (step = isIncludeAdjust && adjustDataSrc != null ? adjustDataSrc.length : 1), false)) != null && (nextCellItemFormula2 = (ItemFormula)nextCell2.getUserObjectValue("ITEM")) != null && nextCellItemFormula2.getExt("DataSrc") != null && (nextItemDataSrc = Integer.valueOf(nextCellItemFormula2.getExt("DataSrc"))) == 1) {
                        if (!isIncludeAdjust) continue;
                        i = i + step - 1;
                        continue;
                    }
                    int dataElementSize = dataElementList.size();
                    curOriginal = curComIxpos = mm - dataElementSize + 1;
                    count = 0;
                    Iterator iterCompany = companys.iterator();
                    int pos = 0;
                    while (iterCompany.hasNext()) {
                        OrgUnitInfo curCom = (OrgUnitInfo)iterCompany.next();
                        pos = 0;
                        iterDataElement = dataElementList.iterator();
                        while (iterDataElement.hasNext()) {
                            tmpFormula2 = (ItemFormula)((ItemFormula)iterDataElement.next()).clone();
                            tmpFormula2.putExt("Company", curCom.getId().toString());
                            tmpFormula2.putExt("CompanyNumber", curCom.getNumber());
                            if (isOnlyDisplayFullName) {
                                tmpFormula2.putExt("CompanyName", curCom.getName());
                            } else {
                                tmpFormula2.putExt("CompanyName", StringUtils.isEmpty((String)curCom.getSimpleName()) ? curCom.getName() : curCom.getSimpleName());
                            }
                            tmpFormula2.putExt("Cover", Boolean.valueOf(count < singleColCount).toString());
                            tmpFormula2.putExt("Index", Integer.toString(curComIxpos));
                            tmpFormula2.putExt("Original", Integer.toString(curOriginal + pos));
                            if (isIncludeAdjust) {
                                tmpFormula2.putExt("DATASRCFORADJUST", itemFormula.getExt("DATASRCFORADJUST"));
                            }
                            tmpFormula2.putExt("step", Integer.toString(step));
                            ls.add(tmpFormula2);
                            pos += step;
                            curComIxpos += step;
                            ++count;
                        }
                    }
                    if (count < singleColCount) {
                        removeColList.add(new int[]{curComIxpos, curComIxpos + (singleColCount - count) * step - 1});
                        mm = mm + singleColCount * step - 1;
                    } else {
                        mm = curOriginal + count * step - 1;
                    }
                    singleColCount = 0;
                    for (int j2 = i - dataElementSize + 1; j2 <= i; ++j2) {
                        creditAndDebitLine.add(j2);
                    }
                    dataElementList.clear();
                    dataElementSet.clear();
                    if (!isIncludeAdjust) continue;
                    i = i + step - 1;
                    continue;
                }
                if (dataSrc == 9) {
                    Integer nextItemDataSrc;
                    currDataElementNumber = itemFormula.getDataElementNumber();
                    if (!dataElementSet.contains(currDataElementNumber)) {
                        dataElementList.add(itemFormula);
                        dataElementSet.add(currDataElementNumber);
                        ++mm;
                    }
                    ++clearSingleColCount;
                    nextCell = sheet.getCell(top, i + 1, false);
                    if (nextCell != null && (nextCellItemFormula = (ItemFormula)nextCell.getUserObjectValue("ITEM")) != null && nextCellItemFormula.getExt("DataSrc") != null && (nextItemDataSrc = Integer.valueOf(nextCellItemFormula.getExt("DataSrc"))) == 9) continue;
                    int dataElementSize = dataElementList.size();
                    curOriginal = curComIxpos = mm - dataElementSize + 1;
                    if (clearingCompanys == null && condition != null) {
                        clearingCompanys = condition.getClearingCompanyList();
                    }
                    if (clearingCompanys != null && clearingCompanys.size() > 0) {
                        count = 0;
                        Iterator<ClearCompanyItemInfo> clearIterCompany = clearingCompanys.iterator();
                        int pos = 0;
                        while (clearIterCompany.hasNext()) {
                            ClearCompanyItemInfo clearCom = clearIterCompany.next();
                            FullOrgUnitInfo curCom = clearCom.getClearCompany();
                            pos = 0;
                            iterDataElement = dataElementList.iterator();
                            while (iterDataElement.hasNext()) {
                                tmpFormula2 = (ItemFormula)((ItemFormula)iterDataElement.next()).clone();
                                tmpFormula2.putExt("Company", curCom.getId().toString());
                                tmpFormula2.putExt("CompanyNumber", curCom.getNumber());
                                if (isOnlyDisplayFullName) {
                                    tmpFormula2.putExt("CompanyName", CslDataSrcTypeEnum.INCLUDECLEARSINGLE.getAlias().substring(0, 2) + "-" + curCom.getName());
                                } else {
                                    tmpFormula2.putExt("CompanyName", CslDataSrcTypeEnum.INCLUDECLEARSINGLE.getAlias().substring(0, 2) + "-" + (StringUtils.isEmpty((String)curCom.getSimpleName()) ? curCom.getName() : curCom.getSimpleName()));
                                }
                                tmpFormula2.putExt("Cover", Boolean.valueOf(count < clearSingleColCount).toString());
                                tmpFormula2.putExt("Index", Integer.toString(curComIxpos));
                                tmpFormula2.putExt("Original", Integer.toString(curOriginal + pos));
                                ls.add(tmpFormula2);
                                ++pos;
                                ++curComIxpos;
                                ++count;
                            }
                        }
                        if (count < clearSingleColCount) {
                            removeColList.add(new int[]{curComIxpos, curComIxpos + (clearSingleColCount - count - 1)});
                            mm = mm + clearSingleColCount - 1;
                        } else {
                            mm = curOriginal + count - 1;
                        }
                        clearSingleColCount = 0;
                        for (j = i - dataElementSize + 1; j <= i; ++j) {
                            creditAndDebitLine.add(j);
                        }
                    }
                    dataElementList.clear();
                    dataElementSet.clear();
                    continue;
                }
                if (dataSrc == 13) {
                    Integer nextItemDataSrc;
                    currDataElementNumber = itemFormula.getDataElementNumber();
                    if (!dataElementSet.contains(currDataElementNumber)) {
                        dataElementList.add(itemFormula);
                        dataElementSet.add(currDataElementNumber);
                        ++mm;
                    }
                    ++disposalColCount;
                    nextCell = sheet.getCell(top, i + 1, false);
                    if (nextCell != null && (nextCellItemFormula = (ItemFormula)nextCell.getUserObjectValue("ITEM")) != null && nextCellItemFormula.getExt("DataSrc") != null && (nextItemDataSrc = Integer.valueOf(nextCellItemFormula.getExt("DataSrc"))) == 13) continue;
                    int dataElementSize = dataElementList.size();
                    curOriginal = curComIxpos = mm - dataElementSize + 1;
                    count = 0;
                    Iterator disposalCompanyItr = disposalComanys.iterator();
                    int pos = 0;
                    if (disposalComanys != null && !disposalComanys.isEmpty()) {
                        while (disposalCompanyItr.hasNext()) {
                            CslOrgUnitInfo curCom = (CslOrgUnitInfo)disposalCompanyItr.next();
                            pos = 0;
                            Iterator iterDataElement2 = dataElementList.iterator();
                            while (iterDataElement2.hasNext()) {
                                tmpFormula2 = (ItemFormula)((ItemFormula)iterDataElement2.next()).clone();
                                tmpFormula2.putExt("Company", curCom.getCompany().getId().toString());
                                tmpFormula2.putExt("CompanyNumber", curCom.getCompany().getNumber());
                                tmpFormula2.putExt("isunion", curCom.getCompany().isIsUnion() ? OrgUnitType_Unit : OrgUnitType_Company);
                                String preName = null;
                                if (DisposalType.Clear.equals((Object)curCom.getDisposalType())) {
                                    if (StringUtils.isEmpty(clearStr)) {
                                        clearStr = ctx != null ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.samecontrol.SameControlResource", (String)"1_clear", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.samecontrol.SameControlResource", (String)"1_clear");
                                    }
                                    preName = clearStr;
                                } else {
                                    if (StringUtils.isEmpty(disposalStr)) {
                                        disposalStr = ctx != null ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.samecontrol.SameControlResource", (String)"2_disposal", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.samecontrol.SameControlResource", (String)"2_disposal");
                                    }
                                    preName = disposalStr;
                                }
                                if (isOnlyDisplayFullName) {
                                    tmpFormula2.putExt("CompanyName", preName + "-" + curCom.getCompany().getName());
                                } else {
                                    tmpFormula2.putExt("CompanyName", preName + "-" + (StringUtils.isEmpty((String)curCom.getCompany().getSimpleName()) ? curCom.getCompany().getName() : curCom.getCompany().getSimpleName()));
                                }
                                tmpFormula2.putExt("Cover", Boolean.valueOf(count < disposalColCount).toString());
                                tmpFormula2.putExt("Index", Integer.toString(curComIxpos));
                                tmpFormula2.putExt("Original", Integer.toString(curOriginal + pos));
                                ls.add(tmpFormula2);
                                ++pos;
                                ++curComIxpos;
                                ++count;
                            }
                        }
                    } else {
                        for (ItemFormula tmpFormula2 : dataElementList) {
                            tmpFormula2.removeExt("Original");
                            tmpFormula2.removeExt("Index");
                            tmpFormula2.removeExt("Cover");
                            tmpFormula2.removeExt("CompanyName");
                            tmpFormula2.removeExt("isunion");
                            tmpFormula2.removeExt("Company");
                            curCell.setValue(new Variant((Object)(CslDataSrcTypeEnum.DISPOSALSINGLE.getAlias() + "(" + MnsRptGuideHelper.getDataElementName(ctx, tmpFormula2.getDataElementNumber()) + ")")));
                        }
                        count = 1;
                    }
                    if (count < disposalColCount) {
                        removeColList.add(new int[]{curComIxpos, curComIxpos + (disposalColCount - count) - 1});
                        mm = mm + disposalColCount - 1;
                    } else {
                        mm = curOriginal + count - 1;
                    }
                    disposalColCount = 0;
                    for (j = i - dataElementSize + 1; j <= i; ++j) {
                        creditAndDebitLine.add(j);
                    }
                    dataElementList.clear();
                    dataElementSet.clear();
                    continue;
                }
                if (dataSrc == 5 || dataSrc == 4 || dataSrc == 6 || dataSrc == 2) {
                    creditAndDebitLine.add(i);
                    ++mm;
                    continue;
                }
                if (dataSrc == 3) {
                    ++mm;
                    if (creditAndDebitLine.size() == 0) continue;
                    if (mapSumItem == null) {
                        mapSumItem = new HashMap();
                    }
                    MnsRptGuideHelper.compatibleOldTemplate(ctx, sheet, creditAndDebitLine, i, mapSumItem);
                    continue;
                }
                ++mm;
                continue;
            }
            ++mm;
        }
    }

    private static void copyTo(Context ctx, Sheet sheet, int srcTop, int srcCol, int srcTop2, int srcCol2, int trgTop, int trgCol, int trgTop2, int trgCol2, PasteMode pastMode) throws Exception {
        Range srcRange = sheet.getRange(srcTop, srcCol, srcTop2, srcCol2);
        HashMap map = srcRange.getMergeLimitProtectState();
        if (map != null) {
            MergeBlocks mergeBlocks = sheet.getSheetOption().getMerger(false);
            CellBlock block = null;
            TreeMap<Integer, Integer> mergBlockMap = new TreeMap<Integer, Integer>();
            for (int i = 0; i < mergeBlocks.size(); ++i) {
                block = mergeBlocks.getBlock(i);
                if (block.getRow() < srcTop || block.getRow() > srcTop2 || srcCol < block.getCol() || srcCol > block.getCol2()) continue;
                mergBlockMap.put(block.getRow(), block.getRow2() < srcTop2 ? block.getRow2() : srcTop2);
            }
            if (mergBlockMap.isEmpty()) {
                srcRange.copyTo(sheet, sheet.getRange(trgTop, trgCol, trgTop2, trgCol2), pastMode);
            } else {
                int index = 1;
                int mergerCount = mergBlockMap.size();
                int startRow = srcTop;
                for (Integer mergerRowStart : mergBlockMap.keySet()) {
                    if (startRow < mergerRowStart) {
                        sheet.getRange(startRow, srcCol, mergerRowStart - 1, srcCol2).copyTo(sheet, sheet.getRange(trgTop + (startRow - srcTop), trgCol, trgTop + (mergerRowStart - 1 - srcTop), trgCol2), pastMode);
                    }
                    startRow = (Integer)mergBlockMap.get(mergerRowStart) + 1;
                    if (index == mergerCount && startRow < srcTop2) {
                        sheet.getRange(startRow, srcCol, srcTop2, srcCol2).copyTo(sheet, sheet.getRange(trgTop + (startRow - srcTop), trgCol, trgTop2, trgCol2), pastMode);
                    }
                    ++index;
                }
                mergBlockMap.clear();
            }
        } else {
            srcRange.copyTo(sheet, sheet.getRange(trgTop, trgCol, trgTop2, trgCol2), pastMode);
        }
    }

    public static SheetAction_Paste getActionPaste(Book dstBook, Sheet srcSheet, Range srcRange, Range dstRange, PasteMode pasteMode) throws Exception {
        ClipboardTransferHandler.getClipDstBook((Sheet)srcSheet, (SortedCellBlockArray)srcRange);
        Book srcBook = KDClipboard.getClipboardBook();
        SheetAction_Paste paste = MnsRptGuideHelper.getActionPaste(srcBook, dstBook, dstRange, pasteMode, null);
        return paste;
    }

    private static SheetAction_Paste getActionPaste(Book srcBook, Book dstBook, Range dstRange, PasteMode mode, String[] userKeys) throws Exception {
        if (srcBook != null) {
            boolean isHeadLess = GraphicsEnvironment.isHeadless();
            if (KDClipboard.isCut()) {
                KDClipboard.setCut((boolean)false);
            }
            CellBlock blockInfo = CellBlock.getNewCellBlock((int)0, (int)0);
            SortedCellBlockArray pasteBlocks = (SortedCellBlockArray)CslRptUtil.invoke(dstRange, "makePasteBlocks", new Class[]{Sheet.class, CellBlock.class}, new Object[]{srcBook.getSheet(0), blockInfo});
            if (dstRange.getMergeLimitProtectState() != null) {
                if (!isHeadLess) {
                    MessageDialog.show(null, (Object)MultiLanguageKeys.getLocalText((String)"PasteAreaAreDifferent", (String)"\u590d\u5236\u533a\u57df\u4e0e\u7c98\u8d34\u533a\u57df\u5f62\u72b6\u4e0d\u540c\uff0c\u65e0\u6cd5\u7c98\u8d34\u3002"), (String)MultiLanguageKeys.getLocalText((String)"warning", (String)"\u8b66\u544a"), (int)-1, (int)2);
                }
                return null;
            }
            if (pasteBlocks != null) {
                boolean ispasteValidity;
                Protection pro;
                if (!KDClipboard.isOffset()) {
                    mode = mode.noOffset();
                }
                if ((pro = dstBook.getActiveSheet().getSheetOption().getProtection(false)) != null && !pro.allowFormattingCells()) {
                    mode = PasteMode.FORMULASANDVALUES;
                }
                if (!(ispasteValidity = ((Boolean)CslRptUtil.invoke(dstRange, "checkPasteValidity", new Class[]{Book.class, PasteMode.class}, new Object[]{srcBook, mode})).booleanValue())) {
                    if (!isHeadLess) {
                        MessageDialog.show(null, (Object)MultiLanguageKeys.getLocalText((String)"PasteAreaAreDifferent", (String)"\u590d\u5236\u533a\u57df\u4e0e\u7c98\u8d34\u533a\u57df\u5f62\u72b6\u4e0d\u540c\uff0c\u65e0\u6cd5\u7c98\u8d34\u3002"), (String)MultiLanguageKeys.getLocalText((String)"warning", (String)"\u8b66\u544a"), (int)-1, (int)2);
                    }
                    return null;
                }
                if (dstRange.getBlock(0) != null) {
                    CellBlock cb = dstRange.getBlock(0);
                    Object paste = null;
                    paste = null != cb && (cb.isCol() || cb.isRow()) ? new SheetActionColRow_Paste(dstRange, srcBook, pasteBlocks, blockInfo, mode, userKeys) : new SheetAction_Paste(dstRange, srcBook, pasteBlocks, blockInfo, mode, userKeys);
                    return paste;
                }
            }
        }
        return null;
    }

    private static void copyToByMutilThread(Context ctx, Sheet sheet, int srcTop, int srcCol, int srcTop2, int srcCol2, int trgTop, int trgCol, int trgTop2, int trgCol2, PasteMode pastMode) throws Exception {
        if (srcTop == trgTop && srcTop2 == trgTop2 && trgCol2 - trgCol > 50) {
            int threadCount = 2;
            int batchSize = (trgCol2 - trgCol) / threadCount;
            int lastCol = -1;
            final AtomicInteger atomic = new AtomicInteger(0);
            Range srcRange = sheet.getRange(srcTop, srcCol, srcTop2, srcCol2);
            for (int i = 0; i < threadCount; ++i) {
                int startCol = i == 0 ? trgCol : lastCol + 1;
                lastCol = startCol + batchSize;
                if (lastCol > trgCol2 || i == threadCount - 1) {
                    lastCol = trgCol2;
                }
                int endCol = lastCol;
                final SheetAction_Paste paste = MnsRptGuideHelper.getActionPaste(sheet.getBook(), sheet, srcRange, sheet.getRange(trgTop, startCol, trgTop2, endCol), pastMode);
                if (paste == null) continue;
                atomic.incrementAndGet();
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            paste.run();
                        }
                        finally {
                            atomic.decrementAndGet();
                        }
                    }
                };
                thread.start();
            }
            while (atomic.get() > 0) {
                Thread.sleep(50L);
            }
        } else {
            sheet.getRange(srcTop, srcCol, srcTop2, srcCol2).copyTo(sheet, sheet.getRange(trgTop, trgCol, trgTop2, trgCol2), pastMode);
        }
    }

    private static String getDataElementName(Context ctx, String number) {
        if (ctx == null) {
            return DataElementProvider.getDataElementName(number);
        }
        return DataElementProvider.getDataElementName(ctx, number);
    }

    private static void compatibleOldTemplate(Context ctx, Sheet sheet, List creditAndDebitLine, int i, Map mapSumItem) throws BOSException {
        ArrayList<String> cdAliasLine = new ArrayList<String>();
        for (int k = 0; k < creditAndDebitLine.size(); ++k) {
            String cellName = Location.getCellName(0, (Integer)creditAndDebitLine.get(k));
            cdAliasLine.add(cellName.substring(0, cellName.length() - 1));
        }
        String cellName = Location.getCellName(0, i);
        String colAliase = cellName.substring(0, cellName.length() - 1);
        Map RPTItemInfoMap = MnsRptGuideHelper.getRPTItemInfoList(ctx, sheet, i);
        String regex = "=(.+!)?[A-Z]+\\d+([\\+|\\-](.+!)?[A-Z]+\\d+)*";
        String exp = null;
        ItemFormula item = null;
        int m = sheet.getMaxRowIndex();
        for (int j = 0; j <= m; ++j) {
            Cell cell2;
            Cell cell = sheet.getCell(j, i, false);
            if (cell == null || (exp = cell.getFormula()) == null || !exp.matches(regex) || (item = (ItemFormula)cell.getUserObjectValue("ITEM")) == null) continue;
            String rptItemNumber = item.getItemNumber();
            RPTItemInfo rptitem = (RPTItemInfo)RPTItemInfoMap.get(rptItemNumber);
            if (rptItemNumber != null && rptitem != null && !rptitem.isIsSumItem()) continue;
            for (int k = 0; k < creditAndDebitLine.size(); ++k) {
                cell2 = sheet.getCell(j, ((Integer)creditAndDebitLine.get(k)).intValue(), false);
                if (cell2 == null || cell2.getFormula() != null) continue;
                String exp2 = exp.replaceAll(colAliase, (String)cdAliasLine.get(k));
                cell2.setFormula(exp2);
                cell2.setUserObject(OrgUnitType_Company, null);
                cell2.setUserObject(OrgUnitType_Unit, null);
            }
            String strHeadKey = TableToolkit.int2pos((int)i);
            cell2 = sheet.getCell(j, ((Integer)creditAndDebitLine.get(0)).intValue(), false);
            if (cell2 != null) {
                strHeadKey = TableToolkit.int2pos((int)((Integer)creditAndDebitLine.get(0)));
                TableToolkit.int2pos((int)((Integer)creditAndDebitLine.get(0)));
                exp = cell2.getFormula();
            }
            ArrayList<String> lstTemp = new ArrayList<String>();
            lstTemp.add(strHeadKey);
            lstTemp.add(exp);
            mapSumItem.put(j, lstTemp);
        }
    }

    private static List getCompanys(Context ctx, OrgTreeInfo orgTree, OrgUnitInfo orgUnitGroup) throws EASBizException, BOSException {
        MergeModeEnum mergeMode = CslRptUtil.getMergeMode(ctx, orgTree.getId().toString());
        HashMap<String, Object> scheme = new HashMap<String, Object>(4);
        scheme.put("OrgTree", orgTree.getId().toString());
        scheme.put("OrgUnitGroup", orgUnitGroup);
        scheme.put("MergeMode", (Object)mergeMode);
        scheme.put("queryAllName", Boolean.TRUE);
        IMnsRptSeqSchemeFacade controller = null;
        controller = ctx == null ? MnsRptSeqSchemeFacadeFactory.getRemoteInstance() : MnsRptSeqSchemeFacadeFactory.getLocalInstance(ctx);
        HashMap orgUnitMap = controller.getOrgUnitList(scheme);
        List orgUnitCollection = (List)orgUnitMap.get("OrgUnitList");
        ArrayList<FullOrgUnitInfo> orgUnitList = new ArrayList<FullOrgUnitInfo>(orgUnitCollection.size());
        FullOrgUnitInfo info = null;
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            HashMap company = (HashMap)orgUnitCollection.get(i);
            info = new FullOrgUnitInfo();
            info.put("id", company.get("OrgUnitID"));
            info.setNumber((String)company.get("OrgUnitNumber"));
            info.setName((String)company.get("OrgUnitName"));
            info.setSimpleName((String)company.get("OrgUnitSimpleName"));
            orgUnitList.add(info);
        }
        return orgUnitList;
    }

    private static void clearCellFormulaByDataCollect(Book book) throws BOSException, SyntaxErrorException {
        int sheetCount = book.getSheetCount();
        for (int index = 0; index < sheetCount; ++index) {
            Sheet sheet = book.getSheet(index);
            int maxRows = sheet.getMaxRowIndex();
            int maxCols = sheet.getMaxColIndex();
            for (int rows = 0; rows <= maxRows; ++rows) {
                for (int cols = 0; cols <= maxCols; ++cols) {
                    Cell cell = sheet.getCell(rows, cols, false);
                    if (cell == null) continue;
                    cell.setUserObject(OrgUnitType_Company, null);
                    cell.setUserObject(OrgUnitType_Unit, null);
                }
            }
        }
    }

    private static void autoFillFormula(Sheet sheet, int ixPos) {
        String tag = "=+-/*";
        StringBuffer newExp = null;
        int m = sheet.getMaxRowIndex();
        for (int j = 0; j <= m; ++j) {
            Cell newCell;
            String exp;
            Cell cell = sheet.getCell(j, ixPos - 1, false);
            if (cell == null || StringUtils.isEmpty((String)(exp = cell.getFormula()))) continue;
            newExp = new StringBuffer();
            boolean hasRef = false;
            StringTokenizer temp = new StringTokenizer(exp, "+-*/", false);
            while (temp.hasMoreElements()) {
                String t = temp.nextToken();
                if (!TableToolkit.isCellRef((String)t.replaceAll("=", "").replaceAll("\\(", "").replaceAll("\\)", ""))) continue;
                hasRef = true;
                break;
            }
            if (hasRef) {
                StringTokenizer token = new StringTokenizer(exp, tag, true);
                while (token.hasMoreTokens()) {
                    String s;
                    String entry = token.nextToken();
                    if (tag.indexOf(entry) >= 0) {
                        newExp.append(entry);
                        continue;
                    }
                    String[] items = entry.split("!");
                    if (items.length > 1) {
                        newExp.append(items[0]).append("!");
                    }
                    String string = s = items.length > 1 ? items[1] : items[0];
                    if (!TableToolkit.isCellRef((String)s.replaceAll("\\)", "").replaceAll("\\(", ""))) {
                        newExp.append(s);
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(s, "\\(:\\)", true);
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken();
                        if (!TableToolkit.isCellRef((String)item)) {
                            newExp.append(item);
                            continue;
                        }
                        int index = -1;
                        for (int k = item.length() - 1; k >= 0; --k) {
                            try {
                                Integer.parseInt(item.substring(k, k + 1));
                                continue;
                            }
                            catch (Exception exc) {
                                index = k;
                                break;
                            }
                        }
                        String s1 = item.substring(0, index + 1);
                        String s2 = item.substring(index + 1, item.length());
                        s1 = TableToolkit.int2pos((int)(TableToolkit.pos2int((String)s1) + 1));
                        newExp.append(s1).append(s2);
                    }
                }
            }
            if (newExp.length() <= 1 || (newCell = sheet.getCell(j, ixPos, true)) == null) continue;
            newCell.setFormula(newExp.toString());
        }
    }

    private static Map getRPTItemInfoList(Context ctx, Sheet sheet, int i) throws BOSException {
        String regex = "=(.+!)?[A-Z]+\\d+([\\+|\\-](.+!)?[A-Z]+\\d+)*";
        ArrayList<String> rptItemNumberList = new ArrayList<String>();
        String exp = null;
        ItemFormula item = null;
        int m = sheet.getMaxRowIndex();
        for (int j = 0; j <= m; ++j) {
            Cell cell = sheet.getCell(j, i, false);
            if (cell == null || (exp = cell.getFormula()) == null || !exp.matches(regex) || (item = (ItemFormula)cell.getUserObjectValue("ITEM")) == null) continue;
            rptItemNumberList.add(item.getItemNumber());
        }
        IRPTItem iRptItem = null;
        iRptItem = ctx == null ? RPTItemFactory.getRemoteInstance() : RPTItemFactory.getLocalInstance(ctx);
        return iRptItem.getRPTItemInfoList(rptItemNumberList);
    }

    public static boolean isExistsDouble(KDTable kdt, String strID) {
        int col = 0;
        if (kdt.getColumn("id") != null) {
            col = kdt.getColumn("id").getColumnIndex();
        }
        return MnsRptGuideHelper.isExistsDouble(kdt, strID, col);
    }

    private static boolean isExistsDouble(KDTable kdt, String strID, int col) {
        for (int i = 0; i < kdt.getRowCount(); ++i) {
            if (!kdt.getCell(i, col).getValue().toString().equals(strID)) continue;
            return true;
        }
        return false;
    }

    public static FullOrgUnitCollection getUnionDebtChildren(String orgTreeId, String orgUnitId) throws BOSException, EASBizException {
        return MnsRptGuideHelper.getUnionDebtChildren(null, orgTreeId, orgUnitId);
    }

    public static FullOrgUnitCollection getUnionDebtChildren(Context ctx, String orgTreeId, String orgUnitId) throws BOSException, EASBizException {
        MessagePostManManager msgMng = new MessagePostManManager("getUnionDebtChildren");
        msgMng.addMessage(new MessagePostMan("treeId", orgTreeId));
        msgMng.addMessage(new MessagePostMan("orgUnitId", orgUnitId));
        msgMng = ctx == null ? RpcHandleFacadeFactory.getRemoteInstance().getRpcZipData(msgMng) : RpcHandleFacadeFactory.getLocalInstance(ctx).getRpcZipData(msgMng);
        return (FullOrgUnitCollection)msgMng.getItem("returnValue").getValue();
    }

    public static CslReportInfo createMnsRpt(Date date, int year, short period, OrgTreeInfo unitTree, OrgUnitInfo company, TemplateInfo template, boolean isSupportOtherDS, CurrencyInfo currency, Date startDate, Date endDate, String description, CompanyOrgUnitInfo companyInfo, DataCollectInfo dataCollect) throws BOSException {
        int periodType = template.getPeriodType().getValue();
        RptTmpTypeEnum tmpType = template.getTemplateType();
        RptSrcTypeEnum rptType = null;
        if (RptTmpTypeEnum.MANUSCRIPT.equals((Object)tmpType)) {
            rptType = RptSrcTypeEnum.MANUSCRIPT;
        } else if (RptTmpTypeEnum.MULTIDYNAMICMNSPORT.equals((Object)tmpType)) {
            rptType = RptSrcTypeEnum.MULTIDYNAMICMNSREPORT;
        }
        CslReportInfo editData = new CslReportInfo();
        editData.setYear(year);
        editData.setPeriod(period);
        editData.setStartDate(startDate);
        editData.setEndDate(endDate);
        editData.setTemplate(template);
        editData.setOrgTree(unitTree);
        editData.setOrgUnit(company);
        editData.setZipData(new byte[]{0});
        editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        editData.getSheetParam().addCollection(sheetParams);
        editData.setSourceType(rptType);
        editData.setOrgTree(unitTree);
        editData.setCurrency(currency);
        editData.setName(template.getName());
        editData.setNumber("001");
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        editData.setReportDate(new Timestamp(date.getTime()));
        editData.setDataCollect(dataCollect);
        if (dataCollect != null) {
            editData.setDataCollectNumber(dataCollect.getNumber());
        }
        if (description != null) {
            editData.setDescription(description);
        }
        return editData;
    }

    public static Point getBasePoint(Sheet sheet) {
        int left = 0;
        int top = 0;
        if (sheet != null) {
            left = CslRptUtil.getBasePosition_Left(sheet);
            top = CslRptUtil.getBasePosition_Top(sheet);
            left = left >= 0 ? left : 0;
            top = top >= 0 ? top : 0;
        }
        return new Point(left, top);
    }
}

