/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLSheetMannerEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CipherInputStream;
import com.kingdee.eas.fi.gr.cslrpt.util.CipherOutputStream;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class UPFFile {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.util.UPFFile");
    public static final String INFO_PROPERTY_XSLDATA = "CSL_PROPERTY_XSLDATA";
    public static final String FILENAME_SEPERATOR = "_";
    public static final String FileExtensionName = "UPF";
    public static final String UPF_ENTRY_PUBLIC = "public.dat";
    private String UPF_ENTRY_REPORT = "report.dat";
    private CslReportCollection cslReportCollection = null;
    private OrgUnitInfo orgUnit = null;
    private String commitTime;
    private final String timeStyle = "yyyy-MM-dd HH:mm:ss";
    private HashMap extEntry = null;
    private ZipFile curFile = null;

    public static String getFileNumber(String file) {
        String[] nameSection = StringUtils.split((String)file, (String)FILENAME_SEPERATOR);
        return nameSection[0];
    }

    public OrgUnitInfo getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(OrgUnitInfo orgUnit) {
        this.orgUnit = orgUnit;
    }

    public String getCommitTime() {
        return this.commitTime;
    }

    public CslReportCollection getCslReportCollection() {
        return this.cslReportCollection;
    }

    public void setCslReportCollection(CslReportCollection cslReportCollection) {
        this.cslReportCollection = cslReportCollection;
    }

    public UPFFile(String kdtPath, String password) {
        try {
            this.init(kdtPath, password);
        }
        catch (IOException e) {
            logger.error((Object)"init_IOException", (Throwable)e);
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"763_DNFFile"));
        }
        catch (ParseException e) {
            logger.error((Object)"init_ParseException", (Throwable)e);
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"763_DNFFile"));
        }
    }

    private CslReportCollection parseReportData(InputStream templateDat) throws Exception {
        CslReportCollection result = new CslReportCollection();
        Date time = RPTDateUtil.stringToDateTime(this.commitTime, "yyyy-MM-dd HH:mm:ss");
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(templateDat);
        }
        catch (DocumentException e) {
            logger.error((Object)"reader.read_DocumentException", (Throwable)e);
        }
        Element root = doc.getRootElement();
        Element foo = null;
        Iterator i = root.elementIterator("row");
        while (i.hasNext()) {
            String auditedTime;
            String lastUpdateTime;
            foo = (Element)i.next();
            CslReportInfo info = new CslReportInfo();
            info.setName(foo.elementTextTrim("fname"));
            info.setDescription(foo.elementTextTrim("fdescription"));
            String number = foo.elementTextTrim("fnumber");
            if (StringUtils.isEmpty((String)number)) {
                number = "001";
            }
            info.setNumber(number);
            info.setTemplate(this.getTemplateInfo(foo.elementTextTrim("ftemplateid")));
            info.setPeriodType(RptPeriodTypeEnum.getEnum((int)Integer.parseInt(foo.elementTextTrim("fperiodtype"))));
            info.setYear(Integer.parseInt(foo.elementTextTrim("fyear")));
            info.setPeriod(Short.parseShort(foo.elementTextTrim("fperiod")));
            info.setReportDate(RPTDate13Util.getPeriodLastDate(info.getYear(), info.getPeriod(), info.getPeriodType()));
            info.setAdjustStatus(AdjustStatusEnum.BEFOREADJUST);
            info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            info.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
            info.setCommitTime(time);
            info.setCurrency(this.getCurrencyInfo(foo.elementTextTrim("fcurrency")));
            info.setDataCollectNumber(foo.elementTextTrim("fdatacollectnumber"));
            if (foo.elementTextTrim("fdatacollectnumber") == null || foo.elementTextTrim("fdatacollectnumber").equals("ACTUALDATA")) {
                info.setDataCollect(DataCollectConstant.getActualDC());
                info.setDataCollectNumber("ACTUALDATA");
            } else {
                info.setDataCollect(DataCollectConstant.getBudgetDC());
                info.setDataCollectNumber("BUDGETDATA");
            }
            String createTime = foo.elementTextTrim("fcreatetime");
            if (createTime != null && createTime.length() != 0) {
                info.setCreateTime(new Timestamp(DateTimeUtils.parseDate((String)createTime).getTime()));
            }
            if ((lastUpdateTime = foo.elementTextTrim("flastupdatetime")) != null && lastUpdateTime.length() != 0) {
                info.setLastUpdateTime(new Timestamp(DateTimeUtils.parseDate((String)lastUpdateTime).getTime()));
            }
            if ((auditedTime = foo.elementTextTrim("fauditedtime")) != null && auditedTime.length() != 0) {
                info.setAuditTime(new Timestamp(DateTimeUtils.parseDate((String)auditedTime).getTime()));
            }
            info.setOrgUnit(this.getOrgUnit());
            try {
                Book book = IOHelper.unpackBook((byte[])this.getBookData(foo.elementTextTrim("fdata")), (String)"rpt_trans");
                book.setCalculate(false);
                int sheetCount = book.getSheetCount();
                for (int j = 0; j < sheetCount; ++j) {
                    Sheet sheet = book.getSheet(j);
                    RptSheetParamInfo param = new RptSheetParamInfo();
                    param.setSheetName(sheet.getSheetName());
                    ReportVariables v = ReportVariables.loadFromBook((Book)book);
                    if (v == null) {
                        v = new ReportVariables();
                        v.storeToBook(book);
                    }
                    int reportClass = v.getIntValue("SheetClass", sheet.getSheetName(), 1);
                    param.setReportClass(CSLReportGroupEnum.getEnum(reportClass));
                    param.setSheetID(sheet.getID());
                    param.setRelaType(ReportTypeEnum.CSLREPORT);
                    param.setCslSheetManner(CSLSheetMannerEnum.getEnum(1));
                    info.getSheetParam().add(param);
                }
                info.setBook(book);
            }
            catch (Exception e1) {
                logger.error((Object)"IOHelper.unpackBook_Exception", (Throwable)e1);
            }
            String dynaRptType = foo.elementTextTrim("fdynarpttype");
            if (dynaRptType != null && dynaRptType.length() != 0) {
                info.setDynaRptType(DynaEnumRptTypeEnum.getEnum(Integer.parseInt(dynaRptType)));
            }
            result.add(info);
        }
        return result;
    }

    private KDF getKDF(String kdfEntry) throws IOException {
        KDF kdf = null;
        try {
            kdf = new KDF(this.curFile.getInputStream(this.curFile.getEntry(kdfEntry)));
            kdf.getAllTable();
        }
        catch (KDFException e) {
            logger.error((Object)"KDF_KDFException", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"getInputStream_IOException", (Throwable)e);
        }
        return kdf != null ? kdf : new KDF();
    }

    private byte[] getBookData(String kdfEntry) throws Exception {
        int i;
        InputStream inputStream = this.curFile.getInputStream(this.curFile.getEntry(kdfEntry));
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        while ((i = inputStream.read()) >= 0) {
            in.write(i);
        }
        inputStream.close();
        return in.toByteArray();
    }

    private ArrayList parseCommentData(InputStream commentDat) throws ParseException {
        ArrayList comments = new ArrayList();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(commentDat);
        }
        catch (DocumentException e) {
            logger.error((Object)"reader.read_DocumentException", (Throwable)e);
        }
        Element root = doc.getRootElement();
        Element sheet = null;
        String sheetName = null;
        Element comment = null;
        Iterator i = root.elementIterator("Sheet");
        while (i.hasNext()) {
            sheet = (Element)i.next();
            sheetName = sheet.attributeValue("name");
            Iterator i2 = sheet.elementIterator("Comment");
            while (i2.hasNext()) {
                comment = (Element)i2.next();
                int row = Integer.parseInt(comment.attributeValue("cellRowIndex"));
                int col = Integer.parseInt(comment.attributeValue("cellColIndex"));
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put("SHEETNAME", sheetName);
                valueMap.put("CELL", TableToolkit.xy2range((int)row, (int)col));
                Element item = comment.element("CommentItem");
                valueMap.put("AUTHORNAME", item.attributeValue("Author"));
                valueMap.put("TEXT", item.attributeValue("text"));
                comments.add(valueMap);
            }
        }
        return comments;
    }

    private OrgUnitInfo parsePublicData(InputStream templateDat) {
        FullOrgUnitInfo info = null;
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(templateDat);
        }
        catch (DocumentException e) {
            logger.error((Object)"reader.read_DocumentException", (Throwable)e);
        }
        Element foo = doc.getRootElement();
        info = this.getOrgUnitInfo(foo.elementTextTrim("companynumber"));
        this.commitTime = foo.elementTextTrim("commitTime");
        if (this.commitTime == null || this.commitTime.trim().length() == 0) {
            this.commitTime = RPTDateUtil.formateDate(new Date(), "yyyy-MM-dd HH:mm:ss");
        }
        this.loadEntry(foo);
        return info;
    }

    private void loadEntry(Element foo) {
        this.UPF_ENTRY_REPORT = foo.elementTextTrim("reportfile");
    }

    private void saveEntry(Element foo) {
        foo.addElement("reportfile").setText(this.UPF_ENTRY_REPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String kdtPath, String password) throws IOException, ParseException {
        File tempFile;
        boolean isEncrypt;
        block10: {
            isEncrypt = false;
            tempFile = new File(kdtPath);
            if (StringUtils.isEmpty((String)password)) break block10;
            CipherInputStream in = null;
            FileOutputStream out = null;
            FileInputStream fileIn = null;
            try {
                int c;
                fileIn = new FileInputStream(tempFile);
                in = new CipherInputStream(fileIn, password);
                kdtPath = kdtPath + System.currentTimeMillis();
                tempFile = new File(kdtPath);
                out = new FileOutputStream(tempFile);
                while ((c = ((InputStream)in).read()) != -1) {
                    ((OutputStream)out).write(c);
                }
            }
            catch (Throwable throwable) {
                CslRptUtil.close(in);
                CslRptUtil.close(out);
                CslRptUtil.close(fileIn);
                throw throwable;
            }
            CslRptUtil.close(in);
            CslRptUtil.close(out);
            CslRptUtil.close(fileIn);
            isEncrypt = true;
        }
        try {
            this.curFile = new ZipFile(tempFile);
        }
        catch (IOException e) {
            if (isEncrypt) {
                tempFile.delete();
            }
            throw e;
        }
        ZipEntry ze = null;
        ze = this.curFile.getEntry(UPF_ENTRY_PUBLIC);
        this.setOrgUnit(this.parsePublicData(this.curFile.getInputStream(ze)));
        ze = this.curFile.getEntry(this.UPF_ENTRY_REPORT);
        try {
            this.setCslReportCollection(this.parseReportData(this.curFile.getInputStream(ze)));
        }
        catch (IOException e) {
            logger.error((Object)"curFile.getInputStream_IOException", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"parseReportData_Exception", (Throwable)e);
        }
        this.curFile.close();
        if (isEncrypt) {
            tempFile.delete();
        }
    }

    public UPFFile(OrgUnitInfo targetCompany, CslReportCollection reports) {
        this.setOrgUnit(targetCompany);
        this.setCslReportCollection(reports);
        this.extEntry = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(String path, String password) {
        boolean result;
        block10: {
            result = true;
            HashMap map = this.extEntry;
            if (this.orgUnit != null) {
                map.put(UPF_ENTRY_PUBLIC, this.parseOrgUnitInfo(this.orgUnit));
            }
            if (this.cslReportCollection != null) {
                map.put(this.UPF_ENTRY_REPORT, this.parseCslRportCollection(this.cslReportCollection));
            }
            ZipOutputStream out = null;
            FileOutputStream f1 = null;
            CipherOutputStream f = null;
            try {
                f1 = new FileOutputStream(path);
                if (!StringUtils.isEmpty((String)password)) {
                    f = new CipherOutputStream(f1, password);
                }
                out = new ZipOutputStream(new DataOutputStream(f));
                Set keySet = map.keySet();
                for (String key : keySet) {
                    out.putNextEntry(new ZipEntry(key));
                    byte[] data = ((String)map.get(key)).getBytes("GBK");
                    for (int i = 0; i < data.length; ++i) {
                        byte b = data[i];
                        out.write(b);
                    }
                }
                CslRptUtil.close(out);
            }
            catch (Exception e) {
                result = false;
                logger.error((Object)"export_Exception", (Throwable)e);
                break block10;
            }
            finally {
                CslRptUtil.close(out);
                CslRptUtil.close(f);
                CslRptUtil.close(f1);
            }
            CslRptUtil.close(f);
            CslRptUtil.close(f1);
        }
        return result;
    }

    private String parseCslRportCollection(CslReportCollection reports) {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("GBK");
        Element rootElement = document.addElement("template");
        String kdfEntryName = null;
        for (int i = 0; i < reports.size(); ++i) {
            CslReportInfo info = reports.get(i);
            Element rowElement = rootElement.addElement("row");
            rowElement.addElement("fid").setText(info.getId().toString());
            rowElement.addElement("fnumber").setText(info.getNumber());
            rowElement.addElement("fname").setText(info.getName());
            rowElement.addElement("fdescription").setText(info.getDescription());
            rowElement.addElement("fperiodtype").setText(Integer.toString(info.getPeriodType().getValue()));
            kdfEntryName = info.getName() + ".kdf";
            rowElement.addElement("fdata").setText(kdfEntryName);
            rowElement.addElement("fdynarpttype").setText(Integer.toString(info.getDynaRptType().getValue()));
        }
        return document.asXML();
    }

    private String parseOrgUnitInfo(OrgUnitInfo info) {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("GBK");
        Element rootElement = document.addElement("public");
        rootElement.addElement("companyid").setText(info.getId().toString());
        rootElement.addElement("companynumber").setText(info.getNumber());
        rootElement.addElement("companyName").setText(info.getName());
        this.saveEntry(rootElement);
        return document.asXML();
    }

    public static void main(String[] args) {
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        list.add(new Integer(10));
    }

    private TemplateInfo getTemplateInfo(String id) {
        TemplateInfo info = new TemplateInfo();
        info.setId(BOSUuid.read((String)id));
        return info;
    }

    private FullOrgUnitInfo getOrgUnitInfo(String number) {
        FullOrgUnitInfo info = new FullOrgUnitInfo();
        info.setNumber(number);
        return info;
    }

    private CurrencyInfo getCurrencyInfo(String id) {
        CurrencyInfo info = new CurrencyInfo();
        info.setId(BOSUuid.read((String)id));
        return info;
    }

    private UserInfo getUserInfo(String number) {
        UserInfo info = null;
        try {
            info = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(number));
        }
        catch (EASBizException e) {
            logger.error((Object)"getUserInfo_EASBizException", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"getUserInfo_BOSException", (Throwable)e);
        }
        return info;
    }
}

