/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.fast.AdjustEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.EliminationEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SolutionExecuteParam
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6909944218996147590L;
    private static Logger LOGGER = Logger.getLogger(SolutionExecuteParam.class);
    private FastMergeSoluInfo soluInfo;
    private int period = 0;
    private int year = 0;
    private int periodType = 0;
    private int createRptStrategy = 1;
    private String description;
    private boolean isSupportOtherDS;
    private boolean isMergeByFiscalPeriod;
    private boolean isDisplayAdjustRPTMByOrg = false;
    private boolean isSupportCrossMerger = false;
    private DataCollectInfo dataCollInfo;
    private MergeModeEnum adjustBoundMergeMode = null;
    private MergeModeEnum elimBoundMergeMode = null;
    private MergeModeEnum soluBoundMergeMode = null;
    private OrgTreeInfo orgBound;
    private FullOrgUnitInfo curOrgUnit;
    private UserInfo curUser;
    private Date reportDate;
    private Context _ctx;
    private String executeTaskId;

    public SolutionExecuteParam(Context ctx, FastMergeSoluInfo soluInfo, UserInfo userInfo, int year, int period, String description, String executeTaskId) throws EASBizException, BOSException {
        this._ctx = ctx;
        this.soluInfo = soluInfo;
        this.curUser = userInfo;
        this.year = year;
        this.period = period;
        this.createRptStrategy = soluInfo.isIsSupportGroupReport() ? 1 : 2;
        this.description = description;
        this.executeTaskId = executeTaskId;
        this.initData();
        this.initOrg();
        this.setCorrectBound();
        this.isSupportCrossMerger = this.createRptStrategy != 1;
    }

    private void initOrgTreeVersion() throws EASBizException, BOSException {
        if (this.soluInfo != null) {
            OrgTreeCollection orgTrees;
            OrgTreeInfo orgTree = this.soluInfo.getOrgBound();
            String sourceNumber = orgTree.getNumber();
            boolean isExistsFlag = false;
            if (orgTree != null && !StringUtils.isEmpty((String)sourceNumber) && (orgTrees = CslRptUtil.getAllUnionTrees(this._ctx, String.valueOf(this.curUser.getId()), this.reportDate)) != null) {
                OrgTreeInfo orgTreeInfo = null;
                for (int i = 0; i < orgTrees.size(); ++i) {
                    orgTreeInfo = orgTrees.get(i);
                    if (!sourceNumber.equals(orgTreeInfo.getNumber())) continue;
                    orgTreeInfo = (this._ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)this._ctx)).getOrgTreeInfo("select id,name,number,IsHide,IsForBudget,status,basic,layerType where id='" + orgTreeInfo.getId() + "'");
                    this.soluInfo.setOrgBound(orgTreeInfo);
                    isExistsFlag = true;
                    break;
                }
            }
            if (!isExistsFlag) {
                this.soluInfo.setOrgBound(null);
                LOGGER.error((Object)("not exists orgTree:" + orgTree.getName() + " in " + this.reportDate));
                throw new BOSException("not exists orgTree:" + orgTree.getName() + " in " + this.reportDate);
            }
        }
    }

    private void initOrgUnits() throws EASBizException, BOSException {
        if (this.soluInfo != null && this.soluInfo.getOrgBound() != null) {
            OrgTreeInfo orgTree = this.soluInfo.getOrgBound();
            StringBuffer ksql = new StringBuffer();
            ksql.append("select unit.id,unit.name,unit.number,unit.longNumber,unit.level,unit.isGrouping,level ");
            ksql.append("where tree.id='").append(orgTree.getId()).append("'");
            ksql.append(" and unit.isunion=1");
            IOrgStructure iStruc = this._ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)this._ctx);
            OrgStructureCollection strucInfos = iStruc.getOrgStructureCollection(ksql.toString());
            HashMap<String, FullOrgUnitInfo> number_Union = new HashMap<String, FullOrgUnitInfo>();
            FullOrgUnitInfo curUnitInfo = null;
            for (int i = 0; i < strucInfos.size(); ++i) {
                curUnitInfo = strucInfos.get(i).getUnit();
                curUnitInfo.setLevel(strucInfos.get(i).getLevel());
                if (curUnitInfo == null) continue;
                number_Union.put(curUnitInfo.getNumber(), curUnitInfo);
            }
            String number = null;
            FastMergeOrgUnitCollection orgUnits = this.soluInfo.getOrgUnits();
            FastMergeOrgUnitInfo fastMergeOrgUnits = null;
            for (int i = 0; i < orgUnits.size(); ++i) {
                fastMergeOrgUnits = orgUnits.get(i);
                number = fastMergeOrgUnits.getOrgUnit().getNumber();
                if (number_Union.containsKey(number)) {
                    curUnitInfo = (FullOrgUnitInfo)number_Union.get(number);
                    fastMergeOrgUnits.setOrgUnit(curUnitInfo);
                    continue;
                }
                LOGGER.error((Object)("not exists unit:" + fastMergeOrgUnits.getOrgUnit().getName() + "(" + number + ") in orgtree:" + orgTree.getName() + "(" + this.reportDate + ")"));
            }
        }
    }

    private void initOrg() throws EASBizException, BOSException {
        this.initOrgTreeVersion();
        this.initOrgUnits();
    }

    private void setCorrectBound() {
        try {
            String soluTreeId = this.soluInfo.getOrgBound().getId().toString();
            OrgTreeInfo treeInfo = this.soluInfo.getOrgBound();
            this.soluInfo.setOrgBound(treeInfo);
            String adjustTreeId = "";
            OrgTreeInfo adjustTreeInfo = null;
            if (this.soluInfo.getAdjustEntrySolu() != null && this.soluInfo.getAdjustEntrySolu().getOrgBound() != null) {
                adjustTreeId = this.soluInfo.getAdjustEntrySolu().getOrgBound().getId().toString();
                if (soluTreeId.equals(adjustTreeId)) {
                    this.soluInfo.getAdjustEntrySolu().setOrgBound(treeInfo);
                } else {
                    adjustTreeInfo = FastMergeUtil.getCurrentTree(this._ctx, this.reportDate, this.curUser.getId().toString(), adjustTreeId);
                    this.soluInfo.getAdjustEntrySolu().setOrgBound(adjustTreeInfo);
                }
            } else if (this.soluInfo.getAdjustEntrySolu() != null && this.soluInfo.getAdjustEntrySolu().getOrgBound() == null) {
                this.soluInfo.getAdjustEntrySolu().setOrgBound(treeInfo);
            }
            if (this.soluInfo.getElimEntrySolu() != null && this.soluInfo.getElimEntrySolu().getOrgBound() != null) {
                String elimTreeId = this.soluInfo.getElimEntrySolu().getOrgBound().getId().toString();
                if (soluTreeId.equals(elimTreeId)) {
                    this.soluInfo.getElimEntrySolu().setOrgBound(treeInfo);
                } else if (adjustTreeId.equals(elimTreeId)) {
                    this.soluInfo.getElimEntrySolu().setOrgBound(adjustTreeInfo);
                } else {
                    this.soluInfo.getElimEntrySolu().setOrgBound(FastMergeUtil.getCurrentTree(this._ctx, this.reportDate, this.curUser.getId().toString(), elimTreeId));
                }
            } else if (this.soluInfo.getElimEntrySolu() != null && this.soluInfo.getElimEntrySolu().getOrgBound() == null) {
                this.soluInfo.getElimEntrySolu().setOrgBound(treeInfo);
            }
        }
        catch (EASBizException e) {
            LOGGER.error((Object)"setCorrectBound", (Throwable)e);
        }
        catch (BOSException e) {
            LOGGER.error((Object)"setCorrectBound", (Throwable)e);
        }
    }

    private void initData() {
        this.dataCollInfo = DataCollectConstant.getActualDC();
        boolean[] values = CSLParamUtil.batchGetParam(this._ctx, new String[]{"GR_CSL_SupportOtherDS", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_AdjustRPTMDisplayByOrg"});
        this.isSupportOtherDS = values[0];
        this.isMergeByFiscalPeriod = values[1];
        this.isDisplayAdjustRPTMByOrg = values[2];
        RptPeriodTypeEnum periodType = this.soluInfo.getTemplates().get(0).getTemplate().getPeriodType();
        this.setPeriodType(periodType.getValue());
        this.reportDate = RPTDateUtil.getPeriodLastDate(this.year, this.period, periodType);
    }

    public Date getReportDate() {
        return this.reportDate;
    }

    public UserInfo getCurUser() {
        return this.curUser;
    }

    public void setCurUser(UserInfo curUser) {
        this.curUser = curUser;
    }

    public DataCollectInfo getDataCollInfo() {
        return this.dataCollInfo;
    }

    public MergeModeEnum getElimBoundMergeMode() {
        if (this.elimBoundMergeMode != null) {
            return this.elimBoundMergeMode;
        }
        if (this.soluInfo.getElimEntrySolu() != null && this.soluInfo.getElimEntrySolu().getOrgBound() != null) {
            try {
                String orgBoundId = this.soluInfo.getElimEntrySolu().getOrgBound().getId().toString();
                this.elimBoundMergeMode = RptAutoWeaveUtil.getMergeMode(this._ctx, orgBoundId);
            }
            catch (EASBizException e) {
                LOGGER.error((Object)"getAdjustBoundMergeMode", (Throwable)e);
            }
            catch (BOSException e) {
                LOGGER.error((Object)"getAdjustBoundMergeMode", (Throwable)e);
            }
        }
        return this.elimBoundMergeMode;
    }

    public MergeModeEnum getSoluBoundMergeMode() {
        if (this.soluBoundMergeMode != null) {
            return this.soluBoundMergeMode;
        }
        if (this.soluInfo.getOrgBound() != null) {
            try {
                String orgBoundId = this.soluInfo.getOrgBound().getId().toString();
                this.soluBoundMergeMode = RptAutoWeaveUtil.getMergeMode(this._ctx, orgBoundId);
            }
            catch (EASBizException e) {
                LOGGER.error((Object)"getAdjustBoundMergeMode", (Throwable)e);
            }
            catch (BOSException e) {
                LOGGER.error((Object)"getAdjustBoundMergeMode", (Throwable)e);
            }
        }
        return this.soluBoundMergeMode;
    }

    public MergeModeEnum getAdjustBoundMergeMode() {
        if (this.adjustBoundMergeMode != null) {
            return this.adjustBoundMergeMode;
        }
        if (this.soluInfo.getAdjustEntrySolu() != null && this.soluInfo.getAdjustEntrySolu().getOrgBound() != null) {
            try {
                String orgBoundId = this.soluInfo.getAdjustEntrySolu().getOrgBound().getId().toString();
                this.adjustBoundMergeMode = RptAutoWeaveUtil.getMergeMode(this._ctx, orgBoundId);
            }
            catch (EASBizException e) {
                LOGGER.error((Object)"getAdjustBoundMergeMode", (Throwable)e);
            }
            catch (BOSException e) {
                LOGGER.error((Object)"getAdjustBoundMergeMode", (Throwable)e);
            }
        }
        return this.adjustBoundMergeMode;
    }

    public boolean isSupportOtherDS() {
        return this.isSupportOtherDS;
    }

    public boolean isMergeByFiscalPeriod() {
        return this.isMergeByFiscalPeriod;
    }

    public boolean isDisplayAdjustRPTMByOrg() {
        return this.isDisplayAdjustRPTMByOrg;
    }

    public AdjustEntiresSoluInfo getAdjustSolu() {
        return this.soluInfo.getAdjustEntrySolu();
    }

    public EliminationEntiresSoluInfo getElimSolu() {
        return this.soluInfo.getElimEntrySolu();
    }

    public FullOrgUnitInfo getCurOrgUnit() {
        return this.curOrgUnit;
    }

    public OrgTreeInfo getOrgBound() {
        return this.orgBound;
    }

    public void setOrgBound(OrgTreeInfo orgBound) {
        this.orgBound = orgBound;
    }

    public void setCurOrgUnit(FullOrgUnitInfo curOrgUnit) {
        this.curOrgUnit = curOrgUnit;
    }

    public FastMergeSoluInfo getSoluInfo() {
        return this.soluInfo;
    }

    public void setSoluInfo(FastMergeSoluInfo soluInfo) {
        this.soluInfo = soluInfo;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(int periodType) {
        this.periodType = periodType;
    }

    public boolean isSupportCrossMerger() {
        return this.isSupportCrossMerger;
    }

    public void setSupportCrossMerger(boolean isSupportCrossMerger) {
        this.isSupportCrossMerger = isSupportCrossMerger;
    }

    public int getCreateRptStrategy() {
        return this.createRptStrategy;
    }

    public String getDescription() {
        return this.description;
    }

    public void clearData() {
    }

    public String getExecuteTaskId() {
        return this.executeTaskId;
    }
}

