/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz.query;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.AdjustItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.CSLItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.ElimEntryItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryAdjustItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryCSLItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryDCSLItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryDSumItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryDynaAdjustItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryDynaElimItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryElimItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QuerySumItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.fast.biz.query.CreateFastMergeItemQueryUnit;
import com.kingdee.eas.fi.gr.fast.biz.query.DefineQuerySourceTypes;
import com.kingdee.eas.fi.gr.fast.biz.query.ExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.query.FastMergeItemQueryUnit;
import com.kingdee.eas.fi.gr.fast.biz.query.MergeStatus;
import com.kingdee.eas.fi.gr.fast.biz.query.ParseFastMergeItemQueryUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryItemDataByFastMerge {
    private DBHandler dao;

    public QueryItemDataByFastMerge(DBHandler dao) {
        this.dao = dao;
    }

    public Object exec(String fastMerge, ExecuteParam param) throws EASBizException, BOSException {
        FastMergeItemQueryUnit queryUnit = new CreateFastMergeItemQueryUnit(this.dao).by(fastMerge, param);
        Collection<IItemQueryUnit> baseItemQueryUnits = new ParseFastMergeItemQueryUnit().exec(queryUnit);
        HashSet<CSLItemQueryUnit> cslQueryUnits = new HashSet<CSLItemQueryUnit>();
        HashSet<CSLItemQueryUnit> sumQueryUnits = new HashSet<CSLItemQueryUnit>();
        HashSet<CSLItemQueryUnit> dynaCslQueryUnits = new HashSet<CSLItemQueryUnit>();
        HashSet<CSLItemQueryUnit> dynaSumQueryUnits = new HashSet<CSLItemQueryUnit>();
        HashSet<ElimEntryItemQueryUnit> elimQueryUnits = new HashSet<ElimEntryItemQueryUnit>();
        HashSet<AdjustItemQueryUnit> adjustQueryUnits = new HashSet<AdjustItemQueryUnit>();
        HashSet<ElimEntryItemQueryUnit> dynaElimQueryUnits = new HashSet<ElimEntryItemQueryUnit>();
        HashSet<AdjustItemQueryUnit> dynaAdjustQueryUnits = new HashSet<AdjustItemQueryUnit>();
        for (IItemQueryUnit baseItemQueryUnit : baseItemQueryUnits) {
            if (baseItemQueryUnit instanceof CSLItemQueryUnit) {
                if (BizFormulaDefine.belongType(baseItemQueryUnit.getType(), new String[]{"CSLITEM"})) {
                    cslQueryUnits.add((CSLItemQueryUnit)baseItemQueryUnit);
                    continue;
                }
                if (BizFormulaDefine.belongType(baseItemQueryUnit.getType(), new String[]{"SUMITEM"})) {
                    sumQueryUnits.add((CSLItemQueryUnit)baseItemQueryUnit);
                    continue;
                }
                if (BizFormulaDefine.belongType(baseItemQueryUnit.getType(), new String[]{"DCSLITEM"})) {
                    dynaCslQueryUnits.add((CSLItemQueryUnit)baseItemQueryUnit);
                    continue;
                }
                if (!BizFormulaDefine.belongType(baseItemQueryUnit.getType(), new String[]{"DSUMITEM"})) continue;
                dynaSumQueryUnits.add((CSLItemQueryUnit)baseItemQueryUnit);
                continue;
            }
            if (baseItemQueryUnit instanceof ElimEntryItemQueryUnit) {
                if (BizFormulaDefine.belongType(baseItemQueryUnit.getType(), new String[]{"ELIMENTRYITEM"})) {
                    elimQueryUnits.add((ElimEntryItemQueryUnit)baseItemQueryUnit);
                    continue;
                }
                if (!BizFormulaDefine.belongType(baseItemQueryUnit.getType(), new String[]{"DELIMENTRYITEM"})) continue;
                dynaElimQueryUnits.add((ElimEntryItemQueryUnit)baseItemQueryUnit);
                continue;
            }
            if (!(baseItemQueryUnit instanceof AdjustItemQueryUnit)) continue;
            if (BizFormulaDefine.belongType(baseItemQueryUnit.getType(), new String[]{"ADJUSTITEM"})) {
                adjustQueryUnits.add((AdjustItemQueryUnit)baseItemQueryUnit);
                continue;
            }
            if (!BizFormulaDefine.belongType(baseItemQueryUnit.getType(), new String[]{"DADJUSTITEM"})) continue;
            dynaAdjustQueryUnits.add((AdjustItemQueryUnit)baseItemQueryUnit);
        }
        HashSet<Integer> emptySourceType = new HashSet<Integer>(0);
        DefineQuerySourceTypes defineQuerySourceTypes = new DefineQuerySourceTypes();
        MergeStatus mergeStatus = queryUnit.getMergeStatus();
        Map<CSLItemQueryUnit, ItemResult> cslResults = new QueryCSLItemData(this.dao).queryValues((Set<CSLItemQueryUnit>)cslQueryUnits, defineQuerySourceTypes.exec(mergeStatus, "CSLITEM"), (OrgType)null);
        Map<CSLItemQueryUnit, ItemResult> sumResults = new QuerySumItemData(this.dao).queryValues((Set<CSLItemQueryUnit>)sumQueryUnits, defineQuerySourceTypes.exec(mergeStatus, "SUMITEM"), (OrgType)null);
        Map<ElimEntryItemQueryUnit, ItemResult> elimResults = new QueryElimItemData(this.dao).queryValues((Set<ElimEntryItemQueryUnit>)elimQueryUnits, (Collection<Integer>)emptySourceType, (OrgType)null);
        Map<AdjustItemQueryUnit, ItemResult> adjustResults = new QueryAdjustItemData(this.dao).queryValues((Set<AdjustItemQueryUnit>)adjustQueryUnits, (Collection<Integer>)emptySourceType, (OrgType)null);
        Map<CSLItemQueryUnit, ItemResult> dynaCslResults = new QueryDCSLItemData(this.dao).queryValues((Set<CSLItemQueryUnit>)dynaCslQueryUnits, defineQuerySourceTypes.exec(mergeStatus, "DCSLITEM"), (OrgType)null);
        Map<CSLItemQueryUnit, ItemResult> dynaSumResults = new QueryDSumItemData(this.dao).queryValues((Set<CSLItemQueryUnit>)dynaSumQueryUnits, defineQuerySourceTypes.exec(mergeStatus, "DSUMITEM"), (OrgType)null);
        Map<ElimEntryItemQueryUnit, ItemResult> dynaElimResults = new QueryDynaElimItemData(this.dao).queryValues((Set<ElimEntryItemQueryUnit>)dynaElimQueryUnits, (Collection<Integer>)emptySourceType, (OrgType)null);
        Map<AdjustItemQueryUnit, ItemResult> dynaAdjustResults = new QueryDynaAdjustItemData(this.dao).queryValues((Set<AdjustItemQueryUnit>)dynaAdjustQueryUnits, (Collection<Integer>)emptySourceType, (OrgType)null);
        HashMap<IItemQueryUnit, ItemResult> results = new HashMap<IItemQueryUnit, ItemResult>(cslResults.size() + sumResults.size() + elimResults.size() + adjustResults.size() + dynaCslResults.size() + dynaSumResults.size() + dynaElimResults.size() + dynaAdjustResults.size());
        results.putAll(cslResults);
        results.putAll(sumResults);
        results.putAll(elimResults);
        results.putAll(adjustResults);
        results.putAll(dynaCslResults);
        results.putAll(dynaSumResults);
        results.putAll(dynaElimResults);
        results.putAll(dynaAdjustResults);
        this.removeAndAddEmptyResult(cslQueryUnits, cslResults, results);
        this.removeAndAddEmptyResult(sumQueryUnits, sumResults, results);
        this.removeAndAddEmptyResultForDyna(elimQueryUnits, elimResults, results);
        this.removeAndAddEmptyResultForDyna(adjustQueryUnits, adjustResults, results);
        this.removeAndAddEmptyResultForDyna(dynaCslQueryUnits, dynaCslResults, results);
        this.removeAndAddEmptyResultForDyna(dynaSumQueryUnits, dynaSumResults, results);
        this.removeAndAddEmptyResultForDyna(dynaElimQueryUnits, dynaElimResults, results);
        this.removeAndAddEmptyResultForDyna(dynaAdjustQueryUnits, dynaAdjustResults, results);
        return results;
    }

    protected <T extends IItemQueryUnit> void removeAndAddEmptyResultForDyna(Set<T> queryUnits, Map<T, ItemResult> currResults, Map<IItemQueryUnit, ItemResult> results) {
        if (queryUnits.isEmpty()) {
            return;
        }
        if (currResults.isEmpty()) {
            this.removeAndAddEmptyResult(queryUnits, currResults, results);
            return;
        }
    }

    protected <T extends IItemQueryUnit> void removeAndAddEmptyResult(Set<T> queryUnits, Map<T, ItemResult> currResults, Map<IItemQueryUnit, ItemResult> results) {
        if (queryUnits.isEmpty()) {
            return;
        }
        if (!currResults.isEmpty()) {
            queryUnits.removeAll(currResults.keySet());
        }
        if (queryUnits.isEmpty()) {
            return;
        }
        for (IItemQueryUnit unit : queryUnits) {
            results.put(unit, new ItemResult());
        }
    }
}

