/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.fast.client.AbstractAdjustForPCEditUI;
import com.kingdee.eas.fi.gr.fast.client.AdjustDynamicItemForPCEditUI;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.Observable;

public class AdjustForPCEditUI
extends AbstractAdjustForPCEditUI {
    private boolean hasEditPerm = false;
    private boolean hasAuditPerm = false;

    public AdjustForPCEditUI() throws Exception {
        this.isAdjustForPCEditUI = Boolean.TRUE;
    }

    @Override
    protected void initCSLContext() {
        this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        try {
            this.initPermission();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void loadFields() {
        this.loadAdjustFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeAdjustFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getAdjustSelectors();
    }

    private void initPermission() throws Exception {
        IPermission permissionIntf = PermissionFactory.getRemoteInstance();
        boolean[] permissions = permissionIntf.hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId()), new String[]{"mcsl_adjvoucher_edit", "mcsl_adjvoucher_audit"});
        if (permissions != null && permissions.length >= 2) {
            this.hasEditPerm = permissions[1];
            this.hasAuditPerm = permissions[0];
        }
    }

    @Override
    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }

    @Override
    protected String getAdjustDynamicItemEditUI() {
        return AdjustDynamicItemForPCEditUI.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeByPK(IObjectPK pk) throws Exception {
        String tempState = this.getOprtState();
        this.setOprtState("REMOVE");
        try {
            this.pubFireVOChangeListener(pk.toString());
        }
        catch (Throwable e) {
            this.setOprtState(tempState);
            this.handUIException(e);
            this.abort();
        }
        try {
            ((IAdjust)this.getBizInterface()).removeBatch(this.selectList);
        }
        finally {
            this.setOprtState(tempState);
            this.initOldData(null);
        }
        if (this.idList.size() > 1) {
            this.editData = null;
            if (this.actionNext.isEnabled()) {
                this.actionNext_actionPerformed(null);
            } else {
                this.actionPre_actionPerformed(null);
            }
            this.idList.remove(pk.toString(), false);
            this.initScrollButtons();
        } else {
            this.idList.remove(pk.toString(), false);
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(pk.toString());
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.setOprtState("ADDNEW");
            IObjectValue value = this.createNewData();
            if (value != null) {
                this.setDataObject(value);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.confirm_close"));
                this.destroyWindow();
            }
            EventListener[] lsts = this.removeDetailTableListener(KDTPropertyChangeListener.class);
            this.loadFields();
            this.restoreDetailTableListener(KDTPropertyChangeListener.class, lsts);
            if (this.idList.size() == 0) {
                this.actionEdit.setEnabled(false);
            }
        }
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    protected String getOrgGroupId() throws BOSException {
        return (String)this.getUIContext().get("parentOrgUnitId");
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            return new ObjectUuidPK(MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(SysContext.getSysContext().getCurrentOrgUnit(), null).getId());
        }
        catch (Exception e) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.hasEditPerm) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.hasEditPerm) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (!this.hasEditPerm) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        super.actionAddNew_actionPerformed(e);
    }
}

