/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.LazyShowName;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.biz.query.ExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.query.QueryItemDataByFastMerge;
import com.kingdee.eas.fi.gr.fast.client.AbstractAutoMergeItemDataUI;
import com.kingdee.eas.fi.gr.fast.client.query.AutoMergeUIData;
import com.kingdee.eas.fi.gr.fast.client.query.ConvertToUIData;
import com.kingdee.eas.fi.gr.fast.client.query.ItemDataElement;
import com.kingdee.eas.fi.gr.fast.client.query.SortUIItemDataElement;
import com.kingdee.eas.fi.gr.fast.log.QueryName;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AutoMergeItemDataUI
extends AbstractAutoMergeItemDataUI {
    private static final long serialVersionUID = 5010220583926666949L;
    private static final Logger logger = CoreUIObject.getLogger(AutoMergeItemDataUI.class);

    public AutoMergeItemDataUI() throws Exception {
        this.item.checkParsed(false);
        this.item.getStyleAttributes().setLocked(true);
        this.item.getSelectManager().setSelectMode(2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CslRptUIUtil.setSpineRange(this.year, 1974, Integer.MAX_VALUE);
        CslRptUIUtil.setSpineRange(this.period, 1, 366);
        FastMergeSoluInfo solution = (FastMergeSoluInfo)this.getUIContext().get(FastMergeSoluInfo.class);
        if (solution == null) {
            return;
        }
        this.currency.setText(solution.getCurrency() + "");
        RptPeriodTypeEnum periodType = this.getPeriodType();
        this.periodType.setText(periodType.getAlias());
        int[] yearAndPeriod = FastMergeUtil.getLastExcuteYearAndPeriod(null, solution.getId().toString());
        if (yearAndPeriod == null) {
            yearAndPeriod = RPTDateUtil.getPeriod(new Date(), periodType);
        }
        if (yearAndPeriod != null && yearAndPeriod.length == 2) {
            this.year.setValue((Object)yearAndPeriod[0], false);
            this.period.setValue((Object)yearAndPeriod[1], false);
        }
        this.refresh();
        this.year.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!(AutoMergeItemDataUI.this.year.getValue() instanceof Integer)) {
                    return;
                }
                AutoMergeItemDataUI.this.refresh();
            }
        });
        this.period.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!(AutoMergeItemDataUI.this.period.getValue() instanceof Integer)) {
                    return;
                }
                AutoMergeItemDataUI.this.refresh();
            }
        });
    }

    protected void refresh() {
        AutoMergeUIData uiData = this.queryUIData();
        new SortUIItemDataElement().exec(uiData);
        this.queryItemName(uiData);
        if (uiData.getYear() != 0) {
            this.year.setValue((Object)uiData.getYear(), false);
        }
        if (uiData.getPeriod() != 0) {
            this.period.setValue((Object)uiData.getPeriod(), false);
        }
        if (uiData.getPeriodType() != null) {
            this.periodType.setText(uiData.getPeriodType() == null ? "" : uiData.getPeriodType().getAlias());
        }
        if (uiData.getCurrency() != null) {
            this.currency.setText(uiData.getCurrency() == null ? "" : uiData.getCurrency().getName());
        }
        this.item.removeRows();
        if (uiData.getItemDataes() != null && !uiData.getItemDataes().isEmpty()) {
            ItemDataElement itemDataElem = null;
            ItemDataElement previousItemDataElem = null;
            boolean sameItem = false;
            for (int i = 0; i < uiData.getItemDataes().size(); ++i) {
                itemDataElem = uiData.getItemDataes().get(i);
                if (itemDataElem == null) continue;
                IRow row = this.item.addRow();
                boolean bl = sameItem = previousItemDataElem != null && previousItemDataElem.getItemNumber() != null && previousItemDataElem.getItemNumber().equals(itemDataElem.getItemNumber());
                if (!sameItem) {
                    row.getCell("itemNumber").setValue((Object)itemDataElem.getItemNumber());
                    row.getCell("itemName").setValue(itemDataElem.getItemName());
                }
                boolean bl2 = sameItem = sameItem && previousItemDataElem != null && previousItemDataElem.getValueType() != null && previousItemDataElem.getValueType().equals((Object)itemDataElem.getValueType());
                if (!sameItem) {
                    row.getCell("valueType").setValue((Object)itemDataElem.getValueType());
                }
                boolean bl3 = sameItem = sameItem && previousItemDataElem != null && previousItemDataElem.getDataElement() != null && previousItemDataElem.getDataElement().equals(itemDataElem.getDataElement());
                if (!sameItem) {
                    row.getCell("dataElement").setValue((Object)itemDataElem.getDataElement());
                }
                boolean bl4 = sameItem = sameItem && previousItemDataElem != null && previousItemDataElem.getCompany() != null && previousItemDataElem.getCompany().equals((Object)itemDataElem.getCompany());
                if (!sameItem) {
                    row.getCell("company").setValue((Object)itemDataElem.getCompany());
                }
                row.getCell("dynaItem").setValue((Object)itemDataElem.getDynaName());
                row.getCell("debitResult").setValue(this.formatMoney(itemDataElem.getDebitResult()));
                row.getCell("creditResult").setValue(this.formatMoney(itemDataElem.getCreditResult()));
                row.getCell("property").setValue((Object)itemDataElem.getItemTypeAlias());
                previousItemDataElem = itemDataElem;
            }
        }
    }

    private Object formatMoney(Object result) {
        if (!(result instanceof BigDecimal)) {
            return result;
        }
        result = ((BigDecimal)result).setScale(2, 4);
        return result;
    }

    private void queryItemName(AutoMergeUIData uiData) {
        QueryName queryName = new QueryName(new DBHandler(null), "fnumber");
        for (ItemDataElement itemDataElem : uiData.getItemDataes()) {
            LazyShowName lazyShowName = new LazyShowName(itemDataElem.getItemNumber());
            itemDataElem.setItemName(lazyShowName);
            queryName.put("item", lazyShowName);
        }
        try {
            queryName.replaceName();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected void sortUIItemDataElement(AutoMergeUIData uiData) {
        Collections.sort(uiData.getItemDataes(), new Comparator<ItemDataElement>(){

            @Override
            public int compare(ItemDataElement o1, ItemDataElement o2) {
                String key1 = this.key(o1);
                String key2 = this.key(o2);
                return key1.compareTo(key2);
            }

            private String key(ItemDataElement o) {
                String itemTypeOrder = null;
                if (BizFormulaDefine.belongType(o.getItemType() + "", new String[]{"CSLITEM", "DCSLITEM"})) {
                    itemTypeOrder = "1";
                } else if (BizFormulaDefine.belongType(o.getItemType() + "", new String[]{"ADJUSTITEM"})) {
                    itemTypeOrder = "2";
                } else if (BizFormulaDefine.belongType(o.getItemType() + "", new String[]{"ELIMENTRYITEM"})) {
                    itemTypeOrder = "3";
                }
                return o.getItemNumber() + "," + itemTypeOrder + "," + o.getCompany() + "," + o.getDataElement() + "," + o.getDynaName();
            }
        });
    }

    private AutoMergeUIData queryUIData() {
        AutoMergeUIData newInst = new AutoMergeUIData();
        DBHandler dao = new DBHandler(null);
        QueryItemDataByFastMerge query = new QueryItemDataByFastMerge(dao);
        int year = this.year.getValue() instanceof Integer ? (Integer)this.year.getValue() : 2013;
        int period = this.period.getValue() instanceof Integer ? (Integer)this.period.getValue() : 1;
        String fastMergeId = (String)this.getUIContext().get("ID");
        ExecuteParam param = new ExecuteParam(year, period);
        Object result = null;
        try {
            result = query.exec(fastMergeId, param);
            if (!(result instanceof Map)) {
                return newInst;
            }
            Map data = (Map)result;
            return new ConvertToUIData(dao).exec(data);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            return newInst;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return newInst;
        }
    }

    protected RptPeriodTypeEnum getPeriodType() {
        RptPeriodTypeEnum periodType;
        FastMergeSoluInfo solution = (FastMergeSoluInfo)this.getUIContext().get(FastMergeSoluInfo.class);
        if (solution == null) {
            return RptPeriodTypeEnum.MONTHLY;
        }
        try {
            periodType = solution.getTemplates().get(0).getTemplate().getPeriodType();
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            periodType = RptPeriodTypeEnum.MONTHLY;
        }
        return periodType;
    }
}

