/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.NeedRefreshable;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.UIParamForNonCompared;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.SetTreeTable;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.TreeTableNodeFoldAction;
import com.kingdee.eas.fi.gr.cslrpt.client.util.IconRender;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.fast.client.AbstractAutoMergeReportUI;
import com.kingdee.eas.fi.gr.fast.client.query.AutoMergeLogTableNode;
import com.kingdee.eas.fi.gr.fast.client.query.AutoMergeReportFacade;
import com.kingdee.eas.fi.gr.fast.log.AutoMergeNodeReport;
import com.kingdee.eas.fi.gr.fast.log.AutoMergeReport;
import com.kingdee.eas.fi.gr.fast.log.NodeType;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class AutoMergeReportUI
extends AbstractAutoMergeReportUI
implements NeedRefreshable {
    private static final long serialVersionUID = -8200761888005124845L;
    private static final Logger logger = CoreUIObject.getLogger(AutoMergeReportUI.class);
    private Timer timer = new Timer();
    private String executeTaskId = "";

    public AutoMergeReportUI() throws Exception {
        this.log.checkParsed(false);
        this.log.getStyleAttributes().setLocked(true);
        this.log.getSelectManager().setSelectMode(10);
        this.progress.setStringPainted(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.statement.setText(ResourceDebugUtil.res("wait.to.show.log"));
        new SetTreeTable(false).exec(this.log, "node", null, null);
        this.log.getColumn("status").setRenderer((IBasicRender)new IconRender());
        this.log.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int rowIndex;
                Object msg;
                if (e.getClickCount() == 2 && (msg = AutoMergeReportUI.this.log.getRow2(rowIndex = AutoMergeReportUI.this.log.getSelectManager().getActiveRowIndex()).getCell("detail").getValue()) != null && msg != "") {
                    String detail = msg.toString();
                    UIContext ctx = new UIContext((Object)this);
                    ctx.put((Object)"Title", (Object)CslRptUtil.getString("CslRptUUCheckResult"));
                    ctx.put((Object)"String", (Object)detail);
                    try {
                        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
                        uiWindow.show();
                    }
                    catch (UIException e1) {
                        logger.error((Object)"tableClicked", (Throwable)e1);
                    }
                }
            }
        });
        this.freshData();
    }

    public void freshData() {
        this.executeTaskId = (String)this.getUIContextParam("executeTaskId", true);
        this.timer.cancel();
        this.timer = new Timer();
        this.progress.setValue(0);
        this.log.removeRows();
        final AutoMergeReportFacade autoMergeReportFacade = new AutoMergeReportFacade(null);
        Map uiContext = this.getUIContext();
        Object currentMergeContext = null;
        String executeTaskId = null;
        currentMergeContext = uiContext.containsKey("mergeContext") ? this.getUIContextParam("mergeContext", false) : "no name scheme";
        executeTaskId = uiContext.containsKey("executeTaskId") ? (String)this.getUIContextParam("executeTaskId", false) : null;
        String currencyName = null;
        currencyName = uiContext.containsKey("currencyName") ? (String)this.getUIContextParam("currencyName", false) : null;
        final Object finalCurrentMergeContext = currentMergeContext;
        final String finalExecuteTaskId = executeTaskId;
        final String finalCurrencyName = currencyName;
        final List<Integer> allNodes = autoMergeReportFacade.getMergeContextNodes(currentMergeContext);
        this.initTable(currentMergeContext);
        this.timer.scheduleAtFixedRate(new TimerTask(){
            private long startTime = System.currentTimeMillis();

            @Override
            public void run() {
                if (AutoMergeReportUI.this.progress.getValue() >= 100) {
                    this.cancel();
                    return;
                }
                if ((System.currentTimeMillis() - this.startTime) / 36000000L != 0L) {
                    try {
                        Thread.currentThread().wait(3600000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                    return;
                }
                try {
                    AutoMergeReportUI.this.collectAndFillDetailReport(finalCurrentMergeContext, autoMergeReportFacade, finalExecuteTaskId, finalCurrencyName, allNodes);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }, 10L, 5000L);
    }

    protected void initTable(Object currentMergeContext) {
        IRow rootRow = this.log.addRow();
        String schemeName = "" + currentMergeContext;
        AutoMergeLogTableNode root = new AutoMergeLogTableNode(schemeName, null, null, null, false);
        root.setText(schemeName);
        root.setHasLoaded(true);
        rootRow.getCell("node").setValue((Object)root);
        rootRow.getCell("node").setUserObject((Object)root);
    }

    private void collectAndFillDetailReport(Object currentMergeContext, AutoMergeReportFacade autoMergeReportFacade, String executeTaskId, String currencyName, List<Integer> allNodes) throws EASBizException, BOSException {
        if (this.log.getRowCount() < 1) {
            return;
        }
        IRow rootRow = this.log.getRow(0);
        String schemeName = "" + currentMergeContext;
        AutoMergeReport report = autoMergeReportFacade.getReport(currentMergeContext, executeTaskId);
        String year = report.getYear();
        String period = report.getPeriod();
        if (year == null) {
            year = "0";
        }
        if (period == null) {
            period = "0";
        }
        if (currencyName == null) {
            currencyName = "";
        }
        this.fastMergeSolu.setText(report.getMergeScheme() + MessageFormat.format(ResourceDebugUtil.res("information.of.year.period.and.currency.with.format"), year, period, currencyName));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.statement.setText(MessageFormat.format(ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "log.reportStatus", " "), report.getStatus().toString(), report.getStartTime() != null ? simpleDateFormat.format(report.getStartTime()) : ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "log.reportStatus.noready", " "), report.getEndTime() != null ? simpleDateFormat.format(report.getEndTime()) : ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "log.reportStatus.noend", " ")));
        int procent = report.getProgress();
        if (procent > 100 || procent < 0) {
            procent = 0;
        }
        this.progress.setValue(procent);
        int nodeReportIndex = 0;
        int nodeReportSize = report.getReports().size();
        List<AutoMergeNodeReport> nodeReports = report.getReports();
        AutoMergeNodeReport nodeReport = null;
        int errorSize = 0;
        int successSize = 0;
        int errorNodeSize = 0;
        int successNodeSize = 0;
        AutoMergeLogTableNode nodeRowValue = null;
        AutoMergeLogTableNode value1 = null;
        Object currentUnit = null;
        IRow nodeRow = null;
        IRow row = null;
        int currNodeDetailIndex = -1;
        int rowIndex = 0;
        String nodeAlias = null;
        TreeTableNodeFoldAction foldAction = new TreeTableNodeFoldAction(this.log, null, "node");
        ArrayList<Integer> foldRowIndexes = new ArrayList<Integer>(8);
        for (int i = 0; i < allNodes.size(); ++i) {
            currentUnit = null;
            nodeAlias = NodeType.alias(allNodes.get(i));
            nodeRow = ++rowIndex < this.log.getRowCount() ? this.log.getRow(rowIndex) : this.log.addRow();
            nodeRowValue = new AutoMergeLogTableNode(schemeName, nodeAlias, null, null, false);
            nodeRowValue.setText(nodeAlias);
            nodeRowValue.setHasLoaded(true);
            nodeRow.getCell("node").setValue((Object)nodeRowValue);
            nodeRow.getCell("node").setUserObject((Object)nodeRowValue);
            nodeRow.getCell("status").setValue(null);
            nodeRow.getCell("status").setUserObject(null);
            currNodeDetailIndex = 0;
            ICell currentUnitStatusCell = null;
            String currentUnitStatus = null;
            errorNodeSize = 0;
            successNodeSize = 0;
            while (nodeReportIndex < nodeReportSize) {
                nodeReport = nodeReports.get(nodeReportIndex);
                if (!allNodes.get(i).equals(nodeReport.getType())) {
                    if (allNodes.contains(nodeReport.getType())) break;
                    ++nodeReportIndex;
                    continue;
                }
                ++currNodeDetailIndex;
                String templateAlias = null;
                if (nodeReport.getTemplate() instanceof TemplateInfo) {
                    templateAlias = ((TemplateInfo)nodeReport.getTemplate()).getName();
                } else {
                    String string = templateAlias = nodeReport.getTemplate() == null ? null : nodeReport.getTemplate().toString();
                }
                if (this.needTemplate(allNodes.get(i))) {
                    if (!(nodeReport.getUnit() == null || currentUnit != null && nodeReport.getUnit().toString().equals(currentUnit.toString()))) {
                        if (currentUnitStatusCell != null) {
                            currentUnitStatusCell.setValue(currentUnitStatus);
                            currentUnitStatusCell.setUserObject((Object)currentUnitStatus);
                        }
                        row = ++rowIndex < this.log.getRowCount() ? this.log.getRow(rowIndex) : this.log.addRow();
                        value1 = new AutoMergeLogTableNode(schemeName, nodeAlias, nodeReport.getUnit().toString(), null, true);
                        value1.setText(nodeReport.getUnit().toString());
                        value1.setHasLoaded(true);
                        row.getCell("node").setValue((Object)value1);
                        row.getCell("node").setUserObject((Object)value1);
                        currentUnitStatusCell = row.getCell("status");
                        currentUnit = nodeReport.getUnit();
                        foldRowIndexes.add(row.getRowIndex());
                        currentUnitStatus = null;
                    }
                    if (currentUnitStatus == null) {
                        currentUnitStatus = Boolean.FALSE.equals(nodeReport.getStatus()) ? "FAILURE" : "SUCCESS";
                    } else if (!("SUCCESS" == currentUnitStatus && Boolean.TRUE.equals(nodeReport.getStatus()) || "FAILURE" == currentUnitStatus && Boolean.FALSE.equals(nodeReport.getStatus()))) {
                        currentUnitStatus = "SUCCESS" == currentUnitStatus && Boolean.FALSE.equals(nodeReport.getStatus()) || "FAILURE" == currentUnitStatus && Boolean.TRUE.equals(nodeReport.getStatus()) ? "PARTFAILURE" : null;
                    }
                    row = ++rowIndex < this.log.getRowCount() ? this.log.getRow(rowIndex) : this.log.addRow();
                    value1 = new AutoMergeLogTableNode(schemeName, nodeAlias, nodeReport.getUnit().toString(), templateAlias, true);
                    value1.setText(templateAlias);
                    row.getCell("node").setValue((Object)value1);
                    row.getCell("node").setUserObject((Object)value1);
                    row.getCell("desc").setValue((Object)nodeReport.getError());
                    row.getCell("desc").setUserObject((Object)nodeReport.getError());
                    row.getCell("detail").setValue((Object)nodeReport.getDetail());
                    row.getCell("detail").setUserObject((Object)nodeReport.getDetail());
                    row.getCell("status").setValue((Object)(Boolean.TRUE.equals(nodeReport.getStatus()) ? "SUCCESS" : "FAILURE"));
                    row.getCell("status").setUserObject(nodeReport.getStatus());
                } else {
                    row = ++rowIndex < this.log.getRowCount() ? this.log.getRow(rowIndex) : this.log.addRow();
                    value1 = new AutoMergeLogTableNode(schemeName, nodeAlias, nodeReport.getUnit().toString(), null, false);
                    value1.setText(nodeReport.getUnit().toString());
                    row.getCell("node").setValue((Object)value1);
                    row.getCell("node").setUserObject((Object)value1);
                    row.getCell("desc").setValue((Object)nodeReport.getError());
                    row.getCell("desc").setUserObject((Object)nodeReport.getError());
                    row.getCell("detail").setValue((Object)nodeReport.getDetail());
                    row.getCell("detail").setUserObject((Object)nodeReport.getDetail());
                    row.getCell("status").setValue((Object)(Boolean.TRUE.equals(nodeReport.getStatus()) ? "SUCCESS" : "FAILURE"));
                    row.getCell("status").setUserObject(nodeReport.getStatus());
                }
                if (nodeReport.getStatus() != null && Boolean.FALSE.equals(nodeReport.getStatus())) {
                    ++errorSize;
                    ++errorNodeSize;
                } else if (Boolean.TRUE.equals(nodeReport.getStatus())) {
                    ++successSize;
                    ++successNodeSize;
                }
                ++nodeReportIndex;
                nodeRow.getCell("desc").setValue(null);
            }
            if (currentUnitStatusCell != null) {
                currentUnitStatusCell.setValue(currentUnitStatus);
                currentUnitStatusCell.setUserObject(currentUnitStatus);
            }
            foldRowIndexes.add(nodeRow.getRowIndex());
            if (procent != 100) continue;
            nodeRow.getCell("status").setValue((Object)(errorNodeSize == 0 ? "SUCCESS" : (successNodeSize == 0 ? "FAILURE" : "PARTFAILURE")));
        }
        for (Integer foldedRowIndex : foldRowIndexes) {
            foldAction.action(foldedRowIndex);
        }
        if (procent == 100) {
            rootRow.getCell("status").setValue((Object)(errorSize == 0 ? "SUCCESS" : (successSize == 0 ? "FAILURE" : "PARTFAILURE")));
            rootRow.getCell("desc").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"log.reportStatus.progress"), procent, successSize, errorSize));
        } else {
            rootRow.getCell("desc").setValue((Object)MessageFormat.format("{0}%", procent));
        }
    }

    private boolean needTemplate(int type) {
        return 1 == type || 3 == type || 5 == type;
    }

    private Object getUIContextParam(String paramName, boolean isParamForUI) {
        if (isParamForUI) {
            UIParamForNonCompared paramForUI = (UIParamForNonCompared)this.getUIContext().get(UIParamForNonCompared.class);
            if (paramForUI == null) {
                return null;
            }
            return paramForUI.get(paramName);
        }
        return this.getUIContext().get(paramName);
    }

    public boolean destroyWindow() {
        this.timer.cancel();
        boolean destroyWindow = super.destroyWindow();
        return destroyWindow;
    }

    @Override
    public boolean isNeed() {
        return this.progress.getValue() == 100;
    }

    @Override
    public void toRefresh() {
        this.freshData();
    }
}

