/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.adv.chain.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.client.AbstractFastMergeSetTimeDispatchUI;
import com.kingdee.eas.fi.gr.fast.client.timedispatch.DispatchPeriodHandle;
import com.kingdee.eas.fi.gr.fast.client.timedispatch.IDispatchPeriodSource;
import com.kingdee.eas.fi.gr.fast.client.timedispatch.ShowDispatchPeriodSettingUI;
import com.kingdee.eas.fi.gr.fast.client.timedispatch.TimeDispatchSourceForFastRpt;
import com.kingdee.eas.fi.gr.weaverpt.FormatJobProcessSettingAction;
import com.kingdee.eas.fi.rpt.RptCalcSchemeFactory;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class FastMergeSetTimeDispatchUI
extends AbstractFastMergeSetTimeDispatchUI {
    private static final Logger logger = CoreUIObject.getLogger(FastMergeSetTimeDispatchUI.class);
    private FastMergeSoluInfo fastMergeSoluInfo;
    DispatchPeriodHandle dipHandle;
    private IDispatchPeriodSource source;
    private KDTextArea taDispatchPeriod = new KDTextArea();

    public void onLoad() throws Exception {
        String curLanguage = SysContext.getSysContext().getLocale().getLanguage();
        FastMergeSetTimeDispatchUI fastMergeSetTimeDispatchUI = this;
        for (Object language : fastMergeSetTimeDispatchUI.txtTimeDesc.getLanguageList()) {
            if (!curLanguage.equals(((LanguageInfo)language).getLocale().getLanguage())) continue;
            this.txtTimeDesc.setSelectedLanguage((LanguageInfo)language);
            break;
        }
        String fastMergeSoluId = null;
        if (this.getUIContext().containsKey("fastMergeSoluId") && (fastMergeSoluId = (String)this.getUIContext().get("fastMergeSoluId")) != null) {
            this.fastMergeSoluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), this.getSelector());
            if ("".equals(this.fastMergeSoluInfo.getDispatchPeriodId())) {
                this.fastMergeSoluInfo.setDispatchPeriodId(null);
            }
            this.source = new TimeDispatchSourceForFastRpt(this.fastMergeSoluInfo);
            this.dipHandle = new DispatchPeriodHandle(this.taDispatchPeriod, (IUIObject)this, this.source);
            if (this.fastMergeSoluInfo.getDispatchPeriodId() != null) {
                this.txtTimeDef.setText(this.fastMergeSoluInfo.getDispatchPeriodId());
                this.txtTimeDesc.setSelectedItemData((Object)this.getTextByDispatchPeriodId(this.fastMergeSoluInfo.getDispatchPeriodId()));
            }
            if (this.fastMergeSoluInfo.isIsCurrentPeriod()) {
                this.isCurrentPeriod.setSelected(true);
                this.isPrePeriod.setSelected(false);
            } else {
                this.isCurrentPeriod.setSelected(false);
                this.isPrePeriod.setSelected(true);
            }
        }
        this.bindAction();
    }

    private String getTextByDispatchPeriodId(String dispatchPeriodId) throws Exception {
        if (dispatchPeriodId != null) {
            Map map = RptCalcSchemeFactory.getRemoteInstance().getProcessDef(dispatchPeriodId);
            ScheduleDef schdef = null;
            if (map != null && !map.isEmpty()) {
                schdef = new ScheduleDef(null);
                String define = (String)map.get("rpt_cacl_scheme_define");
                String[] defines = define.split(":");
                schdef.setType(ScheduleType.getEnum((String)defines[0]));
                schdef.setDefine(defines[1]);
                schdef.setBeginTime((Date)map.get("rpt_cacl_scheme_begintime"));
                schdef.setUseCalendar(RptUtil.isTrue(map.get("rpt_cacl_scheme_is_use_calendar ")));
                schdef.setOrgUnitId((String)map.get("rpt_cacl_scheme_org"));
                schdef.setInstructionType(1);
                return new FormatJobProcessSettingAction().action(schdef);
            }
        }
        return null;
    }

    public void bindAction() {
        this.isCurrentPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastMergeSetTimeDispatchUI.this.isPrePeriod.setSelected(false);
                FastMergeSetTimeDispatchUI.this.isCurrentPeriod.setSelected(true);
            }
        });
        this.isPrePeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastMergeSetTimeDispatchUI.this.isPrePeriod.setSelected(true);
                FastMergeSetTimeDispatchUI.this.isCurrentPeriod.setSelected(false);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnTimeDefine_actionPerformed(ActionEvent e) throws Exception {
        super.btnTimeDefine_actionPerformed(e);
        boolean choose = new ShowDispatchPeriodSettingUI((Object)this, this.source, logger).show();
        if (choose) {
            this.txtTimeDef.setText(this.source.getJobProcess());
            this.txtTimeDesc.setSelectedItemData((Object)this.source.getText());
        }
    }

    @Override
    protected void btnConform_actionPerformed(ActionEvent e) throws Exception {
        super.btnConform_actionPerformed(e);
        ((CoreBaseInfo)this.dipHandle.getDisSource().getJobParam()).setId(this.fastMergeSoluInfo.getId());
        this.dipHandle.saveJobProcessDef();
        this.fastMergeSoluInfo.setIsAutoDispatch(true);
        if (this.isCurrentPeriod.isSelected()) {
            this.fastMergeSoluInfo.setIsCurrentPeriod(true);
        } else {
            this.fastMergeSoluInfo.setIsCurrentPeriod(false);
        }
        this.fastMergeSoluInfo.setDispatchPeriodId(this.source.getJobProcess());
        if (StringUtil.isEmpty((String)this.fastMergeSoluInfo.getDispatchPeriodId())) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "timeSolutionIsNotBeSetted", " "));
            return;
        }
        FastMergeSoluFactory.getRemoteInstance().updatePartial(this.fastMergeSoluInfo, this.getSelector());
        this.destroyWindow();
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isCurrentPeriod");
        selector.add("isAutoDispatch");
        selector.add("dispatchPeriodId");
        return selector;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    protected void isCurrentPeriod_actionPerformed(ActionEvent e) throws Exception {
        super.isCurrentPeriod_actionPerformed(e);
    }
}

