/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptTmpGuideUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.NeedRefreshable;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.UIParamForNonCompared;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.fast.FastMergeBizFacadeFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.client.AbstractFastMergeSoluExecGuideUI;
import com.kingdee.eas.fi.gr.fast.client.AutoMergeReportUI;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FastMergeSoluExecGuideUI
extends AbstractFastMergeSoluExecGuideUI {
    private static final long serialVersionUID = 506662978253745983L;
    private static final Logger LOGGER = CoreUIObject.getLogger(FastMergeSoluExecGuideUI.class);

    public void onLoad() throws Exception {
        MnsRptTmpGuideUIUtil.initGuideImage(this.pnlImage);
        if (this.getUIContext().get("fastMergeSoluInfo") == null || this.getUIContext().get("periodType") == null) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "paramIsWrong", " "));
            SysUtil.abort();
        }
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.getUIContext().get("periodType");
        Calendar calendar = Calendar.getInstance();
        List times = RPTDateUtil.getRptPeriod(calendar.getTime(), periodType);
        Integer year = (Integer)times.get(0);
        Integer period = (Integer)times.get(1);
        CslRptUIUtil.setSpineRange(this.txtYear, 1900, 2999, true, true);
        CslRptUIUtil.setSpineRange(this.txtPeriod, 1, 366, true, true);
        FastMergeUtil.setPeriodRange(this.txtPeriod, periodType.getValue(), year);
        this.txtYear.setValue((Object)year);
        this.txtPeriod.setValue((Object)period);
        FastMergeSoluInfo soluInfo = (FastMergeSoluInfo)this.getUIContext().get("fastMergeSoluInfo");
        this.kDNumber.setText(this.kDNumber.getText() + soluInfo.getNumber());
        this.kDName.setText(this.kDName.getText() + soluInfo.getName());
        this.kDCurrency.setText(this.kDCurrency.getText() + soluInfo.getCurrency().getName());
        this.isSupportGroupReport.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnConform_actionPerformed(ActionEvent e) throws Exception {
        super.btnConform_actionPerformed(e);
        final String fastMergeSoluId = (String)this.getUIContext().get("fastMergeSoluId");
        final String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        final int year = (Integer)this.txtYear.getValue();
        final int period = (Integer)this.txtPeriod.getValue();
        boolean isExistsFlag = FastMergeUtil.checkHasOrgTreeInfo(userId, fastMergeSoluId, year, period);
        if (!isExistsFlag) {
            MessageHandler messageHandler = new MessageHandler(1);
            messageHandler.show(FastMergeUtil.getStringRes("fastmerge.check.orgtree"));
            return;
        }
        final String executeTaskId = Uuid.create().toString();
        Thread calcThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FastMergeBizFacadeFactory.getRemoteInstance().immediateRunSolu(fastMergeSoluId, userId, year, period, 0, executeTaskId);
                }
                catch (EASBizException eASBizException) {
                }
                catch (BOSException bOSException) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        });
        calcThread.start();
        this.destroyWindow();
        while (!calcThread.isAlive()) {
        }
        this.showRunedReport(fastMergeSoluId, executeTaskId);
    }

    private void showRunedReport(String fastMergeSoluId, String executeTaskId) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("isAutoSum");
        selectors.add("autoItemFormual.id");
        selectors.add("adjustEntrySolu.id");
        selectors.add("elimEntrySolu.id");
        selectors.add("elimEntrySolu.id");
        selectors.add("currency.name");
        FastMergeSoluInfo currentInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
        uiContext.put((Object)"ID", (Object)currentInfo.getId().toString());
        uiContext.put((Object)"mergeContext", (Object)currentInfo);
        uiContext.put((Object)"executeTaskId", (Object)executeTaskId);
        uiContext.put((Object)"currencyName", (Object)currentInfo.getCurrency().getName());
        UIParamForNonCompared paramForUI = new UIParamForNonCompared();
        uiContext.put(UIParamForNonCompared.class, (Object)paramForUI);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AutoMergeReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, this.getWinStyle());
        uiWindow.getUIObject().getUIContext().putAll(uiContext);
        if (uiWindow.getUIObject() instanceof NeedRefreshable && ((NeedRefreshable)uiWindow.getUIObject()).isNeed()) {
            ((NeedRefreshable)uiWindow.getUIObject()).toRefresh();
        }
        uiWindow.show();
    }

    protected int getWinStyle() {
        return 85;
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }
}

