/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.gr.cslrpt.client.util.mutex.MutexLock;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluType;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateInfo;
import com.kingdee.eas.fi.gr.fast.FastRptException;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.gr.fast.SrcTmpRelateTagTmpInfo;
import com.kingdee.eas.fi.gr.fast.client.AbstractFastMergeSumEditUI;
import com.kingdee.eas.fi.gr.fast.client.databind.FastMergeUnitTableDataBinder;
import com.kingdee.eas.fi.gr.fast.client.query.FullOrgUnitTableNode;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.ChooseTemplate;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FastMergeSumEditUI
extends AbstractFastMergeSumEditUI {
    private static final long serialVersionUID = -418681790998596157L;
    private static final Logger logger = CoreUIObject.getLogger(FastMergeSumEditUI.class);
    private FastMergeSoluInfo old_editData = null;
    private FastMergeUnitTableDataBinder fastMergeUnitTableDataBinder = null;
    private boolean isAutoSum = true;
    private boolean isHasCreatedMergeReport = false;
    private MutexLock editLock;
    private MutexLock immediateRunLock;
    private MutexLock setTimeDispatchCalcLock;

    public FastMergeSumEditUI() throws Exception {
        this.tblTplUnit.checkParsed(false);
        this.tblTpl.checkParsed(false);
        this.defineBinding();
        this.addOrganUnitFilter();
        this.editLock = new MutexLock("Edit", "ActionEdit", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.modified.cannot.execute"), logger);
        this.immediateRunLock = new MutexLock("ImmediateRun", "ActionImmediateRunLock", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.running.cannot.execute"), logger);
        this.setTimeDispatchCalcLock = new MutexLock("SetTimeDispatch", "ActionSetTimeDispatch", this.getMessageHandler(), FastMergeUtil.getStringRes("scheme.is.scheduled.cannot.execute"), logger);
    }

    public void addOrganUnitFilter() {
        String companyId = null;
        try {
            companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        }
        catch (Exception e) {
            logger.error((Object)"getCurOrgGroup", (Throwable)e);
        }
        EntityViewInfo autoItem_view = new EntityViewInfo();
        FilterInfo autoItem_filter = new FilterInfo();
        autoItem_filter.getFilterItems().add(new FilterItemInfo("schmOrg", (Object)companyId, CompareType.EQUALS));
        autoItem_view.setFilter(autoItem_filter);
        this.kDpSingleDataSolution.setEntityViewInfo(autoItem_view);
        EntityViewInfo adjust_view = new EntityViewInfo();
        FilterInfo adjust_filter = new FilterInfo();
        adjust_filter.getFilterItems().add(new FilterItemInfo("organUnit.id", (Object)companyId, CompareType.EQUALS));
        adjust_view.setFilter(adjust_filter);
        this.kDpAdjustSolution.setEntityViewInfo(adjust_view);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bindAction();
        this.isHasCreatedMergeReport();
        if (this.isSupportGroupReport()) {
            this.kDIsContainUnReceive.setEnabled(false);
            this.kDpSingleDataSolution.setEnabled(false);
        }
        this.initWorkButtonByCreator();
        this.kDbSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.kDbClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initOrgUnitTbl();
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
        this.setCurrency();
    }

    private void setCurrency() {
        if (this.editData != null && this.editData.getCurrency() != null) {
            String currencyId = this.editData.getCurrency().getId().toString();
            int count = this.comboCurrency.getItemCount();
            for (int i = 0; i < count; ++i) {
                CurrencyInfo cur = (CurrencyInfo)this.comboCurrency.getItemAt(i);
                if (!currencyId.equals(cur.getId().toString())) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
    }

    private boolean dataIsLocking() throws Exception {
        BOSUuid bosUuid = this.editData.getId();
        if (this.editLock.isLock(bosUuid)) {
            this.editLock.showError();
            return true;
        }
        if (this.setTimeDispatchCalcLock.isLock(bosUuid)) {
            this.setTimeDispatchCalcLock.showError();
            return true;
        }
        if (RptNewUIUtil.hasMutexLock(null, (String)bosUuid.toString())) {
            this.immediateRunLock.showError();
            return true;
        }
        return false;
    }

    protected void initOrgUnitTbl() {
        if (this.bizOrgBound.getData() != null) {
            OrgTreeInfo orgTree = (OrgTreeInfo)this.bizOrgBound.getData();
            String pk = null;
            if (this.editData != null && this.editData.getId() != null) {
                pk = this.editData.getId().toString();
            }
            FastMergeOrgUnitCollection coll = new FastMergeOrgUnitCollection();
            try {
                String isAutoSum = null;
                isAutoSum = this.editData.isIsAutoSum() ? "isAutoSum" : "isNotAutoSum";
                coll = FastMergeOrgUnitFactory.getRemoteInstance().constructFastMergeUnitColl(orgTree.getId().toString(), pk, isAutoSum);
            }
            catch (EASBizException e) {
                logger.error((Object)"initOrgUnitTbl", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"initOrgUnitTbl", (Throwable)e);
            }
            if (this.fastMergeUnitTableDataBinder == null) {
                this.fastMergeUnitTableDataBinder = new FastMergeUnitTableDataBinder(this.tblTplUnit, (IUIObject)this, this.isAutoSum(), this.isSupportGroupReport());
            }
            this.fastMergeUnitTableDataBinder.setTreeInfo(orgTree);
            this.fastMergeUnitTableDataBinder.setSupportGroupReport(this.isSupportGroupReport());
            this.fastMergeUnitTableDataBinder.setIsAutoSum(this.isAutoSum);
            this.fastMergeUnitTableDataBinder.setTableData((IObjectCollection)coll, true);
        }
    }

    private void initOrgUnitTblByFromPk(String fromPk) {
        if (this.bizOrgBound.getData() != null) {
            OrgTreeInfo orgTree = (OrgTreeInfo)this.bizOrgBound.getData();
            FastMergeOrgUnitCollection coll = new FastMergeOrgUnitCollection();
            try {
                String isAutoSum = null;
                isAutoSum = this.editData.isIsAutoSum() ? "isAutoSum" : "isNotAutoSum";
                coll = FastMergeOrgUnitFactory.getRemoteInstance().constructFastMergeUnitColl(orgTree.getId().toString(), fromPk, isAutoSum);
            }
            catch (EASBizException e) {
                logger.error((Object)"initOrgUnitTblByFromPk", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"initOrgUnitTblByFromPk", (Throwable)e);
            }
            if (this.fastMergeUnitTableDataBinder == null) {
                this.fastMergeUnitTableDataBinder = new FastMergeUnitTableDataBinder(this.tblTplUnit, (IUIObject)this, this.isAutoSum(), this.isSupportGroupReport());
            }
            this.fastMergeUnitTableDataBinder.setTreeInfo(orgTree);
            this.fastMergeUnitTableDataBinder.setTableData((IObjectCollection)coll, true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        UnionVersion2F7 f7 = new UnionVersion2F7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource.sorgse"));
        this.bizOrgBound.setSelector((KDPromptSelector)f7);
        this.disenableAction();
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveBegin.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveEnd.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAddTpl.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelTpl.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void disenableAction() {
        this.actionSave.setEnabled(false);
        this.actionSave.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionFirst.setEnabled(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setEnabled(false);
        this.actionNext.setVisible(false);
        this.actionPre.setEnabled(false);
        this.actionPre.setVisible(false);
        this.actionLast.setEnabled(false);
        this.actionLast.setVisible(false);
        this.actionCancel.setEnabled(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setEnabled(false);
        this.actionCancelCancel.setVisible(false);
    }

    private void defineBinding() {
        this.dataBinder.registerBinding("clientSoluUnit", IObjectCollection.class, (Component)new FastMergeUnitTableDataBinder(this.tblTplUnit, (IUIObject)this, this.isAutoSum(), this.isSupportGroupReport()), "tableData");
    }

    private boolean isAutoSum() {
        return this.isAutoSum;
    }

    private boolean isSupportGroupReport() {
        return this.isSupportGroupReport.isSelected();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeUnitEntries();
        this.editData.setIsAutoSum(this.isAutoSum);
    }

    private void storeUnitEntries() {
        this.editData.setSyncOldValue(false);
        int size = this.tblTplUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblTplUnit.getRow(i);
            FastMergeOrgUnitInfo entryInfo = (FastMergeOrgUnitInfo)row.getUserObject();
            if (row.getCell("fixedTabSoluName").getValue() instanceof IObjectValue) {
                entryInfo.setFixedCalcSolu(((IObjectValue)row.getCell("fixedTabSoluName").getValue()).getString("id"));
            } else if (row.getCell("fixedTabSoluName").getValue() == null) {
                entryInfo.setFixedCalcSolu(null);
            }
            if (row.getCell("dynaTabSoluName").getValue() instanceof IObjectValue) {
                entryInfo.setDynaCalcSolu(((IObjectValue)row.getCell("dynaTabSoluName").getValue()).getString("id"));
                continue;
            }
            if (row.getCell("dynaTabSoluName").getValue() != null) continue;
            entryInfo.setDynaCalcSolu(null);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.isHasCreatedMergeReport();
        this.tblTplUnit.removeRows();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.dataIsLocking()) {
            return;
        }
        super.actionEdit_actionPerformed(e);
        if (this.isSupportGroupReport()) {
            this.kDIsContainUnReceive.setEnabled(false);
            this.kDpSingleDataSolution.setEnabled(false);
        }
    }

    private void initWorkButtonByCreator() throws Exception {
        String fastMergeSoluId;
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.editData != null && this.editData.getId() != null && !StringUtils.isEmpty((String)(fastMergeSoluId = this.editData.getId().toString()))) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("creator.id");
            FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectors);
            String creatorId = soluInfo.getCreator().getId().toString();
            if (!userId.equals(creatorId)) {
                this.btnEdit.setEnabled(false);
            }
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveJobDef();
        super.actionSave_actionPerformed(e);
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
        FastMergeTemplateCollection entrys = (FastMergeTemplateCollection)((Object)this.tblTpl.getUserObject());
        for (int i = 0; entrys != null && i < entrys.size(); ++i) {
            entrys.get(i).setSeq(i + 1);
        }
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setIsAutoSum(false);
            this.tblTplUnit.removeRows();
        }
    }

    protected String getClassAlise() {
        return FastMergeSoluType.fastSum.getAlias();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    private void saveJobDef() throws Exception {
        try {
            this.checkEditData();
        }
        catch (Exception e1) {
            MessageHandler messageHandler = new MessageHandler(1);
            messageHandler.show(e1.toString());
            SysUtil.abort();
        }
        this.checkSelectTemplate();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.selectOrClear(this.tblTplUnit, true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.selectOrClear(this.tblTplUnit, false);
    }

    private void selectOrClear(KDTable adjustTbl, boolean isSelect) {
        block3: {
            int activeRow;
            block2: {
                activeRow = adjustTbl.getSelectManager().getActiveRowIndex();
                if (activeRow >= 0) break block2;
                for (int i = 0; i < adjustTbl.getRowCount(); ++i) {
                    adjustTbl.getCell(i, "choose").setValue((Object)isSelect);
                }
                break block3;
            }
            Object userObject = adjustTbl.getCell(activeRow, "orgUnit").getUserObject();
            adjustTbl.getCell(activeRow, "choose").setValue((Object)isSelect);
            if (userObject == null || !(userObject instanceof FullOrgUnitTableNode) || !((FullOrgUnitTableNode)userObject).getOrgUnit().isIsUnion()) break block3;
            String longNumber = ((FullOrgUnitTableNode)userObject).getLongNumber();
            for (int i = activeRow + 1; i < adjustTbl.getRowCount() && ((FullOrgUnitTableNode)(userObject = adjustTbl.getCell(i, "orgUnit").getUserObject())).getLongNumber().startsWith(longNumber + "!"); ++i) {
                adjustTbl.getCell(i, "choose").setValue((Object)isSelect);
            }
        }
    }

    protected IObjectValue createNewData() {
        FastMergeSoluInfo info = new FastMergeSoluInfo();
        info.setOrganUnit(SysContext.getSysContext().getCurrentFIUnit().castToFullOrgUnitInfo());
        info.setIsAutoSum(true);
        info.setIsSupportGroupReport(false);
        info.setIsContainUnRecive(true);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FastMergeSoluFactory.getRemoteInstance();
    }

    public void bindAction() {
        this.bizOrgBound.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (FastMergeSumEditUI.this.isHasCreatedMergeReport) {
                    String showMsg = FastMergeUtil.getStringRes("cannot.change.orgbound.has.created");
                    MsgBox.showInfo((String)showMsg);
                    e.setResult(0);
                    return;
                }
            }
        });
        this.bizOrgBound.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FastMergeSumEditUI.this.initOrgUnitTbl();
            }
        });
        this.btnAddTpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                if (FastMergeSumEditUI.this.bizOrgBound.getData() == null) {
                    String showMsg = FastMergeUtil.getStringRes("62_selectOrgTree");
                    MsgBox.showInfo((String)showMsg);
                    return;
                }
                List tpls = new ChooseTemplate().open((Component)((Object)FastMergeSumEditUI.this), true, FastMergeSumEditUI.this.getChooseTemplateEntityView(), FastMergeSumEditUI.this.btnAddTpl.getText(), FastMergeSumEditUI.this.getChooseTemplateFilterProceccor(), FastMergeSumEditUI.this.getChooseTemplateHiddenColumnSetting());
                if (!FastMergeSumEditUI.this.canEdit() || tpls.isEmpty()) {
                    return;
                }
                TemplateInfo tpl = null;
                FastMergeTemplateInfo tempEntry = null;
                IRow row = null;
                HashSet<String> rowIdSet = new HashSet<String>();
                FastMergeTemplateCollection entrys = (FastMergeTemplateCollection)((Object)FastMergeSumEditUI.this.tblTpl.getUserObject());
                for (i = 0; entrys != null && i < entrys.size(); ++i) {
                    rowIdSet.add(entrys.get(i).getTemplate().getId().toString());
                }
                for (i = 0; i < tpls.size(); ++i) {
                    tpl = (TemplateInfo)tpls.get(i);
                    tempEntry = new FastMergeTemplateInfo();
                    tempEntry.setTemplate(tpl);
                    if (rowIdSet.contains(tpl.getId().toString())) continue;
                    row = FastMergeSumEditUI.this.tblTpl.addRow();
                    row.setUserObject((Object)tempEntry);
                    BindingUtility.loadDataToTableLine((int)row.getRowIndex(), (IObjectValue)tempEntry, (KDTable)FastMergeSumEditUI.this.tblTpl, null, (DataComponentMap)FastMergeSumEditUI.this.getDataBinder().getDataComponentMap());
                    rowIdSet.add(tpl.getId().toString());
                    entrys = (FastMergeTemplateCollection)((Object)FastMergeSumEditUI.this.tblTpl.getUserObject());
                    entrys.add(tempEntry);
                }
            }
        });
        this.btnDelTpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeSumEditUI.this.canEdit()) {
                    return;
                }
                int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)FastMergeSumEditUI.this.tblTpl);
                FastMergeTemplateCollection entrys = (FastMergeTemplateCollection)((Object)FastMergeSumEditUI.this.tblTpl.getUserObject());
                HashSet rowIdSet = (HashSet)FastMergeSumEditUI.this.tblTpl.getClientProperty((Object)"ROW_ID_SET");
                if (rowIdSet == null) {
                    rowIdSet = new HashSet();
                    FastMergeSumEditUI.this.tblTpl.putClientProperty((Object)"ROW_ID_SET", rowIdSet);
                }
                FastMergeTemplateInfo entryInfo = null;
                int rowIndex = 0;
                for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
                    rowIndex = selectRowIndexes[i];
                    entryInfo = (FastMergeTemplateInfo)FastMergeSumEditUI.this.tblTpl.getRow(rowIndex).getUserObject();
                    rowIdSet.remove(entryInfo.getTemplate().getId().toString());
                    entrys.removeObject((IObjectValue)entryInfo);
                    FastMergeSumEditUI.this.tblTpl.removeRow(rowIndex);
                }
            }
        });
        final KDTableMoveAction rowMoveAction = new KDTableMoveAction(this.tblTpl);
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeSumEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeSumEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveBegin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeSumEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMoveEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FastMergeSumEditUI.this.canEdit()) {
                    return;
                }
                rowMoveAction.moveSelectedRowToTail();
            }
        });
        this.tblTplUnit.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                try {
                    FastMergeSumEditUI.this.tblTplUnit_editValueChanged(e);
                }
                catch (Exception exc) {
                    FastMergeSumEditUI.this.handUIException(exc);
                }
            }
        });
        this.isSupportGroupReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FastMergeSumEditUI.this.isHasCreatedMergeReport) {
                    String showMsg = FastMergeUtil.getStringRes("cannot.change.ishascreatedmergereport.has.created");
                    MsgBox.showInfo((String)showMsg);
                    FastMergeSumEditUI.this.isSupportGroupReport.setSelected(FastMergeSumEditUI.this.editData.isIsSupportGroupReport());
                } else if (FastMergeSumEditUI.this.isSupportGroupReport.isSelected()) {
                    FastMergeSumEditUI.this.kDpSingleDataSolution.setEnabled(false);
                    FastMergeSumEditUI.this.kDpSingleDataSolution.setValue(null);
                    FastMergeSumEditUI.this.kDIsContainUnReceive.setEnabled(false);
                    FastMergeSumEditUI.this.kDIsContainUnReceive.setSelected(false);
                } else {
                    FastMergeSumEditUI.this.kDpSingleDataSolution.setEnabled(true);
                    FastMergeSumEditUI.this.kDIsContainUnReceive.setEnabled(true);
                }
            }
        });
        this.kDIsContainUnReceive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FastMergeSumEditUI.this.isHasCreatedMergeReport) {
                    String showMsg = FastMergeUtil.getStringRes("cannot.change.ishascreatedmergereport.has.created");
                    MsgBox.showInfo((String)showMsg);
                    FastMergeSumEditUI.this.kDIsContainUnReceive.setSelected(FastMergeSumEditUI.this.editData.isIsContainUnRecive());
                }
            }
        });
    }

    private void tblTplUnit_editValueChanged(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int collIndex = e.getColIndex();
        String fieldName = this.tblTplUnit.getColumnKey(collIndex);
        if ("choose".equalsIgnoreCase(fieldName)) {
            if (((Boolean)this.tblTplUnit.getRow(rowIndex).getCell(fieldName).getValue()).booleanValue()) {
                this.tblTplUnit.getCell(rowIndex, collIndex).setValue((Object)false);
            } else {
                this.tblTplUnit.getCell(rowIndex, collIndex).setValue((Object)true);
            }
        }
    }

    private void resetUnitEntries() {
        this.editData.setSyncOldValue(false);
        int size = this.tblTplUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblTplUnit.getRow(i);
            FastMergeOrgUnitInfo entryInfo = (FastMergeOrgUnitInfo)row.getUserObject();
            if (entryInfo == null || !entryInfo.isIsSelected()) continue;
            entryInfo.setFixedCalcSolu(null);
            row.getCell("fixedTabSoluName").setValue(null);
            entryInfo.setDynaCalcSolu(null);
            row.getCell("dynaTabSoluName").setValue(null);
        }
    }

    protected EntityViewInfo getChooseTemplateEntityView() {
        FilterInfo filter = new FilterInfo();
        StringBuffer debars = new StringBuffer();
        int dynaType = 11;
        if (this.isAutoSum()) {
            debars.append(3);
            dynaType = 11;
        } else {
            debars.append(5).append(",");
            debars.append(4);
            dynaType = 13;
        }
        StringBuffer maskString = new StringBuffer();
        int maskIndex = 0;
        filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)debars.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)dynaType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dynaRptType", (Object)2, CompareType.EQUALS));
        maskString.append(" (#" + maskIndex++ + " or (#" + maskIndex++ + " and #" + maskIndex++ + "))");
        filter.getFilterItems().add(new FilterItemInfo("sumType", (Object)1, CompareType.NOTEQUALS));
        maskString.append(" and #" + maskIndex++ + " ");
        filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(1), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        filter.getFilterItems().add(new FilterItemInfo("isfreezed", (Object)new Integer(0), CompareType.EQUALS));
        maskString.append(" and #" + maskIndex++);
        Set<String> selectIds = this.getSelectTmpIds();
        if (!selectIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.NOTINCLUDE));
            maskString.append(" and #" + maskIndex++);
        }
        filter.setMaskString(maskString.toString());
        OrgTreeInfo orgTree = (OrgTreeInfo)this.bizOrgBound.getData();
        if (orgTree != null && orgTree.getId() != null) {
            String inStr = "select distinct fdispensesrcid from t_csl_templetdispense where forgboundid='" + orgTree.getId().toString() + "'";
            try {
                FilterInfo dispenseFilter = new FilterInfo("id in (" + inStr + ")");
                filter.mergeFilter(dispenseFilter, "and");
            }
            catch (Exception e) {
                logger.error((Object)"filter.mergeFilter error.", (Throwable)e);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("number0");
        selector.add("templateType");
        selector.add("periodType");
        view.setSelector(selector);
        logger.debug((Object)("[Weave]view:" + view));
        return view;
    }

    private Set<String> getSelectTmpIds() {
        HashSet<String> tmpIds = new HashSet<String>();
        Object id = null;
        for (int i = 0; i < this.tblTpl.getRowCount(); ++i) {
            id = this.tblTpl.getRow(i).getCell("TplId").getValue();
            if (id == null) continue;
            tmpIds.add(id.toString());
        }
        return tmpIds;
    }

    private IProcessor getChooseTemplateFilterProceccor() {
        return new CommonQueryProcessor(){

            public void process() throws Exception {
                String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                if (fieldProperty.equalsIgnoreCase("templateType")) {
                    KDComboBox cmbxSourceType = (KDComboBox)this.get("CURRENT_EDITOR");
                    for (int i = cmbxSourceType.getItemCount() - 1; i > 0; --i) {
                        RptTmpTypeEnum rptSrcType = (RptTmpTypeEnum)cmbxSourceType.getItemAt(i);
                        if (rptSrcType.getValue() == 6 || rptSrcType.getValue() == 10) continue;
                        cmbxSourceType.removeItemAt(i);
                    }
                } else if (fieldProperty.equalsIgnoreCase("sumType") || fieldProperty.equalsIgnoreCase("orgType")) {
                    // empty if block
                }
            }
        };
    }

    protected Map getChooseTemplateHiddenColumnSetting() {
        HashMap<String, Boolean> hiddenColumns = new HashMap<String, Boolean>();
        hiddenColumns.put("sumType", Boolean.TRUE);
        hiddenColumns.put("orgType", Boolean.TRUE);
        return hiddenColumns;
    }

    protected boolean canEdit() {
        return !"VIEW".equals(this.getOprtState());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("isAutoSum");
        selectors.add("dispatchPeriodId");
        selectors.add("isCurrentPeriod");
        selectors.add("templates.id");
        selectors.add("templates.template.id");
        selectors.add("templates.template.number");
        selectors.add("templates.template.name");
        selectors.add("templates.template.periodType");
        selectors.add("templates.template.templateType");
        selectors.add("templates.seq");
        selectors.add("orgUnits.id");
        selectors.add("orgUnits.seq");
        selectors.add("orgUnits.fixedCalcSolu");
        selectors.add("orgUnits.dynaCalcSolu");
        selectors.add("orgUnits.orgUnit.id");
        selectors.add("orgUnits.orgUnit.name");
        selectors.add("orgUnits.orgUnit.number");
        selectors.add("current.id");
        selectors.add("current.name");
        selectors.add("current.number");
        return selectors;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        try {
            this.checkEditData();
        }
        catch (Exception e1) {
            if (e1 instanceof FastRptException && FastRptException.NAMETOOLARGE.getCode().equals(((FastRptException)((Object)e1)).getSubCode())) {
                MsgBox.showInfo((Component)((Object)this), (String)e1.getMessage());
            } else {
                MessageHandler messageHandler = new MessageHandler(1);
                messageHandler.show(e1.getMessage());
            }
            SysUtil.abort();
        }
        this.checkSelectTemplate();
    }

    private void checkEditData() throws Exception {
        if (StringUtil.isEmpty((String)this.editData.getNumber())) {
            throw new FastRptException(FastRptException.NUMBER_ISBLANK);
        }
        if (StringUtil.isEmpty((String)this.editData.getName())) {
            throw new FastRptException(FastRptException.NAME_ISBLANK);
        }
        if (this.editData.getName().length() > 255) {
            throw new FastRptException(FastRptException.NAMETOOLARGE);
        }
        if (this.editData.getOrgBound() == null) {
            throw new FastRptException(FastRptException.ORGBOUND_ISBLANK);
        }
        if (this.editData.getOrgUnits() == null || this.editData.getOrgUnits().size() == 0) {
            throw new FastRptException(FastRptException.ORGUNIT_ISBLANK);
        }
        FastMergeTemplateCollection tpls = this.editData.getTemplates();
        if (tpls == null || tpls.isEmpty()) {
            throw new FastRptException(FastRptException.TEMPLATE_ISBLANK);
        }
        RptPeriodTypeEnum samePeriodType = null;
        try {
            if (!tpls.isEmpty()) {
                samePeriodType = tpls.get(0).getTemplate().getPeriodType();
            }
            int size = tpls.size();
            for (int i = 1; i < size; ++i) {
                if (tpls.get(i).getTemplate().getPeriodType() == samePeriodType) continue;
                throw new FastRptException(FastRptException.TMPPERIOD_ISNOTSAME);
            }
        }
        catch (NullPointerException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        String errorMsg = this.checkNumberDup((IObjectValue)this.editData, false, FastMergeSoluFactory.getRemoteInstance());
        if (!StringUtils.isEmpty((String)errorMsg)) {
            throw new FastRptException(FastRptException.NUMBER_ISDUP, new Object[]{errorMsg});
        }
        errorMsg = this.checkNameDup((IObjectValue)this.editData, false, FastMergeSoluFactory.getRemoteInstance());
        if (!StringUtils.isEmpty((String)errorMsg)) {
            throw new FastRptException(FastRptException.NAME_ISDUP, new Object[]{errorMsg});
        }
        if (this.editData.isIsSupportGroupReport() && this.editData.getOrgBound() != null && this.editData.getOrgBound().getLayerType() == OrgViewType.PROFITCENTER) {
            throw new FastRptException(FastRptException.ORGBOUND_UNSUITABLE);
        }
    }

    private void checkSelectTemplate() throws Exception {
        String path = "com.kingdee.eas.fi.gr.fast.FastMergeResource";
        FastMergeTemplateCollection templateCol = this.editData.getTemplates();
        FastMergeTemplateInfo fastTemplateInfo = null;
        TemplateInfo templateInfo = null;
        ArrayList<String> templateIds = new ArrayList<String>();
        ArrayList<String> templateNumbers = new ArrayList<String>();
        HashMap<String, TemplateInfo> templateMap = new HashMap<String, TemplateInfo>();
        for (int i = 0; i < templateCol.size(); ++i) {
            fastTemplateInfo = templateCol.get(i);
            if (fastTemplateInfo == null || (templateInfo = fastTemplateInfo.getTemplate()) == null || !RptTmpTypeEnum.CSLREPORT.equals((Object)templateInfo.getTemplateType()) && !RptTmpTypeEnum.MANUSCRIPT.equals((Object)templateInfo.getTemplateType())) continue;
            templateIds.add(String.valueOf(templateInfo.getId()));
            templateNumbers.add(templateInfo.getNumber());
            templateMap.put(String.valueOf(templateInfo.getId()), templateInfo);
        }
        FastMergeOrgUnitCollection orgUnitCol = this.editData.getOrgUnits();
        FullOrgUnitInfo orgUnitInfo = null;
        String orgUnitId = null;
        ArrayList<Integer> orgUnitLevels = new ArrayList<Integer>();
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        for (int i = 0; i < orgUnitCol.size(); ++i) {
            orgUnitInfo = orgUnitCol.get(i).getOrgUnit();
            orgUnitId = String.valueOf(orgUnitInfo.getId());
            if (!orgUnitIds.contains(orgUnitId)) {
                orgUnitIds.add(orgUnitId);
            }
            if (orgUnitLevels.contains(orgUnitInfo.getLevel())) continue;
            orgUnitLevels.add(orgUnitInfo.getLevel());
        }
        if (!CslRptUtil.isListEmpty(templateIds)) {
            boolean fag = false;
            for (Integer level : orgUnitLevels) {
                if (!orgUnitLevels.contains(level + 1)) continue;
                fag = true;
                break;
            }
            HashMap<String, ArrayList<String>> orgTrees = new HashMap<String, ArrayList<String>>();
            orgTrees.put(String.valueOf(this.editData.getOrgBound().getId()), orgUnitIds);
            List result = FastMergeSoluFactory.getRemoteInstance().getRelateTemplates(templateIds, orgTrees);
            StringBuffer erroMsg = new StringBuffer();
            erroMsg.append(this.getNotExistTmpErrorStr(result, templateMap, path, fag));
            erroMsg.append(this.getNoSelectTmpErrorStr(result, templateNumbers, path));
            if (erroMsg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)path, (String)"noSelectRelateTmp"), (String)erroMsg.toString(), (int)1);
                SysUtil.abort();
            }
        }
    }

    private String getNotExistTmpErrorStr(List<SrcTmpRelateTagTmpInfo> result, Map<String, TemplateInfo> templateMap, String path, boolean fag) {
        StringBuffer erroMsg = new StringBuffer();
        boolean isExists = false;
        Iterator<String> ids = templateMap.keySet().iterator();
        String id = null;
        TemplateInfo templateInfo = null;
        while (ids.hasNext()) {
            isExists = false;
            id = ids.next();
            if (result != null) {
                for (SrcTmpRelateTagTmpInfo info : result) {
                    if (!id.equals(info.getSrcTmpId())) continue;
                    isExists = true;
                    break;
                }
            }
            if (isExists) continue;
            templateInfo = templateMap.get(id);
            String resourceName = "noExistsMnsTmp";
            if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.MANUSCRIPT)) {
                if (!fag) continue;
                resourceName = "noExistsCslTmp";
            }
            erroMsg.append(MessageFormat.format(EASResource.getString((String)path, (String)resourceName), "[" + templateInfo.getName() + "(" + templateInfo.getNumber() + ")]"));
            erroMsg.append("\n");
        }
        return erroMsg.toString();
    }

    private String getNoSelectTmpErrorStr(List<SrcTmpRelateTagTmpInfo> result, List<String> templateNumbers, String path) {
        StringBuffer erroMsg = new StringBuffer();
        if (!CslRptUtil.isListEmpty(result)) {
            SrcTmpRelateTagTmpInfo info = null;
            List<TemplateInfo> tagTmpList = null;
            StringBuffer srcStr = new StringBuffer();
            StringBuffer tagStr = new StringBuffer();
            String resourceStr = "noSelectMnsTmp";
            for (int i = 0; i < result.size(); ++i) {
                info = result.get(i);
                tagTmpList = info.getTagTmpList();
                if (this.isExist(templateNumbers, tagTmpList)) continue;
                srcStr.setLength(0);
                tagStr.setLength(0);
                srcStr.append("[").append(info.getSrcTmpName()).append("(").append(info.getSrcTmpNumber()).append(")]");
                for (TemplateInfo tmpInfo : tagTmpList) {
                    tagStr.append(" [").append(tmpInfo.getName()).append("(").append(tmpInfo.getNumber()).append(")] ");
                }
                if (info.getSrcTmpType().equals(String.valueOf(4))) {
                    resourceStr = "noSelectCslTmp";
                }
                erroMsg.append(MessageFormat.format(EASResource.getString((String)path, (String)resourceStr), srcStr.toString(), tagStr.toString()));
                erroMsg.append("\n");
            }
        }
        return erroMsg.toString();
    }

    private boolean isExist(List<String> source, List<TemplateInfo> tag) {
        for (int i = 0; i < tag.size(); ++i) {
            if (!source.contains(tag.get(i).getNumber())) continue;
            return true;
        }
        return false;
    }

    public boolean isModify() {
        boolean isModify = false;
        if (this.editData == null || this.getOprtState() == OprtState.VIEW || "FINDVIEW".equals(this.getOprtState())) {
            return isModify;
        }
        if (this.getOprtState() == OprtState.ADDNEW || this.getOprtState() == OprtState.COPYADDNEW) {
            return super.isModify();
        }
        this.storeFields();
        if (this.getOprtState() == OprtState.EDIT) {
            this.initOldEditData();
            isModify = this.compareEditData(this.old_editData, this.editData);
            if (isModify) {
                return isModify;
            }
            isModify = this.compareOrgUnitEntries(this.old_editData.getOrgUnits(), this.editData.getOrgUnits());
            if (isModify) {
                return isModify;
            }
            isModify = this.compareTemplateEntries(this.old_editData.getTemplates(), this.editData.getTemplates());
            if (isModify) {
                return isModify;
            }
        }
        return isModify;
    }

    private void initOldEditData() {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.old_editData = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)pk, this.getSelectors());
        }
        catch (Exception err) {
            super.handleException(err);
        }
    }

    private boolean compareEditData(FastMergeSoluInfo old_editData, FastMergeSoluInfo new_editData) {
        if (old_editData == null && new_editData == null) {
            return false;
        }
        if (old_editData != null && new_editData != null) {
            if (!StringUtils.equals((String)old_editData.getName(), (String)new_editData.getName())) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getNumber(), (String)new_editData.getNumber())) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getCurrency().getId().toString(), (String)new_editData.getCurrency().getId().toString())) {
                return true;
            }
            if (!old_editData.isIsAutoDispatch() == new_editData.isIsAutoDispatch()) {
                return true;
            }
            if (!old_editData.isIsCurrentPeriod() == new_editData.isIsCurrentPeriod()) {
                return true;
            }
            if (!StringUtils.equals((String)old_editData.getDescription(), (String)new_editData.getDescription())) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getOrgBound(), (AbstractObjectValue)new_editData.getOrgBound())) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getAutoItemFormual(), (AbstractObjectValue)new_editData.getAutoItemFormual())) {
                return true;
            }
            if (!old_editData.isIsAutoSum() == new_editData.isIsAutoSum()) {
                return true;
            }
            if (!old_editData.isIsSupportGroupReport() == new_editData.isIsSupportGroupReport()) {
                return true;
            }
            if (!old_editData.isIsContainUnRecive() == new_editData.isIsContainUnRecive()) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getAdjustEntrySolu(), (AbstractObjectValue)new_editData.getAdjustEntrySolu())) {
                return true;
            }
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)old_editData.getOrgBound(), (AbstractObjectValue)new_editData.getOrgBound())) {
                return true;
            }
        }
        return false;
    }

    private boolean compareOrgUnitEntries(FastMergeOrgUnitCollection old_col, FastMergeOrgUnitCollection new_col) {
        if (old_col == null && new_col == null) {
            return false;
        }
        if (old_col != null && new_col != null) {
            if (old_col.size() != new_col.size()) {
                return true;
            }
            int size = old_col.size();
            for (int i = 0; i < size; ++i) {
                FastMergeOrgUnitInfo oldInfo = old_col.get(i);
                FastMergeOrgUnitInfo newInfo = new_col.get(oldInfo.getId());
                if (!oldInfo.getOrgUnit().getId().equals((Object)newInfo.getOrgUnit().getId())) {
                    return true;
                }
                if (!StringUtil.equals((String)oldInfo.getFixedCalcSolu(), (String)newInfo.getFixedCalcSolu())) {
                    return true;
                }
                if (StringUtil.equals((String)oldInfo.getDynaCalcSolu(), (String)newInfo.getDynaCalcSolu())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareTemplateEntries(FastMergeTemplateCollection old_col, FastMergeTemplateCollection new_col) {
        if (old_col == null && new_col == null) {
            return false;
        }
        if (old_col != null && new_col != null) {
            if (old_col.size() != new_col.size()) {
                return true;
            }
            int size = old_col.size();
            for (int i = 0; i < size; ++i) {
                FastMergeTemplateInfo oldInfo = old_col.get(i);
                FastMergeTemplateInfo newInfo = new_col.get(i);
                if (oldInfo.getTemplate().getId().equals((Object)newInfo.getTemplate().getId())) continue;
                return true;
            }
        }
        return false;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        String fromPk = null;
        if (this.editData != null && this.editData.getId() != null) {
            fromPk = this.editData.getId().toString();
        }
        this.getUIContext().put("isCopy", "isCopy");
        super.actionCopy_actionPerformed(e);
        this.editData.setOrganUnit(SysContext.getSysContext().getCurrentFIUnit().castToFullOrgUnitInfo());
        this.editData.setIsSupportGroupReport(false);
        this.getUIContext().remove("isCopy");
        this.initOrgUnitTblByFromPk(fromPk);
        this.isHasCreatedMergeReport();
    }

    public boolean destroyWindow() {
        if (this.getUIContext().get("ObjectUpdateLockId") != null) {
            MutexUtil.releaseMutex(Uuid.fromString((String)((String)this.getUIContext().get("ObjectUpdateLockId"))));
        }
        return super.destroyWindow();
    }

    private void isHasCreatedMergeReport() throws Exception {
        IFastMergeSolu iFastMergeSolu = (IFastMergeSolu)this.getBizInterface();
        if (this.editData == null || this.editData.getId() == null) {
            this.isHasCreatedMergeReport = false;
            return;
        }
        this.isHasCreatedMergeReport = iFastMergeSolu.isHasCreatedMergeReport((IObjectPK)new ObjectUuidPK(this.editData.getId()));
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }

    private String getExistFastMergeSoluInfo(String keyCon, String valueTxt) throws Exception {
        String rtnTxt = null;
        FastMergeSoluInfo existFastMergeSoluInfo = null;
        IFastMergeSolu iFastMergeSolu = (IFastMergeSolu)this.getBizInterface();
        FastMergeSoluCollection coll = iFastMergeSolu.getFastMergeSoluCollection("where " + keyCon + "='" + valueTxt + "'");
        if (coll != null && coll.size() > 0) {
            existFastMergeSoluInfo = coll.get(0);
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            rtnTxt = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(existFastMergeSoluInfo.getOrganUnit().getId())).getName();
        }
        return rtnTxt;
    }

    private String checkNumberDup(IObjectValue model, boolean isOrgFilter, IFastMergeSolu corebase) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem0 = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        int formulaIndex = 0;
        filter.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        if (dataBaseInfo.getId() != null) {
            FilterItemInfo filterItem1 = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (isOrgFilter) {
            FilterItemInfo filterItem2 = new FilterItemInfo("organUnit.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        FilterItemInfo filterItem3 = new FilterItemInfo("isautosum", dataBaseInfo.get("isautosum"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem3);
        sbFormula.append(" #" + formulaIndex++);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("organUnit.name");
        viewInfo.setSelector(coll);
        viewInfo.setFilter(filter);
        FastMergeSoluCollection fastColl = corebase.getFastMergeSoluCollection(viewInfo);
        if (fastColl != null && fastColl.size() > 0) {
            return fastColl.get(0).getOrganUnit().getName();
        }
        return null;
    }

    private String checkNameDup(IObjectValue model, boolean isOrgFilter, IFastMergeSolu corebase) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem0 = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        int formulaIndex = 0;
        filter.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        if (dataBaseInfo.getId() != null) {
            FilterItemInfo filterItem1 = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (isOrgFilter) {
            FilterItemInfo filterItem2 = new FilterItemInfo("organUnit.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        FilterItemInfo filterItem3 = new FilterItemInfo("isautosum", dataBaseInfo.get("isautosum"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem3);
        sbFormula.append(" #" + formulaIndex++);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("organUnit.name");
        viewInfo.setSelector(coll);
        viewInfo.setFilter(filter);
        FastMergeSoluCollection fastColl = corebase.getFastMergeSoluCollection(viewInfo);
        if (fastColl != null && fastColl.size() > 0) {
            return fastColl.get(0).getOrganUnit().getName();
        }
        return null;
    }

    public class AddTplAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

