/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.fast.client.AbstractMgMergeElimInvestRateFilterUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MgMergeElimInvestRateFilterUI
extends AbstractMgMergeElimInvestRateFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MgMergeElimInvestRateFilterUI.class);
    private Date curDate = new Date();
    private boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
    private String selectOrgTreeNumber = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPeriodType();
        this.initYearPeriod(false);
        this.refreshOrgTree();
        this.initListense();
    }

    private void initListense() {
        this.periodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (MgMergeElimInvestRateFilterUI.this.periodType.getSelectedItem() != null) {
                        MgMergeElimInvestRateFilterUI.this.initYearPeriod(false);
                        MgMergeElimInvestRateFilterUI.this.refreshOrgTree();
                    }
                }
                catch (Exception e1) {
                    MgMergeElimInvestRateFilterUI.this.handUIException(e1);
                }
            }
        });
        this.year.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    MgMergeElimInvestRateFilterUI.this.refreshOrgTree();
                }
                catch (Exception e1) {
                    MgMergeElimInvestRateFilterUI.this.handUIException(e1);
                }
            }
        });
        this.period.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    MgMergeElimInvestRateFilterUI.this.refreshOrgTree();
                }
                catch (Exception e1) {
                    MgMergeElimInvestRateFilterUI.this.handUIException(e1);
                }
            }
        });
    }

    private void initPeriodType() {
        Iterator itor = RptPeriodTypeEnum.iterator();
        RptPeriodTypeEnum curItem = null;
        this.periodType.removeAllItems();
        while (itor.hasNext()) {
            curItem = (RptPeriodTypeEnum)itor.next();
            this.periodType.addItem((Object)curItem);
        }
        if (this.periodType.getItemCount() != 0) {
            this.periodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        }
    }

    private void initYearPeriod(boolean isActiveListense) {
        CslRptUIUtil.setSpineRange(this.year, 1900, 2999, true, true);
        if (this.periodType.getSelectedItem() != null && ((RptPeriodTypeEnum)this.periodType.getSelectedItem()).getValue() == 3) {
            CslRptUIUtil.setSpineRange(this.period, 1, 13, true, true);
        } else {
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.period, (RptPeriodTypeEnum)this.periodType.getSelectedItem(), true, true);
        }
        int[] yearPeriod = RPTDateUtil.getPeriod(this.curDate, (RptPeriodTypeEnum)this.periodType.getSelectedItem());
        this.year.setValue((Object)yearPeriod[0], isActiveListense);
        this.period.setValue((Object)yearPeriod[1], isActiveListense);
    }

    private void refreshOrgTree() throws Exception {
        if (this.orgTree.getSelectedItem() != null) {
            this.selectOrgTreeNumber = ((OrgTreeInfo)this.orgTree.getSelectedItem()).getNumber();
        }
        this.orgTree.removeAllItems();
        Date rptDate = RPTDateUtil.getPeriodLastDate(this.year.getIntegerVlaue(), this.period.getIntegerVlaue(), (RptPeriodTypeEnum)this.periodType.getSelectedItem());
        OrgTreeCollection orgTreeColl = CslRptUIUtil.getOrgTreeCollection(rptDate);
        if (orgTreeColl == null) {
            return;
        }
        orgTreeColl = CslRptUtil.getOrgTreeCollectionFilterProfitOrg(null, orgTreeColl);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("GR_CSL_ELIMMETHOD_001");
        ArrayList<String> orgIdStrList = new ArrayList<String>();
        for (int i = 0; i < orgTreeColl.size(); ++i) {
            orgIdStrList.add(orgTreeColl.get(i).getId().toString());
        }
        ArrayList result = ParamManager.getParamListBatch(null, paramList, orgIdStrList);
        ParamSimpleInfo info = null;
        OrgTreeInfo selectInfo = null;
        for (int k = 0; k < result.size(); ++k) {
            info = (ParamSimpleInfo)result.get(k);
            if (!info.getParamValue().trim().equals("4") || !info.getOrgUnitPK().toString().equals(orgTreeColl.get(k).getId().toString())) continue;
            this.orgTree.addItem((Object)orgTreeColl.get(k));
            if (StringUtils.isEmpty((String)this.selectOrgTreeNumber) || !this.selectOrgTreeNumber.equals(orgTreeColl.get(k).getNumber())) continue;
            selectInfo = orgTreeColl.get(k);
        }
        if (selectInfo != null) {
            this.orgTree.setSelectedItem(selectInfo);
        }
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        if (this.orgTree.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"50_ItemAnalysisFilterUI"));
            SysUtil.abort();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo periodTypeFilter = new FilterItemInfo("periodType", (Object)((RptPeriodTypeEnum)this.periodType.getSelectedItem()).getValue(), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(periodTypeFilter);
        sbFormula.append(" #" + formulaIndex++);
        FilterItemInfo yearFilter = new FilterItemInfo("year", (Object)this.year.getIntegerVlaue(), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(yearFilter);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo periodFilter = new FilterItemInfo("period", (Object)this.period.getIntegerVlaue(), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(periodFilter);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo orgTreeFilter = new FilterItemInfo("orgBound.id", (Object)((OrgTreeInfo)this.orgTree.getSelectedItem()).getId().toString(), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(orgTreeFilter);
        sbFormula.append(" and #" + formulaIndex++);
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        if (entityViewInfo != null) {
            FilterItemCollection item = entityViewInfo.getFilter().getFilterItems();
            FilterItemInfo info = null;
            OrgTreeInfo orgTreeInfo = null;
            block0: for (int i = 0; i < item.size(); ++i) {
                info = item.get(i);
                if (info == null) continue;
                if (info.getPropertyName().equalsIgnoreCase("periodType")) {
                    this.periodType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)((Integer)info.getCompareValue())), false);
                    continue;
                }
                if (info.getPropertyName().equalsIgnoreCase("year")) {
                    this.year.setValue(info.getCompareValue(), false);
                    continue;
                }
                if (info.getPropertyName().equalsIgnoreCase("period")) {
                    this.period.setValue(info.getCompareValue(), false);
                    continue;
                }
                if (!info.getPropertyName().equalsIgnoreCase("orgBound.id")) continue;
                for (int k = 0; k < this.orgTree.getItemCount(); ++k) {
                    orgTreeInfo = (OrgTreeInfo)this.orgTree.getItemAt(k);
                    if (orgTreeInfo == null || !orgTreeInfo.getId().toString().equals(info.getCompareValue())) continue;
                    this.orgTree.setSelectedIndex(k);
                    continue block0;
                }
            }
        }
    }

    public void clear() {
        super.clear();
        this.initPeriodType();
        this.initYearPeriod(false);
        if (this.orgTree.getItemCount() > 0) {
            this.orgTree.setSelectedIndex(0);
        }
    }
}

