/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.fast.client.AbstractSimulationMergeListUI;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import org.apache.log4j.Logger;

public class SimulationMergeListUI
extends AbstractSimulationMergeListUI {
    private static final long serialVersionUID = 7779295908494659745L;
    private static final Logger logger = CoreUIObject.getLogger(SimulationMergeListUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButtonByCreator();
    }

    private void initWorkButtonByCreator() throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        String[] permItems = new String[]{"csl_simulationmerge_edit", "csl_simulationmerge_execute"};
        boolean[] isHasPerms = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), permItems);
        boolean isHasEditPerm = isHasPerms[0];
        boolean isHasExecutePerm = isHasPerms[1];
        this.btnEdit.setEnabled(isHasEditPerm);
        this.btnRemove.setEnabled(isHasEditPerm);
        this.btnImmediateRun.setEnabled(isHasExecutePerm);
        this.btnSetTimeDispatch.setEnabled(isHasExecutePerm);
        this.btnUnSetTimeDispatch.setEnabled(isHasExecutePerm);
        this.menuItemEdit.setEnabled(isHasEditPerm);
        this.menuItemRemove.setEnabled(isHasEditPerm);
        this.menuImmediateRun.setEnabled(isHasExecutePerm);
        this.menuSetTimeDispatch.setEnabled(isHasExecutePerm);
        this.menuUnSetTimeDispatch.setEnabled(isHasExecutePerm);
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.fi.gr.fast.client.SimulationMergeEditUI";
    }

    @Override
    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        filter.appendFilterItem("isAutoSum", (Object)0);
        return filter;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            return new ObjectUuidPK(MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(SysContext.getSysContext().getCurrentOrgUnit(), null).getId());
        }
        catch (Exception e) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        }
    }
}

