/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.client.timedispatch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.fast.client.timedispatch.IDispatchPeriodSource;
import com.kingdee.eas.fi.gr.weaverpt.FormatJobProcessSettingAction;
import com.kingdee.eas.fi.rpt.RptCalcSchemeFactory;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DispatchPeriodHandle {
    private static final Logger log = Logger.getLogger(DispatchPeriodHandle.class);
    KDTextArea taDispatchPeriod;
    private String jobProcessDef;
    IDispatchPeriodSource disSource;
    private IUIObject ui;

    public IDispatchPeriodSource getDisSource() {
        return this.disSource;
    }

    public DispatchPeriodHandle(KDTextArea taDispatchPeriod, IUIObject ui, IDispatchPeriodSource disSource) {
        this.taDispatchPeriod = taDispatchPeriod;
        this.ui = ui;
        this.disSource = disSource;
    }

    public void setJobProcessDef(String jobProcessDefId) throws EASBizException, BOSException {
        if (jobProcessDefId != null) {
            this.jobProcessDef = jobProcessDefId;
            Map map = RptCalcSchemeFactory.getRemoteInstance().getProcessDef(jobProcessDefId);
            ScheduleDef schdef = null;
            if (map != null && !map.isEmpty()) {
                schdef = new ScheduleDef(null);
                String define = (String)map.get("rpt_cacl_scheme_define");
                String[] defines = define.split(":");
                schdef.setType(ScheduleType.getEnum((String)defines[0]));
                schdef.setDefine(defines[1]);
                schdef.setBeginTime((Date)map.get("rpt_cacl_scheme_begintime"));
                schdef.setUseCalendar(RptUtil.isTrue(map.get("rpt_cacl_scheme_is_use_calendar ")));
                schdef.setOrgUnitId((String)map.get("rpt_cacl_scheme_org"));
                schdef.setInstructionType(1);
                this.taDispatchPeriod.setText(new FormatJobProcessSettingAction().action(schdef));
                this.taDispatchPeriod.setUserObject((Object)schdef);
                this.taDispatchPeriod.setDirty(false);
            }
        } else {
            this.taDispatchPeriod.setText(null);
            this.taDispatchPeriod.setUserObject(null);
            this.taDispatchPeriod.setDirty(false);
        }
    }

    public String saveJobProcessDef() {
        try {
            ScheduleDef schedule = this.disSource.getUserObject();
            if (schedule == null) {
                return null;
            }
            String jobProcessDef = this.disSource.getJobProcess();
            if (jobProcessDef != null) {
                this.disSource.getWorkflowClient().updateProcessSchedule(jobProcessDef, KpdlParser.scheduleToString((ScheduleDef)schedule));
                return jobProcessDef;
            }
            HashMap<String, String> jobContext = new HashMap<String, String>();
            jobContext.put("fastMergeSoluId", ((CoreBaseInfo)this.disSource.getJobParam()).getId().toString());
            jobContext.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            FunctionObjectInfo function = this.buildFunctionObjectInfo(this.disSource);
            OperationInfo operation = this.buildOperationInfo(this.disSource, function);
            jobProcessDef = this.disSource.getWorkflowClient().createJobProcessDef(this.disSource.getJobTitle(), function, operation, jobContext, KpdlParser.scheduleToString((ScheduleDef)schedule), SysContext.getSysContext().getLocale());
            this.disSource.setJobProcess(jobProcessDef);
            return jobProcessDef;
        }
        catch (WfException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return null;
    }

    protected OperationInfo buildOperationInfo(IDispatchPeriodSource source, FunctionObjectInfo function) {
        OperationInfo operation = function.getOperation().get(source.operationIndex());
        return operation;
    }

    protected FunctionObjectInfo buildFunctionObjectInfo(IDispatchPeriodSource source) {
        MetaDataPK functionPK = MetaDataPK.create((String)source.function());
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }
}

