/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.ExecuteSQL;
import com.kingdee.eas.fi.gr.cslrpt.client.LazyShowName;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class QueryName {
    private Map<String, Collection<LazyShowName>> lazyDB;
    private DBHandler dao;
    private String mainField = "fid";

    public QueryName(DBHandler dao) {
        this.dao = dao;
        this.lazyDB = new HashMap<String, Collection<LazyShowName>>(3);
    }

    public QueryName(DBHandler dao, String mainField) {
        this(dao);
        this.mainField = mainField;
    }

    public void put(String key, LazyShowName lazyName) {
        Collection<Object> names = null;
        if (this.lazyDB.containsKey(key)) {
            names = this.lazyDB.get(key);
        } else {
            names = new ArrayList(8);
            this.lazyDB.put(key, names);
        }
        names.add(lazyName);
    }

    public void replaceName() throws BOSException {
        if (this.lazyDB.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Collection<LazyShowName>> entry : this.lazyDB.entrySet()) {
            if ("template".equalsIgnoreCase(entry.getKey())) {
                this.queryTemplate(entry.getValue());
                continue;
            }
            if ("orgUnit".equalsIgnoreCase(entry.getKey())) {
                this.queryOrgUnit(entry.getValue());
                continue;
            }
            if ("company".equalsIgnoreCase(entry.getKey())) {
                this.queryCompany(entry.getValue());
                continue;
            }
            if (!"item".equalsIgnoreCase(entry.getKey())) continue;
            this.queryItem(entry.getValue());
        }
    }

    public void clear() {
        this.lazyDB.clear();
    }

    protected void queryTemplate(Collection<LazyShowName> ids) throws BOSException {
        this.query(ids, "T_RPT_Template", false);
    }

    protected void queryOrgUnit(Collection<LazyShowName> ids) throws BOSException {
        this.query(ids, "T_ORG_BaseUnit", true);
    }

    protected void queryCompany(Collection<LazyShowName> ids) throws BOSException {
        this.query(ids, "T_Org_Company", true);
    }

    protected void queryItem(Collection<LazyShowName> numbers) throws BOSException {
        this.query(numbers, "T_CSL_RPTITEM", true);
    }

    protected void query(Collection<LazyShowName> ids, String tableName, boolean nameIsMultiLang) throws BOSException {
        ExecuteSQL executeSQL = this.dao.getExecuteSQL();
        StringBuffer querySQL = new StringBuffer();
        String nameField = "FName";
        Locale locale = null;
        if (nameIsMultiLang) {
            locale = SysContext.getSysContext().getLocale();
            nameField = "FNAME_" + locale.toString();
        }
        querySQL.append(" SELECT " + nameField + " name," + this.mainField + " \n");
        querySQL.append(" FROM \t" + tableName + " \n");
        querySQL.append(" WHERE  \n");
        int idNum = 0;
        StringBuffer inExpr = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>(10);
        ArrayList<LazyShowName> lazyParams = new ArrayList<LazyShowName>(10);
        for (LazyShowName id : ids) {
            inExpr.append(",?");
            params.add(id.getName());
            lazyParams.add(id);
            if (++idNum <= 2000) continue;
            inExpr.deleteCharAt(0);
            this.query(executeSQL, querySQL, inExpr, params, lazyParams);
            idNum = 0;
            inExpr.setLength(0);
            params.clear();
        }
        if (!params.isEmpty()) {
            inExpr.deleteCharAt(0);
            this.query(executeSQL, querySQL, inExpr, params, lazyParams);
        }
    }

    protected void query(ExecuteSQL executeSQL, StringBuffer querySQL, StringBuffer inExpr, List<Object> params, List<LazyShowName> lazyParams) throws BOSException {
        IRowSet rs = executeSQL.executeQuery(querySQL + " " + this.mainField + " IN (" + inExpr + ") ORDER BY  " + this.mainField + "  ", params.toArray());
        try {
            String idValue = null;
            String nameValue = null;
            while (rs.next()) {
                idValue = rs.getString(this.mainField);
                nameValue = rs.getString("name");
                Iterator<LazyShowName> it = lazyParams.iterator();
                while (it.hasNext()) {
                    LazyShowName lazyShowName = it.next();
                    if (!idValue.equals(lazyShowName.getName())) continue;
                    lazyShowName.setName(nameValue);
                    it.remove();
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
    }
}

