/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysisFacade;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFacadeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeEntryCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeEntryFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeEntryInfo;
import com.kingdee.eas.fi.gr.mobile.IndexDataElementEnum;
import com.kingdee.eas.fi.gr.mobile.IndexQueryCondition;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexAnalysisBIUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndexAnalysisBIUI
extends AbstractIndexAnalysisBIUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(IndexAnalysisBIUI.class);
    private IIndexAnalysisFacade itf = null;
    private boolean isShowAllOrg = false;

    private IIndexAnalysisFacade getBizInterface() throws BOSException {
        if (this.itf == null) {
            this.itf = IndexAnalysisFacadeFactory.getRemoteInstance();
        }
        return this.itf;
    }

    public void onLoad() throws Exception {
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.kDTable2.getSelectManager().setSelectMode(10);
        this.init();
        this.refreshMainData(false, true);
        this.initTblListener();
    }

    private void initTblListener() {
        this.kDTable1.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int row = e.getSelectBlock().getBeginRow();
                try {
                    IndexAnalysisBIUI.this.refreshDetailData(row);
                }
                catch (Exception ee) {
                    IndexAnalysisBIUI.this.handleException(ee);
                }
            }
        });
    }

    private void init() throws Exception {
        String itId = null;
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        Map itMap = this.getBizInterface().getIdxTypeCollection();
        if (itMap.get("key_list") != null) {
            List l = (List)itMap.get("key_list");
            for (int i = 0; i < l.size(); ++i) {
                Map m = (Map)l.get(i);
                this.comboIndexType.addItem((Object)new ItemIndexType((String)m.get("id"), (String)m.get("name")));
            }
            if (l.size() > 0) {
                this.comboIndexType.setSelectedIndex(0);
                itId = (String)((Map)l.get(0)).get("id");
            }
        }
        this.comboIndexType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        IndexAnalysisBIUI.this.initIndexControl();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        if (!StringUtils.isEmpty(itId)) {
            this.initOrgUnit(itId, this.isShowAllOrg, null);
        }
        int year = Calendar.getInstance().get(1);
        int month = Calendar.getInstance().get(2) + 1;
        this.comboDataElementType.addItems(IndexDataElementEnum.getEnumList().toArray());
        this.spinYear.setValue((Object)year);
        this.spinPeriod.setValue((Object)month);
        if (!StringUtils.isEmpty((String)itId)) {
            this.initIndexControl();
        }
    }

    private void initOrgUnit(String indexTypeId, boolean isShowAllOrg, String schemeId) throws EASBizException, BOSException {
        this.comboOrgUnit.removeAllItems();
        if (!isShowAllOrg) {
            Map map = this.getBizInterface().getOrgUnitList(indexTypeId);
            if (map.get("key_list") != null) {
                List l = (List)map.get("key_list");
                for (int i = 0; i < l.size(); ++i) {
                    Map m = (Map)l.get(i);
                    this.comboOrgUnit.addItem((Object)new ItemOrgUnit((String)m.get("name"), (String)m.get("value"), (String)m.get("orgId")));
                }
                if (l.size() > 0) {
                    this.comboOrgUnit.setSelectedIndex(0);
                }
            }
        } else {
            HashMap<String, String> param = new HashMap<String, String>();
            if (StringUtils.isEmpty((String)schemeId)) {
                schemeId = "lVIAAAB2SWiszsAX";
            }
            param.put("schemeId", schemeId);
            IndexTypeInfo indexTypeInfo = this.getIndexTypeInfoById(indexTypeId);
            param.put("treeId", indexTypeInfo.getOrgBound().getId().toString());
            Map map = this.getBizInterface().getBossQuery(param);
            List l = (List)map.get("orgUnit");
            for (int i = 0; i < l.size(); ++i) {
                Map m = (Map)l.get(i);
                this.comboOrgUnit.addItem((Object)new ItemOrgUnit((String)m.get("name"), (String)m.get("value"), (String)m.get("orgId")));
            }
            if (l.size() > 0) {
                this.comboOrgUnit.setSelectedIndex(0);
            }
        }
    }

    private void initIndexControl() throws BOSException, EASBizException {
        ItemIndexType itInfo = (ItemIndexType)this.comboIndexType.getSelectedItem();
        String indexTypeId = itInfo.id;
        this.comboIndex.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("indexType.id", (Object)indexTypeId));
        view.setFilter(filter);
        IndexAnalysisCollection indexAnaCol = IndexAnalysisFactory.getRemoteInstance().getIndexAnalysisCollection(view);
        int defaultIndex = 0;
        for (int i = 0; i < indexAnaCol.size(); ++i) {
            if (indexAnaCol.get(i) instanceof IndexAnalysisInfo) {
                indexAnaCol.get(i).toString();
            }
            this.comboIndex.addItem((Object)new ItemIndex(indexAnaCol.get(i).getId().toString(), indexAnaCol.get(i).getName()));
            if (!indexAnaCol.get(i).isIsDefaultIndex()) continue;
            defaultIndex = i;
        }
        this.comboIndex.setSelectedIndex(defaultIndex);
        this.comboOrgUnit.removeAllItems();
        Map map = this.getBizInterface().getOrgUnitList(indexTypeId);
        if (map.get("key_list") != null) {
            List l = (List)map.get("key_list");
            for (int i = 0; i < l.size(); ++i) {
                Map m = (Map)l.get(i);
                this.comboOrgUnit.addItem((Object)new ItemOrgUnit((String)m.get("name"), (String)m.get("value"), (String)m.get("orgId")));
            }
            if (l.size() > 0) {
                this.comboOrgUnit.setSelectedIndex(0);
            }
        }
    }

    private IndexTypeInfo getIndexTypeInfoById(String itId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)itId)) {
            return null;
        }
        return IndexTypeFactory.getRemoteInstance().getIndexTypeInfo((IObjectPK)new ObjectUuidPK(itId));
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.refreshMainData(this.cbIsSearchAll.isSelected(), false);
    }

    private void refreshMainData(boolean isSearchAll, boolean isFirstQuery) throws BOSException, EASBizException {
        if (this.comboIndexType.getItemCount() == 0 || this.comboIndexType.getSelectedItem() == null) {
            return;
        }
        IndexQueryCondition cond = new IndexQueryCondition();
        ItemIndexType itInfo = (ItemIndexType)this.comboIndexType.getSelectedItem();
        cond.setIdxTypeID(itInfo.id);
        cond.setFirstMainQuery(isFirstQuery);
        if (!isFirstQuery) {
            ItemOrgUnit ioUnit;
            cond.setYear(Integer.valueOf(this.spinYear.getValue().toString()));
            int period = Integer.valueOf(this.spinPeriod.getValue().toString());
            IndexTypeInfo indexTypeInfo = this.getIndexTypeInfoById(itInfo.id);
            cond.setDimension(indexTypeInfo.getDimension().getValue());
            cond.setPeriod(period);
            cond.setOrgTreeID(indexTypeInfo.getOrgBound().getId().toString());
            IndexDataElementEnum ideEnum = (IndexDataElementEnum)((Object)this.comboDataElementType.getSelectedItem());
            cond.setDataElement(ideEnum.getValue());
            boolean isFirstMainQuery = isFirstQuery;
            if (!isSearchAll && (ioUnit = (ItemOrgUnit)this.comboOrgUnit.getSelectedItem()) != null) {
                cond.setLongNumber(ioUnit.longnumber);
            }
            IIndexAnalysisFacade intr1 = this.getBizInterface();
            ItemIndex ii = (ItemIndex)this.comboIndex.getSelectedItem();
            cond.setIdxID(ii.id);
            cond.setPeriodType(3);
            cond.setUserId("");
            cond.setSortColumnNo("");
            cond.setSortType(1);
            cond.setSearchTxt(this.txtSearchTxt.getText());
            cond.setOrgID("");
            if (this.cbMainQueryType.isSelected()) {
                cond.setMainQueryType(2);
            }
        }
        IIndexAnalysisFacade intr = this.getBizInterface();
        if (isSearchAll) {
            this.fillSearchMap(intr.getSearchTip(cond));
        } else {
            this.kDTable1.removeRows();
            this.kDTable1.removeColumns();
            this.fillMainTable(intr.getIdxAnaMainData(cond));
        }
    }

    private void fillSearchMap(Map map) {
        this.kDTable2.removeRows();
        this.kDTable2.removeColumns();
        if (map.size() > 0) {
            List list = (List)map.get("key_list");
            this.kDTable2.addColumns(1);
            for (int i = 0; i < list.size(); ++i) {
                IRow row = this.kDTable2.addRow();
                String value = "";
                if (list.get(i) != null) {
                    value = list.get(i).toString();
                }
                row.getCell(0).setValue((Object)value);
            }
        }
    }

    private void fillMainTable(Map map) {
        List result;
        int i;
        if (map == null) {
            return;
        }
        List columnnos = (List)map.get("key_columnnos");
        List columnnames = (List)map.get("key_columnnames");
        if (columnnames != null) {
            this.kDTable1.addColumns(columnnames.size() + 1);
            IRow headRow = this.kDTable1.addHeadRow();
            headRow.getCell(0).setValue((Object)this.getHardCodingSettingResourceByName("10_rptCell"));
            for (i = 0; i < columnnames.size(); ++i) {
                headRow.getCell(i + 1).setValue(columnnames.get(i));
            }
        }
        if ((result = (List)map.get("key_list")) == null) {
            System.out.println(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"969_IndexAnalysisBIUI"));
            return;
        }
        for (i = 0; i < result.size(); ++i) {
            IRow row = this.kDTable1.addRow();
            Map rec = (Map)result.get(i);
            row.getCell(0).setValue(rec.get("orgName"));
            for (int j = 0; j < columnnos.size(); ++j) {
                row.getCell(j + 1).setValue((Object)((String)rec.get(columnnos.get(j))).toString());
            }
            row.setUserObject((Object)rec);
        }
    }

    private void refreshDetailData(int rowIndex) throws EASBizException, BOSException {
        IndexQueryCondition cond = new IndexQueryCondition();
        ItemIndexType itInfo = (ItemIndexType)this.comboIndexType.getSelectedItem();
        cond.setIdxTypeID(itInfo.id);
        cond.setYear(Integer.valueOf(this.spinYear.getValue().toString()));
        cond.setPeriod(Integer.valueOf(this.spinPeriod.getValue().toString()));
        cond.setUserId("");
        Object select = this.kDTable1.getRow(rowIndex).getUserObject();
        if (select == null || !(select instanceof Map)) {
            MsgBox.showError((String)"OrgID is null, Plese select record!");
            return;
        }
        Map rec = (Map)select;
        cond.setOrgID((String)rec.get("orgID"));
        ItemIndex ii = (ItemIndex)this.comboIndex.getSelectedItem();
        cond.setIdxID(ii.id);
        IndexDataElementEnum ideEnum = (IndexDataElementEnum)((Object)this.comboDataElementType.getSelectedItem());
        cond.setDataElement(ideEnum.getValue());
        this.kDTable2.removeRows();
        this.kDTable2.removeColumns();
        Map map = this.getBizInterface().getIdxAnaDetailData(cond);
        if (map != null && map.size() > 0) {
            this.kDTable2.addColumns(4);
            IRow headRow = this.kDTable2.addHeadRow();
            headRow.getCell(0).setValue((Object)this.getHardCodingSettingResourceByName("11_dataTypeCode"));
            headRow.getCell(1).setValue((Object)this.getHardCodingSettingResourceByName("12_dataType"));
            headRow.getCell(2).setValue((Object)this.getHardCodingSettingResourceByName("13_period"));
            headRow.getCell(3).setValue((Object)this.getHardCodingSettingResourceByName("14_amount"));
            List list = (List)map.get("key_detailList");
            for (int i = 0; i < list.size(); ++i) {
                IRow row = this.kDTable2.addRow();
                Map rec2 = (Map)list.get(i);
                row.getCell(0).setValue(rec2.get("dataType"));
                row.getCell(1).setValue(rec2.get("dataTypeName"));
                row.getCell(2).setValue(rec2.get("period"));
                row.getCell(3).setValue(rec2.get("amount"));
            }
            this.kDTable2.addRow();
            List list3 = (List)map.get("key_chartList");
            for (int i = 0; i < list3.size(); ++i) {
                IRow row = this.kDTable2.addRow();
                Map rec3 = (Map)list3.get(i);
                row.getCell(0).setValue(rec3.get("dataType"));
                row.getCell(1).setValue(rec3.get("dataTypeName"));
                row.getCell(2).setValue(rec3.get("period"));
                row.getCell(3).setValue(rec3.get("amount"));
            }
            this.kDTable2.addRow();
            Map others = (Map)map.get("key_other");
            IRow otherRow = this.kDTable2.addRow();
            otherRow.getCell(0).setValue(others.get("unit"));
            otherRow.getCell(1).setValue(others.get("updateTime"));
            otherRow.getCell(2).setValue(others.get("chartTitle"));
        }
    }

    private String getHardCodingSettingResourceByName(String name) {
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)name);
    }

    @Override
    protected void btnShowAllOrg_actionPerformed(ActionEvent e) throws Exception {
        ItemIndexType itInfo = (ItemIndexType)this.comboIndexType.getSelectedItem();
        String schemeId = "lVIAAAB2SWiszsAX";
        this.initOrgUnit(itInfo.id, this.isShowAllOrg, schemeId);
        if (this.isShowAllOrg) {
            this.btnShowAllOrg.setText("-");
            this.btnShowAllOrg.setToolTipText(this.getHardCodingSettingResourceByName("15_showOrg"));
        } else {
            this.btnShowAllOrg.setText("+");
            this.btnShowAllOrg.setToolTipText(this.getHardCodingSettingResourceByName("16_showCompany"));
        }
        this.isShowAllOrg = !this.isShowAllOrg;
    }

    @Override
    protected void btnBossQuery_actionPerformed(ActionEvent e) throws Exception {
        IIndexAnalysisFacade facade = this.getBizInterface();
        HashMap<String, String> param = new HashMap<String, String>();
        int style = 0;
        style = 0;
        String schemeId = this.txtScheme.getText();
        if (style != 0) {
            if (style == 1) {
                param.put("schemeId", schemeId);
            } else if (style == 2) {
                param.put("schemeId", schemeId);
                String searchTxt = "";
                param.put("searchTxt", searchTxt);
            } else if (style == 3) {
                String longNumber = "";
                param.put("longNumber", longNumber);
            }
        }
        Map map = facade.getBossQuery(param);
    }

    @Override
    protected void btnMain_actionPerformed(ActionEvent e) throws Exception {
        IIndexAnalysisFacade facade = this.getBizInterface();
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (this.comboOrgUnit.getSelectedItem() == null) {
            return;
        }
        ItemOrgUnit ioUnit = (ItemOrgUnit)this.comboOrgUnit.getSelectedItem();
        boolean style = false;
        style = false;
        String schemeId = this.txtScheme.getText();
        if (style && style) {
            param.put("schemeId", schemeId);
            param.put("orgId", ioUnit.orgId);
            param.put("longNumber", ioUnit.longnumber);
            param.put("year", Integer.valueOf(this.spinYear.getValue().toString()));
            param.put("period", Integer.valueOf(this.spinPeriod.getValue().toString()));
            ItemIndexType itInfo = (ItemIndexType)this.comboIndexType.getSelectedItem();
            IndexTypeInfo indexTypeInfo = this.getIndexTypeInfoById(itInfo.id);
            param.put("treeId", indexTypeInfo.getOrgBound().getId().toString());
        }
        Map map = facade.getBossMain(param);
    }

    @Override
    protected void btnDetail_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String schemeId = this.txtScheme.getText();
        param.put("schemeId", schemeId);
        if (this.comboIndex.getSelectedItem() == null) {
            return;
        }
        ItemIndex ii = (ItemIndex)this.comboIndex.getSelectedItem();
        param.put("idxId", ii.id);
        ItemIndexType itInfo = (ItemIndexType)this.comboIndexType.getSelectedItem();
        IndexTypeInfo indexTypeInfo = this.getIndexTypeInfoById(itInfo.id);
        param.put("treeId", indexTypeInfo.getOrgBound().getId().toString());
        ItemOrgUnit ioUnit = (ItemOrgUnit)this.comboOrgUnit.getSelectedItem();
        param.put("longNumber", ioUnit.longnumber);
        param.put("orgId", ioUnit.orgId);
        param.put("chartType", 3);
        param.put("year", Integer.valueOf(this.spinYear.getValue().toString()));
        param.put("period", Integer.valueOf(this.spinPeriod.getValue().toString()));
        Map map = this.getBizInterface().getBossChart(param);
    }

    @Override
    protected void btnSort_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String schemeId = this.txtScheme.getText();
        MsgBox.showInfo((String)schemeId);
        param.put("schemeId", schemeId);
        int type = 2;
        if (type != 1) {
            if (this.comboIndexType.getSelectedItem() == null) {
                return;
            }
            ItemIndexType itInfo = (ItemIndexType)this.comboIndexType.getSelectedItem();
            IndexAnalysisSchemeEntryCollection col = IndexAnalysisSchemeEntryFactory.getRemoteInstance().getIndexAnalysisSchemeEntryCollection("select * where scheme.id='" + schemeId + "'");
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < col.size(); ++i) {
                IndexAnalysisSchemeEntryInfo info = col.get(i);
                idList.add(info.getId().toString());
            }
            param.put("indexType", idList);
        }
        Map map = this.getBizInterface().sortIndexType(param);
    }

    class ItemIndexType {
        private String id;
        private String name;

        public ItemIndexType(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    class ItemOrgUnit {
        private String fullName;
        private String longnumber;
        private String orgId;

        public ItemOrgUnit(String fullName, String longnumber, String orgId) {
            this.fullName = fullName;
            this.longnumber = longnumber;
            this.orgId = orgId;
        }

        public String toString() {
            return this.fullName;
        }
    }

    class ItemIndex {
        private String id;
        private String name;

        public ItemIndex(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

