/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaSelector;
import com.kingdee.eas.fi.gr.mobile.DCAmountEnum;
import com.kingdee.eas.fi.gr.mobile.DCCurYearCumulative;
import com.kingdee.eas.fi.gr.mobile.DCEndingBalance;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysis;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysisEntry;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisEntryCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisEntryFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisEntryInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisInfo;
import com.kingdee.eas.fi.gr.mobile.IndexDataElementEnum;
import com.kingdee.eas.fi.gr.mobile.IndexTypeCollection;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.VerifyException;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexAnalysisEditUI;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class IndexAnalysisEditUI
extends AbstractIndexAnalysisEditUI {
    private static final long serialVersionUID = 847901767487426411L;
    private static final String TB_Details_dataTypeNumber = "dataTypeNumber";
    private static final String TB_Details_dataTypeName = "dataTypeName";
    private static final String TB_Details_dataTypeValue = "dataTypeValue";
    private static final String TB_Details_formula = "formula";
    private static final String TB_Details_isDefault = "isDefault";
    private static final String TB_Details_dataElementType = "dataElementType";
    private static final String TB_Details_seq = "seq";
    private static final String TB_Details_isShow = "isShow";
    private static final String RESOURCE = "com.kingdee.eas.fi.gr.mobile.MobileCommonResource";
    private List rptItem = new ArrayList();
    private List bgItem = new ArrayList();
    private static final Logger logger = CoreUIObject.getLogger(IndexAnalysisEditUI.class);
    private KDTable[] tables = new KDTable[]{this.tblProduce, this.tblCumulation, this.tblBalance};

    private void initButton() {
        if (this.getUIContext().get("indexTypeID") == null) {
            this.btnAddNew.setEnabled(false);
            try {
                if (this.editData != null && this.editData.getId() != null) {
                    IndexAnalysisInfo info = ((IIndexAnalysis)this.getBizInterface()).getIndexAnalysisInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
                    this.getUIContext().put("indexTypeID", info.getIndexType().getId().toString());
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
        }
    }

    public void onLoad() throws Exception {
        IndexAnalysisInfo info;
        for (KDTable tbl : this.tables) {
            tbl.checkParsed();
        }
        super.onLoad();
        this.initHeadData();
        this.initEntryTable();
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.bindDataToTable(this.idList.getCurrentID());
            this.putTableData2Entries();
        } else {
            this.putTableData2Entries();
        }
        this.setPanelShowOrHidden(this.cbHasProduce, this.kDPanel1);
        this.setPanelShowOrHidden(this.cbHasCumulation, this.kDPanel2);
        this.setPanelShowOrHidden(this.cbHasBalance, this.kDPanel3);
        this.setDefaultDEShowOrHidden();
        if (this.getOprtState().equals(OprtState.VIEW) && (info = IndexAnalysisFactory.getRemoteInstance().getIndexAnalysisInfo("select trackRecordCreator.id where id='" + this.editData.getId().toString() + "'")) != null && info.getTrackRecordCreator() != null && info.getTrackRecordCreator().getId() != null) {
            ArrayList<JComponent> jComponents = new ArrayList<JComponent>();
            jComponents.add((JComponent)this.btnAddNew);
            jComponents.add((JComponent)this.btnEdit);
            jComponents.add((JComponent)this.btnRemove);
            jComponents.add((JComponent)this.menuItemAddNew);
            jComponents.add((JComponent)this.menuItemEdit);
            jComponents.add((JComponent)this.menuItemRemove);
            MobileUtil.checkCUPermission(info.getTrackRecordCreator().getId().toString(), jComponents);
        }
        this.initButton();
    }

    private void initHeadData() {
        IndexAnalysisInfo info;
        if (this.editData != null && (info = this.editData).isIsDefaultIndex()) {
            if (info.isHasProduce()) {
                this.cbDefaultDE.addItem((Object)IndexDataElementEnum.Produce);
            }
            if (info.isHasCumulation()) {
                this.cbDefaultDE.addItem((Object)IndexDataElementEnum.Cumulation);
            }
            if (info.isHasBalance()) {
                this.cbDefaultDE.addItem((Object)IndexDataElementEnum.Balance);
            }
            this.cbDefaultDE.setSelectedItem((Object)info.getDefaultDE());
        }
    }

    private void initEntryTable() {
        for (KDTable tbl : this.tables) {
            if (tbl.getRowCount() <= 0) continue;
            tbl.removeRows();
        }
        KDPromptBox prmtBoxD = new KDPromptBox();
        prmtBoxD.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, 4));
        prmtBoxD.setEditable(true);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmtBoxD);
        this.tblProduce.getColumn(TB_Details_formula).setEditor((ICellEditor)editor);
        this.tblCumulation.getColumn(TB_Details_formula).setEditor((ICellEditor)editor);
        this.tblBalance.getColumn(TB_Details_formula).setEditor((ICellEditor)editor);
        this.tblProduce.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                IndexAnalysisEditUI.this.fillFormula(e, IndexAnalysisEditUI.this.tblProduce);
            }
        });
        this.tblCumulation.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                IndexAnalysisEditUI.this.fillFormula(e, IndexAnalysisEditUI.this.tblCumulation);
            }
        });
        this.tblBalance.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                IndexAnalysisEditUI.this.fillFormula(e, IndexAnalysisEditUI.this.tblBalance);
            }
        });
        this.initFormulaRows(this.tblProduce, DCAmountEnum.iterator(), IndexDataElementEnum.Produce);
        this.initFormulaRows(this.tblCumulation, DCCurYearCumulative.iterator(), IndexDataElementEnum.Cumulation);
        this.initFormulaRows(this.tblBalance, DCEndingBalance.iterator(), IndexDataElementEnum.Balance);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            try {
                String id = this.getUIContext().get("indexTypeID").toString();
                IndexTypeInfo info = IndexTypeFactory.getRemoteInstance().getIndexTypeInfo("select isProduce,isCumulative,isBalance,produceDataType,cumulativeDataType,balanceDataType where id='" + id + "'");
                if (info.isIsBalance()) {
                    this.cbHasBalance.setSelected(true);
                    this.setIsDefaultToTable(this.tblBalance, info.getBalanceDataType());
                }
                if (info.isIsCumulative()) {
                    this.cbHasCumulation.setSelected(true);
                    this.setIsDefaultToTable(this.tblCumulation, info.getCumulativeDataType());
                }
                if (info.isIsProduce()) {
                    this.cbHasProduce.setSelected(true);
                    this.setIsDefaultToTable(this.tblProduce, info.getProduceDataType());
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
        }
    }

    private void setIsDefaultToTable(KDTable kDTable, String dataTypeStr) {
        if (StringUtils.isEmpty((String)dataTypeStr)) {
            return;
        }
        dataTypeStr = "," + dataTypeStr + ",";
        for (int i = 0; i < kDTable.getRowCount(); ++i) {
            IRow row = kDTable.getRow(i);
            String value = "," + row.getCell(TB_Details_dataTypeValue).getValue() + ",";
            if (dataTypeStr.indexOf(value) <= -1) continue;
            row.getCell(TB_Details_isDefault).setValue((Object)true);
        }
    }

    private void initFormulaRows(KDTable tbl, Iterator<StringEnum> it, IndexDataElementEnum dataElementTypeEnum) {
        int rowCount = tbl.getRowCount();
        if (rowCount == 0) {
            IRow row = null;
            int seq = 0;
            while (it.hasNext()) {
                StringEnum em = it.next();
                row = tbl.addRow(rowCount++);
                row.getCell(TB_Details_dataTypeNumber).setValue((Object)em.getName());
                row.getCell(TB_Details_dataTypeName).setValue((Object)em.getAlias());
                row.getCell(TB_Details_dataTypeValue).setValue((Object)em.getValue());
                row.getCell(TB_Details_isDefault).setValue((Object)false);
                row.getCell(TB_Details_isShow).setValue((Object)true);
                row.getCell(TB_Details_dataElementType).setValue((Object)dataElementTypeEnum);
                if (em.getValue() != null && em.getValue().length() > 1) {
                    row.getCell(TB_Details_formula).getStyleAttributes().setLocked(true);
                }
                row.getCell(TB_Details_seq).setValue((Object)seq++);
            }
        }
    }

    private void fillFormula(KDTActiveCellEvent e, KDTable tbl) {
        int rowIndex = e.getRowIndex();
        if (rowIndex > tbl.getRowCount() || rowIndex < 0) {
            return;
        }
        this.putClientProperty("clientProperty_formula_credit", null);
        int colIndex = e.getColumnIndex();
        Object formulaObj = tbl.getRow(rowIndex).getCell(colIndex).getValue();
        if (formulaObj != null && formulaObj.toString().trim().length() > 0) {
            this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
        }
    }

    private void bindDataToTable(String parentId) {
        IndexAnalysisEntryCollection cols = null;
        try {
            IIndexAnalysisEntry iIndexAnalysis = IndexAnalysisEntryFactory.getRemoteInstance();
            cols = iIndexAnalysis.getIndexAnalysisEntryCollection("select * where indexAnalysis.id='" + parentId + "' order by dataElementType, seq");
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (cols == null) {
            return;
        }
        ArrayList<IndexAnalysisEntryInfo> produceInfoList = new ArrayList<IndexAnalysisEntryInfo>();
        ArrayList<IndexAnalysisEntryInfo> cumulationInfoList = new ArrayList<IndexAnalysisEntryInfo>();
        ArrayList<IndexAnalysisEntryInfo> balanceInfoList = new ArrayList<IndexAnalysisEntryInfo>();
        if (cols != null) {
            for (int i = 0; i < cols.size(); ++i) {
                IndexAnalysisEntryInfo info = cols.get(i);
                if (IndexDataElementEnum.Produce.equals((Object)info.getDataElementType())) {
                    produceInfoList.add(info);
                    continue;
                }
                if (IndexDataElementEnum.Cumulation.equals((Object)info.getDataElementType())) {
                    cumulationInfoList.add(info);
                    continue;
                }
                if (!IndexDataElementEnum.Balance.equals((Object)info.getDataElementType())) continue;
                balanceInfoList.add(info);
            }
        }
        this.setEntryInfo2Table(produceInfoList, this.tblProduce);
        this.setEntryInfo2Table(cumulationInfoList, this.tblCumulation);
        this.setEntryInfo2Table(balanceInfoList, this.tblBalance);
    }

    private void setEntryInfo2Table(List<IndexAnalysisEntryInfo> produceInfoList, KDTable tblProduce) {
        for (int i = 0; i < produceInfoList.size(); ++i) {
            IndexAnalysisEntryInfo info = produceInfoList.get(i);
            IRow row = tblProduce.getRow(i);
            row.getCell(TB_Details_dataTypeNumber).setValue((Object)info.getDataTypeNumber());
            row.getCell(TB_Details_dataTypeName).setValue((Object)info.getDataTypeName());
            row.getCell(TB_Details_dataTypeValue).setValue((Object)info.getDataTypeValue());
            row.getCell(TB_Details_formula).setValue((Object)info.getFormula());
            row.getCell(TB_Details_isDefault).setValue((Object)info.isIsDefault());
            row.getCell(TB_Details_dataElementType).setValue((Object)info.getDataElementType());
            row.getCell(TB_Details_seq).setValue((Object)info.getSeq());
            row.getCell(TB_Details_isShow).setValue((Object)info.isIsShow());
            if (info.getDataTypeValue() >= 10) {
                row.getCell(TB_Details_formula).getStyleAttributes().setLocked(true);
                continue;
            }
            row.getCell(TB_Details_formula).getStyleAttributes().setLocked(false);
        }
    }

    private void putTableData2Entries() {
        int entryCount = 0;
        entryCount += this.putTableData2Entries(this.tblProduce, IndexDataElementEnum.Produce, entryCount);
        entryCount += this.putTableData2Entries(this.tblCumulation, IndexDataElementEnum.Cumulation, entryCount);
        entryCount += this.putTableData2Entries(this.tblBalance, IndexDataElementEnum.Balance, entryCount);
    }

    private int putTableData2Entries(KDTable tbl, IndexDataElementEnum emu, int entryCount) {
        int size = tbl.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = tbl.getRow(i);
            IndexAnalysisEntryInfo entryInfo = this.editData.getEntries().get(i + entryCount);
            if (entryInfo == null) {
                entryInfo = new IndexAnalysisEntryInfo();
                this.storeLine(row, entryInfo);
                this.editData.getEntries().add(entryInfo);
                this.editData.copyNewToOld();
                continue;
            }
            this.storeLine(row, entryInfo);
        }
        return tbl.getRowCount();
    }

    private void storeLine(IRow row, IndexAnalysisEntryInfo entryInfo) {
        if (row.getCell(TB_Details_dataTypeNumber).getValue() != null) {
            entryInfo.setDataTypeNumber(row.getCell(TB_Details_dataTypeNumber).getValue().toString());
        } else {
            entryInfo.setDataTypeNumber("");
        }
        if (row.getCell(TB_Details_dataTypeName).getValue() != null) {
            entryInfo.setDataTypeName(row.getCell(TB_Details_dataTypeName).getValue().toString());
        } else {
            entryInfo.setDataTypeName("");
        }
        if (row.getCell(TB_Details_dataTypeValue).getValue() != null) {
            entryInfo.setDataTypeValue(Integer.parseInt(row.getCell(TB_Details_dataTypeValue).getValue().toString()));
        } else {
            entryInfo.setDataTypeValue(0);
        }
        if (row.getCell(TB_Details_formula).getValue() != null) {
            entryInfo.setFormula(row.getCell(TB_Details_formula).getValue().toString());
        } else {
            entryInfo.setFormula("");
        }
        if (row.getCell(TB_Details_dataElementType).getValue() instanceof IndexDataElementEnum) {
            entryInfo.setDataElementType((IndexDataElementEnum)((Object)row.getCell(TB_Details_dataElementType).getValue()));
        } else {
            entryInfo.setDataElementType(null);
        }
        entryInfo.setSeq(row.getRowIndex());
        if (row.getCell(TB_Details_isDefault).getValue() != null) {
            entryInfo.setIsDefault(Boolean.valueOf(row.getCell(TB_Details_isDefault).getValue().toString()));
        } else {
            entryInfo.setIsDefault(false);
        }
        if (row.getCell(TB_Details_isShow).getValue() != null) {
            entryInfo.setIsShow(Boolean.valueOf(row.getCell(TB_Details_isShow).getValue().toString()));
        } else {
            entryInfo.setIsShow(false);
        }
    }

    protected void initListener() {
        this.cbHasProduce.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexAnalysisEditUI.this.doActionEvent1(IndexAnalysisEditUI.this.cbHasProduce, IndexAnalysisEditUI.this.kDPanel1);
            }
        });
        this.cbHasCumulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexAnalysisEditUI.this.doActionEvent1(IndexAnalysisEditUI.this.cbHasCumulation, IndexAnalysisEditUI.this.kDPanel2);
            }
        });
        this.cbHasBalance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexAnalysisEditUI.this.doActionEvent1(IndexAnalysisEditUI.this.cbHasBalance, IndexAnalysisEditUI.this.kDPanel3);
            }
        });
        final KDTableMoveAction rowMoveAction1 = new KDTableMoveAction(this.tblProduce);
        this.btnMoveUp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction1.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction1.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveTop1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction1.moveSelectedRowToHead();
            }
        });
        this.btnMoveBottom1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction1.moveSelectedRowToTail();
            }
        });
        final KDTableMoveAction rowMoveAction2 = new KDTableMoveAction(this.tblCumulation);
        this.btnMoveUp2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction2.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction2.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveTop2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction2.moveSelectedRowToHead();
            }
        });
        this.btnMoveBottom2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction2.moveSelectedRowToTail();
            }
        });
        final KDTableMoveAction rowMoveAction3 = new KDTableMoveAction(this.tblBalance);
        this.btnMoveUp3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction3.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction3.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveTop3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction3.moveSelectedRowToHead();
            }
        });
        this.btnMoveBottom3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction3.moveSelectedRowToTail();
            }
        });
        this.cbIsDefaultIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexAnalysisEditUI.this.doActionEvent2();
            }
        });
    }

    private void setPanelShowOrHidden(KDCheckBox cb, KDPanel panel) {
        int panelCount = this.kDTabbedPane1.getTabCount();
        if (cb.isSelected()) {
            this.kDTabbedPane1.add((Component)panel, (Object)this.resHelper.getString(panel.getName() + ".constraints"), panelCount);
            this.kDTabbedPane1.setSelectedComponent((Component)panel);
        } else {
            this.kDTabbedPane1.remove((Component)panel);
        }
    }

    private void doActionEvent1(KDCheckBox cb, KDPanel panel) {
        this.setPanelShowOrHidden(cb, panel);
        this.initDefaultDECheckBox();
    }

    private void doActionEvent2() {
        this.setDefaultDEShowOrHidden();
        this.initDefaultDECheckBox();
    }

    private void setDefaultDEShowOrHidden() {
        this.kdLabelContainer2.setVisible(this.cbIsDefaultIndex.isSelected());
    }

    private void initDefaultDECheckBox() {
        if (this.cbIsDefaultIndex.isSelected()) {
            Object o = this.cbDefaultDE.getSelectedItem();
            this.cbDefaultDE.removeAllItems();
            if (this.cbHasProduce.isSelected()) {
                this.cbDefaultDE.addItem((Object)IndexDataElementEnum.Produce);
            }
            if (this.cbHasCumulation.isSelected()) {
                this.cbDefaultDE.addItem((Object)IndexDataElementEnum.Cumulation);
            }
            if (this.cbHasBalance.isSelected()) {
                this.cbDefaultDE.addItem((Object)IndexDataElementEnum.Balance);
            }
            if (o != null) {
                this.cbDefaultDE.setSelectedItem(o);
            }
        } else {
            this.cbDefaultDE.removeAllItems();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.putTableData2Entries();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.putTableData2Entries();
        this.editData.setSyncOldValue(true);
        if (this.editData.getIndexType() == null && this.getUIContext().get("indexTypeID") != null) {
            BOSUuid id = BOSUuid.read((String)this.getUIContext().get("indexTypeID").toString());
            IndexTypeInfo type = new IndexTypeInfo();
            type.setId(id);
            this.editData.setIndexType(type);
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
        this.editData.setSyncOldValue(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ICell cell;
        int i;
        int count;
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            throw new VerifyException(VerifyException.INDEXNAME_BLANK);
        }
        if (this.txtName.getText().getBytes().length > 16) {
            throw new VerifyException(VerifyException.INDEXNAME_TOOLONG, new Object[]{8});
        }
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            throw new VerifyException(VerifyException.INDEXNUMBER_BLANK);
        }
        if (this.txtNumber.getText().getBytes().length > 80) {
            throw new VerifyException(VerifyException.INDEXNUMBER_TOOLONG, new Object[]{80});
        }
        this.verityNumber();
        StringBuffer Info = new StringBuffer();
        Boolean save_Produce = false;
        Boolean save_Cumulation = false;
        Boolean save_Balance = false;
        if (this.cbHasProduce.isSelected()) {
            count = 0;
            for (i = 0; i < this.tblProduce.getRowCount(); ++i) {
                cell = this.tblProduce.getRow(i).getCell(TB_Details_isDefault);
                if (!Boolean.valueOf(cell.getValue().toString()).booleanValue()) continue;
                ++count;
            }
            if (count > 3) {
                this.kDTabbedPane1.setSelectedComponent((Component)this.kDPanel1);
                Info = Info.append(MobileUtil.getString(RESOURCE, "IsDefault_More", new Object[]{this.cbHasProduce.getText()})).append("\n");
            } else if (count == 0) {
                this.kDTabbedPane1.setSelectedComponent((Component)this.kDPanel1);
                Info = Info.append(MobileUtil.getString(RESOURCE, "IsDefault_Least", new Object[]{this.cbHasProduce.getText()})).append("\n");
            } else {
                save_Produce = true;
            }
        }
        if (this.cbHasCumulation.isSelected()) {
            count = 0;
            for (i = 0; i < this.tblCumulation.getRowCount(); ++i) {
                cell = this.tblCumulation.getRow(i).getCell(TB_Details_isDefault);
                if (!Boolean.valueOf(cell.getValue().toString()).booleanValue()) continue;
                ++count;
            }
            if (count > 3) {
                this.kDTabbedPane1.setSelectedComponent((Component)this.kDPanel2);
                Info = Info.append(MobileUtil.getString(RESOURCE, "IsDefault_More", new Object[]{this.cbHasCumulation.getText()})).append("\n");
            } else if (count == 0) {
                this.kDTabbedPane1.setSelectedComponent((Component)this.kDPanel2);
                Info = Info.append(MobileUtil.getString(RESOURCE, "IsDefault_Least", new Object[]{this.cbHasCumulation.getText()})).append("\n");
            } else {
                save_Cumulation = true;
            }
        }
        if (this.cbHasBalance.isSelected()) {
            count = 0;
            for (i = 0; i < this.tblBalance.getRowCount(); ++i) {
                cell = this.tblBalance.getRow(i).getCell(TB_Details_isDefault);
                if (!Boolean.valueOf(cell.getValue().toString()).booleanValue()) continue;
                ++count;
            }
            if (count > 3) {
                this.kDTabbedPane1.setSelectedComponent((Component)this.kDPanel3);
                Info = Info.append(MobileUtil.getString(RESOURCE, "IsDefault_More", new Object[]{this.cbHasBalance.getText()})).append("\n");
            } else if (count == 0) {
                this.kDTabbedPane1.setSelectedComponent((Component)this.kDPanel3);
                Info = Info.append(MobileUtil.getString(RESOURCE, "IsDefault_Least", new Object[]{this.cbHasBalance.getText()})).append("\n");
            } else {
                save_Balance = true;
            }
        }
        if (this.cbHasProduce.isSelected() != save_Produce.booleanValue() || this.cbHasCumulation.isSelected() != save_Cumulation.booleanValue() || this.cbHasBalance.isSelected() != save_Balance.booleanValue()) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"59DefaultType"), (String)Info.toString(), (int)1);
            SysUtil.abort();
        }
        if (this.cbHasProduce.isSelected()) {
            for (int i2 = 0; i2 < this.tblProduce.getRowCount(); ++i2) {
                IRow row = this.tblProduce.getRow(i2);
                if (row.getCell(TB_Details_formula).getStyleAttributes().isLocked() || row.getCell(TB_Details_formula).getValue() == null || StringUtils.isEmpty((String)row.getCell(TB_Details_formula).getValue().toString())) continue;
                String formula = row.getCell(TB_Details_formula).getValue().toString();
                this.checkFormulaFormat(formula);
            }
        }
        if (this.cbHasCumulation.isSelected()) {
            for (int i3 = 0; i3 < this.tblCumulation.getRowCount(); ++i3) {
                IRow row = this.tblCumulation.getRow(i3);
                if (row.getCell(TB_Details_formula).getStyleAttributes().isLocked() || row.getCell(TB_Details_formula).getValue() == null || StringUtils.isEmpty((String)row.getCell(TB_Details_formula).getValue().toString())) continue;
                String formula = row.getCell(TB_Details_formula).getValue().toString();
                this.checkFormulaFormat(formula);
            }
        }
        if (this.cbHasBalance.isSelected()) {
            for (int i4 = 0; i4 < this.tblBalance.getRowCount(); ++i4) {
                IRow row = this.tblBalance.getRow(i4);
                if (row.getCell(TB_Details_formula).getStyleAttributes().isLocked() || row.getCell(TB_Details_formula).getValue() == null || StringUtils.isEmpty((String)row.getCell(TB_Details_formula).getValue().toString())) continue;
                String formula = row.getCell(TB_Details_formula).getValue().toString();
                this.checkFormulaFormat(formula);
            }
        }
    }

    private void verityNumber() throws Exception {
        StringBuffer buffer = new StringBuffer();
        String indexTypeId = "";
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            indexTypeId = this.getUIContext().get("indexTypeID").toString();
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            indexTypeId = this.editData.getIndexType().getId().toString();
        }
        buffer.append("select number where indextype.id='" + indexTypeId + "'");
        BOSUuid id = this.editData.getId();
        if (id != null) {
            buffer.append(" and id not in ('" + id.toString() + "')");
        }
        CoreBaseCollection col = this.getBizInterface().getCollection(buffer.toString());
        HashSet<String> set = new HashSet<String>();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                set.add(col.get(i).getString("number"));
            }
        }
        if (set.contains(this.txtNumber.getText())) {
            throw new VerifyException(VerifyException.INDEXNUMBER_DUPLICATE, new Object[]{this.txtNumber.getText()});
        }
    }

    private void checkFormulaFormat(String formulaString) throws VerifyException, BOSException {
        Expression stmt;
        try {
            stmt = ExcelFormulaPaserHelper.parse((String)formulaString);
        }
        catch (Exception e) {
            throw new VerifyException(VerifyException.CHECK_FORMULA_ERROR, e);
        }
        this.checkFormulaFormat(stmt);
        try {
            if (this.rptItem != null && this.rptItem.size() > 0) {
                this.checkFormulaItemExists(this.rptItem);
            }
            if (this.bgItem != null && this.bgItem.size() > 0) {
                this.checkBgItemExists(this.bgItem);
            }
        }
        catch (VerifyException e) {
            if (this.rptItem != null && this.rptItem.size() > 0) {
                this.rptItem.clear();
            }
            if (this.bgItem != null && this.bgItem.size() > 0) {
                this.bgItem.clear();
            }
            throw new VerifyException(VerifyException.RPTITEMNOTEXISTS);
        }
        if (this.rptItem != null && this.rptItem.size() > 0) {
            this.rptItem.clear();
        }
        if (this.bgItem != null && this.bgItem.size() > 0) {
            this.bgItem.clear();
        }
    }

    private void checkFormulaFormat(Expression stmt) throws VerifyException {
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            String item = null;
            FunctionExpr expr = (FunctionExpr)stmt;
            List param = expr.parameters;
            if (funName.equalsIgnoreCase("AcctItem")) {
                StringBuffer sb = new StringBuffer();
                boolean flag = false;
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.Message"));
                item = ((StringExpr)param.get((int)4)).value;
                if (StringUtils.isEmpty((String)item)) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.ItemFrom"));
                }
                if (!this.rptItem.contains(item)) {
                    this.rptItem.add(item);
                }
                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)5)).value))) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.ItemTo"));
                }
                if (!this.rptItem.contains(item)) {
                    this.rptItem.add(item);
                }
                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)11)).value))) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.DataElement"));
                }
                if (flag) {
                    String message = sb.toString();
                    message = message.substring(0, message.length() - 1);
                    message = message + EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.NotBlank");
                    MsgBox.showInfo((String)message);
                    SysUtil.abort();
                }
            } else if (funName.equalsIgnoreCase("BgFormula")) {
                StringBuffer sb = new StringBuffer();
                boolean flag = false;
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.Message"));
                item = ((StringExpr)param.get((int)1)).value;
                if (StringUtils.isEmpty((String)item)) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.Solution"));
                }
                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)2)).value))) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.Element"));
                }
                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)3)).value))) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.BudgetItem"));
                }
                if (!this.bgItem.contains(item)) {
                    this.bgItem.add(item);
                }
                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)4)).value))) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.BudgetCurrency"));
                }
                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)5)).value))) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.StartTime"));
                }
                if (StringUtils.isEmpty((String)(item = ((StringExpr)param.get((int)6)).value))) {
                    flag = true;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.EndTime"));
                }
                if (flag) {
                    String message = sb.toString();
                    message = message.substring(0, message.length() - 1);
                    message = message + EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.NotBlank");
                    MsgBox.showInfo((String)message);
                    SysUtil.abort();
                }
            }
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)stmt).left;
            this.checkFormulaFormat(expr);
            expr = ((BinaryOperationExpr)stmt).right;
            this.checkFormulaFormat(expr);
        } else if (stmt instanceof UnaryOperationExpr) {
            Expression expr = ((UnaryOperationExpr)stmt).operand;
            this.checkFormulaFormat(expr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkFormulaItemExists(List list) throws BOSException, VerifyException {
        StringBuffer oql = new StringBuffer();
        int length = list.size();
        int count = 0;
        oql.append("select id where number in (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            oql.append("'");
            oql.append(iter.next().toString());
            oql.append("'");
            if (++count != length) {
                oql.append(",");
            }
            if (count != length) continue;
            oql.append(")");
        }
        if (list == null) throw new VerifyException(VerifyException.RPTITEMNOTEXISTS);
        if (list.isEmpty()) throw new VerifyException(VerifyException.RPTITEMNOTEXISTS);
        RPTItemCollection col = RPTItemFactory.getRemoteInstance().getRPTItemCollection(oql.toString());
        int size = col.size();
        if (size == list.size()) return;
        throw new VerifyException(VerifyException.RPTITEMNOTEXISTS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkBgItemExists(List list) throws BOSException, VerifyException {
        StringBuffer oql = new StringBuffer();
        int length = list.size();
        int count = 0;
        oql.append("select id where number in (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            oql.append("'");
            oql.append(iter.next().toString());
            oql.append("'");
            if (++count != length) {
                oql.append(",");
            }
            if (count != length) continue;
            oql.append(")");
        }
        if (list == null) throw new VerifyException(VerifyException.RPTITEMNOTEXISTS);
        if (list.isEmpty()) throw new VerifyException(VerifyException.RPTITEMNOTEXISTS);
        BgItemCollection col = BgItemFactory.getRemoteInstance().getBgItemCollection(oql.toString());
        int size = col.size();
        if (size == list.size()) return;
        throw new VerifyException(VerifyException.RPTITEMNOTEXISTS);
    }

    @Override
    public void actionChangeDimension_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        this.initEntryTable();
        this.setPanelShowOrHidden(this.cbHasProduce, this.kDPanel1);
        this.setPanelShowOrHidden(this.cbHasCumulation, this.kDPanel2);
        this.setPanelShowOrHidden(this.cbHasBalance, this.kDPanel3);
    }

    protected IObjectValue createNewData() {
        return new IndexAnalysisInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IndexAnalysisFactory.getRemoteInstance();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        this.editData.setIsDefaultIndex(false);
        this.editData.setDefaultDE(null);
        this.cbIsDefaultIndex.setEnabled(false);
        this.cbIsDefaultIndex.setSelected(false);
        this.cbDefaultDE.removeAllItems();
        this.kdLabelContainer2.setVisible(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.beforeEdit();
    }

    private void beforeEdit() {
        try {
            IndexTypeInfo info;
            String indexTypeId = null;
            CompareType compareType = null;
            if (this.getUIContext().get("indexTypeID") != null) {
                indexTypeId = this.getUIContext().get("indexTypeID").toString();
                compareType = CompareType.EQUALS;
            } else if (this.editData != null && this.editData.getIndexType() != null) {
                indexTypeId = this.editData.getIndexType().getId().toString();
                compareType = CompareType.EQUALS;
            } else if (this.getDataObject() != null) {
                indexTypeId = "SELECT FIndexTypeId FROM T_CSL_IndexAnalysis WHERE FId='" + ((IndexAnalysisInfo)this.getDataObject()).getId().toString() + "'";
                compareType = CompareType.INNER;
            } else {
                return;
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo userFilterInfo = new FilterInfo();
            entityViewInfo.setFilter(userFilterInfo);
            userFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)indexTypeId, compareType));
            SelectorItemCollection selec = new SelectorItemCollection();
            entityViewInfo.setSelector(selec);
            selec.add(new SelectorItemInfo("trackRecordCreator.id"));
            IndexTypeCollection col = IndexTypeFactory.getRemoteInstance().getIndexTypeCollection(entityViewInfo);
            if (col != null && col.size() > 0 && (info = col.get(0)).getTrackRecordCreator() != null && info.getTrackRecordCreator().getId() != null) {
                ArrayList<JComponent> jComponents = new ArrayList<JComponent>();
                jComponents.add((JComponent)this.cbIsDefaultIndex);
                MobileUtil.checkCUPermission(info.getTrackRecordCreator().getId().toString(), jComponents);
            }
        }
        catch (Exception e) {
            logger.error((Object)"loadFields", (Throwable)e);
            this.handUIException(e);
        }
    }
}

