/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.mobile.IReportUserGroupDispense;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeInfo;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupDispEntryCollection;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupDispEntryInfo;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupDispenseFactory;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupDispenseInfo;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupInfo;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexSchemeDispenseUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class IndexSchemeDispenseUI
extends AbstractIndexSchemeDispenseUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(IndexSchemeDispenseUI.class);
    protected static final int MOVE_LEFT = 1;
    protected static final int MOVE_RIGHT = 2;
    protected static final int MOVE_ALL_LEFT = 3;
    protected static final int MOVE_ALL_RIGHT = 4;
    private String userGrpId = null;
    private boolean isChangeData = false;
    private ReportUserGroupDispenseInfo editData = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadDispenseData();
    }

    private void loadDispenseData() throws Exception {
        this.userGrpId = (String)this.getUIContext().get("ID");
        if (StringUtils.isEmpty((String)this.userGrpId)) {
            return;
        }
        this.editData = this.getBizInterface().exists(this.getQueryOql()) ? this.getBizInterface().getReportUserGroupDispenseInfo(this.getQueryOql()) : this.createNewData();
        this.initTableData();
    }

    private void initTableData() throws Exception {
        this.initSelectTable();
        this.initUnSelectTable();
    }

    private void initUnSelectTable() throws Exception {
        IndexAnalysisSchemeCollection col = IndexAnalysisSchemeFactory.getRemoteInstance().getIndexAnalysisSchemeCollection(this.getEntityViewInfo());
        this.tblUnSelectScheme.removeRows(false);
        this.tblUnSelectScheme.setRefresh(false);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblUnSelectScheme.addRow(i);
            row.getCell("id").setValue((Object)col.get(i).getId().toString());
            row.getCell("schemeNumber").setValue((Object)col.get(i).getNumber());
            row.getCell("schemeName").setValue((Object)col.get(i).getName());
        }
        this.tblUnSelectScheme.setRefresh(true);
        this.tblUnSelectScheme.reLayoutAndPaint();
        this.tblUnSelectScheme.setRowCount(col.size());
    }

    private void initSelectTable() {
        ReportUserGroupDispEntryCollection col = this.editData.getEntries();
        this.tblSelectScheme.removeRows();
        this.tblSelectScheme.setRefresh(false);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblSelectScheme.addRow(i);
            this.insertOneSchemeInfo2OneRow(row, col.get(i).getScheme(), true, col.get(i).isIsDefaultScheme());
        }
        this.tblSelectScheme.setRefresh(true);
        this.tblSelectScheme.reLayoutAndPaint();
    }

    private void insertOneSchemeInfo2OneRow(IRow row, IndexAnalysisSchemeInfo schemInfo, boolean hasDefaultCell, boolean isSelected) {
        row.getCell("id").setValue((Object)schemInfo.getId().toString());
        row.getCell("schemeNumber").setValue((Object)schemInfo.getNumber());
        row.getCell("schemeName").setValue((Object)schemInfo.getName());
        if (hasDefaultCell) {
            ICell iCell = row.getCell("isDefaultScheme");
            KDCheckBox curCheckBox = null;
            if (iCell.getEditor() == null) {
                curCheckBox = new KDCheckBox();
                this.initCheckBoxListener(curCheckBox);
                KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)curCheckBox);
                iCell.setEditor((ICellEditor)cellEditor);
            } else {
                curCheckBox = (KDCheckBox)iCell.getEditor().getComponent();
            }
            iCell.setValue((Object)isSelected);
            curCheckBox.setSelected(isSelected);
        }
    }

    private void initCheckBoxListener(KDCheckBox checkBox) {
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent paramItemEvent) {
                if (paramItemEvent.getStateChange() == 1) {
                    int rowCount = IndexSchemeDispenseUI.this.tblSelectScheme.getRowCount();
                    int[] selectRows = KDTableUtil.getSelectedRows((KDTable)IndexSchemeDispenseUI.this.tblSelectScheme);
                    if (selectRows.length == 0) {
                        return;
                    }
                    for (int i = 0; i < rowCount; ++i) {
                        if (i == selectRows[0]) continue;
                        IndexSchemeDispenseUI.this.tblSelectScheme.getRow(i).getCell("isDefaultScheme").setValue((Object)false);
                    }
                }
            }
        });
    }

    private String getQueryOql() {
        StringBuffer oql = new StringBuffer();
        oql.append("select id,").append("userGroup.id,").append("entries.scheme.id,").append("entries.scheme.number,").append("entries.scheme.name,").append("entries.isDefaultScheme").append(" where userGroup.id ='" + this.userGrpId + "'").append(" order by entries.scheme.number asc");
        return oql.toString();
    }

    private EntityViewInfo getEntityViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createOrgUnit.id", (Object)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        if (!StringUtils.isEmpty((String)this.userGrpId)) {
            StringBuffer subSql = new StringBuffer();
            subSql.append(" select scheme.fid from t_csl_ReportUserGroupDispense disp").append(" join t_csl_ReportUserGroupDispEntry entry on disp.fid = entry.FdispenseId").append(" join t_csl_IndexAnalysisScheme scheme on entry.fschemeId = scheme.FID").append(" where disp.FUserGroupID ='").append(this.userGrpId).append("'");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)subSql.toString(), CompareType.NOTINNER));
        }
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        return view;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnDispense.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    @Override
    public void actionDispense_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null && this.tblSelectScheme.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"SchemeIsUnselect"));
            SysUtil.abort();
            return;
        }
        if (this.editData.getId() != null && this.tblSelectScheme.getRowCount() <= 0) {
            this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
            this.disposeUIWindow();
            return;
        }
        this.editData.getEntries().clear();
        ReportUserGroupInfo userGrpInfo = new ReportUserGroupInfo();
        userGrpInfo.setId(BOSUuid.read((String)this.userGrpId));
        for (int i = 0; i < this.tblSelectScheme.getRowCount(); ++i) {
            IRow row = this.tblSelectScheme.getRow(i);
            ReportUserGroupDispEntryInfo entryInfo = new ReportUserGroupDispEntryInfo();
            IndexAnalysisSchemeInfo schemeInfo = new IndexAnalysisSchemeInfo();
            schemeInfo.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
            entryInfo.setScheme(schemeInfo);
            entryInfo.setIsDefaultScheme((Boolean)row.getCell("isDefaultScheme").getValue());
            this.editData.getEntries().add(entryInfo);
            this.editData.setUserGroup(userGrpInfo);
        }
        this.getBizInterface().submit(this.editData);
        this.disposeUIWindow();
    }

    protected void initListener() {
        super.initListener();
        this.btnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexSchemeDispenseUI.this.moveActionPerformed(2);
            }
        });
        this.btnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexSchemeDispenseUI.this.moveActionPerformed(1);
            }
        });
        this.btnAllRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexSchemeDispenseUI.this.moveActionPerformed(4);
            }
        });
        this.btnAllLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexSchemeDispenseUI.this.moveActionPerformed(3);
            }
        });
        EventListener[] listeners = this.tblSelectScheme.getListeners(KDTMouseListener.class);
        if (listeners != null) {
            for (EventListener l : listeners) {
                this.tblSelectScheme.removeKDTMouseListener((KDTMouseListener)l);
            }
        }
        this.tblSelectScheme.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    IndexSchemeDispenseUI.this.moveActionPerformed(1);
                }
            }
        });
        listeners = this.tblUnSelectScheme.getListeners(KDTMouseListener.class);
        if (listeners != null) {
            for (EventListener l : listeners) {
                this.tblUnSelectScheme.removeKDTMouseListener((KDTMouseListener)l);
            }
        }
        this.tblUnSelectScheme.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    IndexSchemeDispenseUI.this.moveActionPerformed(2);
                }
            }
        });
    }

    protected void moveActionPerformed(int command) {
        KDTable table;
        if (command == 4) {
            this.mockSelectAll(this.tblUnSelectScheme);
        } else if (command == 3) {
            this.mockSelectAll(this.tblSelectScheme);
        }
        IndexAnalysisSchemeCollection coll = null;
        boolean hasDefaultCell = false;
        if (command == 4 || command == 2) {
            coll = this.collectSchmeFromTable(this.tblUnSelectScheme);
            this.deleteSelectRow(this.tblUnSelectScheme);
            table = this.tblSelectScheme;
            hasDefaultCell = true;
        } else {
            coll = this.collectSchmeFromTable(this.tblSelectScheme);
            this.deleteSelectRow(this.tblSelectScheme);
            table = this.tblUnSelectScheme;
            hasDefaultCell = false;
        }
        this.moveRows(coll, table, hasDefaultCell);
        this.isChangeData = true;
    }

    private void moveRows(IndexAnalysisSchemeCollection coll, KDTable table, boolean hasDefaultCell) {
        int rowIndex = table.getRowCount();
        table.setRefresh(false);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            IRow row = table.addRow(rowIndex++);
            this.insertOneSchemeInfo2OneRow(row, coll.get(i), hasDefaultCell, false);
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    private void deleteSelectRow(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            table.removeRow(selectRows[i]);
        }
    }

    private IndexAnalysisSchemeCollection collectSchmeFromTable(KDTable table) {
        IndexAnalysisSchemeCollection col = new IndexAnalysisSchemeCollection();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = 0; i < selectRows.length; ++i) {
            IndexAnalysisSchemeInfo info = new IndexAnalysisSchemeInfo();
            info.setId(BOSUuid.read((String)((String)table.getRow(selectRows[i]).getCell("id").getValue())));
            info.setNumber((String)table.getRow(selectRows[i]).getCell("schemeNumber").getValue());
            info.setName((String)table.getRow(selectRows[i]).getCell("schemeName").getValue());
            col.add(info);
        }
        return col;
    }

    private void mockSelectAll(KDTable table) {
        KDTSelectBlock block = new KDTSelectBlock(0, 0, table.getRowCount() - 1, table.getRowCount() - 1, 10);
        table.getSelectManager().add(block);
    }

    public boolean isModify() {
        if (OprtState.VIEW.equals(this.oprtState)) {
            return false;
        }
        return this.isChangeData;
    }

    public void checkModified() {
        if (this.isModify()) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnDispense, 1001, this.btnDispense.getActionCommand());
                this.btnDispense.getAction().actionPerformed(event);
                if (this.actionDispense.isInvokeFailed()) {
                    SysUtil.abort();
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        this.destroyWindow();
    }

    protected void checkTableParsed() {
        this.tblSelectScheme.checkParsed();
        this.tblUnSelectScheme.checkParsed();
        this.tblSelectScheme.setEditable(true);
        this.tblUnSelectScheme.setEditable(false);
        this.tblUnSelectScheme.getSelectManager().setSelectMode(10);
        this.tblSelectScheme.getSelectManager().setSelectMode(10);
    }

    protected ReportUserGroupDispenseInfo createNewData() {
        return new ReportUserGroupDispenseInfo();
    }

    protected IReportUserGroupDispense getBizInterface() throws Exception {
        return ReportUserGroupDispenseFactory.getRemoteInstance();
    }
}

