/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisInfo;
import com.kingdee.eas.fi.gr.mobile.VerifyException;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexSyncUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class IndexSyncUI
extends AbstractIndexSyncUI {
    private static final Logger logger = CoreUIObject.getLogger(IndexSyncUI.class);
    private static final int MOVE_TO_DEST = 0;
    private static final int MOVE_TO_SOURCE = 1;
    private IndexAnalysisCollection leftCol = new IndexAnalysisCollection();
    private IndexAnalysisCollection rightCol = new IndexAnalysisCollection();

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.checkParsed();
        this.kDTable1.checkParsed();
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.kDTable2.getSelectManager().setSelectMode(10);
        final String itId = (String)this.getUIContext().get("indexTypeID");
        this.prmtTempIndex.setQueryInfo("com.kingdee.eas.fi.gr.mobile.IndexAnalysisQuery");
        this.prmtTempIndex.setFilterInfoProducer(new IFilterInfoProducer(){

            public FilterInfo getFilterInfo() {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("indextype.id", (Object)itId));
                return filter;
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
                cui = SysContext.getSysContext().getCurrentCtrlUnit();
            }

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }
        });
        this.prmtTempIndex.setEditFormat("$number$");
        this.prmtTempIndex.setDisplayFormat("$name$");
        this.prmtTempIndex.setEditable(true);
        this.prmtTempIndex.setCommitFormat("$number$");
        this.prmtTempIndex.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                IndexSyncUI.this.handleTempIndexChange(itId);
            }
        });
    }

    private void initSourceTable(String itId, String id) throws BOSException {
        IndexAnalysisCollection col = IndexAnalysisFactory.getRemoteInstance().getIndexAnalysisCollection("select * where indextype='" + itId + "' and id not in ('" + id + "') order by number");
        if (col != null) {
            this.kDTable1.removeRows();
            for (int i = 0; i < col.size(); ++i) {
                IndexAnalysisInfo info = col.get(i);
                this.leftCol.add(info);
                IRow row = this.kDTable1.addRow();
                row.getCell(0).setValue((Object)info.getNumber());
                row.getCell(1).setValue((Object)info.getName());
                row.getCell(2).setValue((Object)info.getId().toString());
                row.getCell(3).setValue((Object)info);
            }
        }
    }

    private void handleTempIndexChange(String itId) {
        IndexAnalysisInfo data = (IndexAnalysisInfo)this.prmtTempIndex.getData();
        String id = data.getId().toString();
        this.kDTable1.removeRows();
        this.kDTable2.removeRows();
        try {
            this.initSourceTable(itId, id);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        this.moveItem(0, false);
    }

    @Override
    public void actionReduce_actionPerformed(ActionEvent e) throws Exception {
        super.actionReduce_actionPerformed(e);
        this.moveItem(1, false);
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        this.moveItem(0, true);
    }

    @Override
    public void actionReduceAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionReduceAll_actionPerformed(e);
        this.moveItem(1, true);
    }

    private void moveItem(int iMoveDirection, boolean isMoveAll) {
        int i;
        KDTable toKdTable;
        KDTable sourceKdTable;
        boolean is2Right;
        int iMoveSize = -1;
        boolean bl = is2Right = iMoveDirection == 0;
        if (is2Right) {
            sourceKdTable = this.kDTable1;
            toKdTable = this.kDTable2;
        } else {
            sourceKdTable = this.kDTable2;
            toKdTable = this.kDTable1;
        }
        if (sourceKdTable.getRowCount() <= 0) {
            return;
        }
        IRow row = null;
        IndexAnalysisInfo info = null;
        if (isMoveAll) {
            int j;
            int count = sourceKdTable.getRowCount();
            if (is2Right) {
                for (j = 0; j < count; ++j) {
                    row = sourceKdTable.getRow(j);
                    info = (IndexAnalysisInfo)row.getCell(3).getValue();
                    this.rightCol.add(info);
                    this.leftCol.remove(info);
                }
            } else {
                for (j = 0; j < count; ++j) {
                    row = sourceKdTable.getRow(j);
                    info = (IndexAnalysisInfo)row.getCell(3).getValue();
                    this.leftCol.add(info);
                    this.rightCol.remove(info);
                }
            }
            sourceKdTable.removeRows();
        } else {
            int i2;
            iMoveSize = sourceKdTable.getSelectManager().size();
            if (iMoveSize <= 0) {
                return;
            }
            ArrayList<Integer> movingList = new ArrayList<Integer>(iMoveSize);
            for (i2 = 0; i2 < iMoveSize; ++i2) {
                int j;
                KDTSelectBlock sb = sourceKdTable.getSelectManager().get(i2);
                if (is2Right) {
                    for (j = sb.getTop(); j <= sb.getBottom(); ++j) {
                        row = sourceKdTable.getRow(j);
                        info = (IndexAnalysisInfo)row.getCell(3).getValue();
                        this.rightCol.add(info);
                        this.leftCol.remove(info);
                        movingList.add(new Integer(j));
                    }
                    continue;
                }
                for (j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    row = sourceKdTable.getRow(j);
                    info = (IndexAnalysisInfo)row.getCell(3).getValue();
                    this.leftCol.add(info);
                    this.rightCol.remove(info);
                    movingList.add(new Integer(j));
                }
            }
            Collections.sort(movingList);
            for (i2 = movingList.size() - 1; i2 >= 0; --i2) {
                Integer rowIndex = (Integer)movingList.get(i2);
                sourceKdTable.removeRow(rowIndex.intValue());
            }
        }
        if (is2Right) {
            toKdTable.removeRows();
            for (i = 0; i < this.rightCol.size(); ++i) {
                IndexAnalysisInfo iaInfo = this.rightCol.get(i);
                IRow r = toKdTable.addRow();
                r.getCell(0).setValue((Object)iaInfo.getNumber());
                r.getCell(1).setValue((Object)iaInfo.getName());
                r.getCell(2).setValue((Object)iaInfo.getId().toString());
                r.getCell(3).setValue((Object)iaInfo);
            }
        } else {
            toKdTable.removeRows();
            this.leftCol.sort("number");
            for (i = 0; i < this.leftCol.size(); ++i) {
                IndexAnalysisInfo iaInfo = this.leftCol.get(i);
                IRow r = toKdTable.addRow();
                r.getCell(0).setValue((Object)iaInfo.getNumber());
                r.getCell(1).setValue((Object)iaInfo.getName());
                r.getCell(2).setValue((Object)iaInfo.getId().toString());
                r.getCell(3).setValue((Object)iaInfo);
            }
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object o = this.prmtTempIndex.getData();
        if (o != null) {
            IndexAnalysisInfo info = (IndexAnalysisInfo)o;
            map.put("sourceIndexId", info.getId().toString());
        }
        HashSet<String> set = new HashSet<String>();
        int count = this.kDTable2.getRowCount();
        for (int i = 0; i < count; ++i) {
            String id = this.kDTable2.getRow(i).getCell(2).getValue().toString();
            set.add(id);
        }
        map.put("targetIndexIds", set);
        IndexAnalysisFactory.getRemoteInstance().syncIndexes(map);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.SyncIndexSuccess"));
    }

    private void verifyInput() throws Exception {
        if (this.prmtTempIndex.getData() == null) {
            throw new VerifyException(VerifyException.TEMPINDEX_BLANK);
        }
        if (this.kDTable2.getRowCount() == 0) {
            throw new VerifyException(VerifyException.TARGETINDEXES_BLANK);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }
}

