/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.mobile.DCAmountEnum;
import com.kingdee.eas.fi.gr.mobile.DCCurYearCumulative;
import com.kingdee.eas.fi.gr.mobile.DCEndingBalance;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeEntryFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeDimension;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexTypeEditUI;
import com.kingdee.eas.fi.gr.mobile.client.UnionVersionMobileF7;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.StringEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class IndexTypeEditUI
extends AbstractIndexTypeEditUI {
    private static final long serialVersionUID = 2377303307391368038L;
    private static final Logger logger = CoreUIObject.getLogger(IndexTypeEditUI.class);
    private IndexTypeDimension dimension;
    private String orgBoundId;
    private String currencyId;
    private int curSelectedIndex;
    private KDPanel curPanel;
    private static final int SHEET_UP = 0;
    private static final int SHEET_DOWN = 1;

    public IndexTypeEditUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        UnionVersionMobileF7 f7 = new UnionVersionMobileF7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource.sorgse"));
        this.prmtOrgBound.setSelector((KDPromptSelector)f7);
        this.prmtOrgBound.setEditable(false);
        this.prmtOrgBound.setDisplayFormat("$name$");
        CslRptUIUtil.setSpineRange(this.spinAnaPeriod, 1, 13, true);
        CslRptUIUtil.setSpineRange(this.spinPrecision, 0, 2, true);
        this.combDemension.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        IndexTypeEditUI.this.initAnaSpin();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.spinPrecision.setValue((Object)new Integer(2));
    }

    private void moveCell(int direction) {
        int nextIdx;
        KDPanel kDPanelSheet = this.curPanel;
        Integer index = this.curSelectedIndex;
        if (index == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.SelectRowFirst"));
            return;
        }
        int rowCount = kDPanelSheet.getComponentCount();
        int currentIdx = index;
        int n = nextIdx = direction == 0 ? currentIdx - 1 : currentIdx + 1;
        if (currentIdx == 0 && direction == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.MoveIsFirstRow"));
            return;
        }
        if (currentIdx >= rowCount - 1 && direction == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.MoveIsLastRow"));
            return;
        }
        Component currentComponent = kDPanelSheet.getComponent(currentIdx);
        Component nextComponent = kDPanelSheet.getComponent(nextIdx);
        kDPanelSheet.remove(currentComponent);
        kDPanelSheet.remove(nextComponent);
        if (direction == 0) {
            kDPanelSheet.add(currentComponent, nextIdx);
            kDPanelSheet.add(nextComponent, currentIdx);
        } else {
            kDPanelSheet.add(nextComponent, currentIdx);
            kDPanelSheet.add(currentComponent, nextIdx);
        }
        ((KDCheckBox)currentComponent).requestFocusInWindow();
        this.curSelectedIndex = nextIdx;
        Rectangle rectangle = currentComponent.getBounds();
        int suitableWrap = 30;
        if (direction == 0) {
            rectangle.setLocation((int)rectangle.getX(), (int)rectangle.getY() - suitableWrap);
        } else {
            rectangle.setLocation((int)rectangle.getX(), (int)rectangle.getY() + suitableWrap);
        }
        if (!kDPanelSheet.getVisibleRect().contains(rectangle)) {
            kDPanelSheet.scrollRectToVisible(rectangle);
        }
        kDPanelSheet.updateUI();
    }

    @Override
    public void actionBtnMoveDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveCell(1);
    }

    @Override
    public void actionBtnMoveUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveCell(0);
    }

    protected void initListener() {
        this.cbProduce.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!IndexTypeEditUI.this.cbProduce.isSelected()) {
                    for (int i = 0; i < IndexTypeEditUI.this.panelProduce.getComponentCount(); ++i) {
                        ((KDCheckBox)IndexTypeEditUI.this.panelProduce.getComponent(i)).setSelected(false);
                    }
                    IndexTypeEditUI.this.cbProduce.setSelected(false);
                }
            }
        });
        this.cbCumulative.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!IndexTypeEditUI.this.cbCumulative.isSelected()) {
                    for (int i = 0; i < IndexTypeEditUI.this.panelCumulative.getComponentCount(); ++i) {
                        ((KDCheckBox)IndexTypeEditUI.this.panelCumulative.getComponent(i)).setSelected(false);
                    }
                    IndexTypeEditUI.this.cbCumulative.setSelected(false);
                }
            }
        });
        this.cbBalance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!IndexTypeEditUI.this.cbBalance.isSelected()) {
                    for (int i = 0; i < IndexTypeEditUI.this.panelBalance.getComponentCount(); ++i) {
                        ((KDCheckBox)IndexTypeEditUI.this.panelBalance.getComponent(i)).setSelected(false);
                    }
                    IndexTypeEditUI.this.cbBalance.setSelected(false);
                }
            }
        });
    }

    private void initPanel(Iterator<StringEnum> it, KDPanel kDPanel) {
        kDPanel.setLayout((LayoutManager)new BoxLayout((Container)kDPanel, 1));
        Map uiContext = this.getUIContext();
        ItemMoveUpDownListener itemMoveUpdownListener = new ItemMoveUpDownListener(uiContext);
        while (it.hasNext()) {
            StringEnum em = it.next();
            KDCheckBox cbx = new KDCheckBox();
            cbx.setName(em.getValue() + "#" + kDPanel.getName());
            cbx.setText(em.getAlias());
            kDPanel.add((Component)cbx);
            cbx.addItemListener((ItemListener)itemMoveUpdownListener);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPanel(DCAmountEnum.iterator(), this.panelProduce);
        this.initPanel(DCCurYearCumulative.iterator(), this.panelCumulative);
        this.initPanel(DCEndingBalance.iterator(), this.panelBalance);
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.dimension = this.editData.getDimension();
            this.orgBoundId = this.editData.getOrgBound().getId().toString();
            this.currencyId = this.editData.getCurrency().getId().toString();
            IndexTypeInfo info = IndexTypeFactory.getRemoteInstance().getIndexTypeInfo("select cu.id,isProduce,isCumulative,isBalance,produceDataType,cumulativeDataType,balanceDataType where id='" + this.editData.getId().toString() + "'");
            this.editData.setProduceDataType(info.getProduceDataType());
            if (info.isIsProduce()) {
                this.loadEntries(info.getProduceDataType(), this.panelProduce);
            }
            if (info.isIsCumulative()) {
                this.loadEntries(info.getCumulativeDataType(), this.panelCumulative);
            }
            if (info.isIsBalance()) {
                this.loadEntries(info.getBalanceDataType(), this.panelBalance);
            }
        }
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        this.clearChecked(this.panelProduce);
        this.clearChecked(this.panelCumulative);
        this.clearChecked(this.panelBalance);
        this.cbProduce.setSelected(false);
        this.cbCumulative.setSelected(false);
        this.cbBalance.setSelected(false);
    }

    private void clearChecked(KDPanel panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            KDCheckBox cbx = (KDCheckBox)panel.getComponent(i);
            if (!cbx.isSelected()) continue;
            cbx.setSelected(false);
        }
    }

    private void loadEntries(String dataTypeStr, KDPanel kDPanel) {
        if (StringUtils.isEmpty((String)dataTypeStr)) {
            return;
        }
        String[] dataType = dataTypeStr.split(",");
        for (int j = 0; j < dataType.length; ++j) {
            for (int k = 0; k < kDPanel.getComponentCount(); ++k) {
                KDCheckBox box = (KDCheckBox)kDPanel.getComponent(k);
                String[] name = box.getName().split("#");
                if (!name[0].equals(dataType[j])) continue;
                box.setSelected(true);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.kDScrollPane1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.kDScrollPane2.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.kDScrollPane3.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.btnMoveUp1.setText(null);
        this.btnMoveDown1.setText(null);
        this.btnMoveUp2.setText(null);
        this.btnMoveDown2.setText(null);
        this.btnMoveUp3.setText(null);
        this.btnMoveDown3.setText(null);
        try {
            IndexTypeInfo info;
            if (OprtState.VIEW.equals(this.getOprtState()) && (info = IndexTypeFactory.getRemoteInstance().getIndexTypeInfo("select cu.id where id='" + this.editData.getId().toString() + "'")) != null && info.getCU() != null && info.getCU().getId() != null) {
                ArrayList<JComponent> jComponents = new ArrayList<JComponent>();
                jComponents.add((JComponent)this.btnAddNew);
                jComponents.add((JComponent)this.btnEdit);
                jComponents.add((JComponent)this.btnRemove);
                MobileUtil.checkCUPermission(info.getCU().getId().toString(), jComponents);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort((Throwable)e);
        }
    }

    private void initAnaSpin() {
        int m = 0;
        IndexTypeDimension itDim = (IndexTypeDimension)((Object)this.combDemension.getSelectedItem());
        m = IndexTypeDimension.year.equals((Object)itDim) ? 10 : (IndexTypeDimension.quater.equals((Object)itDim) ? 12 : 13);
        CslRptUIUtil.setSpineRange(this.spinAnaPeriod, 1, m, true);
        this.spinAnaPeriod.setValue((Object)new Integer(m));
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void storeFields() {
        String DataType2;
        super.storeFields();
        this.editData.setSyncOldValue(true);
        if (this.cbProduce.isSelected()) {
            DataType2 = this.putEditDataType(this.panelProduce);
            this.editData.setProduceDataType(DataType2);
        } else {
            this.editData.setProduceDataType(null);
        }
        if (this.cbCumulative.isSelected()) {
            DataType2 = this.putEditDataType(this.panelCumulative);
            this.editData.setCumulativeDataType(DataType2);
        } else {
            this.editData.setCumulativeDataType(null);
        }
        if (this.cbBalance.isSelected()) {
            DataType2 = this.putEditDataType(this.panelBalance);
            this.editData.setBalanceDataType(DataType2);
        } else {
            this.editData.setBalanceDataType(null);
        }
        this.editData.setSyncOldValue(true);
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
        this.editData.setSyncOldValue(false);
    }

    private String putEditDataType(KDPanel kDPanel) {
        String dataTypeStr = "";
        for (int i = 0; i < kDPanel.getComponentCount(); ++i) {
            KDCheckBox kb = (KDCheckBox)kDPanel.getComponent(i);
            String[] name = kb.getName().split("#");
            if (!kb.isSelected()) continue;
            if (this.panelProduce.equals(kDPanel)) {
                dataTypeStr = dataTypeStr + DCAmountEnum.getEnum(name[0]).getValue() + ",";
                continue;
            }
            if (this.panelCumulative.equals(kDPanel)) {
                dataTypeStr = dataTypeStr + DCCurYearCumulative.getEnum(name[0]).getValue() + ",";
                continue;
            }
            if (!this.panelBalance.equals(kDPanel)) continue;
            dataTypeStr = dataTypeStr + DCEndingBalance.getEnum(name[0]).getValue() + ",";
        }
        if (dataTypeStr.endsWith(",")) {
            dataTypeStr = dataTypeStr.substring(0, dataTypeStr.length() - 1);
        }
        return dataTypeStr;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        KDCheckBox checkBox;
        Component[] checkBoxs;
        String factorText;
        super.verifyInput(e);
        StringBuffer info = new StringBuffer();
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"47IndexNumber_Blank")).append("\n");
        } else if (this.txtNumber.getText().getBytes().length > 80) {
            info = info.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "48IndexNumber_TooLong", new Object[]{80})).append("\n");
        }
        if (StringUtils.isEmpty((String)this.txtName.getSelectedItem().toString())) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"45Name_Blank")).append("\n");
        } else if (this.txtName.getSelectedItem().toString().getBytes().length > 14) {
            info = info.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "46IndexName_TooLong", new Object[]{7})).append("\n");
        }
        if (StringUtils.isEmpty((String)this.prmtOrgBound.getText())) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"49OrgBound_Blank")).append("\n");
        }
        if (StringUtils.isEmpty((String)this.prmtCurrency.getText())) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"50IndexTypeCurrency_Blank")).append("\n");
        }
        if (StringUtils.isEmpty((String)this.txtUnit.getText())) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"51Unit_Blank")).append("\n");
        }
        if (this.txtUnit.getText().length() > 16) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"52Unit_More")).append("\n");
        }
        if (StringUtils.isEmpty((String)(factorText = this.txtFactor.getText()))) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"53Factor_Blank")).append("\n");
        } else {
            String f;
            String[] arr = factorText.split("\\.");
            String i = arr[0];
            String string = f = arr.length > 1 ? arr[1] : "";
            if (i.length() > 11) {
                info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"54IntegerFactor_More")).append("\n");
            }
            if (f.length() > 10) {
                info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"60DecimalFactor_More")).append("\n");
            }
        }
        if (Float.valueOf(this.txtFactor.getStringValue()).floatValue() <= 0.0f) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"55Factor_GreaterThanZero")).append("\n");
        }
        if (this.combDemension.getSelectedItem() == null) {
            info = info.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"56IndexTypeDimension_Blank")).append("\n");
        }
        if (!StringUtils.isEmpty((String)this.txtDescription.getSelectedItem().toString()) && this.txtDescription.getSelectedItem().toString().length() > 512) {
            info = info.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "95_Description_TooLong", new Object[]{512})).append("\n");
        }
        if (!StringUtils.isEmpty((String)this.txtRemark.getSelectedItem().toString()) && this.txtRemark.getSelectedItem().toString().getBytes().length > 18) {
            info = info.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "95_Description_TooLong", new Object[]{9})).append("\n");
        }
        if (this.cbProduce.isSelected()) {
            int count = 0;
            for (int i = 0; i < this.panelProduce.getComponentCount(); ++i) {
                checkBoxs = this.panelProduce.getComponents();
                checkBox = (KDCheckBox)checkBoxs[i];
                if (32 != checkBox.getSelected()) continue;
                ++count;
            }
            if (count == 0) {
                info = info.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "58LeastDataType", new Object[]{this.cbProduce.getText()})).append("\n");
            }
        }
        if (this.cbCumulative.isSelected()) {
            int count = 0;
            for (int i = 0; i < this.panelCumulative.getComponentCount(); ++i) {
                checkBoxs = this.panelCumulative.getComponents();
                checkBox = (KDCheckBox)checkBoxs[i];
                if (32 != checkBox.getSelected()) continue;
                ++count;
            }
            if (count == 0) {
                info = info.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "58LeastDataType", new Object[]{this.cbCumulative.getText()})).append("\n");
            }
        }
        if (this.cbBalance.isSelected()) {
            int count = 0;
            for (int i = 0; i < this.panelBalance.getComponentCount(); ++i) {
                checkBoxs = this.panelBalance.getComponents();
                checkBox = (KDCheckBox)checkBoxs[i];
                if (32 != checkBox.getSelected()) continue;
                ++count;
            }
            if (count == 0) {
                info = info.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "58LeastDataType", new Object[]{this.cbBalance.getText()})).append("\n");
            }
        }
        if (info.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"44ErrorMessage"), (String)info.toString(), (int)1);
            SysUtil.abort();
        }
        if (OprtState.EDIT.equals(this.getOprtState()) && this.checkModify()) {
            boolean flag;
            String indexTypeId = this.editData.getId().toString();
            Map modifyMessage = IndexTypeFactory.getRemoteInstance().getMessage(indexTypeId, "modify");
            if (modifyMessage.get("message") == null) {
                return;
            }
            String message = modifyMessage.get("message").toString();
            boolean bl = flag = (Integer)modifyMessage.get("flag") == 1;
            if (flag) {
                if (MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"84_Confirm"), (String)modifyMessage.get("message").toString()) == 0 && flag) {
                    this.removeAnalysisByType((List)modifyMessage.get("schemeIds"), indexTypeId);
                }
            } else {
                MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"88_Delete"), (String)message);
                SysUtil.abort();
            }
        }
    }

    private boolean checkModify() throws EASBizException, BOSException {
        return !this.orgBoundId.equals(this.editData.getOrgBound().getId().toString()) || !this.currencyId.equals(this.editData.getCurrency().getId().toString()) || !this.dimension.equals((Object)this.editData.getDimension());
    }

    private void removeAnalysisByType(List<String> schemeIds, String indexTypeId) throws Exception {
        if (schemeIds == null || schemeIds.size() == 0) {
            return;
        }
        String schemeId = "";
        for (int i = 0; i < schemeIds.size(); ++i) {
            schemeId = schemeId + "'" + schemeIds.get(i) + "',";
        }
        schemeId = schemeId.substring(0, schemeId.length() - 1);
        IndexAnalysisSchemeEntryFactory.getRemoteInstance().delete("where scheme.id in (" + schemeId + ") and indexType.id = '" + indexTypeId + "'");
    }

    protected IObjectValue createNewData() {
        IndexTypeInfo info = new IndexTypeInfo();
        info.setDimension(IndexTypeDimension.month);
        info.setAnaPeriod(6);
        info.setPrecision(2);
        info.setFactor(1.0);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IndexTypeFactory.getRemoteInstance();
    }

    protected class ItemMoveUpDownListener
    implements ItemListener {
        private Map uiContext;

        public ItemMoveUpDownListener(Map uiContext) {
            this.uiContext = uiContext;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Component component = (Component)e.getSource();
            String[] name = component.getName().split("#");
            KDPanel kDPanel = null;
            if (IndexTypeEditUI.this.panelProduce.getName().equals(name[1])) {
                kDPanel = IndexTypeEditUI.this.panelProduce;
                IndexTypeEditUI.this.cbProduce.setSelected(true);
                IndexTypeEditUI.this.btnMoveUp1.setEnabled(true);
                IndexTypeEditUI.this.btnMoveDown1.setEnabled(true);
                IndexTypeEditUI.this.btnMoveUp2.setEnabled(false);
                IndexTypeEditUI.this.btnMoveDown2.setEnabled(false);
                IndexTypeEditUI.this.btnMoveUp3.setEnabled(false);
                IndexTypeEditUI.this.btnMoveDown3.setEnabled(false);
            } else if (IndexTypeEditUI.this.panelCumulative.getName().equals(name[1])) {
                kDPanel = IndexTypeEditUI.this.panelCumulative;
                IndexTypeEditUI.this.cbCumulative.setSelected(true);
                IndexTypeEditUI.this.btnMoveUp1.setEnabled(false);
                IndexTypeEditUI.this.btnMoveDown1.setEnabled(false);
                IndexTypeEditUI.this.btnMoveUp2.setEnabled(true);
                IndexTypeEditUI.this.btnMoveDown2.setEnabled(true);
                IndexTypeEditUI.this.btnMoveUp3.setEnabled(false);
                IndexTypeEditUI.this.btnMoveDown3.setEnabled(false);
            } else if (IndexTypeEditUI.this.panelBalance.getName().equals(name[1])) {
                kDPanel = IndexTypeEditUI.this.panelBalance;
                IndexTypeEditUI.this.cbBalance.setSelected(true);
                IndexTypeEditUI.this.btnMoveUp1.setEnabled(false);
                IndexTypeEditUI.this.btnMoveDown1.setEnabled(false);
                IndexTypeEditUI.this.btnMoveUp2.setEnabled(false);
                IndexTypeEditUI.this.btnMoveDown2.setEnabled(false);
                IndexTypeEditUI.this.btnMoveUp3.setEnabled(true);
                IndexTypeEditUI.this.btnMoveDown3.setEnabled(true);
            }
            int index = 0;
            if (kDPanel != null) {
                int size = kDPanel.getComponentCount();
                for (int j = 0; j < size; ++j) {
                    if (!kDPanel.getComponent(j).equals(component)) continue;
                    index = j;
                    break;
                }
            }
            IndexTypeEditUI.this.curSelectedIndex = index;
            IndexTypeEditUI.this.curPanel = kDPanel;
        }
    }
}

