/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupEntryCollection;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupFactory;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupInfo;
import com.kingdee.eas.fi.gr.mobile.client.AbstractReportUserGroupEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericException;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.apache.log4j.Logger;

public class ReportUserGroupEditUI
extends AbstractReportUserGroupEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ReportUserGroupEditUI.class);
    protected MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.base.permission.app.UserListQuery");
    private List<UserInfo> unSelectUserLst = new ArrayList<UserInfo>();
    private List<UserInfo> selectedUserLst = new ArrayList<UserInfo>();
    protected String resuorcePath = "com.kingdee.eas.fi.gr.mobile.MobileCommonResource";
    private boolean isLoaded = false;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTree_user"));
        this.aciontMoveRight.setEnabled(true);
        this.actionMoveLeft.setEnabled(true);
        this.actionMoveAllToRight.setEnabled(true);
        this.actionMoveAllToLeft.setEnabled(true);
        this.actionQueryUser.setEnabled(true);
        this.menuBiz.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.isLoaded = true;
        this.initListener();
        this.cachSelectUserInfo2List();
        this.queryAuthorizedUserAndFill();
    }

    protected void checkTableParsed() {
        this.tblSelectUser.checkParsed();
        this.tblSelectUser.setEditable(false);
        this.tblUser.checkParsed();
        this.tblUser.setEditable(false);
    }

    private void cachSelectUserInfo2List() {
        ReportUserGroupEntryCollection coll = this.editData.getEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            com.kingdee.eas.base.permission.UserInfo userInfo = coll.get(i).getUser();
            this.selectedUserLst.add(new UserInfo(userInfo.getId().toString(), userInfo.getNumber(), userInfo.getName()));
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblSelectUser.getSelectManager().setSelectMode(10);
        this.tblUser.getSelectManager().setSelectMode(10);
        this.tblUser.getDataRequestManager().setDataRequestMode(0);
        this.tblUser.addKDTDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent e) {
                if (ReportUserGroupEditUI.this.isLoaded) {
                    ReportUserGroupEditUI.this.filterUserListAndFill();
                }
            }
        });
        EventListener[] listeners = this.tblUser.getListeners(KDTMouseListener.class);
        if (listeners != null) {
            for (EventListener l : listeners) {
                this.tblUser.removeKDTMouseListener((KDTMouseListener)l);
            }
        }
        this.tblUser.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    try {
                        ReportUserGroupEditUI.this.aciontMoveRight_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        listeners = this.tblSelectUser.getListeners(KDTMouseListener.class);
        if (listeners != null) {
            for (EventListener l : listeners) {
                this.tblSelectUser.removeKDTMouseListener((KDTMouseListener)l);
            }
        }
        this.tblSelectUser.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    try {
                        ReportUserGroupEditUI.this.actionMoveLeft_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        int rowCount = this.tblSelectUser.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            IRow row = this.tblSelectUser.getRow(r);
            if (row.getCell("id").getUserObject() != null && row.getCell("id").getUserObject() instanceof UserInfo) continue;
            row.getCell("id").setUserObject((Object)new UserInfo(((BOSUuid)row.getCell("id").getValue()).toString(), (String)row.getCell("number").getValue(), (String)row.getCell("name").getValue()));
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.reloadUnSelectTable();
    }

    private void reloadUnSelectTable() {
        this.selectedUserLst.clear();
        this.unSelectUserLst.clear();
        this.cachSelectUserInfo2List();
        this.tblUser.removeRows(false);
        this.queryAuthorizedUserAndFill();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.reloadUnSelectTable();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.reloadUnSelectTable();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.reloadUnSelectTable();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.reloadUnSelectTable();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setCreateOrgUnit(SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo());
        super.actionSubmit_actionPerformed(e);
    }

    public void handUIException(Throwable exc) {
        if (exc instanceof NumericException) {
            String msg = exc.getMessage();
            String[] splitArr = msg.split("@@@");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)splitArr[0], (String)splitArr[1], (int)2);
            return;
        }
        super.handUIException(exc);
    }

    private void filterUserListAndFill() {
        String searchTxt;
        ArrayList<UserInfo> searchList = new ArrayList();
        String string = searchTxt = this.txtQuery.getText() == null ? "" : this.txtQuery.getText().trim();
        if (StringUtils.isEmpty((String)searchTxt)) {
            searchList = this.unSelectUserLst;
        } else {
            int size = this.unSelectUserLst.size();
            for (int k = 0; k < size; ++k) {
                if (!this.unSelectUserLst.get(k).isMatched(searchTxt)) continue;
                searchList.add(this.unSelectUserLst.get(k));
            }
        }
        this.tblUser.removeRows(false);
        this.insertRows(this.tblUser, searchList);
    }

    private void queryAuthorizedUserAndFill() {
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.queryPK);
            exec.setObjectView(this.getQueryUserView());
            IRowSet rowSet = exec.executeQuery();
            this.wrappedRowSet2UserList(rowSet);
            this.delSelectedUserList();
            this.insertRows(this.tblUser, this.unSelectUserLst);
        }
        catch (Exception e) {
            logger.error((Object)"query user error!", (Throwable)e);
            this.handUIExceptionAndAbort(e);
            this.tblUser.setRowCount(0);
        }
    }

    private void delSelectedUserList() {
        this.unSelectUserLst.removeAll(this.selectedUserLst);
    }

    private void wrappedRowSet2UserList(IRowSet rs) throws SQLException {
        while (rs.next()) {
            this.unSelectUserLst.add(new UserInfo(rs.getString("id"), rs.getString("number"), rs.getString("name")));
        }
    }

    private void insertRows(KDTable table, List<UserInfo> list) {
        int rowIndex = table.getRowCount();
        rowIndex = rowIndex <= 0 ? 0 : rowIndex;
        UserInfo[] infoArrs = new UserInfo[list.size()];
        infoArrs = list.toArray(infoArrs);
        table.setRefresh(false);
        for (UserInfo info : infoArrs) {
            IRow row = table.addRow(rowIndex++);
            row.getCell("id").setValue((Object)info.id);
            row.getCell("number").setValue((Object)info.number);
            row.getCell("name").setValue((Object)info.name);
            row.getCell("id").setUserObject((Object)info);
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
        table.setRowCount(rowIndex);
    }

    private EntityViewInfo getQueryUserView() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id", "id");
        view.getSelector().add("number", "number");
        view.getSelector().add("name", "name");
        view.setFilter(this.getUserFilterInfo());
        if (!StringUtils.isEmpty((String)this.txtQuery.getText())) {
            int i;
            String searchTxt = "%" + this.txtQuery.getText().trim() + "%";
            StringBuffer maskString = new StringBuffer();
            int size = view.getFilter().getFilterItems().size();
            for (i = 0; i < size; ++i) {
                if (i > 0) {
                    maskString.append(" and ");
                }
                maskString.append("#").append(i);
            }
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)searchTxt, CompareType.LIKE));
            view.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)searchTxt, CompareType.LIKE));
            maskString.append(" and (#").append(i++).append(" or #").append(i).append(")");
            view.getFilter().setMaskString(maskString.toString());
        }
        return view;
    }

    protected FilterInfo getUserFilterInfo() throws Exception {
        FilterInfo userFilterInfo = new FilterInfo();
        userFilterInfo.getFilterItems().add(new FilterItemInfo("defOrgUnit.id", (Object)("select forgid from t_pm_orgrange where  fuserId ='" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "' and ftype = 30"), CompareType.INNER));
        try {
            userFilterInfo.mergeFilter(Administrator.getNotAdminUserFilter(), "AND");
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
        return userFilterInfo;
    }

    @Override
    public void actionQueryUser_actionPerformed(ActionEvent e) throws Exception {
        this.tblUser.removeRows();
    }

    @Override
    public void aciontMoveRight_actionPerformed(ActionEvent e) throws Exception {
        List<UserInfo> selectUserList = this.getSelectRowUserInfoList(this.tblUser);
        this.unSelectUserLst.removeAll(selectUserList);
        this.selectedUserLst.addAll(selectUserList);
        this.deleteSelectRow(this.tblUser);
        this.insertRows(this.tblSelectUser, selectUserList);
    }

    private List<UserInfo> getSelectRowUserInfoList(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        ArrayList<UserInfo> selectUserList = new ArrayList<UserInfo>(selectRows.length);
        for (int i : selectRows) {
            selectUserList.add((UserInfo)table.getRow(i).getCell("id").getUserObject());
        }
        return selectUserList;
    }

    private void deleteSelectRow(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            table.removeRow(selectRows[i]);
        }
    }

    @Override
    public void actionMoveLeft_actionPerformed(ActionEvent e) throws Exception {
        List<UserInfo> selectUserList = this.getSelectRowUserInfoList(this.tblSelectUser);
        this.selectedUserLst.removeAll(selectUserList);
        this.unSelectUserLst.addAll(selectUserList);
        this.deleteSelectRow(this.tblSelectUser);
        this.insertRows(this.tblUser, selectUserList);
    }

    @Override
    public void actionMoveAllToRight_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = new KDTSelectBlock(0, 0, this.tblUser.getRowCount() - 1, this.tblUser.getRowCount() - 1, 10);
        this.tblUser.getSelectManager().add(block);
        this.aciontMoveRight_actionPerformed(e);
    }

    @Override
    public void actionMoveAllToLeft_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = new KDTSelectBlock(0, 0, this.tblSelectUser.getRowCount() - 1, this.tblSelectUser.getRowCount() - 1, 10);
        this.tblSelectUser.getSelectManager().add(block);
        this.actionMoveLeft_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)(this.contNumber.getBoundLabelText() + EASResource.getString((String)this.resuorcePath, (String)"NotBlank").substring(1)));
            this.txtNumber.setFocusable(true);
            SysUtil.abort();
            return;
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)(this.contName.getBoundLabelText() + EASResource.getString((String)this.resuorcePath, (String)"NotBlank").substring(1)));
            this.txtName.setFocusable(true);
            SysUtil.abort();
            return;
        }
        if (this.selectedUserLst.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resuorcePath, (String)"selectUserIsBlank"));
            SysUtil.abort();
            return;
        }
    }

    protected IObjectValue createNewData() {
        ReportUserGroupInfo editData = new ReportUserGroupInfo();
        editData.setCreateOrgUnit(SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo());
        return editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReportUserGroupFactory.getRemoteInstance();
    }

    class UserInfo {
        BOSUuid id;
        String name;
        String number;

        UserInfo(String id, String number, String name) {
            this.id = BOSUuid.read((String)id);
            this.name = name;
            this.number = number;
        }

        public int hashCode() {
            return this.id.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return this.hashCode() == ((UserInfo)obj).hashCode();
        }

        public boolean isMatched(String searchTxt) {
            return this.number.indexOf(searchTxt) != -1 || this.name.indexOf(searchTxt) != -1;
        }
    }
}

