/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fi.gr.pa.PaReportCollection;
import com.kingdee.eas.fi.gr.pa.PaReportFactory;
import com.kingdee.eas.fi.gr.pa.PaTemplateCollection;
import com.kingdee.eas.fi.gr.pa.PaTemplateDispenseCollection;
import com.kingdee.eas.fi.gr.pa.PaTemplateDispenseFactory;
import com.kingdee.eas.fi.gr.pa.PaTemplateFactory;
import com.kingdee.eas.fi.gr.pa.PaTemplateInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PaRptServerUtil {
    private PaRptServerUtil() {
    }

    public static PaTemplateCollection getPaTemplateCollection(Context ctx, List idList) throws BOSException {
        if (idList == null || idList.isEmpty()) {
            return new PaTemplateCollection();
        }
        return PaRptServerUtil.getPaTemplateCollection(ctx, new HashSet(idList));
    }

    public static PaTemplateCollection getPaTemplateCollection(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return new PaTemplateCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("templateType"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        PaTemplateCollection collection = ctx == null ? PaTemplateFactory.getRemoteInstance().getPaTemplateCollection(view) : PaTemplateFactory.getLocalInstance(ctx).getPaTemplateCollection(view);
        return collection;
    }

    public static Set getDispensePaTemplateId(Context ctx, String treeID, String orgUnitID) {
        HashSet<String> set = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("dispenseSrcID"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)treeID));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnitID));
        view.setFilter(filter);
        try {
            PaTemplateDispenseCollection collection = ctx == null ? PaTemplateDispenseFactory.getRemoteInstance().getPaTemplateDispenseCollection(view) : PaTemplateDispenseFactory.getLocalInstance(ctx).getPaTemplateDispenseCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                set.add(collection.get(i).getDispenseSrcID());
            }
        }
        catch (BOSException e) {
            return set;
        }
        return set;
    }

    public static PaTemplateInfo getPaTemplateInfo(Context ctx, String templateId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("sheetParam"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)templateId);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        PaTemplateCollection collection = ctx == null ? PaTemplateFactory.getRemoteInstance().getPaTemplateCollection(view) : PaTemplateFactory.getLocalInstance(ctx).getPaTemplateCollection(view);
        return collection.get(0);
    }

    public static PaReportCollection getPaReportCollection(Context ctx, List idList) throws BOSException {
        if (idList == null || idList.isEmpty()) {
            return new PaReportCollection();
        }
        return PaRptServerUtil.getPaReportCollection(ctx, new HashSet(idList));
    }

    public static PaReportCollection getPaReportCollection(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return new PaReportCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        PaReportCollection collection = ctx == null ? PaReportFactory.getRemoteInstance().getPaReportCollection(view) : PaReportFactory.getLocalInstance(ctx).getPaReportCollection(view);
        return collection;
    }
}

