/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.UnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.pa.PaReportException;
import com.kingdee.eas.fi.gr.pa.PaReportFactory;
import com.kingdee.eas.fi.gr.pa.PaReportInfo;
import com.kingdee.eas.fi.gr.pa.PaRptClientUtil;
import com.kingdee.eas.fi.gr.pa.PaRptServerUtil;
import com.kingdee.eas.fi.gr.pa.PaTemplateInfo;
import com.kingdee.eas.fi.gr.pa.client.AbstractPaReportEditUI;
import com.kingdee.eas.fi.gr.pa.client.PaReportListUI;
import com.kingdee.eas.fi.gr.pa.client.PaReportProcessUI;
import com.kingdee.eas.fi.gr.pa.client.PaTemplateTreePromptBox;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PaReportEditUI
extends AbstractPaReportEditUI {
    private static final long serialVersionUID = 9186067650569208964L;
    private static final Logger logger = CoreUIObject.getLogger(PaReportEditUI.class);
    private boolean isSupport13Period = false;
    private Map perUnionUnitsMap = null;
    private boolean isBatchAdd = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.isBatchAdd = (Boolean)this.getUIContext().get("isBatchAdd");
        this.init();
        this.addListeners();
        this.initOrgTreeCombo();
        this.refreshCompany();
        this.refreshRptDate();
        this.actionCheckIsTemplateSelect_actionPerformed(null);
    }

    private void init() {
        if (this.isBatchAdd) {
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - 40));
            this.rbnNoTemplate.setEnabled(false);
            this.rbnTemplate.setSelected(true);
            this.contNumber.setVisible(false);
            this.contName.setVisible(false);
            this.kDPanel1.setBounds(new Rectangle(0, 0, 580, 128));
            this.add((Component)this.kDPanel1, new KDLayout.Constraints(0, 0, 580, 128, 0));
            this.kDPanel2.setBounds(new Rectangle(0, 130, 580, 219));
            this.add((Component)this.kDPanel2, new KDLayout.Constraints(0, 130, 580, 219, 0));
            CslRptUIUtil.moveContainerLocation((JComponent)this.btnOK, 0, -50);
            CslRptUIUtil.moveContainerLocation((JComponent)this.btnCacel, 0, -50);
        }
        this.txtName.setRequired(!this.isBatchAdd);
        this.txtNumber.setRequired(!this.isBatchAdd);
        this.txtName.setEnabled(!this.isBatchAdd);
        this.txtNumber.setEnabled(!this.isBatchAdd);
        this.kDTable1.checkParsed();
        this.actionCancel.setEnabled(true);
        this.kDDatePicker1.setEnabled(false);
        this.prmtOrgUnit.setEditable(false);
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setCommitFormat("$number$");
        CslRptUIUtil.setSpineRange(this.spinYear, 1900, 9999);
        CslRptUIUtil.setSpineRange(this.spinPeriod, 1, this.isSupport13Period ? 13 : 12, false);
        this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        Calendar calendar = Calendar.getInstance();
        this.spinYear.setValue((Object)new Integer(calendar.get(1)), false);
        this.spinPeriod.setValue((Object)new Integer(calendar.get(2) + 1), false);
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, true, false);
    }

    private void addListeners() {
        this.comboPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PaReportEditUI.this.refreshPeriod();
                    PaReportEditUI.this.refreshRptDate();
                }
            }
        });
        this.spinYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaReportEditUI.this.refreshPeriod();
                PaReportEditUI.this.refreshRptDate();
            }
        });
        this.spinPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaReportEditUI.this.refreshRptDate();
            }
        });
        this.kDDatePicker1.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                PaReportEditUI.this.initOrgTreeCombo();
                PaReportEditUI.this.refreshCompany();
            }
        });
        this.prmtOrgUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReportEditUI.this.kDTable1.removeRows();
            }
        });
        this.comboCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReportEditUI.this.reCreateReportNumber();
            }
        });
    }

    private void refreshPeriod() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        PaRptClientUtil.setPeriodRange(this.spinPeriod, periodType.getValue(), (Integer)this.spinYear.getValue(), this.isSupport13Period);
        int[] period = PaRptClientUtil.getLastPeriod(periodType);
        this.spinPeriod.setValue((Object)new Integer(period[1]));
    }

    private void refreshRptDate() {
        int year = (Integer)this.spinYear.getValue();
        int period = (Integer)this.spinPeriod.getValue();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        Date rptDate = RPTDateUtil.getPeriodLastDate(year, period, periodType);
        this.kDDatePicker1.setValue((Object)rptDate);
    }

    @Override
    protected void listOrgBound_actionPerformed(ActionEvent e) throws Exception {
        super.listOrgBound_actionPerformed(e);
        this.refreshCompany();
        this.kDTable1.removeRows();
    }

    private void refreshCompany() {
        OrgTreeInfo orgTreeInfo = null;
        this.prmtOrgUnit.setValue(null);
        if (this.listOrgBound.getSelectedItem() != null) {
            orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
            UnionF7 oldf7 = (UnionF7)this.prmtOrgUnit.getSelector();
            UnionF7 f7 = new UnionF7((IUIObject)this);
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                f7.setTreeID(orgTreeInfo.getId().toString());
            } else {
                f7 = oldf7;
            }
            HashMap map = null;
            try {
                String key;
                if (this.perUnionUnitsMap == null) {
                    this.perUnionUnitsMap = new HashMap(4);
                }
                if (this.perUnionUnitsMap.containsKey(key = orgTreeInfo.getId().toString() + this.getUserId())) {
                    map = (HashMap)this.perUnionUnitsMap.get(key);
                } else {
                    map = (HashMap)PermissionFactory.getRemoteInstance().getUnionUnits(CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), CslRptUtil.getPK((IObjectValue)orgTreeInfo));
                    this.perUnionUnitsMap.put(key, map);
                }
            }
            catch (EASBizException e) {
                super.handUIException((Throwable)e);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
            f7.disablePerm(map, true);
            f7.setSelectMode(2);
            this.prmtOrgUnit.setSelector((KDPromptSelector)f7);
            this.prmtOrgUnit.setEnabled(true);
        } else {
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    private void refreshTable() {
        int width = this.isBatchAdd ? 110 : 200;
        this.kDTable1.getColumn("reportNumber").getStyleAttributes().setHided(!this.isBatchAdd);
        this.kDTable1.getColumn("reportName").getStyleAttributes().setHided(!this.isBatchAdd);
        this.kDTable1.getColumn("reportName").setWidth(120);
        this.kDTable1.getColumn("reportNumber").setWidth(180);
        this.kDTable1.getColumn("templateNumber").setWidth(width);
        this.kDTable1.getColumn("tempalteName").setWidth(width);
        this.kDTable1.getColumn("templateNumber").getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn("tempalteName").getStyleAttributes().setLocked(true);
    }

    private String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    private List getRptYearAndPeriodAndDate() {
        int year = (Integer)this.spinYear.getValue();
        int period = (Integer)this.spinPeriod.getValue();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        return RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType);
    }

    private void initOrgTreeCombo() {
        try {
            List rptYearAndPeriodAndDate = this.getRptYearAndPeriodAndDate();
            Date rptDate = (Date)rptYearAndPeriodAndDate.get(rptYearAndPeriodAndDate.size() - 1);
            PaRptClientUtil.initOrgTreeCombox(this.listOrgBound, rptDate);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected IObjectValue createNewData() {
        PaReportInfo info = new PaReportInfo();
        info.setSourceType(RptSrcTypeEnum.PAREPORT);
        info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        return info;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.rbnTemplate.isSelected() && this.kDTable1.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("1_chooseTemplate"));
            SysUtil.abort();
        }
        if (this.isBatchAdd) {
            IRow row = null;
            for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
                row = this.kDTable1.getRow(i);
                String number = (String)row.getCell("reportNumber").getValue();
                String name = (String)row.getCell("reportName").getValue();
                this.checkNull(number, PaReportException.REPORTNUMBERNULL1, i + 1);
                this.checkLength(number, PaReportException.REPORTNUMBERLENGTH1, i + 1);
                this.checkNull(name, PaReportException.REPORTNAMENULL1, i + 1);
                this.checkLength(name, PaReportException.REPORTNAMELENGTH1, i + 1);
            }
        } else {
            this.checkNull(this.txtNumber.getText(), PaReportException.REPORTNUMBERNULL, -1);
            this.checkLength(this.txtNumber.getText(), PaReportException.REPORTNUMBERLENGTH, -1);
            this.checkNull(this.txtName.getText(), PaReportException.REPORTNAMENULL, -1);
            this.checkLength(this.txtName.getText(), PaReportException.REPORTNAMELENGTH, -1);
        }
        if (this.prmtOrgUnit.getValue() == null) {
            throw new PaReportException(PaReportException.ORGUNITNULL);
        }
        this.checkReportNumber();
    }

    private void checkNull(String compValue, NumericExceptionSubItem item, int row) throws Exception {
        if (compValue == null || compValue.trim().equals("")) {
            if (row > 0) {
                throw new PaReportException(item, new Object[]{new Integer(row)});
            }
            throw new PaReportException(item);
        }
    }

    private void checkLength(String compValue, NumericExceptionSubItem item, int row) throws Exception {
        if (compValue.length() > 80) {
            if (row > 0) {
                throw new PaReportException(item, new Object[]{new Integer(row)});
            }
            throw new PaReportException(item);
        }
    }

    private void checkReportNumber() throws Exception {
        if (this.isBatchAdd) {
            IRow row = null;
            HashSet<Object> numberSet = new HashSet<Object>();
            for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
                row = this.kDTable1.getRow(i);
                if (numberSet.contains(row.getCell("reportNumber").getValue())) {
                    throw new PaReportException(PaReportException.REPORTNUMBEREXIST02, new Object[]{new Integer(i + 1)});
                }
                numberSet.add(row.getCell("reportNumber").getValue());
            }
        } else {
            boolean exist = PaReportFactory.getRemoteInstance().exists("where number = '" + this.txtNumber.getText() + "'");
            if (exist) {
                throw new PaReportException(PaReportException.REPORTNUMBEREXIST01, new Object[]{this.txtName.getText(), this.txtNumber.getText(), this.txtNumber.getText()});
            }
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        this.verifyInput(e);
        this.storeFields();
        if (this.isBatchAdd) {
            this.batchAdd();
        } else {
            PaReportInfo report = (PaReportInfo)this.getEditDataObject();
            if (report.getPaTemplate() != null) {
                StringBuffer oql = new StringBuffer();
                oql.append(" select  id where orgTree.id ='").append(report.getOrgTree().getId().toString()).append("'");
                oql.append(" and orgUnit.id ='").append(report.getOrgUnit().getId().toString()).append("'");
                oql.append(" and periodType = ").append(report.getPeriodType().getValue());
                oql.append(" and year = ").append(report.getYear());
                oql.append(" and period = ").append(report.getPeriod());
                oql.append(" and currency.id ='").append(report.getCurrency().getId().toString()).append("'");
                oql.append(" and paTemplate.id = '").append(report.getPaTemplate().getId().toString()).append("'");
                boolean exist = PaReportFactory.getRemoteInstance().exists(oql.toString());
                if (exist) {
                    throw new PaReportException(PaReportException.REPORTEXIST01, new Object[]{report.getName(), report.getNumber()});
                }
            }
            this.add();
        }
    }

    private void add() throws UIException {
        PaReportInfo vo = (PaReportInfo)this.getEditDataObject();
        vo.setOrgType(OrgType.Company);
        this.getUIWindow().hide();
        UIContext context = new UIContext(this.getUIContext().get("Owner"));
        context.put((Object)"InitDataObject", (Object)vo);
        context.put(PaReportInfo.class, (Object)vo);
        final IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(PaReportProcessUI.class.getName(), (Map)context, null, OprtState.ADDNEW);
        this.destroyWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                window2.show();
            }
        });
    }

    private void batchAdd() throws Exception {
        CoreBaseCollection colls = new CoreBaseCollection();
        PaReportInfo paReportInfo = null;
        IRow row = null;
        ArrayList<PaReportInfo> success = new ArrayList<PaReportInfo>();
        ArrayList<Exception> fail = new ArrayList<Exception>();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            paReportInfo = this.editData.getEditCopy();
            row = this.kDTable1.getRow(i);
            String number = (String)row.getCell("reportNumber").getValue();
            String name = (String)row.getCell("reportName").getValue();
            paReportInfo.setName(name);
            paReportInfo.setNumber(number);
            PaTemplateInfo templateInfo = new PaTemplateInfo();
            templateInfo.put("id", row.getCell("tempalteId").getValue());
            paReportInfo.setPaTemplate(templateInfo);
            colls.add((CoreBaseInfo)paReportInfo);
            try {
                PaReportFactory.getRemoteInstance().addnew(paReportInfo);
                success.add(paReportInfo);
                continue;
            }
            catch (Exception e) {
                fail.add(e);
            }
        }
        if (success.size() == this.kDTable1.getRowCount()) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("2_reportAddSuccess"));
        } else if (fail.size() == this.kDTable1.getRowCount()) {
            String detailMessage = "";
            for (int i = 0; i < fail.size(); ++i) {
                if (fail.get(i) instanceof PaReportException) {
                    PaReportException ex = (PaReportException)((Object)fail.get(i));
                    detailMessage = detailMessage + ex.getMessage() + "\r\n";
                    continue;
                }
                detailMessage = detailMessage + fail.get(i) + "\r\n";
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)PaRptClientUtil.getResString("3_reportAddFail"), (String)detailMessage, (int)2);
        } else {
            StringBuffer detailMessage = new StringBuffer();
            for (int i = 0; i < success.size(); ++i) {
                paReportInfo = (PaReportInfo)success.get(i);
                detailMessage.append(PaRptClientUtil.getResString("4_reportAddSuccess", new Object[]{paReportInfo.getName(), paReportInfo.getNumber()}));
                detailMessage.append("\r\n");
            }
            for (int i = 0; i < fail.size(); ++i) {
                if (fail.get(i) instanceof PaReportException) {
                    PaReportException ex = (PaReportException)((Object)fail.get(i));
                    detailMessage.append(ex.getMessage()).append("\r\n");
                    continue;
                }
                detailMessage.append(fail.get(i)).append("\r\n");
            }
            Object[] param = new Object[]{new Integer(success.size()), new Integer(fail.size())};
            MsgBox.showDetailAndOK((Component)((Object)this), (String)PaRptClientUtil.getResString("5_AddMsg", param), (String)detailMessage.toString(), (int)2);
        }
        this.destroyWindow();
        Object owner = this.getUIContext().get("Owner");
        if (owner instanceof PaReportListUI) {
            ((PaReportListUI)((Object)owner)).refreshList();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setId(BOSUuid.create((BOSObjectType)this.editData.getBOSType()));
        this.editData.setNumber(this.txtNumber.getText().trim());
        this.editData.setName(this.txtName.getText().trim());
        this.editData.setSourceType(RptSrcTypeEnum.PAREPORT);
        this.editData.setOrgTree((OrgTreeInfo)this.listOrgBound.getSelectedItem());
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.prmtOrgUnit.getValue();
        this.editData.setOrgUnit(orgUnitInfo);
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(orgUnitInfo.getId());
        this.editData.setCompany(company);
        int year = (Integer)this.spinYear.getValue();
        int period = (Integer)this.spinPeriod.getValue();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        this.editData.setYear(year);
        this.editData.setPeriod(Short.valueOf(period + ""));
        this.editData.setPeriodType(periodType);
        this.editData.setStartDate(RPTDateUtil.getPeriodFirstDate(year, period, periodType));
        this.editData.setEndDate(RPTDateUtil.getPeriodLastDate(year, period, periodType));
        this.editData.setReportDate(RPTDateUtil.getPeriodLastDate(year, period, periodType));
        this.editData.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        this.storeTemplate();
        this.editData.setDataCollectNumber("ACTUALDATA");
    }

    private void storeTemplate() {
        if (!this.isBatchAdd && this.rbnTemplate.isSelected()) {
            String templateId = this.kDTable1.getRow(0).getCell("tempalteId").getValue().toString();
            PaTemplateInfo templateInfo = this.getTemplateInfo(templateId);
            if (templateInfo == null) {
                return;
            }
            this.editData.setPaTemplate(templateInfo);
            this.editData.setZipData(templateInfo.getZipData());
            RptSheetParamCollection sheetParams = templateInfo.getSheetParam();
            if (sheetParams != null && sheetParams.size() > 0) {
                for (int j = 0; j < sheetParams.size(); ++j) {
                    sheetParams.get(j).setRelaType(ReportTypeEnum.PAREPORT);
                    sheetParams.get(j).setStatus(1);
                }
            }
            this.editData.getSheetParam().addCollection(sheetParams);
        }
    }

    private PaTemplateInfo getTemplateInfo(String templateId) {
        try {
            return PaRptServerUtil.getPaTemplateInfo(null, templateId);
        }
        catch (BOSException e) {
            this.handUIException(e);
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    @Override
    public void actionCheckIsOpenAutoCalc_actionPerformed(ActionEvent e) throws Exception {
        super.actionCheckIsOpenAutoCalc_actionPerformed(e);
        if (this.chkIsOpenAutoCalc.isSelected()) {
            this.editData.setIsOpenAutoCalc(true);
        } else {
            this.editData.setIsOpenAutoCalc(false);
        }
    }

    @Override
    public void actionCheckIsTemplateSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionCheckIsTemplateSelect_actionPerformed(e);
        boolean isEnabled = false;
        if (this.rbnNoTemplate.isSelected()) {
            isEnabled = false;
            this.kDTable1.removeRows();
        } else if (this.rbnTemplate.isSelected()) {
            isEnabled = true;
        }
        this.btnAddTemplate.setEnabled(isEnabled);
        this.btnDelTemplate.setEnabled(isEnabled);
        this.kDTable1.setEnabled(isEnabled);
        this.kDTable1.setEditable(isEnabled);
        this.refreshTable();
    }

    public String getUITitle() {
        if (!this.isBatchAdd) {
            return PaRptClientUtil.getResString("6_PaRptEditTitle");
        }
        return PaRptClientUtil.getResString("7_PaRptEditTitle_Batch");
    }

    @Override
    public void actionAddTemplate_actionPerformed(ActionEvent e) throws Exception {
        Object data;
        FullOrgUnitInfo orgUnitInfo;
        if (this.prmtOrgUnit.getValue() == null) {
            throw new PaReportException(PaReportException.ORGUNITNULL);
        }
        String treeId = ((OrgTreeInfo)this.listOrgBound.getSelectedItem()).getId().toString();
        Set idSet = PaRptServerUtil.getDispensePaTemplateId(null, treeId, (orgUnitInfo = (FullOrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString());
        if (idSet == null || idSet.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("8_NoUseTemplate"));
            SysUtil.abort();
        }
        PaTemplateTreePromptBox templateTree = new PaTemplateTreePromptBox((IUIObject)this, this.isBatchAdd);
        templateTree.setTemplateIdSet(idSet);
        templateTree.show();
        if (!templateTree.isCanceled() && (data = templateTree.getData()) != null) {
            if (!this.isBatchAdd) {
                this.kDTable1.removeRows();
            }
            this.createReportNumber((Object[])data);
            PaRptClientUtil.addArrayValueToTable(this.kDTable1, (Object[])data);
        }
    }

    private void createReportNumber(Object[] data) {
        if (!this.isBatchAdd) {
            return;
        }
        int arrCount = data.length;
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        int year = (Integer)this.spinYear.getValue();
        int period = (Integer)this.spinPeriod.getValue();
        String orgUnitNumber = ((FullOrgUnitInfo)this.prmtOrgUnit.getValue()).getNumber();
        String currencyNumber = ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getNumber();
        for (int i = 0; i < arrCount; ++i) {
            if (!(data[i] instanceof PaTemplateInfo)) continue;
            PaTemplateInfo templateInfo = (PaTemplateInfo)data[i];
            String value = PaRptClientUtil.autoCreateReportNumber(periodType, templateInfo.getNumber(), year, period, currencyNumber, orgUnitNumber);
            templateInfo.put("reportNumber", value);
        }
    }

    private void reCreateReportNumber() {
        if (!this.isBatchAdd || this.kDTable1.getRowCount() == 0) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(this.kDTable1.getRowCount());
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            list.add(this.kDTable1.getRow(i).getUserObject());
        }
        this.kDTable1.removeRows();
        this.createReportNumber(list.toArray());
        PaRptClientUtil.addArrayValueToTable(this.kDTable1, list.toArray());
    }

    @Override
    public void actionDelTemplate_actionPerformed(ActionEvent e) throws Exception {
        PaRptClientUtil.deleteKdTableSelectedRows(this.kDTable1);
    }

    public boolean isModify() {
        return false;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PaReportFactory.getRemoteInstance();
    }
}

