/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.client.f7.UnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.pa.PaRptClientUtil;
import com.kingdee.eas.fi.gr.pa.client.AbstractPaReportFilter1UI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PaReportFilter1UI
extends AbstractPaReportFilter1UI {
    private static final long serialVersionUID = -4972068378543192218L;
    private static final Logger logger = CoreUIObject.getLogger(PaReportFilter1UI.class);
    private static final String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    private boolean isSupport13Period = false;
    private Map perUnionUnitsMap = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.addListeners();
        this.initOrgTreeCombo();
        this.refreshCompany();
    }

    private void init() {
        this.orgUnitPromp.setEditable(false);
        this.orgUnitPromp.setDisplayFormat("$name$");
        this.orgUnitPromp.setCommitFormat("$number$");
        CslRptUIUtil.setSpineRange(this.startYearSpin, 1900, 9999);
        CslRptUIUtil.setSpineRange(this.endYearSpin, 1900, 9999);
        CslRptUIUtil.setSpineRange(this.startPeriodSpin, 1, this.isSupport13Period ? 13 : 12, false);
        CslRptUIUtil.setSpineRange(this.endPeriodSpin, 1, this.isSupport13Period ? 13 : 12, false);
        this.initData();
    }

    private void initData() {
        this.periodTypeCombo.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        Calendar calendar = Calendar.getInstance();
        this.startYearSpin.setValue((Object)new Integer(calendar.get(1)), false);
        this.startPeriodSpin.setValue((Object)new Integer(calendar.get(2) + 1), false);
        this.endYearSpin.setValue((Object)new Integer(calendar.get(1)), false);
        this.endPeriodSpin.setValue((Object)new Integer(calendar.get(2) + 1), false);
        this.comboCurrency.removeAllItems();
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, false, true);
    }

    private void addListeners() {
        this.periodTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PaReportFilter1UI.this.refreshPeriod(true);
                    PaReportFilter1UI.this.refreshPeriod(false);
                    PaReportFilter1UI.this.initOrgTreeCombo();
                    PaReportFilter1UI.this.refreshCompany();
                }
            }
        });
        this.endYearSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaReportFilter1UI.this.initOrgTreeCombo();
                PaReportFilter1UI.this.refreshCompany();
            }
        });
        this.endPeriodSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaReportFilter1UI.this.initOrgTreeCombo();
                PaReportFilter1UI.this.refreshCompany();
            }
        });
        this.orgTreeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReportFilter1UI.this.listOrgBound_actionPerformed(e);
            }
        });
    }

    private void listOrgBound_actionPerformed(ActionEvent e) {
        if (e != null) {
            this.refreshCompany();
        }
    }

    private void refreshPeriod(boolean isRefreshStart) {
        KDSpinner yearSpin = this.endYearSpin;
        KDSpinner periodSpin = this.endPeriodSpin;
        if (isRefreshStart) {
            yearSpin = this.startYearSpin;
            periodSpin = this.startPeriodSpin;
        }
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        PaRptClientUtil.setPeriodRange(periodSpin, periodType.getValue(), (Integer)yearSpin.getValue(), this.isSupport13Period);
        int[] period = PaRptClientUtil.getLastPeriod(periodType);
        periodSpin.setValue((Object)new Integer(period[1]), false);
    }

    private void initOrgTreeCombo() {
        try {
            Date rptDate = this.getRptDate();
            PaRptClientUtil.initOrgTreeCombox(this.orgTreeCombo, rptDate);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void refreshCompany() {
        OrgTreeInfo orgTreeInfo = null;
        this.orgUnitPromp.setValue(null);
        if (this.orgTreeCombo.getSelectedItem() != null) {
            orgTreeInfo = (OrgTreeInfo)this.orgTreeCombo.getSelectedItem();
            UnionF7 oldf7 = (UnionF7)this.orgUnitPromp.getSelector();
            UnionF7 f7 = new UnionF7((IUIObject)this);
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                f7.setTreeID(orgTreeInfo.getId().toString());
            } else {
                f7 = oldf7;
            }
            HashMap map = null;
            try {
                String key;
                if (this.perUnionUnitsMap == null) {
                    this.perUnionUnitsMap = new HashMap(4);
                }
                if (this.perUnionUnitsMap.containsKey(key = orgTreeInfo.getId().toString() + this.getUserId())) {
                    map = (HashMap)this.perUnionUnitsMap.get(key);
                } else {
                    map = (HashMap)PermissionFactory.getRemoteInstance().getUnionUnits(CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), CslRptUtil.getPK((IObjectValue)orgTreeInfo));
                    this.perUnionUnitsMap.put(key, map);
                }
            }
            catch (EASBizException e) {
                super.handUIException((Throwable)e);
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
                logger.error((Object)"", (Throwable)e);
            }
            f7.disablePerm(map, true);
            f7.setSelectMode(2);
            this.orgUnitPromp.setSelector((KDPromptSelector)f7);
            this.orgUnitPromp.setEnabled(true);
        } else {
            this.orgUnitPromp.setEnabled(false);
        }
    }

    public FilterInfo getFilterInfo() {
        FullOrgUnitInfo orgUnitInfo;
        FilterInfo filterInfo = new FilterInfo();
        int formularIndex = 0;
        StringBuffer maskString = new StringBuffer();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        FilterItemInfo filterItemPeriodType = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()));
        filterInfo.getFilterItems().add(filterItemPeriodType);
        maskString.append("#").append(formularIndex++);
        Integer startYear = (Integer)this.startYearSpin.getValue();
        Integer endYear = (Integer)this.endYearSpin.getValue();
        Integer startPeriod = (Integer)this.startPeriodSpin.getValue();
        Integer endPeriod = (Integer)this.endPeriodSpin.getValue();
        FilterItemInfo year1 = new FilterItemInfo("year", (Object)startYear, CompareType.GREATER);
        FilterItemInfo year2 = new FilterItemInfo("year", (Object)startYear);
        FilterItemInfo year3 = new FilterItemInfo("year", (Object)endYear, CompareType.LESS);
        FilterItemInfo year4 = new FilterItemInfo("year", (Object)endYear);
        FilterItemInfo period1 = new FilterItemInfo("period", (Object)startPeriod, CompareType.GREATER_EQUALS);
        FilterItemInfo period2 = new FilterItemInfo("period", (Object)endPeriod, CompareType.LESS_EQUALS);
        filterInfo.getFilterItems().add(year1);
        filterInfo.getFilterItems().add(year2);
        filterInfo.getFilterItems().add(period1);
        filterInfo.getFilterItems().add(year3);
        filterInfo.getFilterItems().add(year4);
        filterInfo.getFilterItems().add(period2);
        maskString.append(" and (#").append(formularIndex++);
        maskString.append(" \tor (#").append(formularIndex++);
        maskString.append(" \t\tand #").append(formularIndex++).append("))");
        maskString.append(" and (#").append(formularIndex++);
        maskString.append(" \tor (#").append(formularIndex++);
        maskString.append(" \t\tand #").append(formularIndex++).append("))");
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.orgTreeCombo.getSelectedItem();
        if (orgTreeInfo != null) {
            FilterItemInfo itemInfo = new FilterItemInfo("orgTree.id", (Object)orgTreeInfo.getId().toString());
            filterInfo.getFilterItems().add(itemInfo);
            maskString.append(" and #").append(formularIndex++);
        }
        if ((orgUnitInfo = (FullOrgUnitInfo)this.orgUnitPromp.getValue()) != null) {
            FilterItemInfo itemInfo = new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString());
            filterInfo.getFilterItems().add(itemInfo);
            maskString.append(" and #").append(formularIndex++);
        }
        if (!selectAll.equals(this.comboCurrency.getSelectedItem())) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            FilterItemInfo itemInfo = new FilterItemInfo("currency.id", (Object)currencyInfo.getId().toString());
            filterInfo.getFilterItems().add(itemInfo);
            maskString.append(" and #").append(formularIndex++);
        }
        filterInfo.setMaskString(maskString.toString());
        return filterInfo;
    }

    public void loadData(EntityViewInfo v) {
        super.loadData(v);
        this.clear();
        FilterItemCollection filterItems = v.getFilter() == null ? new FilterItemCollection() : v.getFilter().getFilterItems();
        try {
            for (int i = 0; i < filterItems.size(); ++i) {
                String pk;
                FilterItemInfo item = filterItems.get(i);
                if (item.getPropertyName().equalsIgnoreCase("currency.id")) {
                    pk = (String)item.getCompareValue();
                    this.setSelectItem(this.comboCurrency, pk);
                    continue;
                }
                if (item.getPropertyName().equalsIgnoreCase("orgTree.id")) {
                    pk = (String)item.getCompareValue();
                    this.setSelectItem(this.orgTreeCombo, pk);
                    continue;
                }
                if (item.getPropertyName().equalsIgnoreCase("orgUnit.id")) {
                    pk = (String)item.getCompareValue();
                    FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
                    this.orgUnitPromp.setValue((Object)orgUnitInfo);
                    continue;
                }
                if (item.getPropertyName().equalsIgnoreCase("periodType")) {
                    Integer periodTypeInt = (Integer)item.getCompareValue();
                    this.periodTypeCombo.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)periodTypeInt));
                    continue;
                }
                if (item.getPropertyName().equalsIgnoreCase("year")) {
                    if (CompareType.GREATER_EQUALS.equals((Object)item.getCompareType())) {
                        this.startYearSpin.setValue(item.getCompareValue());
                        continue;
                    }
                    if (!CompareType.LESS_EQUALS.equals((Object)item.getCompareType())) continue;
                    this.endYearSpin.setValue(item.getCompareValue());
                    continue;
                }
                if (!item.getPropertyName().equalsIgnoreCase("period")) continue;
                if (CompareType.GREATER_EQUALS.equals((Object)item.getCompareType())) {
                    this.startPeriodSpin.setValue(item.getCompareValue());
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)item.getCompareType())) continue;
                this.endPeriodSpin.setValue(item.getCompareValue());
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void setSelectItem(KDComboBox box, String id) {
        int count = box.getItemCount();
        for (int i = 0; i < count; ++i) {
            CoreBaseInfo info;
            if (box.getItemAt(i).equals(selectAll) || !id.equals((info = (CoreBaseInfo)box.getItemAt(i)).getId().toString())) continue;
            box.setSelectedIndex(i, false);
            break;
        }
    }

    private Date getRptDate() {
        int year = (Integer)this.endYearSpin.getValue();
        int period = (Integer)this.endPeriodSpin.getValue();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        return RPTDateUtil.getPeriodLastDate(year, period, periodType);
    }

    public void clear() {
        super.clear();
        this.initData();
        this.initOrgTreeCombo();
        this.refreshCompany();
    }

    protected void setIsSupport13Period(boolean isSupport13Period) {
        this.isSupport13Period = isSupport13Period;
    }

    private String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }
}

