/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client;

import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.pa.PaReportInfo;
import com.kingdee.eas.fi.gr.pa.PaReportPropertyAdapter;
import com.kingdee.eas.fi.gr.pa.client.AbstractPaReportProcessUI;
import com.kingdee.eas.fi.gr.pa.client.PaReportListUI;
import com.kingdee.eas.fi.gr.pa.client.report.InsertCompanyListener;
import com.kingdee.eas.fi.gr.pa.client.report.PaReportMenuManger;
import com.kingdee.eas.fi.gr.pa.client.report.PaReportProvider;
import com.kingdee.eas.fi.gr.pa.client.rptguide.PaReportGuide;
import com.kingdee.eas.fi.gr.pa.client.rptguide.PaRptFillHelper;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.ReportStyleCover;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class PaReportProcessUI
extends AbstractPaReportProcessUI {
    private static final long serialVersionUID = -6104715890112389929L;
    private static final Logger logger = CoreUIObject.getLogger(PaReportProcessUI.class);
    private PaReportGuide paReportGuide;

    public PaReportProcessUI() throws Exception {
        this.setBookProvider(new PaReportProvider());
        this.setPropertyAdapter(new PaReportPropertyAdapter());
        this.setMenuStrategy((IMenuStrategy)new PaReportMenuManger());
        this.setVariableProvider(new IReportVariableProvider(){

            public void initSheetDefaultVariable(String sheetName, ReportVariables variables) {
                ReportVariables init = VariablesHelper.initSheetReservedVariables((String)sheetName, (RptPeriodTypeEnum)PaReportProcessUI.this.getPaReportProvider().getPaReportInfo().getPeriodType());
                variables.addAll(init, false);
            }

            public void initReportDefaultVariable(ReportVariables variables) {
            }
        });
        this.setReportStyleCover(new ReportStyleCover(){

            public TemplateCollection GetCanUseTemplateSet() throws Exception {
                return null;
            }
        });
    }

    public void onLoad() throws Exception {
        this.parseContext();
        super.onLoad();
        this.actionCreatePaRpt.setEnabled(true);
        PaRptFillHelper.addPaTableAction(this.getSpreadManager().getSpreadContainer().getActionManager(), this.getPaReportProvider());
        this.getSpreadManager().addKDSBlockInvalidListener((SheetChangeListener)new InsertCompanyListener((IUIObject)this));
    }

    private void parseContext() {
        Map uiContext = this.getUIContext();
        Object rptInfo = uiContext.get(PaReportInfo.class);
        if (rptInfo == null) {
            rptInfo = uiContext.get("InitDataObject");
        }
        if (rptInfo != null && rptInfo instanceof PaReportInfo) {
            rptInfo = ((PaReportInfo)rptInfo).clone();
            this.getBookProvider().setEditValue((IObjectValue)((PaReportInfo)rptInfo));
            uiContext.put("InitDataObject", rptInfo);
        }
    }

    private PaReportProvider getPaReportProvider() {
        return (PaReportProvider)this.getBookProvider();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private PaReportInfo getReportInfo() {
        PaReportInfo editValue = (PaReportInfo)this.getPaReportProvider().getEditValue();
        editValue.setSourceType(RptSrcTypeEnum.PAREPORT);
        return editValue;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        PaReportInfo reportInfo = this.getReportInfo();
        this.getBookProvider().restoreBook(this.getBook());
        reportInfo.setBook(this.getBook());
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            reportInfo.setId(null);
        }
        super.actionSave_actionPerformed(e);
        this.refreshParentList();
    }

    public void onShow() {
        super.onShow();
        this.getSpreadManager().setItemFormulaEnable(true);
        this.getSpreadManager().setItemFormulaShowModel(1);
        this.hideAction();
        IUIWindow window = this.getUIWindow();
        if (OprtState.EDIT.equals(this.getOprtState()) && window instanceof Window) {
            ((Window)window).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (PaReportProcessUI.this.getReportInfo().isIsOpenAutoCalc()) {
                        try {
                            PaReportProcessUI.this.actionCalculate_actionPerformed(null);
                        }
                        catch (Exception ee) {
                            PaReportProcessUI.super.handleException(ee);
                        }
                    }
                }
            });
        }
    }

    private void hideAction() {
        this.menuFind.setVisible(false);
        this.itemCheckFormula.setVisible(false);
        this.itemItemDiffer.setVisible(false);
        this.itemCheckAll.setVisible(false);
        this.itemCompanyFill.setVisible(false);
        this.actionToolsCompanyFill.setVisible(false);
        this.actionInvestCompanyFill.setVisible(false);
        this.miInvestCompanyFill.setVisible(false);
        this.menuItemSheeSum.setVisible(false);
        this.menuItemAutoFillAndCalculateAllSheet.setVisible(false);
        this.menuItemAutoFillAndCalculateSelectedSheet.setVisible(false);
        this.actionToolsRptAudit.setVisible(false);
        this.actionToolsRptCommit.setVisible(false);
        this.actionToolsRptUnCommit.setVisible(false);
        this.menuItemCalculator.setEnabled(true);
        this.menuItemCalculator.setVisible(true);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        this.hideAction();
    }

    protected void onSheetActive(Sheet sheet) {
        super.onSheetActive(sheet);
        this.hideAction();
    }

    private void refreshParentList() throws Exception {
        Map ctx = this.getUIContext();
        Object owner = ctx.get("Owner");
        if (owner instanceof PaReportListUI) {
            ((PaReportListUI)((Object)owner)).refreshList();
        } else if (owner instanceof PaReportProcessUI && (owner = ((PaReportProcessUI)((Object)owner)).getUIContext().get("Owner")) instanceof PaReportListUI) {
            ((PaReportListUI)((Object)owner)).refreshList();
        }
    }

    protected void checkCanUpdateTemplate() throws Exception {
    }

    protected void releaseNetControl() {
        if (this.getReportInfo().getId() == null) {
            return;
        }
        super.releaseNetControl();
    }

    public void actionToolsDynaItemFillWizard_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionCreatePaRpt_actionPerformed(ActionEvent e) throws Exception {
        boolean isConfirm;
        super.actionCreatePaRpt_actionPerformed(e);
        if (this.paReportGuide == null) {
            this.paReportGuide = new PaReportGuide((IUIObject)this);
        }
        if (isConfirm = this.paReportGuide.show()) {
            logger.info((Object)" fill paReport begin");
            PaRptFillHelper.fillSheet(this.getBook().getActiveSheet(), this.paReportGuide.getFillData());
            PaRptFillHelper.fillAcctItem(this.getBook().getActiveSheet(), (IObjectValue)this.getReportInfo());
            logger.info((Object)" fill paReport end");
            this.repaint();
        }
    }

    @Override
    public void actionItem2AcctItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionItem2AcctItem_actionPerformed(e);
        PaRptFillHelper.fillAcctItem(this.getBook().getActiveSheet(), (IObjectValue)this.getReportInfo());
        this.repaint();
    }
}

