/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fi.gr.pa.PaRptTmpTypeEnum;
import com.kingdee.eas.fi.gr.pa.client.AbstractPaTemplateFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class PaTemplateFilterUI
extends AbstractPaTemplateFilterUI {
    private static final long serialVersionUID = 4173002611616710000L;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        Calendar calendar;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        if (this.comboTemplateType.getSelectedItem() != null) {
            PaRptTmpTypeEnum templateType = (PaRptTmpTypeEnum)((Object)this.comboTemplateType.getSelectedItem());
            FilterItemInfo filterItemTemplateType = new FilterItemInfo("templateType", (Object)new Integer(templateType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTemplateType);
            ++formulaIndex;
        }
        if (this.txtTemplateNumber.getText() != null && this.txtTemplateNumber.getText().trim().length() > 0) {
            FilterItemInfo filterItemNumber = new FilterItemInfo("number", (Object)this.txtTemplateNumber.getText().trim(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemNumber);
            ++formulaIndex;
        }
        if (this.txtTemplateName.getText() != null && this.txtTemplateName.getText().trim().length() > 0) {
            FilterItemInfo filterItemName = new FilterItemInfo("name", (Object)("%" + this.txtTemplateName.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(filterItemName);
            ++formulaIndex;
        }
        if (this.pkDateStart.getValue() != null) {
            Date startDate = (Date)this.pkDateStart.getValue();
            calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            Timestamp startTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterItemStartDate = new FilterItemInfo("lastUpdateTime", (Object)startTime, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemStartDate);
            ++formulaIndex;
        }
        if (this.pkDateEnd.getValue() != null) {
            Date endDate = (Date)this.pkDateEnd.getValue();
            calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            Timestamp endTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterItemEndDate = new FilterItemInfo("lastUpdateTime", (Object)endTime, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemEndDate);
            ++formulaIndex;
        }
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < formulaIndex; ++i) {
            if (i == 0) {
                sbFormula.append(" (#0)");
                continue;
            }
            sbFormula.append(" and (#" + i + ")");
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.clearUI();
    }

    public void loadData(EntityViewInfo view) {
        this.clearUI();
        super.loadData(view);
        FilterItemCollection fic = view.getFilter() == null ? new FilterItemCollection() : view.getFilter().getFilterItems();
        for (int i = 0; i < fic.size(); ++i) {
            FilterItemInfo filterItemInfo = fic.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("templateType")) {
                Integer templateTypeInt = (Integer)filterItemInfo.getCompareValue();
                PaRptTmpTypeEnum templateType = PaRptTmpTypeEnum.getEnum(templateTypeInt);
                this.comboTemplateType.setSelectedItem((Object)templateType);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("name")) {
                String templateName = (String)filterItemInfo.getCompareValue();
                if (templateName.startsWith("%")) {
                    templateName = templateName.substring(1);
                }
                if (templateName.endsWith("%")) {
                    templateName = templateName.substring(0, templateName.length() - 1);
                }
                this.txtTemplateName.setText(templateName);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (number.startsWith("%")) {
                    number = number.substring(1);
                }
                if (number.endsWith("%")) {
                    number = number.substring(0, number.length() - 1);
                }
                this.txtTemplateNumber.setText(number);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("lastUpdateTime")) continue;
            Date time = (Date)filterItemInfo.getCompareValue();
            if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                this.pkDateStart.setValue((Object)new Date(time.getTime()));
                continue;
            }
            if (!CompareType.LESS_EQUALS.equals((Object)filterItemInfo.getCompareType())) continue;
            this.pkDateEnd.setValue((Object)new Date(time.getTime()));
        }
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    private void clearUI() {
        this.comboTemplateType.setSelectedIndex(0);
        this.txtTemplateNumber.setText("");
        this.txtTemplateName.setText("");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calendar.get(1) - 1);
        this.pkDateStart.setValue((Object)calendar.getTime());
        calendar = Calendar.getInstance();
        this.pkDateEnd.setValue((Object)calendar.getTime());
    }

    @Override
    protected void pkDateStart_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isShowing()) {
            return;
        }
        super.pkDateStart_dataChanged(e);
        Date dStart = DateTimeUtils.truncateDate((Date)this.pkDateStart.getTimestamp());
        Date dEnd = DateTimeUtils.truncateDate((Date)this.pkDateEnd.getTimestamp());
        if (dStart != null && dEnd != null && dStart.after(dEnd)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"StartBigEnd"));
            this.pkDateStart.setValue((Object)dEnd);
        }
    }

    @Override
    protected void pkDateEnd_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isShowing()) {
            return;
        }
        super.pkDateEnd_dataChanged(e);
        Date dStart = DateTimeUtils.truncateDate((Date)this.pkDateStart.getTimestamp());
        Date dEnd = DateTimeUtils.truncateDate((Date)this.pkDateEnd.getTimestamp());
        if (dStart != null && dEnd != null && dStart.after(dEnd)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"StartBigEnd"));
            this.pkDateEnd.setValue((Object)dStart);
        }
    }
}

