/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client.rptguide;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.pa.PaRptClientUtil;
import com.kingdee.eas.fi.gr.pa.client.rptguide.AbstractCompanyTabUI;
import com.kingdee.eas.fi.gr.pa.client.rptguide.CompanyF7Dialog;
import com.kingdee.eas.fi.gr.pa.client.rptguide.PaRptFillHelper;
import com.kingdee.eas.fi.gr.pa.rptguide.CompanyTabCollection;
import com.kingdee.eas.fi.gr.pa.rptguide.CompanyTabInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class CompanyTabUI
extends AbstractCompanyTabUI {
    private static final long serialVersionUID = -8341962285696715147L;
    private static final Logger logger = CoreUIObject.getLogger(CompanyTabUI.class);
    private static final String COMPANYTABLE_RptSrcType = "source";
    private static final String COMPANYTABLE_Company = "name";
    private boolean perIsShowName;
    private List bizUserCUOrgRange;
    private boolean isAdmin;
    private List userOrgRangeList;
    private Set selectedOrgs;
    private IObjectPK currentUserPK;

    public void onLoad() throws Exception {
        super.onLoad();
        this.remove((Component)this.btnMoveUp);
        this.remove((Component)this.btnMoveDown);
        this.remove((Component)this.selectCompany);
        this.remove((Component)this.btnDel);
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.selectCompany.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDContainer1.addButton((JButton)this.selectCompany);
        this.kDContainer1.addButton((JButton)this.btnMoveUp);
        this.kDContainer1.addButton((JButton)this.btnMoveDown);
        this.kDContainer1.addButton((JButton)this.btnDel);
        this.kDContainer1.setEnableActive(false);
        this.showName.setSelected(true);
        this.perIsShowName = true;
        this.companyTable.checkParsed();
        KDComboBox srcTypeEnum = new KDComboBox();
        srcTypeEnum.addItem((Object)RptSrcTypeEnum.COMMITREPORT);
        srcTypeEnum.addItem((Object)RptSrcTypeEnum.SUM);
        srcTypeEnum.addItem((Object)RptSrcTypeEnum.CONSOLIDATION);
        this.companyTable.getColumn(COMPANYTABLE_RptSrcType).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)srcTypeEnum));
        this.companyTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
            }
        });
        this.companyTable.addKDTEditListener(new KDTEditListener(){

            public void editStopped(KDTEditEvent e) {
                if (e.getValue() != null && e.getOldValue() == e.getValue()) {
                    return;
                }
                CompanyTabUI.this.companyTable.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getValue());
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editStarting(KDTEditEvent e) {
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public FilterInfo getFilterInfo() {
        if (this.companyTable.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("15_CompanyNull"));
            SysUtil.abort();
        }
        return this.getViewFilterInfo();
    }

    protected FilterInfo getViewFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        boolean isShowName = this.showName.isSelected();
        FilterItemInfo itemInfo0 = new FilterItemInfo("isShowName", (Object)(isShowName ? "true" : "false"));
        filterInfo.getFilterItems().add(itemInfo0);
        CompanyTabCollection c = new CompanyTabCollection(this.companyTable.getRowCount());
        for (int i = 0; i < this.companyTable.getRowCount(); ++i) {
            IRow row = this.companyTable.getRow(i);
            CompanyTabInfo companyTabInfo = (CompanyTabInfo)row.getUserObject();
            companyTabInfo.setShowString(row.getCell(COMPANYTABLE_Company).getValue().toString());
            companyTabInfo.setSrcTypeEnum((RptSrcTypeEnum)row.getCell(COMPANYTABLE_RptSrcType).getValue());
            c.add(companyTabInfo);
        }
        FilterItemInfo itemInfo = new FilterItemInfo("companyTable", (Object)c.toString());
        filterInfo.getFilterItems().add(itemInfo);
        filterInfo.setMaskString("#0 and #1");
        return filterInfo;
    }

    public void loadData(EntityViewInfo v) {
        super.loadData(v);
        this.clear();
        FilterItemCollection filterItems = v.getFilter() == null ? new FilterItemCollection() : v.getFilter().getFilterItems();
        try {
            for (int i = 0; i < filterItems.size(); ++i) {
                boolean isShowName;
                FilterItemInfo item = filterItems.get(i);
                if (item.getPropertyName().equalsIgnoreCase("companyTable")) {
                    CompanyTabCollection c = CompanyTabCollection.parse(item.getCompareValue().toString());
                    PaRptClientUtil.addArrayValueToTable(this.companyTable, c.toArray());
                }
                if (!item.getPropertyName().equalsIgnoreCase("isShowName")) continue;
                this.perIsShowName = isShowName = "true".equals(item.getCompareValue());
                if (isShowName) {
                    this.showName.setSelected(true, false);
                    continue;
                }
                this.showNumberAndName.setSelected(true, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public void clear() {
        super.clear();
        this.companyTable.removeRows();
        this.showName.setSelected(true, false);
        this.perIsShowName = true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void beforeSelectCompany() throws Exception {
        if (this.bizUserCUOrgRange == null) {
            this.selectedOrgs = new HashSet();
            this.currentUserPK = ToolUtils.getCurrentUserPK();
            this.bizUserCUOrgRange = PermissionRangeHelper.getBizUserCUOrgRange(null, (IObjectPK)this.currentUserPK);
            this.isAdmin = Administrator.isCUAdmin(null, (IObjectPK)this.currentUserPK);
            this.userOrgRangeList = PermissionRangeHelper.getUserOrgId(null, (IObjectPK)this.currentUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
        }
    }

    @Override
    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        this.beforeSelectCompany();
        CompanyF7Dialog orgF7 = PaRptFillHelper.getOUUnionF7((IUIObject)this, this.selectedOrgs, true, "00000000-0000-0000-0000-000000000000CCE7AED4", this.bizUserCUOrgRange, this.isAdmin, this.userOrgRangeList, true);
        FullOrgUnitInfo[] fullOrgUnitInfos = null;
        orgF7.show();
        if (!orgF7.isCanceled()) {
            fullOrgUnitInfos = ToolUtils.transFromOrgUnitInfo((OrgUnitInfo[])((OrgUnitInfo[])orgF7.getData()));
            this.fillCompanyTable(fullOrgUnitInfos);
        }
    }

    private void fillCompanyTable(FullOrgUnitInfo[] fullOrgUnitInfos) {
        if (fullOrgUnitInfos == null) {
            return;
        }
        CompanyTabCollection c = new CompanyTabCollection(fullOrgUnitInfos.length);
        boolean isShowName = this.showName.isSelected();
        for (int i = 0; i < fullOrgUnitInfos.length; ++i) {
            CompanyTabInfo companyTabInfo = new CompanyTabInfo();
            companyTabInfo.setFullOrgUnitInfo(fullOrgUnitInfos[i]);
            if (isShowName) {
                companyTabInfo.setShowString(fullOrgUnitInfos[i].getName());
            } else {
                companyTabInfo.setShowString(fullOrgUnitInfos[i].getNumber() + fullOrgUnitInfos[i].getName());
            }
            c.add(companyTabInfo);
        }
        PaRptClientUtil.addArrayValueToTable(this.companyTable, c.toArray());
    }

    @Override
    public void actionShow_actionPerformed(ActionEvent e) throws Exception {
        super.actionShow_actionPerformed(e);
        boolean isShowName = this.showName.isSelected();
        if (isShowName) {
            if (!this.perIsShowName) {
                for (int i = 0; i < this.companyTable.getRowCount(); ++i) {
                    IRow row = this.companyTable.getRow(i);
                    CompanyTabInfo companyTabInfo = (CompanyTabInfo)row.getUserObject();
                    row.getCell(COMPANYTABLE_Company).setValue((Object)companyTabInfo.getName());
                    companyTabInfo.setShowString(companyTabInfo.getName());
                }
            }
        } else if (this.perIsShowName) {
            for (int i = 0; i < this.companyTable.getRowCount(); ++i) {
                IRow row = this.companyTable.getRow(i);
                CompanyTabInfo companyTabInfo = (CompanyTabInfo)row.getUserObject();
                String str = companyTabInfo.getNumber() + companyTabInfo.getName();
                row.getCell(COMPANYTABLE_Company).setValue((Object)str);
                companyTabInfo.setShowString(str);
            }
        }
        this.perIsShowName = isShowName;
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUp_actionPerformed(e);
        PaRptClientUtil.moveUp(this.companyTable);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        PaRptClientUtil.moveDown(this.companyTable);
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        super.actionDel_actionPerformed(e);
        PaRptClientUtil.deleteKdTableSelectedRows(this.companyTable);
    }
}

