/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client.rptguide;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.pa.PaReportInfo;
import com.kingdee.eas.fi.gr.pa.PaRptClientUtil;
import com.kingdee.eas.fi.gr.pa.PaTemplateInfo;
import com.kingdee.eas.fi.gr.pa.client.report.PaTableAfterAction;
import com.kingdee.eas.fi.gr.pa.client.report.PaTableBeforeAction;
import com.kingdee.eas.fi.gr.pa.client.rptguide.CompanyF7Dialog;
import com.kingdee.eas.fi.gr.pa.rptguide.CompanyTabCollection;
import com.kingdee.eas.fi.gr.pa.rptguide.CompanyTabInfo;
import com.kingdee.eas.fi.gr.pa.rptguide.ItemTabCollection;
import com.kingdee.eas.fi.gr.pa.rptguide.ItemTabInfo;
import com.kingdee.eas.fi.gr.pa.rptguide.PaRptFillinfo;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class PaRptFillHelper {
    public static final String FILTER_ITEMTABLE = "itemTable";
    public static final String FILTER_COMPANYTABLE = "companyTable";
    public static final String FILTER_COMPANYSHOWTYPE = "isShowName";
    public static final String FILTER_POINT = "point";
    public static final String FILTER_YEAR = "year";
    public static final String FILTER_PERIOD = "period";
    public static final String FILTER_FILLTYPE = "filltype";
    public static final String ITEM_COMPANY_ID = "companyid";
    public static final String ITEM_COMPANY_NUMBER = "companynumber";
    public static final String ITEM_COMPANY_SOURCE = "datasource";
    public static final String POINT_FillType = "fillType";
    public static final String POINT_ITEMSIZE = "ITEMSIZE";
    public static final String POINT_COMPANYSIZE = "COMPANYSIZE";
    public static final String POINT_COMPANYSHOWTYPE = "COMPANYSHOWTYPE";

    public static PaRptFillinfo makePaRptFillinfo(EntityViewInfo v) {
        PaRptFillinfo paRptFillinfo = new PaRptFillinfo();
        if (v == null || v.getFilter() == null) {
            return paRptFillinfo;
        }
        FilterItemCollection filterItems = v.getFilter().getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo item = filterItems.get(i);
            if (item.getPropertyName().equalsIgnoreCase(FILTER_COMPANYTABLE)) {
                CompanyTabCollection c = CompanyTabCollection.parse(item.getCompareValue().toString());
                paRptFillinfo.setCompanyTabColl(c);
            }
            if (item.getPropertyName().equalsIgnoreCase(FILTER_ITEMTABLE)) {
                String value = item.getCompareValue().toString();
                paRptFillinfo.setItemTabColl(ItemTabCollection.parse(value));
            }
            if (item.getPropertyName().equalsIgnoreCase(FILTER_COMPANYSHOWTYPE)) {
                boolean isShowName = "true".equals(item.getCompareValue());
                paRptFillinfo.setCompanyShowType(isShowName ? 0 : 1);
            }
            if (item.getPropertyName().equalsIgnoreCase(FILTER_POINT)) {
                String value = item.getCompareValue().toString();
                paRptFillinfo.setPoint(value);
            }
            if (item.getPropertyName().equalsIgnoreCase(FILTER_YEAR)) {
                paRptFillinfo.setYear(Integer.valueOf(item.getCompareValue().toString()));
            }
            if (item.getPropertyName().equalsIgnoreCase(FILTER_PERIOD)) {
                paRptFillinfo.setPeriod(Integer.valueOf(item.getCompareValue().toString()));
            }
            if (!item.getPropertyName().equalsIgnoreCase(FILTER_FILLTYPE)) continue;
            boolean b = "true".equals(item.getCompareValue());
            paRptFillinfo.setFillType(b ? 0 : 1);
        }
        return paRptFillinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillSheet(Sheet sheet, PaRptFillinfo rptFillinfo) {
        if (sheet == null || rptFillinfo == null || rptFillinfo.getPoint() == null) {
            return;
        }
        try {
            sheet.getBook().setSkipListeners(true);
            sheet.getBook().getUndoManager().startGroup();
            sheet.getBook().getUndoManager().enable(false);
            CslRptUIUtil.clearSheet(sheet, false, true);
            Point basePoint = PaRptFillHelper.getStartPos(sheet, rptFillinfo.getPoint());
            int colIndex = basePoint.x;
            int rowIndex = basePoint.y;
            CslRptUtil.saveBasePosition(sheet, colIndex, rowIndex);
            PaRptFillHelper.saveFillInfo(sheet, colIndex, rowIndex, rptFillinfo);
            PaRptFillHelper.fillRptItem(basePoint, sheet, rptFillinfo);
            PaRptFillHelper.fillCompany(basePoint, sheet, rptFillinfo);
        }
        finally {
            sheet.getBook().setSkipListeners(false);
            sheet.getBook().getUndoManager().endGroup();
            sheet.getBook().getUndoManager().enable(true);
        }
    }

    private static void saveFillInfo(Sheet sheet, int iLeft, int iTop, PaRptFillinfo rptFillinfo) {
        Range range = sheet.getRange(iTop, iLeft);
        if (range != null) {
            ItemFormula f = (ItemFormula)range.getUserObject("ITEM");
            f.putExt(POINT_FillType, rptFillinfo.getFillType() + "");
            f.putExt(POINT_ITEMSIZE, rptFillinfo.getItemTabColl().size() + "");
            f.putExt(POINT_COMPANYSIZE, rptFillinfo.getCompanyTabColl().size() + "");
            f.putExt(POINT_COMPANYSHOWTYPE, rptFillinfo.getCompanyShowType() + "");
        }
    }

    public static void fillCompany(Point basePoint, Sheet sheet, PaRptFillinfo rptFillinfo) {
        int colIndex = basePoint.x;
        int rowIndex = basePoint.y;
        CompanyTabCollection companys = rptFillinfo.getCompanyTabColl();
        Cell cell = null;
        Range range = null;
        for (int i = 0; i < companys.size(); ++i) {
            CompanyTabInfo companyTabInfo = companys.get(i);
            cell = rptFillinfo.getFillType() == 0 ? sheet.getCell(++rowIndex, colIndex, true) : sheet.getCell(rowIndex, ++colIndex, true);
            range = sheet.getRange(cell);
            range.setIgnoreProtected(true);
            range.setValue(new Variant((Object)companyTabInfo.getShowString()));
            ItemFormula itemFormula = new ItemFormula();
            itemFormula.putExt(ITEM_COMPANY_ID, companyTabInfo.getId());
            itemFormula.putExt(ITEM_COMPANY_NUMBER, companyTabInfo.getNumber());
            itemFormula.putExt(ITEM_COMPANY_SOURCE, companyTabInfo.getSrcTypeEnum().getName());
            range.setUserObject("ITEM", (Object)itemFormula);
            range.setIgnoreProtected(false);
        }
    }

    public static void fillRptItem(Point basePoint, Sheet sheet, PaRptFillinfo rptFillinfo) {
        int colIndex = basePoint.x;
        int rowIndex = basePoint.y;
        ItemTabCollection coll = rptFillinfo.getItemTabColl();
        Cell cell = null;
        for (int i = 0; i < coll.size(); ++i) {
            ItemTabInfo info = coll.get(i);
            RPTItemInfo rptItem = info.getRPTItemInfo();
            DataElementInfo dataElement = info.getDataElementInfo();
            ValueTypeEnum valueType = info.getValueType();
            cell = rptFillinfo.getFillType() == 0 ? sheet.getCell(rowIndex, ++colIndex, true) : sheet.getCell(++rowIndex, colIndex, true);
            StringBuffer formulaString = new StringBuffer();
            formulaString.append("=Item(\"").append(rptItem.getNumber());
            formulaString.append("\",");
            formulaString.append(rptFillinfo.getYear()).append(",");
            formulaString.append(rptFillinfo.getPeriod()).append(",\"");
            formulaString.append(dataElement.getNumber()).append("\",\"");
            formulaString.append(valueType.getName()).append("\")");
            ItemFormula itemFormula = new ItemFormula(formulaString.toString());
            cell.setUserObject("ITEM", (Object)itemFormula);
            String displayName = rptItem.getName() + "/" + dataElement.getName() + "/" + valueType.getAlias();
            cell.setValue(new Variant((Object)displayName));
        }
    }

    private static Point getBasePoint(Sheet sheet) {
        HashMap basePosition = CslRptUtil.getBasePosition(sheet);
        if (basePosition == null) {
            return null;
        }
        int colIndex = (Integer)basePosition.get("left");
        int rowIndex = (Integer)basePosition.get("top");
        Range pointRange = sheet.getRange(rowIndex, colIndex);
        if (pointRange == null) {
            return null;
        }
        return new Point(colIndex, rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillAcctItem(Sheet sheet, IObjectValue objectValue) {
        if (sheet == null || objectValue == null || !(objectValue instanceof PaReportInfo) && !(objectValue instanceof PaTemplateInfo)) {
            return;
        }
        Point point = PaRptFillHelper.getBasePoint(sheet);
        if (point == null) {
            return;
        }
        int rowIndex = point.y;
        int colIndex = point.x;
        Range pointRange = sheet.getRange(rowIndex, colIndex);
        if (pointRange == null) {
            return;
        }
        sheet.getBook().setSkipListeners(true);
        sheet.getBook().getUndoManager().startGroup();
        sheet.getBook().getUndoManager().enable(false);
        try {
            ItemFormula pointFor = (ItemFormula)pointRange.getUserObject("ITEM");
            int fillType = Integer.valueOf(pointFor.getExt(POINT_FillType));
            int itemSize = Integer.valueOf(pointFor.getExt(POINT_ITEMSIZE));
            int companySize = Integer.valueOf(pointFor.getExt(POINT_COMPANYSIZE));
            if (fillType == 0) {
                for (int i = colIndex + 1; i < itemSize + colIndex + 1; ++i) {
                    Range itemRang = sheet.getRange(rowIndex, i);
                    ItemFormula itemFormula = (ItemFormula)itemRang.getUserObject("ITEM");
                    if (itemFormula == null) continue;
                    for (int j = rowIndex + 1; j < companySize + rowIndex + 1; ++j) {
                        Range companyRang = sheet.getRange(j, colIndex);
                        ItemFormula companyFormula = (ItemFormula)companyRang.getUserObject("ITEM");
                        if (companyFormula == null) continue;
                        Cell cell = sheet.getCell(j, i, true);
                        Range range = sheet.getRange(cell);
                        PaRptFillHelper.fillRange(range, objectValue, itemFormula, companyFormula);
                    }
                }
            } else {
                for (int i = colIndex + 1; i < companySize + colIndex + 1; ++i) {
                    Range companyRang = sheet.getRange(rowIndex, i);
                    ItemFormula companyFormula = (ItemFormula)companyRang.getUserObject("ITEM");
                    if (companyFormula == null) continue;
                    for (int j = rowIndex + 1; j < itemSize + rowIndex + 1; ++j) {
                        Range itemRang = sheet.getRange(j, colIndex);
                        ItemFormula itemFormula = (ItemFormula)itemRang.getUserObject("ITEM");
                        if (itemFormula == null) continue;
                        Cell cell = sheet.getCell(j, i, true);
                        Range range = sheet.getRange(cell);
                        PaRptFillHelper.fillRange(range, objectValue, itemFormula, companyFormula);
                    }
                }
            }
        }
        finally {
            sheet.getBook().setSkipListeners(false);
            sheet.getBook().getUndoManager().endGroup();
            sheet.getBook().getUndoManager().enable(true);
        }
    }

    private static void fillRange(Range range, IObjectValue objectValue, ItemFormula itemFormula, ItemFormula companyFormula) {
        if (range.getFormula() != null && range.isHasFormula()) {
            return;
        }
        range.setIgnoreProtected(true);
        range.setFormula(PaRptFillHelper.createAcctItemExp(objectValue, itemFormula, companyFormula));
        range.setIgnoreProtected(false);
    }

    private static String createAcctItemExp(IObjectValue objectValue, ItemFormula itemFormula, ItemFormula companyFormula) {
        StringBuffer exp = new StringBuffer();
        exp.append("=AcctItem(\"");
        PaReportInfo reportInfo = null;
        if (objectValue instanceof PaReportInfo) {
            reportInfo = (PaReportInfo)objectValue;
        }
        exp.append(reportInfo == null ? "" : reportInfo.getOrgTree().getNumber()).append("\",\"");
        exp.append(companyFormula.getExt(ITEM_COMPANY_NUMBER)).append("\",\"");
        exp.append(reportInfo == null ? "" : reportInfo.getCurrency().getNumber()).append("\",\"");
        exp.append(reportInfo == null ? "" : reportInfo.getCurrency().getNumber()).append("\",\"");
        exp.append(itemFormula.getItemNumber()).append("\",\"");
        exp.append(itemFormula.getItemNumber()).append("\",\"");
        exp.append(reportInfo == null ? "" : reportInfo.getPeriodType().getName()).append("\",");
        exp.append(itemFormula.getYearOffSet()).append(",");
        exp.append(itemFormula.getPeriodOffSet()).append(",");
        exp.append(itemFormula.getPeriodOffSet()).append(",\"");
        exp.append(companyFormula.getExt(ITEM_COMPANY_SOURCE)).append("\",\"");
        exp.append(itemFormula.getDataElementNumber()).append("\",\"");
        exp.append(ValueTypeEnum.getEnum(itemFormula.getValueType()).getName()).append("\",");
        exp.append("True,False,\"\",False)");
        return exp.toString();
    }

    private static Point getStartPos(Sheet sheet, String str) {
        Range range = sheet.getRange(str, true);
        if (range == null || range.getBlock(0).getCol() < 0 || range.getBlock(0).getRow() < 0) {
            MsgBox.showError((String)PaRptClientUtil.getResString("22_pointError"));
            SysUtil.abort();
        }
        return new Point(range.getBlock(0).getCol(), range.getBlock(0).getRow());
    }

    public static void addPaTableAction(ActionManager actions, IBookProvider bookProvider) {
        actions.getAction("Insert_Row").setBeforeAction((NotifyListener)new PaTableBeforeAction("Insert_Row", bookProvider));
        actions.getAction("Delete_Row").setBeforeAction((NotifyListener)new PaTableBeforeAction("Delete_Row", bookProvider));
        actions.getAction("Insert_Col").setBeforeAction((NotifyListener)new PaTableBeforeAction("Insert_Col", bookProvider));
        actions.getAction("Delete_Col").setBeforeAction((NotifyListener)new PaTableBeforeAction("Delete_Col", bookProvider));
        actions.getAction("Cut").setBeforeAction((NotifyListener)new PaTableBeforeAction("Cut", bookProvider));
        actions.getAction("Copy").setBeforeAction((NotifyListener)new PaTableBeforeAction("Copy", bookProvider));
        actions.getAction("Insert_Cell").setBeforeAction((NotifyListener)new PaTableBeforeAction("Insert_Cell", bookProvider));
        actions.getAction("Delete_Cell").setBeforeAction((NotifyListener)new PaTableBeforeAction("Delete_Cell", bookProvider));
        actions.getAction("Insert_MultiRow").setAfterAction((NotifyListener)new PaTableAfterAction("Insert_MultiRow", bookProvider));
    }

    public static boolean beforeAddRow(Sheet sheet, int size) {
        Point point = PaRptFillHelper.getBasePoint(sheet);
        ItemFormula pointFor = PaRptFillHelper.getBasePointItemFormula(sheet, point);
        if (point == null || pointFor == null) {
            return false;
        }
        int rowIndex = point.y;
        int fillType = Integer.valueOf(pointFor.getExt(POINT_FillType));
        if (fillType == 0) {
            int companySize = Integer.valueOf(pointFor.getExt(POINT_COMPANYSIZE));
            boolean isbetween = PaRptFillHelper.isBetween(sheet, rowIndex, rowIndex + companySize, true);
            if (isbetween) {
                pointFor.putExt(POINT_COMPANYSIZE, companySize + size + "");
            }
        } else {
            int itemSize = Integer.valueOf(pointFor.getExt(POINT_ITEMSIZE));
            boolean isbetween = PaRptFillHelper.isBetween(sheet, rowIndex, rowIndex + itemSize, true);
            if (isbetween) {
                pointFor.putExt(POINT_ITEMSIZE, itemSize + size + "");
            }
        }
        return true;
    }

    private static ItemFormula getBasePointItemFormula(Sheet sheet, Point point) {
        if (point == null) {
            return null;
        }
        Range pointRange = sheet.getRange(point.y, point.x);
        if (pointRange == null) {
            return null;
        }
        return (ItemFormula)pointRange.getUserObject("ITEM");
    }

    private static boolean isBetween(Sheet sheet, int start, int end, boolean isRow) {
        boolean isbetween = false;
        Range selection = sheet.getSelectionRange();
        int point = -1;
        for (int i = 0; i < selection.size(); ++i) {
            CellBlock block = selection.getBlock(i);
            if (block == null) continue;
            int n = point = isRow ? block.getRow() : block.getCol();
            if (point <= start || point > end) continue;
            isbetween = true;
            break;
        }
        return isbetween;
    }

    public static boolean beforeDelRow(Sheet sheet, int size) {
        return true;
    }

    public static boolean beforeAddColumn(Sheet sheet, int size) {
        Point point = PaRptFillHelper.getBasePoint(sheet);
        ItemFormula pointFor = PaRptFillHelper.getBasePointItemFormula(sheet, point);
        if (point == null || pointFor == null) {
            return false;
        }
        int colIndex = point.x;
        int fillType = Integer.valueOf(pointFor.getExt(POINT_FillType));
        if (fillType == 0) {
            int itemSize = Integer.valueOf(pointFor.getExt(POINT_ITEMSIZE));
            boolean isbetween = PaRptFillHelper.isBetween(sheet, colIndex, colIndex + itemSize, false);
            if (isbetween) {
                pointFor.putExt(POINT_ITEMSIZE, itemSize + size + "");
            }
        } else {
            int companySize = Integer.valueOf(pointFor.getExt(POINT_COMPANYSIZE));
            boolean isbetween = PaRptFillHelper.isBetween(sheet, colIndex, colIndex + companySize, false);
            if (isbetween) {
                pointFor.putExt(POINT_COMPANYSIZE, companySize + size + "");
            }
        }
        return true;
    }

    public static boolean beforeDelColumn(Sheet sheet, int size) {
        return false;
    }

    public static boolean allowInsertOrDel(Sheet sheet, Range range) {
        boolean isAllow = true;
        if (sheet == null || range == null) {
            return isAllow;
        }
        Point point = PaRptFillHelper.getBasePoint(sheet);
        ItemFormula pointFor = PaRptFillHelper.getBasePointItemFormula(sheet, point);
        if (point == null || pointFor == null) {
            return isAllow;
        }
        int colIndex = point.x;
        int rowIndex = point.y;
        if (range.getBlock(0).getCol() <= colIndex || range.getBlock(0).getRow() <= rowIndex) {
            isAllow = false;
        }
        return isAllow;
    }

    public static boolean allowShow(Sheet sheet, Range range) {
        boolean isAllowShow = false;
        if (sheet == null || range == null) {
            return isAllowShow;
        }
        ItemFormula formula = (ItemFormula)range.getUserObject("ITEM");
        if (formula != null) {
            return isAllowShow;
        }
        Point point = PaRptFillHelper.getBasePoint(sheet);
        ItemFormula pointFor = PaRptFillHelper.getBasePointItemFormula(sheet, point);
        if (point == null || pointFor == null) {
            return isAllowShow;
        }
        int colIndex = point.x;
        int rowIndex = point.y;
        if (range.getBlock(0).getCol() >= colIndex && range.getBlock(0).getRow() >= rowIndex) {
            int fillType = Integer.valueOf(pointFor.getExt(POINT_FillType));
            int companySize = Integer.valueOf(pointFor.getExt(POINT_COMPANYSIZE));
            if (fillType == 0) {
                if (range.getBlock(0).getCol() == colIndex && range.getBlock(0).getRow() <= rowIndex + companySize) {
                    isAllowShow = true;
                }
            } else if (range.getBlock(0).getRow() == rowIndex && range.getBlock(0).getCol() <= colIndex + companySize) {
                isAllowShow = true;
            }
        }
        return isAllowShow;
    }

    public static void insertCompany(Sheet sheet, Range range, IUIObject uiObject, Set selectedOrgs, boolean isMultiCU, String cuID, List cuIdList, boolean isCUAdmin, List userOrgRangeList, boolean multiSelect) {
        CompanyF7Dialog orgF7 = PaRptFillHelper.getOUUnionF7(uiObject, selectedOrgs, true, "00000000-0000-0000-0000-000000000000CCE7AED4", cuIdList, isCUAdmin, userOrgRangeList, true);
        FullOrgUnitInfo[] fullOrgUnitInfos = null;
        orgF7.show();
        if (!orgF7.isCanceled()) {
            fullOrgUnitInfos = ToolUtils.transFromOrgUnitInfo((OrgUnitInfo[])((OrgUnitInfo[])orgF7.getData()));
            FullOrgUnitInfo orgUnitInfo = fullOrgUnitInfos[0];
            Point point = PaRptFillHelper.getBasePoint(sheet);
            ItemFormula pointFor = PaRptFillHelper.getBasePointItemFormula(sheet, point);
            int showType = Integer.valueOf(pointFor.getExt(POINT_COMPANYSHOWTYPE));
            range.setIgnoreProtected(true);
            String str = showType == 0 ? orgUnitInfo.getName() : orgUnitInfo.getNumber() + orgUnitInfo.getName();
            range.setValue(new Variant((Object)str));
            ItemFormula itemFormula = new ItemFormula();
            itemFormula.putExt(ITEM_COMPANY_ID, orgUnitInfo.getId().toString());
            itemFormula.putExt(ITEM_COMPANY_NUMBER, orgUnitInfo.getNumber());
            itemFormula.putExt(ITEM_COMPANY_SOURCE, RptSrcTypeEnum.COMMITREPORT.getName());
            range.setUserObject("ITEM", (Object)itemFormula);
            range.setIgnoreProtected(false);
        }
    }

    public static CompanyF7Dialog getOUUnionF7(IUIObject _uiObject, Set selectedOrgs, boolean isMultiCU, String cuID, List cuIdList, boolean isCUAdmin, List userOrgRangeList, boolean multiSelect) {
        CompanyF7Dialog orgF7 = new CompanyF7Dialog(_uiObject);
        orgF7.setShowAssistantOrg(true);
        orgF7.setShowSub(true);
        orgF7.setMultiCUs(isMultiCU);
        if (cuIdList != null) {
            orgF7.setCuIdList(cuIdList);
        }
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setMultiSelect(multiSelect);
        orgF7.setIsShowContainSealUp(true);
        if (!StringUtils.isEmpty((String)cuID)) {
            orgF7.setCuID(cuID);
        }
        orgF7.setCheckedOrgIDs(selectedOrgs);
        if (!isCUAdmin) {
            orgF7.useFilter(ToolUtils.trans2Map((Collection)userOrgRangeList));
        }
        return orgF7;
    }
}

