/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client.rptguide;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.pa.PaRptClientUtil;
import com.kingdee.eas.fi.gr.pa.client.rptguide.AbstractParamTabUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class ParamTabUI
extends AbstractParamTabUI {
    private static final long serialVersionUID = -4444730691424547412L;
    private static final Logger logger = CoreUIObject.getLogger(ParamTabUI.class);
    private static final String POINT = "A1";

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtPoint.setText(POINT);
        this.rbRow.setSelected(true);
        this.spnYear.setValue((Object)new Integer(0));
        this.spnPeriod.setValue((Object)new Integer(0));
    }

    public FilterInfo getFilterInfo() {
        if (StringUtils.isEmpty((String)this.txtPoint.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("16_pointNull"));
            SysUtil.abort();
        }
        return this.getViewFilterInfo();
    }

    protected FilterInfo getViewFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo itemInfo1 = new FilterItemInfo("point", (Object)this.txtPoint.getText());
        filterInfo.getFilterItems().add(itemInfo1);
        FilterItemInfo itemInfo2 = new FilterItemInfo("year", this.spnYear.getValue());
        filterInfo.getFilterItems().add(itemInfo2);
        FilterItemInfo itemInfo3 = new FilterItemInfo("period", this.spnPeriod.getValue());
        filterInfo.getFilterItems().add(itemInfo3);
        FilterItemInfo itemInfo4 = new FilterItemInfo("filltype", (Object)(this.rbRow.isSelected() ? "true" : "false"));
        filterInfo.getFilterItems().add(itemInfo4);
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        return filterInfo;
    }

    public void loadData(EntityViewInfo v) {
        super.loadData(v);
        this.clear();
        FilterItemCollection filterItems = v.getFilter() == null ? new FilterItemCollection() : v.getFilter().getFilterItems();
        try {
            for (int i = 0; i < filterItems.size(); ++i) {
                FilterItemInfo item = filterItems.get(i);
                if (item.getPropertyName().equalsIgnoreCase("point")) {
                    String value = item.getCompareValue().toString();
                    this.txtPoint.setText(value);
                }
                if (item.getPropertyName().equalsIgnoreCase("year")) {
                    this.spnYear.setValue(item.getCompareValue());
                }
                if (item.getPropertyName().equalsIgnoreCase("period")) {
                    this.spnPeriod.setValue(item.getCompareValue());
                }
                if (!item.getPropertyName().equalsIgnoreCase("filltype")) continue;
                if ("true".equals(item.getCompareValue())) {
                    this.rbRow.setSelected(true);
                    continue;
                }
                this.rbCol.setSelected(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public void clear() {
        super.clear();
        this.txtPoint.setText(POINT);
        this.rbRow.setSelected(true);
        this.spnYear.setValue((Object)new Integer(0));
        this.spnPeriod.setValue((Object)new Integer(0));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

