/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client.rptguide;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.IReportClass;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassCollection;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.pa.PaRptClientUtil;
import com.kingdee.eas.fi.gr.pa.client.rptguide.AbstractSelectRptItemUI;
import com.kingdee.eas.fi.gr.pa.rptguide.ItemTabCollection;
import com.kingdee.eas.fi.gr.pa.rptguide.ItemTabInfo;
import com.kingdee.eas.fi.rpt.QueryTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class SelectRptItemUI
extends AbstractSelectRptItemUI {
    private static final long serialVersionUID = 3261858659269876048L;
    private static final Logger logger = CoreUIObject.getLogger(SelectRptItemUI.class);
    private Map selectDataElementMap = new HashMap();
    private boolean isCanceled = false;
    private ArrayList rptArr = null;
    private ItemTabCollection data;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPreferredSize(new Dimension(800, 560));
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnReduce.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnReduceAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.remove((Component)this.btnMoveUp);
        this.remove((Component)this.btnMoveDown);
        this.remove((Component)this.btnMoveTop);
        this.remove((Component)this.btnMoveBottom);
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.kDContainer2.addButton((JButton)this.btnMoveUp);
        this.kDContainer2.addButton((JButton)this.btnMoveDown);
        this.kDContainer2.addButton((JButton)this.btnMoveTop);
        this.kDContainer2.addButton((JButton)this.btnMoveBottom);
        this.kDContainer1.setEnableActive(false);
        this.kDContainer2.setEnableActive(false);
        this.kDqueryType.removeAllItems();
        this.kDqueryType.addItem((Object)QueryTypeEnum.NUMBER);
        this.kDqueryType.addItem((Object)QueryTypeEnum.NAME);
        this.kDqueryType.addItem((Object)QueryTypeEnum.NUMBERANDNAME);
        this.kDqueryType.setSelectedItem((Object)QueryTypeEnum.NUMBER);
        this.money.setSelected(true);
        this.initDataElement();
        this.initItemClass();
        this.loadRptItem();
        this.btnQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SelectRptItemUI.this.loadRptItem();
                }
                catch (Exception ex) {
                    SelectRptItemUI.this.handleException(ex);
                }
            }
        });
    }

    private void initDataElement() throws BOSException {
        this.panDataGetType.setLayout((LayoutManager)new BoxLayout((Container)this.panDataGetType, 1));
        this.panDataGetType1.setBorder(BorderFactory.createLineBorder(Color.gray));
        DataElementCollection dataElements = DataElementFactory.getRemoteInstance().getDataElementCollection();
        int n = dataElements.size();
        KDCheckBox chk = null;
        ItemSelectListener selectListener = new ItemSelectListener();
        for (int i = 0; i < n; ++i) {
            DataElementInfo dataElement = dataElements.get(i);
            dataElement.put("sequence", new Integer(i));
            chk = new KDCheckBox(dataElement.getName());
            chk.setUserObject((Object)dataElement);
            chk.addItemListener((ItemListener)selectListener);
            this.panDataGetType.add((Component)chk);
        }
    }

    private void initItemClass() throws Exception {
        IReportClass iReportClass = ReportClassFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        ReportClassCollection cl = iReportClass.getReportClassCollection(viewInfo);
        this.kdcmb_ItemClass.removeAllItems();
        this.kdcmb_ItemClass.addItem((Object)"");
        if (cl != null && cl.size() > 0) {
            int iCount = cl.size();
            for (int i = 0; i < iCount; ++i) {
                this.kdcmb_ItemClass.addItem((Object)((ReportClassInfo)cl.getObject(i)));
            }
        }
    }

    private void loadRptItem() throws BOSException {
        this.getRptArr().clear();
        RPTItemCollection rptItemCL = this.getRptItemCollection();
        CslRptUtil.addCollectionToArrayList(this.getRptArr(), (IObjectCollection)rptItemCL);
        this.addArrayListToTable(this.getRptArr(), this.tblRptItem);
    }

    private void addArrayListToTable(ArrayList rptArr, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        int count = rptArr.size();
        RPTItemInfo rpt = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            rpt = (RPTItemInfo)rptArr.get(i);
            r = table.addRow();
            r.setUserObject((Object)rpt);
            r.getCell(0).setValue((Object)rpt.getNumber());
            r.getCell(1).setValue((Object)rpt.getName());
            r.getCell(2).setValue((Object)rpt.getId());
        }
    }

    private ArrayList getRptArr() {
        if (this.rptArr == null) {
            this.rptArr = new ArrayList();
        }
        return this.rptArr;
    }

    private RPTItemCollection getRptItemCollection() throws BOSException {
        IRPTItem iRptItem = RPTItemFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int index = 0;
        StringBuffer mask = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
        mask.append("#").append(index++);
        ReportClassInfo reportClass = null;
        if (this.kdcmb_ItemClass.getSelectedIndex() > 0) {
            reportClass = (ReportClassInfo)this.kdcmb_ItemClass.getItemAt(this.kdcmb_ItemClass.getSelectedIndex());
        }
        if (reportClass != null) {
            filter.getFilterItems().add(new FilterItemInfo("reportClass.id", (Object)reportClass.getId().toString()));
            mask.append(" and #").append(index++);
        }
        if (!StringUtils.isEmpty((String)this.txtValue.getText())) {
            String txt = this.txtValue.getText();
            boolean isBlured = this.chkBlured.isSelected();
            QueryTypeEnum typeEnum = (QueryTypeEnum)this.kDqueryType.getSelectedItem();
            if (typeEnum.getValue() == 2 || typeEnum.getValue() == 1) {
                String compareExpr = typeEnum.getValue() == 2 ? "name" : "number";
                FilterItemInfo info = !isBlured ? new FilterItemInfo(compareExpr, (Object)txt) : new FilterItemInfo(compareExpr, (Object)("%" + txt + "%"), CompareType.LIKE);
                filter.getFilterItems().add(info);
                mask.append(" and #").append(index++);
            } else if (typeEnum.getValue() == 3) {
                FilterItemInfo number;
                FilterItemInfo name;
                if (!isBlured) {
                    name = new FilterItemInfo("name", (Object)txt);
                    number = new FilterItemInfo("number", (Object)txt);
                } else {
                    name = new FilterItemInfo("name", (Object)("%" + txt + "%"), CompareType.LIKE);
                    number = new FilterItemInfo("number", (Object)("%" + txt + "%"), CompareType.LIKE);
                }
                filter.getFilterItems().add(name);
                filter.getFilterItems().add(number);
                mask.append(" and (#").append(index++).append(" or #").append(index++).append(" )");
            }
        }
        filter.setMaskString(mask.toString());
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        return (RPTItemCollection)iRptItem.getCollectionNoChild(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        this.beforeAdd();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblRptItem);
        if (selectRows != null && selectRows.length > 0) {
            ItemTabCollection coll = this.getSelectColl(selectRows);
            PaRptClientUtil.addArrayValueToTable(this.tblRptItemSelected, coll.toArray());
        }
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        this.beforeAdd();
        ItemTabCollection coll = new ItemTabCollection();
        IRow row = null;
        for (int i = 0; i < this.tblRptItem.getRowCount(); ++i) {
            row = this.tblRptItem.getRow(i);
            this.make(row, coll);
        }
        PaRptClientUtil.addArrayValueToTable(this.tblRptItemSelected, coll.toArray());
    }

    private void beforeAdd() {
        if (!this.money.isSelected() && !this.count.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("24_selectValueType"));
            return;
        }
        if (this.selectDataElementMap.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("25_selectDataElement"));
            return;
        }
    }

    private ItemTabCollection getSelectColl(int[] selectRows) {
        IRow row = null;
        ItemTabCollection coll = new ItemTabCollection();
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblRptItem.getRow(selectRows[i]);
            this.make(row, coll);
        }
        return coll;
    }

    private void make(IRow row, ItemTabCollection coll) {
        ArrayList dataElementList = new ArrayList(this.selectDataElementMap.keySet());
        Collections.sort(dataElementList);
        for (int j = 0; j < dataElementList.size(); ++j) {
            ItemTabInfo info;
            DataElementInfo dataElementInfo = (DataElementInfo)this.selectDataElementMap.get(dataElementList.get(j));
            if (this.money.isSelected()) {
                info = this.createItemTabInfo(row, dataElementInfo, ValueTypeEnum.MONEY);
                coll.add(info);
            }
            if (!this.count.isSelected()) continue;
            info = this.createItemTabInfo(row, dataElementInfo, ValueTypeEnum.QUANTITY);
            coll.add(info);
        }
    }

    private ItemTabInfo createItemTabInfo(IRow row, DataElementInfo dataElementInfo, ValueTypeEnum valueType) {
        ItemTabInfo info = new ItemTabInfo();
        info.setDataElementInfo(dataElementInfo);
        info.setValueType(valueType);
        info.setRPTItemInfo((RPTItemInfo)row.getUserObject());
        return info;
    }

    @Override
    public void actionReduce_actionPerformed(ActionEvent e) throws Exception {
        super.actionReduce_actionPerformed(e);
        PaRptClientUtil.deleteKdTableSelectedRows(this.tblRptItemSelected);
    }

    @Override
    public void actionReduceAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionReduceAll_actionPerformed(e);
        this.tblRptItemSelected.removeRows();
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUp_actionPerformed(e);
        int selectRow = this.tblRptItemSelected.getSelectManager().getActiveRowIndex();
        if (selectRow == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.MoveIsFirstRow"));
            return;
        }
        PaRptClientUtil.moveUp(this.tblRptItemSelected);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        int selectRow = this.tblRptItemSelected.getSelectManager().getActiveRowIndex();
        if (selectRow == this.tblRptItemSelected.getRowCount() - 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.MoveIsLastRow"));
            return;
        }
        PaRptClientUtil.moveDown(this.tblRptItemSelected);
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        PaRptClientUtil.moveTop(this.tblRptItemSelected);
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        PaRptClientUtil.moveBottom(this.tblRptItemSelected);
    }

    @Override
    public void rptItemClassChanged_actionPerformed(ActionEvent e) throws Exception {
        super.rptItemClassChanged_actionPerformed(e);
        this.loadRptItem();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionOk_actionPerformed(e);
        this.isCanceled = false;
        this.data = new ItemTabCollection();
        for (int i = 0; i < this.tblRptItemSelected.getRowCount(); ++i) {
            this.data.add((ItemTabInfo)this.tblRptItemSelected.getRow(i).getUserObject());
        }
        this.getUIWindow().close();
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
        this.destroyWindow();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public ItemTabCollection getData() {
        return this.data;
    }

    protected class ItemSelectListener
    implements ItemListener {
        protected ItemSelectListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            KDCheckBox checkBox = (KDCheckBox)e.getSource();
            DataElementInfo dataElement = (DataElementInfo)checkBox.getUserObject();
            if (checkBox.isSelected()) {
                SelectRptItemUI.this.selectDataElementMap.put(dataElement.get("sequence"), dataElement);
            } else {
                SelectRptItemUI.this.selectDataElementMap.remove(dataElement.get("sequence"));
            }
        }
    }
}

