/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.rptintegration.client.AbstractBaseDataSelectUI;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.GetDatasFromDataCenterSynOperate;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BaseDataSelectUI
extends AbstractBaseDataSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(BaseDataSelectUI.class);
    private String dataCenterId = null;
    private String bosType = null;
    private KDTable mappedTable = null;
    private boolean isCanceled = true;
    private Object result = null;
    private boolean isSubDataCenter = false;
    private boolean isOrgTree = false;
    private String uiTitle = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.dataCenterId = (String)this.getUIContext().get("dataCenterId");
        this.bosType = (String)this.getUIContext().get("bosType");
        this.mappedTable = (KDTable)this.getUIContext().get("mappedTable");
        this.isOrgTree = this.bosType.equals(new OrgTreeInfo().getBOSType().toString());
        this.uiTitle = (String)this.getUIContext().get("uiTitle");
        if (this.getUIContext().containsKey("isSubDataCenter")) {
            this.isSubDataCenter = (Boolean)this.getUIContext().get("isSubDataCenter");
        }
        this.kdtable.getSelectManager().setSelectMode(2);
        this.kdtable.setEditable(false);
        if (this.isOrgTree) {
            this.kdtable.checkParsed();
            this.kdtable.getColumn("startTime").getStyleAttributes().setHided(false);
            this.kdtable.getColumn("endTime").getStyleAttributes().setHided(false);
            this.kdtable.getColumn("longNumber").getStyleAttributes().setHided(true);
        }
        this.kdtable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    BaseDataSelectUI.this.isCanceled = false;
                    int activeRow = BaseDataSelectUI.this.kdtable.getSelectManager().getActiveRowIndex();
                    if (activeRow >= 0) {
                        BaseDataSelectUI.this.result = BaseDataSelectUI.this.kdtable.getRow(activeRow).getUserObject();
                    }
                    BaseDataSelectUI.this.destroyWindow();
                }
            }
        });
        if (this.mappedTable != null) {
            IRow selectRow = this.mappedTable.getRow(this.mappedTable.getSelectManager().getActiveRowIndex());
            Object value = null;
            if (this.isSubDataCenter) {
                value = selectRow.getCell("subName").getValue();
                if (value == null) {
                    value = selectRow.getCell("parentName").getValue();
                }
            } else {
                value = selectRow.getCell("parentName").getValue();
            }
            if (value != null) {
                this.ktfContent.setText(value.toString());
            }
        }
        this.kdtable.checkParsed();
        this.actionQuery_actionPerformed(null);
    }

    public Object getData() {
        return this.result;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.kdtable.removeRows();
            GetDatasFromDataCenterSynOperate sysOperate = (GetDatasFromDataCenterSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.getDatasFromDataCenter);
            List dataList = null;
            CoreBaseCollection coll = null;
            StringBuffer whereStr = new StringBuffer();
            boolean isContextNull = StringUtils.isEmpty((String)this.ktfContent.getText());
            boolean isOrgUnit = this.bosType.equals(new OrgUnitInfo().getBOSType().toString());
            EntityViewInfo view = null;
            if (this.isSubDataCenter) {
                dataList = sysOperate.getDatasFromDataCenter(null, "select top 1 fid from t_org_baseunit", this.dataCenterId, OrgUnitInfo.class.getName());
                if (dataList == null || dataList.isEmpty()) {
                    MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "68_subDataCenterNotSupport"));
                    return;
                }
                if (isOrgUnit) {
                    whereStr.append(" where fisunion=0 ");
                }
                if (!isContextNull) {
                    if (whereStr.length() > 0) {
                        whereStr.append(" and ");
                    } else {
                        whereStr.append(" where ");
                    }
                    whereStr.append(" (fname_l2 like '%").append(this.ktfContent.getText()).append("%' or fnumber like '%").append(this.ktfContent.getText()).append("%') ");
                }
                whereStr.append(" order by fnumber asc ");
            } else {
                FilterInfo filter = null;
                if (!isContextNull) {
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + this.ktfContent.getText() + "%"), CompareType.LIKE));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.ktfContent.getText() + "%"), CompareType.LIKE));
                    filter.setMaskString("#0 or #1");
                }
                if (isOrgUnit) {
                    if (filter == null) {
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("isunion", (Object)0, CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("isunion", (Object)0, CompareType.EQUALS));
                        filter.setMaskString("(" + filter.getMaskString() + ") and #2 ");
                    }
                }
                if (this.isOrgTree) {
                    if (filter == null) {
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("type", (Object)8, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("type", (Object)8, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
                        filter.setMaskString("(" + filter.getMaskString() + ") and #2 and #3 ");
                    }
                }
                view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("number"));
                if (!this.isOrgTree) {
                    view.getSelector().add(new SelectorItemInfo("longNumber"));
                } else {
                    view.getSelector().add(new SelectorItemInfo("startDate"));
                    view.getSelector().add(new SelectorItemInfo("endDate"));
                }
                view.getSelector().add(new SelectorItemInfo("name"));
                if (filter != null) {
                    view.setFilter(filter);
                }
                view.setTopCount(500);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo numberSort = new SorterItemInfo("number");
                numberSort.setSortType(SortType.ASCEND);
                sorter.add(numberSort);
                if (this.isOrgTree) {
                    SorterItemInfo startDate = new SorterItemInfo("startDate");
                    numberSort.setSortType(SortType.DESCEND);
                    sorter.add(startDate);
                }
                view.setSorter(sorter);
            }
            StringBuffer sql = new StringBuffer();
            if (isOrgUnit) {
                if (this.isSubDataCenter) {
                    sql.append("select top 500 fid id,fnumber,flongNumber,fname_l2 fname from t_org_baseunit ").append(whereStr);
                    dataList = sysOperate.getDatasFromDataCenter(null, sql.toString(), this.dataCenterId, OrgUnitInfo.class.getName());
                } else {
                    coll = FullOrgUnitFactory.getRemoteInstance().getCollection(view);
                }
            } else if (this.bosType.equals(new RPTItemInfo().getBOSType().toString())) {
                if (this.isSubDataCenter) {
                    sql.append("select top 500 fid id,fnumber,flongNumber,fname_l2 fname from t_csl_rptitem ").append(whereStr);
                    dataList = sysOperate.getDatasFromDataCenter(null, sql.toString(), this.dataCenterId, RPTItemInfo.class.getName());
                } else {
                    coll = RPTItemFactory.getRemoteInstance().getCollection(view);
                }
            } else if (this.isOrgTree) {
                if (!this.isSubDataCenter) {
                    coll = OrgTreeFactory.getRemoteInstance().getCollection(view);
                }
            } else if (this.bosType.equals(new DataElementInfo().getBOSType().toString()) && view != null) {
                FilterInfo filter = view.getFilter();
                if (filter == null) {
                    filter = new FilterInfo();
                }
                filter.getFilterItems().add(new FilterItemInfo("isSys", (Object)1, CompareType.NOTEQUALS));
                if (!StringUtils.isEmpty((String)filter.getMaskString())) {
                    filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
                }
                view.setFilter(filter);
                coll = DataElementFactory.getRemoteInstance().getCollection(view);
            }
            Iterator iter = null;
            if (this.isSubDataCenter) {
                if (dataList != null) {
                    iter = dataList.iterator();
                }
            } else if (coll != null) {
                iter = coll.iterator();
            }
            if (iter != null) {
                Object rowObj = null;
                while (iter.hasNext()) {
                    rowObj = iter.next();
                    IRow row = this.kdtable.addRow();
                    row.setUserObject(rowObj);
                    row.getCell("id").setValue(((CoreBaseInfo)rowObj).get("id"));
                    row.getCell("number").setValue(((CoreBaseInfo)rowObj).get("number"));
                    row.getCell("name").setValue(((CoreBaseInfo)rowObj).get("name"));
                    if (this.isOrgTree) {
                        row.getCell("startTime").setValue(((CoreBaseInfo)rowObj).get("startDate"));
                        row.getCell("endTime").setValue(((CoreBaseInfo)rowObj).get("endDate"));
                        continue;
                    }
                    row.getCell("longNumber").setValue(((CoreBaseInfo)rowObj).get("longNumber"));
                }
            }
        }
        catch (Exception ex) {
            if (!StringUtils.isEmpty((String)ex.getMessage())) {
                MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
                SysUtil.abort();
            }
            throw ex;
        }
    }

    public String getUITitle() {
        if (!StringUtils.isEmpty((String)this.uiTitle)) {
            return this.uiTitle;
        }
        return super.getUITitle();
    }
}

