/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.rptintegration.BatchSynDatasCollection;
import com.kingdee.eas.fi.gr.rptintegration.BatchSynDatasFactory;
import com.kingdee.eas.fi.gr.rptintegration.BatchSynDatasInfo;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterCollection;
import com.kingdee.eas.fi.gr.rptintegration.client.AbstractBatchSynDataListUI;
import com.kingdee.eas.fi.gr.rptintegration.client.BaseDataSelectUI;
import com.kingdee.eas.fi.gr.rptintegration.client.DataTypeInfo;
import com.kingdee.eas.fi.gr.rptintegration.client.TaskExecutorUI;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.SynBatchTask;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BatchSynDataListUI
extends AbstractBatchSynDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchSynDataListUI.class);
    private Map uicontext = new HashMap();
    private Set<String> alterSet = new HashSet<String>();
    private Set<String> tableDatas = new HashSet<String>();
    private String orgTreeBosType = new OrgTreeInfo().getBOSType().toString();
    private Object selectDataType = null;
    private boolean isFireDataTypeChange = true;

    public void onLoad() throws Exception {
        super.onLoad();
        DataCenterCollection coll = DataCenterUtil.getChildDataCenters(null);
        if (coll == null || coll.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "80_cantBatchSyn"));
            SysUtil.abort();
        }
        this.dataTypeComBox.addItem((Object)new DataTypeInfo(new OrgUnitInfo().getBOSType().toString(), CoreUtils.getResourceStr(null, "70_orgUnit")));
        this.dataTypeComBox.addItem((Object)new DataTypeInfo(new RPTItemInfo().getBOSType().toString(), CoreUtils.getResourceStr(null, "71_rptItem")));
        this.dataTypeComBox.addItem((Object)new DataTypeInfo(new DataElementInfo().getBOSType().toString(), CoreUtils.getResourceStr(null, "72_dataElement")));
        this.dataTypeComBox.addItem((Object)new DataTypeInfo(this.orgTreeBosType, CoreUtils.getResourceStr(null, "73_orgTree")));
        this.tblMain.setEditable(false);
        this.tblMain.checkParsed();
        this.dataTypeComBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && BatchSynDataListUI.this.isFireDataTypeChange) {
                    try {
                        if (BatchSynDataListUI.this.selectDataType != null && !BatchSynDataListUI.this.alterSet.isEmpty() && MsgBox.showConfirm2(null, (String)CoreUtils.getResourceStr(null, "82_dataisalter")) != 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        BatchSynDataListUI.this.isFireDataTypeChange = false;
                                        BatchSynDataListUI.this.dataTypeComBox.setSelectedItem(BatchSynDataListUI.this.selectDataType, true);
                                    }
                                    finally {
                                        BatchSynDataListUI.this.isFireDataTypeChange = true;
                                    }
                                }
                            });
                            return;
                        }
                        BatchSynDataListUI.this.initTblMainData();
                        BatchSynDataListUI.this.selectDataType = BatchSynDataListUI.this.dataTypeComBox.getSelectedItem();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"", (Throwable)ex);
                        ExceptionHandler.handle((Throwable)ex);
                        SysUtil.abort();
                    }
                }
            }
        });
        this.initTblMainData();
        this.selectDataType = this.dataTypeComBox.getSelectedItem();
    }

    public void initTblMainData() throws Exception {
        if (this.dataTypeComBox.getSelectedItem() != null) {
            this.tblMain.removeRows();
            this.tableDatas.clear();
            String number = ((DataTypeInfo)this.dataTypeComBox.getSelectedItem()).getNumber();
            BatchSynDatasCollection coll = BatchSynDatasFactory.getRemoteInstance().getBatchSynDatasCollection("select creator.name,dataId,number,name,createTime where type='" + number + "' order by number ");
            boolean isOrgTree = number.equals(this.orgTreeBosType);
            for (int i = 0; i < coll.size(); ++i) {
                BatchSynDatasInfo obj = coll.get(i);
                IRow row = this.tblMain.addRow();
                row.getCell("dataId").setValue((Object)obj.getDataId());
                row.getCell("number").setValue((Object)obj.getNumber());
                row.getCell("name").setValue((Object)obj.getName());
                row.getCell("createTime").setValue((Object)obj.getCreateTime());
                row.getCell("creataUser").setValue((Object)obj.getCreator().getName());
                this.tableDatas.add(isOrgTree ? obj.getNumber() : obj.getDataId());
            }
            this.alterSet.clear();
        }
    }

    public boolean isOrgTreeType() {
        String number = ((DataTypeInfo)this.dataTypeComBox.getSelectedItem()).getNumber();
        return number.equals(this.orgTreeBosType);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex < 0) {
            activeRowIndex = this.tblMain.getRowCount();
        }
        if (activeRowIndex < 0) {
            activeRowIndex = 0;
        }
        this.addLine(activeRowIndex);
    }

    public void addLine(int rowIndex) throws Exception {
        this.uicontext.put("bosType", ((DataTypeInfo)this.dataTypeComBox.getSelectedItem()).getNumber());
        this.uicontext.put("uiTitle", ((DataTypeInfo)this.dataTypeComBox.getSelectedItem()).getName() + CoreUtils.getResourceStr(null, "74_query"));
        this.uicontext.put("Owner", this);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BaseDataSelectUI.class.getName(), this.uicontext);
        if (ui instanceof UIModelDialog) {
            ((UIModelDialog)ui).setResizable(true);
        }
        ui.show();
        BaseDataSelectUI uiObject = (BaseDataSelectUI)ui.getUIObject();
        if (!uiObject.isCanceled() && uiObject.getData() instanceof CoreBaseInfo) {
            CoreBaseInfo obj = (CoreBaseInfo)uiObject.getData();
            boolean isOrgTreeType = this.isOrgTreeType();
            if (this.tableDatas.contains(isOrgTreeType ? obj.get("number").toString() : obj.get("id").toString())) {
                MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "83_dataExist"));
                return;
            }
            IRow row = null;
            row = rowIndex >= 0 ? this.tblMain.addRow(rowIndex) : this.tblMain.addRow();
            row.getCell("dataId").setValue(obj.get("id"));
            row.getCell("number").setValue(obj.get("number"));
            row.getCell("name").setValue(obj.get("name"));
            this.alterSet.add(obj.get("id").toString());
            this.tableDatas.add(isOrgTreeType ? obj.get("number").toString() : obj.get("id").toString());
        }
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows == null || rows.length <= 0) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            String id = this.tblMain.getRow(rows[i]).getCell("dataId").getValue().toString();
            this.alterSet.add(id);
            String key = this.isOrgTreeType() ? this.tblMain.getRow(rows[i]).getCell("number").getValue().toString() : id;
            this.tblMain.removeRow(rows[i]);
            this.tableDatas.remove(key);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        IRow row = null;
        BatchSynDatasInfo obj = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        String type = ((DataTypeInfo)this.dataTypeComBox.getSelectedItem()).getNumber();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            obj = new BatchSynDatasInfo();
            obj.setDataId(row.getCell("dataId").getValue().toString());
            obj.setNumber(row.getCell("number").getValue().toString());
            obj.setName(row.getCell("name").getValue().toString());
            obj.setType(type);
            colls.add((CoreBaseInfo)obj);
        }
        if (colls.isEmpty()) {
            obj = new BatchSynDatasInfo();
            obj.setType(type);
            colls.add((CoreBaseInfo)obj);
        }
        BatchSynDatasFactory.getRemoteInstance().submitBatchData(colls);
        this.initTblMainData();
        MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "75_saveSuccess"));
    }

    @Override
    public void actionSyn_actionPerformed(ActionEvent e) throws Exception {
        String bosType = ((DataTypeInfo)this.dataTypeComBox.getSelectedItem()).getNumber();
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "76_notSetDate"));
            return;
        }
        IRow row = null;
        Object obj = null;
        ArrayList<String> ids = new ArrayList<String>();
        String type = ((DataTypeInfo)this.dataTypeComBox.getSelectedItem()).getNumber();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            ids.add(row.getCell("dataId").getValue().toString());
        }
        TaskExecutorUI.createTaskUI(this, new SynBatchTask(ids, bosType, (Component)((Object)this))).show();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(-1);
    }

    public boolean destroyWindow() {
        if (!this.alterSet.isEmpty() && MsgBox.showConfirm2((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "81_dataisalter")) != 0) {
            return false;
        }
        return super.destroyWindow();
    }
}

