/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.agent.EipUserCollection;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterCUMapCollection;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterCUMapFactory;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterCollection;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterEipUserMapCollection;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterEipUserMapFactory;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterFactory;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterInfo;
import com.kingdee.eas.fi.gr.rptintegration.WebserviceInfo;
import com.kingdee.eas.fi.gr.rptintegration.client.AbstractDataCenterEditUI;
import com.kingdee.eas.fi.gr.rptintegration.client.CslRptOrgTreeF7;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataCenterEditUI
extends AbstractDataCenterEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DataCenterEditUI.class);
    private Map<String, Object> oldCUMap = new HashMap<String, Object>();
    private Map<String, Object> oldEipUserMap = new HashMap<String, Object>();
    private DataCenterInfo oldDataCenter = null;
    private String preAddress = null;
    private DataCenterInfo curDataCenterInfo = DataCenterUtil.getCurrentDatacenter(null);
    private String loadNumber = null;
    private String loadName = null;

    @Override
    public void actionAddAgent_actionPerformed(ActionEvent e) throws Exception {
        this.agentF7.setDataBySelector();
        Object[] selectDataArray = (Object[])this.agentF7.getData();
        if (selectDataArray != null && selectDataArray.length > 0) {
            EipUserInfo eipUserInfo = null;
            IRow row = null;
            boolean hasData = false;
            for (Object selectObject : selectDataArray) {
                if (selectObject == null) continue;
                if (!hasData) {
                    this.eipUser.removeRows(false);
                    hasData = true;
                }
                eipUserInfo = (EipUserInfo)selectObject;
                row = this.eipUser.addRow();
                row.getCell("id").setValue((Object)eipUserInfo.getId().toString());
                row.getCell("number").setValue((Object)eipUserInfo.getNumber().toString());
                row.getCell("name").setValue((Object)eipUserInfo.getName().toString());
            }
            this.eipUser.repaint();
        }
    }

    @Override
    public void actionDeleteAgent_actionPerformed(ActionEvent e) throws Exception {
        this.removeTableSelection(this.eipUser);
    }

    @Override
    public void actionAddCU_actionPerformed(ActionEvent e) throws Exception {
        HashMap selectLongNumbers = new HashMap();
        for (int i = 0; i < this.cuTable.getRowCount(); ++i) {
            selectLongNumbers.put(this.cuTable.getRow(i).getCell("longNumber").getValue().toString(), null);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"IsMultiSelect", (Object)true);
        uiContext.put((Object)"selectIds", selectLongNumbers);
        String orgTreeF7 = "com.kingdee.eas.fi.gr.rptintegration.client.CslRptOrgTreeF7";
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(orgTreeF7, (Map)uiContext, null, OprtState.EDIT);
        window.show();
        CslRptOrgTreeF7 orgF7 = (CslRptOrgTreeF7)window.getUIObject();
        if (!orgF7.isCanceled) {
            List<FullOrgUnitInfo> orgUnits = orgF7.result;
            this.cuTable.removeRows(false);
            IRow row = null;
            for (FullOrgUnitInfo curOrgUnit : orgUnits) {
                row = this.cuTable.addRow();
                row.getCell("id").setValue((Object)curOrgUnit.getId().toString());
                row.getCell("name").setValue((Object)curOrgUnit.getName().toString());
                row.getCell("number").setValue((Object)curOrgUnit.getNumber());
                row.getCell("longNumber").setValue((Object)curOrgUnit.getLongNumber());
            }
            this.cuTable.repaint();
            orgUnits.clear();
        }
        selectLongNumbers.clear();
        window.close();
    }

    @Override
    public void loadFields() {
        try {
            super.loadFields();
            if (this.editData.getWebservice() != null) {
                if (!StringUtils.isEmpty((String)this.editData.getWebservice().getServerPort())) {
                    this.serverIPAddress.setText(this.editData.getWebservice().getServerIPAddress() + ":" + this.editData.getWebservice().getServerPort());
                }
                if (this.editData.getWebservice().isIsEncrypt() && this.editData.getWebservice().getPassword() != null) {
                    String pwd = CryptoTean.decrypt((String)this.editData.getWebservice().getAccount(), (String)this.editData.getWebservice().getPassword());
                    this.password.setText(pwd);
                }
                this.initDBNumberItems(false);
                if (this.dateCenterNumber.getSelectedObjects().length <= 0 && this.editData.getWebservice().getDateCenterNumber() != null) {
                    this.dateCenterNumber.addItem((Object)this.editData.getWebservice().getDateCenterNumber());
                }
                this.dateCenterNumber.setSelectedItem((Object)this.editData.getWebservice().getDateCenterNumber());
            }
            if (this.editData != null) {
                String longNumber = null;
                int longNumberLeng = -1;
                if (!StringUtils.isEmpty((String)this.editData.getLongNumber())) {
                    longNumber = this.editData.getLongNumber();
                    if (!StringUtils.isEmpty((String)longNumber)) {
                        longNumberLeng = longNumber.lastIndexOf("!");
                    }
                } else if (this.editData.getParent() != null && !StringUtils.isEmpty((String)this.editData.getParent().getLongNumber()) && !StringUtils.isEmpty((String)(longNumber = this.editData.getParent().getLongNumber()))) {
                    longNumberLeng = longNumber.length();
                }
                if (longNumberLeng > 0) {
                    this.txtNumber.setMaxLength(80 - longNumberLeng - 1);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SysUtil.abort((Throwable)ex);
        }
    }

    @Override
    public void actionRemoveCU_actionPerformed(ActionEvent e) throws Exception {
        this.removeTableSelection(this.cuTable);
    }

    protected void removeTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        for (int i = blocks.size() - 1; i >= 0; --i) {
            int bigLine;
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    tbl.removeRow(i);
                }
                break;
            }
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int row = bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow(); row >= smallLine; --row) {
                tbl.removeRow(row);
            }
        }
    }

    public DataCenterEditUI() throws Exception {
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.txtNumber, this.txtName, this.remark, this.serverIPAddress, this.dateCenterNumber, this.account, this.password}));
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        CslRptUIUtil.setWindowIsNotResizable(this.getUIWindow());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DataCenterFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("longNumber"));
        selectors.add(new SelectorItemInfo("parent.*"));
        selectors.add(new SelectorItemInfo("webservice.serverPort"));
        selectors.add(new SelectorItemInfo("webservice.dateCenterNumber"));
        return selectors;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState())) {
            if (this.getUIContext().get("ParentNode") == null) {
                if (this.curDataCenterInfo != null) {
                    MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "selectNode"));
                    SysUtil.abort();
                } else {
                    dataObject.put("isAtCurrentSys", (Object)true);
                }
            } else {
                dataObject.put("parent", this.getUIContext().get("ParentNode"));
            }
        }
        super.setDataObject(dataObject);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.oprtState == OprtState.EDIT || this.oprtState == OprtState.VIEW) {
            this.loadNumber = this.txtNumber.getText().trim();
            this.loadName = this.txtName.getSelectedItem().toString();
        }
        this.btnAddNew.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuEdit.setVisible(false);
        this.addAgent.setEnabled(true);
        this.deleteAgent.setEnabled(true);
        this.menuView.setVisible(false);
        this.menuBiz.setVisible(false);
        this.agentF7.setEnabledMultiSelection(true);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.setEnable(false);
        }
        this.cuTable.checkParsed();
        this.cuTable.getSelectManager().setSelectMode(10);
        this.eipUser.checkParsed();
        this.eipUser.getSelectManager().setSelectMode(10);
        this.initCuList();
        this.initEipUser();
        this.oldDataCenter = this.editData;
        this.initCurListener();
        this.kDTabbedPane1.remove((Component)this.cuContain);
        this.kDTabbedPane1.remove((Component)this.agent);
    }

    private void initCurListener() throws Exception {
        this.serverIPAddress.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataCenterEditUI.this.initDBNumberItems(true);
            }
        });
    }

    public void initDBNumberItems(boolean ignoreException) {
        block8: {
            String address = this.serverIPAddress.getText();
            if (this.getOprtState().equals("VIEW")) {
                return;
            }
            if (!StringUtils.isEmpty((String)address) && !address.equals(this.preAddress)) {
                try {
                    String dbList;
                    block7: {
                        WebServiceInfo serviceInfo = DataCenterUtil.getWebServiceObject(null, this.getWebServiceInfo(), null);
                        WebServiceClient serviceClient = WebServiceClient.getInstance();
                        serviceInfo.setOperationName("invoke");
                        serviceInfo.setArgs(new Object[]{SynchronizeType.getDBList});
                        dbList = null;
                        try {
                            dbList = (String)serviceClient.callMethod(serviceInfo);
                        }
                        catch (Exception ec) {
                            logger.error((Object)"webservice connect error", (Throwable)ec);
                            if (!ignoreException) break block7;
                            MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "ConnectFail"));
                            throw ec;
                        }
                    }
                    JSONArray jsonArray = new JSONArray(dbList);
                    this.dateCenterNumber.removeAllItems();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        this.dateCenterNumber.addItem((Object)jsonArray.getString(i));
                    }
                    this.preAddress = address;
                }
                catch (Exception ex) {
                    logger.error((Object)"getDataCenterNumber error", (Throwable)ex);
                    if (!ignoreException) break block8;
                    SysUtil.abort((Throwable)ex);
                }
            }
        }
    }

    private void initCuList() throws Exception {
        try {
            if (this.editData.getId() != null) {
                this.oldCUMap.clear();
                String dataCenterId = this.editData.getId().toString();
                DataCenterCUMapCollection cuMapColl = DataCenterCUMapFactory.getRemoteInstance().getDataCenterCUMapCollection("select cu.id,cu.name,cu.number,cu.longNumber where dataCenter.id='" + dataCenterId + "'");
                IRow row = null;
                CtrlUnitInfo cuInfo = null;
                for (int i = 0; i < cuMapColl.size(); ++i) {
                    cuInfo = cuMapColl.get(i).getCu();
                    row = this.cuTable.addRow();
                    row.getCell("id").setValue((Object)cuInfo.getId().toString());
                    row.getCell("name").setValue((Object)cuInfo.getName());
                    row.getCell("number").setValue((Object)cuInfo.getNumber());
                    row.getCell("longNumber").setValue((Object)cuInfo.getLongNumber());
                    this.oldCUMap.put(cuInfo.getId().toString(), null);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"initCuList error", (Throwable)ex);
            SysUtil.abort((Throwable)ex);
        }
    }

    private void initEipUser() throws Exception {
        try {
            if (this.editData.getId() != null) {
                this.oldEipUserMap.clear();
                String dataCenterId = this.editData.getId().toString();
                DataCenterEipUserMapCollection colls = DataCenterEipUserMapFactory.getRemoteInstance().getDataCenterEipUserMapCollection("select eipUserId where dataCenterId='" + dataCenterId + "'");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < colls.size(); ++i) {
                    sb.append("'").append(colls.get(i).getEipUserId()).append("',");
                }
                if (sb.lastIndexOf(",") > 0) {
                    sb.deleteCharAt(sb.lastIndexOf(","));
                    EipUserCollection eipUsers = EipUserFactory.getRemoteInstance().getEipUserCollection("select id,number,name where id in(" + sb.toString() + ")");
                    IRow row = null;
                    EipUserInfo info = null;
                    for (int i = 0; i < eipUsers.size(); ++i) {
                        info = eipUsers.get(i);
                        row = this.eipUser.addRow();
                        row.getCell("id").setValue((Object)info.getId().toString());
                        row.getCell("name").setValue((Object)info.getName());
                        row.getCell("number").setValue((Object)info.getNumber());
                        this.oldEipUserMap.put(info.getId().toString(), null);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"initCuList error", (Throwable)ex);
            SysUtil.abort();
        }
    }

    private void setEnable(boolean enabled) {
        this.serverIPAddress.setAccessAuthority(0);
        this.account.setAccessAuthority(0);
        this.dateCenterNumber.setAccessAuthority(0);
        this.serverIPAddress.setEnabled(enabled);
        this.account.setEnabled(enabled);
        this.dateCenterNumber.setEnabled(enabled);
        this.password.setEnabled(enabled);
        this.addCu.setEnabled(enabled);
        this.remvoeCu.setEnabled(enabled);
        this.addAgent.setEnabled(enabled);
        this.deleteAgent.setEnabled(enabled);
        this.remark.setAccessAuthority(0);
        this.remark.setEnabled(enabled);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        String number = this.txtNumber.getText().trim();
        String name = this.txtName.getSelectedItem().toString();
        if (number.length() == 0) {
            MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "NumberNotNull"));
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
        if (name.length() == 0) {
            MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "NameNotNull"));
            this.txtName.requestFocusInWindow();
            SysUtil.abort();
        }
        DataCenterCollection dc = DataCenterFactory.getRemoteInstance().getDataCenterCollection();
        DataCenterInfo info = null;
        if (this.oprtState == OprtState.ADDNEW || this.oprtState == OprtState.COPYADDNEW) {
            for (int i = 0; i < dc.size(); ++i) {
                info = dc.get(i);
                if (number.equals(info.getNumber())) {
                    MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "NumberRepeat"));
                    this.txtNumber.requestFocusInWindow();
                    SysUtil.abort();
                }
                if (!name.equals(info.getName())) continue;
                MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "NameRepeat"));
                this.txtName.requestFocusInWindow();
                SysUtil.abort();
            }
        } else if (this.oprtState == OprtState.EDIT) {
            for (int i = 0; i < dc.size(); ++i) {
                info = dc.get(i);
                if (!this.loadNumber.equals(info.getNumber()) && number.equals(info.getNumber())) {
                    MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "NumberRepeat"));
                    this.txtNumber.requestFocusInWindow();
                    SysUtil.abort();
                }
                if (this.loadName.equals(info.getName()) || !name.equals(info.getName())) continue;
                MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "NameRepeat"));
                this.txtName.requestFocusInWindow();
                SysUtil.abort();
            }
        }
        this.loadNumber = number;
        this.loadName = name;
        this.verifyInputWebService();
    }

    private void verifyInputWebService() {
        if (this.dateCenterNumber.getSelectedItem() == null || StringUtils.isEmpty((String)this.serverIPAddress.getText()) || StringUtils.isEmpty((String)this.account.getText())) {
            MsgBox.showInfo((String)CoreUtils.getResourceStr(null, "IsNotNull"));
            SysUtil.abort();
        }
        String ip = null;
        String port = null;
        String[] address = this.serverIPAddress.getText().split(":");
        if (address.length == 2) {
            ip = address[0];
            port = address[1];
        } else {
            ip = this.serverIPAddress.getText();
        }
        StringBuffer oql = new StringBuffer();
        oql.append("where webservice.serverIPAddress='").append(ip).append("' and webservice.serverPort='");
        oql.append(port).append("' and webservice.dateCenterNumber='").append(this.dateCenterNumber.getSelectedItem().toString());
        oql.append("' and isAtCurrentSys=1 ");
        if (this.editData.getWebservice() != null && this.editData.getWebservice().getId() != null) {
            oql.append(" and webservice.id<> '").append(this.editData.getWebservice().getId()).append("'");
        }
        try {
            if (DataCenterFactory.getRemoteInstance().exists(oql.toString())) {
                MsgBox.showInfo((String)CoreUtils.getResourceStr(null, "91_dataCenterDub"));
                SysUtil.abort();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            SysUtil.abort();
        }
    }

    public IObjectPK runSubmit() throws Exception {
        WebserviceInfo serviceInfo = this.getWebServiceInfo();
        this.editData.setWebservice(serviceInfo);
        ArrayList<String> cuIds = new ArrayList<String>();
        for (int i = 0; i < this.cuTable.getRowCount(); ++i) {
            cuIds.add(this.cuTable.getRow(i).getCell("id").getValue().toString());
        }
        ArrayList<String> eipUserIds = new ArrayList<String>();
        for (int i = 0; i < this.eipUser.getRowCount(); ++i) {
            eipUserIds.add(this.eipUser.getRow(i).getCell("id").getValue().toString());
        }
        IObjectPK pk = DataCenterFactory.getRemoteInstance().save(this.editData, cuIds, eipUserIds);
        String res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK_New");
        MsgBox.showInfo((String)res.substring(3));
        this.disposeUIWindow();
        return pk;
    }

    private WebserviceInfo getWebServiceInfo() throws Exception {
        WebserviceInfo serviceInfo = this.editData.getWebservice();
        String pwd = this.password.getText();
        if (serviceInfo == null) {
            serviceInfo = new WebserviceInfo();
        }
        if (!StringUtils.isEmpty((String)this.account.getText())) {
            pwd = CryptoTean.encrypt((String)this.account.getText(), (String)pwd);
        }
        if (this.dateCenterNumber.getSelectedItem() != null) {
            serviceInfo.setDateCenterNumber(this.dateCenterNumber.getSelectedItem().toString());
        }
        String ip = null;
        String port = null;
        String[] address = this.serverIPAddress.getText().split(":");
        if (address.length == 2) {
            ip = address[0];
            port = address[1];
        } else {
            ip = this.serverIPAddress.getText();
        }
        serviceInfo.setServerIPAddress(ip);
        serviceInfo.setAccount(this.account.getText());
        serviceInfo.setServerPort(port);
        serviceInfo.setPassword(pwd);
        serviceInfo.setIsEncrypt(true);
        return serviceInfo;
    }

    @Override
    public void actionTestConnection_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInputWebService();
        WebServiceInfo serviceInfo = DataCenterUtil.getWebServiceObject(null, this.getWebServiceInfo(), null);
        WebServiceClient serviceClient = WebServiceClient.getInstance();
        if (serviceClient.login(serviceInfo)) {
            MsgBox.showInfo((String)CoreUtils.getResourceStr(null, "ConnectSuccess"));
        } else {
            MsgBox.showInfo((String)CoreUtils.getResourceStr(null, "ConnectFail"));
        }
    }

    public boolean isModify() {
        boolean isChange = false;
        if (this.oldDataCenter != null) {
            if (!CoreUtils.isEquals(this.txtNumber.getText(), this.oldDataCenter.getNumber())) {
                return true;
            }
            if (!CoreUtils.isEquals(this.txtName.getSelectedItemData(), this.oldDataCenter.getName())) {
                return true;
            }
            if (!CoreUtils.isEquals(this.remark.getText(), this.oldDataCenter.getDescription())) {
                return true;
            }
            if (this.oldDataCenter.getWebservice() != null) {
                if (!CoreUtils.isEquals(this.dateCenterNumber.getSelectedItem(), this.oldDataCenter.getWebservice().getDateCenterNumber())) {
                    return true;
                }
                if (!CoreUtils.isEquals(this.account.getText(), this.oldDataCenter.getWebservice().getAccount())) {
                    return true;
                }
                String pwd = this.password.getText();
                if (!StringUtils.isEmpty((String)this.account.getText())) {
                    try {
                        pwd = CryptoTean.encrypt((String)this.account.getText(), (String)pwd);
                    }
                    catch (Exception e) {
                        logger.error((Object)"encrypt error", (Throwable)e);
                    }
                }
                if (!CoreUtils.isEquals(pwd, this.oldDataCenter.getWebservice().getPassword())) {
                    return true;
                }
                String address = this.oldDataCenter.getWebservice().getServerIPAddress();
                if (!StringUtils.isEmpty((String)this.oldDataCenter.getWebservice().getServerPort())) {
                    address = address + ":" + this.oldDataCenter.getWebservice().getServerPort();
                }
                if (!CoreUtils.isEquals(this.serverIPAddress.getText(), address)) {
                    return true;
                }
            } else if (this.dateCenterNumber.getSelectedItem() != null || !StringUtils.isEmpty((String)this.serverIPAddress.getText()) || !StringUtils.isEmpty((String)this.account.getText())) {
                return true;
            }
            if (!this.isCUSame()) {
                return true;
            }
            if (!this.isEipUserSame()) {
                return true;
            }
        }
        return isChange;
    }

    private boolean isCUSame() {
        if (this.cuTable.getRowCount() == this.oldCUMap.size()) {
            for (int i = 0; i < this.cuTable.getRowCount(); ++i) {
                if (this.oldCUMap.containsKey(this.cuTable.getRow(i).getCell("id").getValue().toString())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isEipUserSame() {
        if (this.eipUser.getRowCount() == this.oldEipUserMap.size()) {
            for (int i = 0; i < this.eipUser.getRowCount(); ++i) {
                if (this.oldEipUserMap.containsKey(this.eipUser.getRow(i).getCell("id").getValue().toString())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected IObjectValue createNewData() {
        DataCenterInfo objectValue = new DataCenterInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (!b) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }
}

