/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.rptintegration.TaskClass;
import com.kingdee.eas.fi.gr.rptintegration.TaskManagerFactory;
import com.kingdee.eas.fi.gr.rptintegration.TaskManagerInfo;
import com.kingdee.eas.fi.gr.rptintegration.TaskState;
import com.kingdee.eas.fi.gr.rptintegration.TaskType;
import com.kingdee.eas.fi.gr.rptintegration.client.AbstractTaskChooseUI;
import com.kingdee.eas.fi.gr.rptintegration.client.EDwindowUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class TaskChooseUI
extends AbstractTaskChooseUI {
    private Map<String, KDCheckBox> key_cb = new LinkedHashMap<String, KDCheckBox>();
    private boolean actionEnable = true;
    LanguageInfo languageInfo = new LanguageInfo(SysContext.getSysContext().getLocale());

    public TaskChooseUI() throws Exception {
        this.key_cb.put("orgunit", this.cbOrgUnit);
        this.key_cb.put("orgtree", this.cbOrgTree);
        this.key_cb.put("asstactType", this.cbAsstactType);
        this.key_cb.put("currency", this.cbCurrency);
        this.key_cb.put("dataelement", this.cbDataElement);
        this.key_cb.put("reportclass", this.cbReportClass);
        this.key_cb.put("rptitem", this.cbRPTItem);
        this.key_cb.put("elimType", this.elimType);
        this.key_cb.put("elimtempletgroup", this.cbElimTempletGroup);
        this.key_cb.put("elimtemplet", this.cbElimTemplet);
        this.key_cb.put("adjustmode", this.cbAdjustMode);
        this.key_cb.put("adjusttemplet", this.cbAdjustTemplet);
        this.key_cb.put("rptitemcheckformula", this.cbRPTItemCheckFormula);
        this.key_cb.put("rptitemfenpei", this.cbGoujiGuanxi);
        this.cbDataElement.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TaskChooseUI.this.cbDataElement.getSelected() != 32) {
                    TaskChooseUI.this.cbReportClass.setSelected(false);
                    TaskChooseUI.this.cbRPTItem.setSelected(false);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cbOrgTree_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbOrgTree.getSelected() == 32 && this.cbOrgUnit.getSelected() != 32) {
            this.cbOrgUnit.setSelected(true);
        }
    }

    @Override
    protected void cbOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbOrgUnit.getSelected() == 32) {
            int checked = MsgBox.showConfirm2((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "SynOrgUnitShowMsg"));
            if (checked != 0) {
                this.cbOrgUnit.setSelected(false);
                this.cbOrgTree.setSelected(false);
            }
        } else {
            this.cbOrgTree.setSelected(false);
        }
    }

    @Override
    protected void cbRPTItem_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbRPTItem.getSelected() == 32) {
            this.cbReportClass.setSelected(true);
            this.cbDataElement.setSelected(true);
        }
    }

    @Override
    protected void cbReportClass_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbReportClass.getSelected() == 32) {
            this.cbDataElement.setSelected(true);
        } else if (this.cbRPTItem.getSelected() == 32) {
            this.cbRPTItem.setSelected(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDContainer1.setEnableActive(false);
        this.kDContainer2.setEnableActive(false);
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.taskName.setSelectedLanguage(this.languageInfo);
        this.taskDes.setSelectedLanguage(this.languageInfo);
        Map uiContext = this.getUIContext();
        Object taskKey = uiContext.get("ID");
        if (taskKey != null) {
            this.initSelect((String)taskKey);
            if (OprtState.VIEW.equals(this.getOprtState())) {
                this.setEnable(false);
            }
        } else {
            this.taskDes.setSelectedItemData((Object)CoreUtils.getResourceStr(null, "SynCslRptBaseData"));
        }
    }

    public void setEnable(boolean enable) {
        try {
            this.actionEnable = false;
            Iterator<KDCheckBox> kdCheckBoxIter = this.key_cb.values().iterator();
            while (kdCheckBoxIter.hasNext()) {
                kdCheckBoxIter.next().setEnabled(enable);
            }
            this.checkAllin.setEnabled(enable);
            this.btnOK.setEnabled(enable);
            this.taskName.setEnabled(enable);
            this.taskDes.setEnabled(enable);
        }
        finally {
            this.actionEnable = true;
        }
    }

    public void initSelect(String taskKey) throws Exception {
        Iterator<KDCheckBox> kdCheckBoxIter = this.key_cb.values().iterator();
        while (kdCheckBoxIter.hasNext()) {
            kdCheckBoxIter.next().setSelected(false);
        }
        TaskManagerInfo taskInfo = TaskManagerFactory.getRemoteInstance().getTaskManagerInfo("select name,description,taskContext where id='" + taskKey + "'");
        if (taskInfo != null) {
            if (taskInfo.getTaskContext() != null) {
                String[] items = taskInfo.getTaskContext().split(CoreUtils.splitStr);
                KDCheckBox curKdCheckBox = null;
                for (String item : items) {
                    curKdCheckBox = this.key_cb.get(item);
                    if (curKdCheckBox == null) continue;
                    curKdCheckBox.setSelected(true);
                }
                if (this.key_cb.size() == items.length) {
                    this.checkAllin.setSelected(true);
                } else {
                    this.checkAllin.setSelected(false);
                }
            }
            this.taskName.setSelectedItemData((Object)taskInfo.getName());
            this.taskDes.setSelectedItemData((Object)taskInfo.getDescription());
        }
    }

    public static IUIWindow createTaskUI(CoreUI owner) {
        UIContext ctx = new UIContext((Object)owner);
        return EDwindowUtil.getWindow((Map)ctx, TaskChooseUI.class.getName());
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer sbstring = new StringBuffer();
        Iterator<String> keyIter = this.key_cb.keySet().iterator();
        KDCheckBox curCheckBox = null;
        String curKey = null;
        while (keyIter.hasNext()) {
            curKey = keyIter.next();
            curCheckBox = this.key_cb.get(curKey);
            if (curCheckBox.getSelected() != 32) continue;
            sbstring.append(curKey).append(CoreUtils.splitStr);
        }
        if (this.taskName.getSelectedItemData() == null || StringUtils.isEmpty((String)String.valueOf(this.taskName.getSelectedItemData()))) {
            MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "TaskNameNotNull"));
            return;
        }
        if (sbstring.length() > 0) {
            String taskContext = sbstring.substring(0, sbstring.lastIndexOf(CoreUtils.splitStr));
            boolean isok = this.addTask(taskContext, "customSynTask", "40");
            if (isok) {
                MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "AddTaskSuccess"));
                this.destroyWindow();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "SelectSynInfo"));
        }
    }

    private boolean addTask(String ctxString, String number, String taskClassValue) {
        try {
            TaskManagerInfo taskInfo = new TaskManagerInfo();
            LanguageInfo curLanguageInfo = null;
            TaskChooseUI taskChooseUI = this;
            for (Object obj : taskChooseUI.taskName.getLanguageList()) {
                curLanguageInfo = (LanguageInfo)obj;
                taskInfo.setName(String.valueOf(this.taskName.getItemDataByLang(curLanguageInfo)), curLanguageInfo.getLocale());
            }
            TaskChooseUI taskChooseUI2 = this;
            for (Object obj : taskChooseUI2.taskDes.getLanguageList()) {
                curLanguageInfo = (LanguageInfo)obj;
                taskInfo.setDescription(String.valueOf(this.taskDes.getItemDataByLang(curLanguageInfo)), curLanguageInfo.getLocale());
            }
            taskInfo.setNumber(number);
            taskInfo.setTaskContext(ctxString);
            taskInfo.setTaskState(TaskState.noexec);
            taskInfo.setTaskType(TaskType.personhandle);
            taskInfo.setTaskClass(TaskClass.getEnum(taskClassValue));
            TaskManagerFactory.getRemoteInstance().save((CoreBaseInfo)taskInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected void checkAllin_stateChanged(ChangeEvent e) throws Exception {
        block4: {
            if (!this.actionEnable) break block4;
            Iterator<KDCheckBox> kdCheckBoxIter = this.key_cb.values().iterator();
            if (this.checkAllin.getSelected() == 32) {
                while (kdCheckBoxIter.hasNext()) {
                    kdCheckBoxIter.next().setSelected(true);
                }
            } else {
                while (kdCheckBoxIter.hasNext()) {
                    kdCheckBoxIter.next().setSelected(false);
                }
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

