/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.rptintegration.ErrorCountEnum;
import com.kingdee.eas.fi.gr.rptintegration.client.AbstractTaskExecutorUI;
import com.kingdee.eas.fi.gr.rptintegration.client.EDwindowUtil;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.ITaskManager;
import com.kingdee.eas.fi.gr.rptintegration.util.AlreadyUpException;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TaskExecutorUI
extends AbstractTaskExecutorUI
implements ActionListener {
    private static final Logger logger = CoreUIObject.getLogger(TaskExecutorUI.class);
    public static final String Success = "TaskExecutorUI_Success";
    public static final String Fail = "TaskExecutorUI_Fail";
    public static final String Doing = "TaskExecutorUI_Doing";
    public static final String Waiting = "TaskExecutorUI_Waiting";
    public static final String AlreadyUp = "TaskExecutorUI_AlreadyUp";
    public static final String TaskKey = "TaskExecutorUI_Task";
    protected Timer timer;
    protected int processValue;
    protected Color processColor = new Color(87, 145, 191);
    protected StringBuffer msg = new StringBuffer();
    protected ITaskManager task;
    protected ExecutorService service = Executors.newSingleThreadExecutor();
    protected volatile int errorCount = -1;
    protected volatile boolean isProcessing;

    public static IUIWindow createTaskUI(CoreUI owner, ITaskManager task) {
        UIContext ctx = new UIContext((Object)owner);
        ctx.put((Object)TaskKey, (Object)task);
        return EDwindowUtil.getWindow((Map)ctx, "com.kingdee.eas.fi.gr.rptintegration.client.TaskExecutorUI");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mainTable.checkParsed();
        this.mainTable.setEditable(false);
        this.mainTable.setEnabled(false);
        this.kDTextArea1.setEditable(false);
        this.timer = new Timer(100, this);
        logger.info((Object)" >>>>>>>>>>>>>>>>>>> timer is inited .");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(69, 128), "showMsg");
        this.getActionMap().put("showMsg", (Action)new ItemAction(){
            int clickCount = 1;

            public void actionPerformed(ActionEvent e) {
                ++this.clickCount;
                TaskExecutorUI.this.showMsg(this.clickCount);
            }
        });
        this.mainTable.getColumn("state").setRenderer((IBasicRender)new TaskCellRender());
        this.mainTable.getIndexColumn().getStyleAttributes().setHided(true);
        if (this.getUIContext().get(TaskKey) != null && this.getUIContext().get(TaskKey) instanceof ITaskManager) {
            this.task = (ITaskManager)this.getUIContext().get(TaskKey);
        }
        this.initTaskUI();
        this.mainTable.getColumn("taskItem").setWidth(280);
    }

    protected void initTaskUI() {
        if (this.task != null) {
            this.setTaskTitle(this.task.getTaskName());
            int count = this.task.getTaskStepCount();
            for (int i = 0; i < count; ++i) {
                IRow row = this.mainTable.addRow();
                String subTaskName = this.task.getSubTaskTitle(i);
                row.getCell("taskItem").setValue((Object)subTaskName);
                row.getCell("state").setValue((Object)Waiting);
            }
        }
    }

    protected void showMsg(int clickCount) {
        if (clickCount % 2 == 0) {
            this.resizeWindow(new Rectangle(10, 10, 556, 530));
        } else {
            this.resizeWindow(new Rectangle(10, 10, 556, 410));
        }
    }

    public void setTaskTitle(String title) {
        this.kDContainer1.setTitle(title);
    }

    public void resizeWindow(Rectangle rect) {
        Window window = ComponentUtil.getOwnerWindow((Component)((Object)this));
        Rectangle r = window.getBounds();
        rect.setBounds(r.x, r.y, rect.width, rect.height);
        window.setBounds(rect);
    }

    public void refreshMsg() {
        this.kDTextArea1.setText(this.msg.toString());
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setBounds(new Rectangle(10, 10, 556, 380));
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer = null;
        logger.info((Object)" >>>>>>>>>>>>>>>>>>> timer is closed .");
    }

    protected boolean checkBeforeWindowClosing() {
        boolean boos = super.checkBeforeWindowClosing();
        if (this.isProcessing) {
            MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "TaskRuning"));
            return false;
        }
        if (boos) {
            this.stop();
            this.service.shutdown();
        }
        return boos && !this.isProcessing;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.task == null) {
            MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "NoTask"));
            return;
        }
        final int count = this.task.getTaskStepCount();
        if (count > 0) {
            final int allowErrorCount = ((ErrorCountEnum)((Object)this.kDComboBox1.getSelectedItem())).getValue();
            this.taskBegin();
            final TaskExecutorUI curUI = this;
            int i = 0;
            while (i < count) {
                final int step = i++;
                this.service.submit(new Runnable(){

                    @Override
                    public void run() {
                        IRow row = TaskExecutorUI.this.mainTable.getRow(step);
                        if (TaskExecutorUI.this.errorCount >= allowErrorCount) {
                            row.getCell("state").setValue(null);
                        } else {
                            String subTaskName = TaskExecutorUI.this.task.getSubTaskTitle(step);
                            row.getCell("taskItem").setValue((Object)subTaskName);
                            row.getCell("state").setValue((Object)TaskExecutorUI.Doing);
                            try {
                                TaskExecutorUI.this.processValue = 1;
                                ResultInfo result = TaskExecutorUI.this.task.executeTask(step);
                                boolean isSuccess = true;
                                if (result != null) {
                                    String subTaskTitle = TaskExecutorUI.this.task.getSubTaskTitle(step).trim();
                                    subTaskTitle = subTaskTitle.substring(2, subTaskTitle.length() - 3);
                                    if (result.getStatus() == 0 && !StringUtils.isEmpty((String)result.getMsgInfo())) {
                                        MsgBox.showDetailAndOK((Component)((Object)curUI), (String)("[" + subTaskTitle + "]" + EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"89_partFail")), (String)("[" + subTaskTitle + "] " + result.getMsgInfo()), (int)8188);
                                    }
                                    if (result.getStatus() == 1 && !StringUtils.isEmpty((String)result.getMsgInfo())) {
                                        MsgBox.showDetailAndOK((Component)((Object)curUI), (String)("[" + subTaskTitle + "]" + EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"90_fail")), (String)("[" + subTaskTitle + "] " + result.getMsgInfo()), (int)0);
                                        isSuccess = false;
                                    }
                                }
                                row.getCell("state").setValue((Object)(isSuccess ? TaskExecutorUI.Success : TaskExecutorUI.Fail));
                            }
                            catch (AlreadyUpException ex) {
                                row.getCell("state").setValue((Object)TaskExecutorUI.AlreadyUp);
                            }
                            catch (Exception e1) {
                                logger.error((Object)e1.getMessage(), (Throwable)e1);
                                ++TaskExecutorUI.this.errorCount;
                                row.getCell("state").setValue((Object)TaskExecutorUI.Fail);
                                TaskExecutorUI.this.msg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"Index"), step + 1) + e1.getMessage()).append("\n");
                                TaskExecutorUI.this.refreshMsg();
                            }
                        }
                        if (step == count - 1) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    TaskExecutorUI.this.taskEnd();
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    protected void taskBegin() {
        this.start();
        this.errorCount = -1;
        this.setTaskTitle(this.task.getTaskName());
        this.msg = new StringBuffer();
        this.refreshMsg();
        this.isProcessing = true;
        this.btnOK.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.kDComboBox1.setEnabled(false);
    }

    protected void taskEnd() {
        this.isProcessing = false;
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.kDComboBox1.setEnabled(true);
        if (this.msg.toString().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "taskEnd"));
            this.getUIWindow().close();
        } else {
            MsgBox.showError((Component)((Object)this), (String)CoreUtils.getResourceStr(null, "ErrorMsg"), (String)this.msg.toString());
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.processValue += 2;
        this.mainTable.repaint();
    }

    class TaskCellRender
    implements IBasicRender {
        TaskCellRender() {
        }

        public void draw(Graphics g, Shape s, Object o, Style style) {
            if (o == TaskExecutorUI.Doing) {
                g.setColor(TaskExecutorUI.this.processColor);
                g.fillRect(s.getBounds().x, s.getBounds().y + 4, TaskExecutorUI.this.processValue <= s.getBounds().width ? TaskExecutorUI.this.processValue : s.getBounds().width, s.getBounds().height - 8);
            } else if (o == TaskExecutorUI.Waiting) {
                FontMetrics fontMetrics = g.getFontMetrics();
                int sw = fontMetrics.stringWidth("Waiting......");
                int x = s.getBounds().x + s.getBounds().width / 2 - sw / 2;
                int y = s.getBounds().y + s.getBounds().height / 2;
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(TaskExecutorUI.this.processColor);
                g2.setFont((Font)style.getKDFont());
                g2.drawString("Waiting......", x, y + 3);
                g2.dispose();
            } else if (TaskExecutorUI.Success == o) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(TaskExecutorUI.this.processColor);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int x1 = s.getBounds().x + s.getBounds().width / 2 - 6;
                int y1 = s.getBounds().y + 7;
                int x2 = s.getBounds().x + s.getBounds().width / 2 - 1;
                int y2 = s.getBounds().y + 7 + 7;
                g2.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
                x2 = s.getBounds().x + s.getBounds().width / 2 + 12;
                y2 = s.getBounds().y + 4;
                g2.drawLine(x1, y1, x2, y2);
                g2.dispose();
            } else if (TaskExecutorUI.Fail == o) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(Color.red);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int x1 = s.getBounds().x + s.getBounds().width / 2 - 6;
                int y1 = s.getBounds().y + 2;
                int x2 = s.getBounds().x + s.getBounds().width / 2 + 6;
                int y2 = s.getBounds().y + s.getBounds().height - 4;
                g2.drawLine(x1, y1, x2, y2);
                int temp = y1;
                y1 = y2;
                y2 = temp;
                g2.drawLine(x1, y1, x2, y2);
                g2.dispose();
            } else if (TaskExecutorUI.AlreadyUp == o) {
                int radius = 6;
                int rx = s.getBounds().x + s.getBounds().width / 2 - radius;
                int ry = s.getBounds().y + s.getBounds().height / 2 - radius;
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(TaskExecutorUI.this.processColor);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawOval(rx, ry, radius * 2, radius * 2);
                int x1 = rx;
                int y1 = ry + radius;
                int x2 = x1 + radius * 2;
                int y2 = y1;
                g2.drawLine(x1, y1, x2, y2);
                g2.dispose();
            } else {
                g.setColor(style.getBackground());
                g.fillRect(s.getBounds().x, s.getBounds().y, s.getBounds().width, s.getBounds().height);
            }
            if (TaskExecutorUI.this.processValue >= s.getBounds().width) {
                TaskExecutorUI.this.processValue = 1;
            }
        }
    }
}

