/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client.itask;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.rptintegration.SubmitLogCollection;
import com.kingdee.eas.fi.gr.rptintegration.SubmitLogFactory;
import com.kingdee.eas.fi.gr.rptintegration.client.TaskExecutorUI;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.SynAdjustElimTask;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.SynCslReportTask;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.SynTemplateTask;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CommitAndDispenseUtils {
    private static final Logger logger = Logger.getLogger(CommitAndDispenseUtils.class);

    public static void addDispenseButton(KDToolBar tooBar, ListUI owner) {
        try {
            Object startMultiDataCenterValue = CslRptUtil.getParamValue(null, null, "GR_CSL_StartMultiDataCenterIntegration");
            if (startMultiDataCenterValue != null && startMultiDataCenterValue.toString().toUpperCase(Locale.ENGLISH).equals("TRUE")) {
                KDWorkButton btnPushToSubDataCenter = new KDWorkButton(CoreUtils.getResourceStr(null, "DispToSubDataCenter"));
                final ListUI curOwner = owner;
                btnPushToSubDataCenter.setIcon(EASResource.getIcon((String)"imgTbtn_downbill"));
                btnPushToSubDataCenter.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        try {
                            curOwner.checkSelected();
                            ArrayList idList = curOwner.getAllSelecteIDListValues();
                            CommitAndDispenseUtils.pushTemplateToSubDataCenter_actionPerformed((CoreUI)curOwner, idList);
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex);
                            SysUtil.abort();
                        }
                    }
                });
                tooBar.add((Component)btnPushToSubDataCenter);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                MsgBox.showError((Component)owner, (String)e.getMessage());
            }
            SysUtil.abort();
        }
    }

    public static void addCommitToParentDataCenterButton(KDToolBar tooBar, ListUI owner, HandleType handleType2, boolean isRequestStart) {
        try {
            Object startMultiDataCenterValue = "true";
            if (isRequestStart) {
                startMultiDataCenterValue = CslRptUtil.getParamValue(null, null, "GR_CSL_StartMultiDataCenterIntegration");
            }
            if (startMultiDataCenterValue != null && startMultiDataCenterValue.toString().toUpperCase(Locale.ENGLISH).equals("TRUE")) {
                KDWorkButton btnPushToSubDataCenter = new KDWorkButton(CoreUtils.getResourceStr(null, "CommitToParentDataCenter"));
                final ListUI curOwner = owner;
                final HandleType curHandleType = handleType2;
                btnPushToSubDataCenter.setIcon(EASResource.getIcon((String)"imgIcon_update"));
                btnPushToSubDataCenter.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        try {
                            curOwner.checkSelected();
                            ArrayList idList = curOwner.getAllSelecteIDListValues();
                            if (curHandleType == HandleType.cslRpt || curHandleType == HandleType.report) {
                                CommitAndDispenseUtils.pushCslRptToParentDataCenter_actionPerformed((CoreUI)curOwner, idList, curHandleType == HandleType.cslRpt ? SynchronizeType.cslRptSyn : SynchronizeType.reportSyn);
                                curOwner.actionRefresh_actionPerformed(null);
                            } else if (curHandleType.equals((Object)HandleType.adjust)) {
                                CommitAndDispenseUtils.pushAdjustToParentDataCenter_actionPerformed((CoreUI)curOwner, idList);
                            } else if (curHandleType.equals((Object)HandleType.elim)) {
                                CommitAndDispenseUtils.pushElimToParentDataCenter_actionPerformed((CoreUI)curOwner, idList);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex);
                            if (!StringUtils.isEmpty((String)ex.getMessage())) {
                                MsgBox.showError((Component)curOwner, (String)ex.getMessage());
                            }
                            SysUtil.abort();
                        }
                    }
                });
                tooBar.add((Component)btnPushToSubDataCenter);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showError((Component)owner, (String)e.getMessage());
            SysUtil.abort();
        }
    }

    public static void addCommitToParentDataCenterButton(KDToolBar tooBar, ListUI owner, HandleType handleType2) {
        CommitAndDispenseUtils.addCommitToParentDataCenterButton(tooBar, owner, handleType2, true);
    }

    public static void pushTemplateToSubDataCenter_actionPerformed(CoreUI owner, List<String> idList) throws Exception {
        try {
            ArrayList<TemplateInfo> templateInfoList = new ArrayList<TemplateInfo>();
            TemplateCollection templateCols = TemplateFactory.getRemoteInstance().getTemplateCollection("select id,name,number,auditedstatus,isFreezed where id in(" + CslRptUtil.list2String(idList, ",", true) + ")");
            TemplateInfo info = null;
            boolean existNotAudited = false;
            for (int i = 0; i < templateCols.size(); ++i) {
                info = templateCols.get(i);
                if (AuditedStatusEnum.AUDITED.equals((Object)info.getAuditedStatus()) && !info.isIsFreezed()) {
                    templateInfoList.add(info);
                    continue;
                }
                existNotAudited = true;
            }
            if (existNotAudited) {
                MsgBox.showInfo((Component)owner, (String)CoreUtils.getResourceStr(null, "OnlyDispAuditStatusTmp"));
            }
            if (templateInfoList.size() > 0) {
                TaskExecutorUI.createTaskUI(owner, new SynTemplateTask(templateInfoList)).show();
            }
        }
        catch (Exception ex) {
            if (!StringUtils.isEmpty((String)ex.getMessage())) {
                MsgBox.showError((Component)owner, (String)ex.getMessage());
            }
            SysUtil.abort();
            throw ex;
        }
    }

    public static void pushCslRptToParentDataCenter_actionPerformed(CoreUI owner, List<String> idList, String synType) throws Exception {
        try {
            ArrayList<ReportBaseInfo> InfoList = new ArrayList<ReportBaseInfo>();
            ReportBaseCollection cslRptColl = (SynchronizeType.cslRptSyn.equals(synType) ? CslReportFactory.getRemoteInstance() : ReportFactory.getRemoteInstance()).getReportBaseCollection("select id,name,number,sourceType,committedstatus where id in(" + CslRptUtil.list2String(idList, ",", true) + ")");
            ReportBaseInfo info = null;
            boolean existNotAudited = false;
            for (int i = 0; i < cslRptColl.size(); ++i) {
                info = cslRptColl.get(i);
                if (info.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT) || CommittedStatusEnum.COMMITTED.equals((Object)info.getCommittedStatus()) || CommittedStatusEnum.GROUPCOMMITTED.equals((Object)info.getCommittedStatus())) {
                    InfoList.add(info);
                    continue;
                }
                existNotAudited = true;
            }
            if (existNotAudited) {
                MsgBox.showInfo((Component)owner, (String)CoreUtils.getResourceStr(null, "OnlyCommitSubmitStatus"));
            }
            if (InfoList.size() > 0) {
                TaskExecutorUI.createTaskUI(owner, new SynCslReportTask(InfoList, synType)).show();
            }
        }
        catch (Exception ex) {
            if (!StringUtils.isEmpty((String)ex.getMessage())) {
                MsgBox.showError((Component)owner, (String)ex.getMessage());
            }
            logger.error((Object)"error.", (Throwable)ex);
            SysUtil.abort();
            throw ex;
        }
    }

    public static void pushAdjustToParentDataCenter_actionPerformed(CoreUI owner, List<String> idList) throws Exception {
        try {
            ArrayList<BillBaseInfo> InfoList = new ArrayList<BillBaseInfo>();
            AdjustCollection adjustColl = AdjustFactory.getRemoteInstance().getAdjustCollection("select id,number,checkedStatus where id in(" + CslRptUtil.list2String(idList, ",", true) + ")");
            AdjustInfo info = null;
            boolean existNotAudited = false;
            for (int i = 0; i < adjustColl.size(); ++i) {
                info = adjustColl.get(i);
                if (CheckedStatusEnum.AUDITED.equals((Object)info.getCheckedStatus())) {
                    InfoList.add(info);
                    continue;
                }
                existNotAudited = true;
            }
            if (existNotAudited) {
                MsgBox.showInfo((Component)owner, (String)(CoreUtils.getResourceStr(null, "OnlyCommitAuditStatus") + CoreUtils.getResourceStr(null, "Adjust")));
            }
            if (InfoList.size() > 0) {
                TaskExecutorUI.createTaskUI(owner, new SynAdjustElimTask(InfoList, CoreUtils.getResourceStr(null, "Adjust"), SynchronizeType.adjustSyn)).show();
            }
        }
        catch (Exception ex) {
            if (!StringUtils.isEmpty((String)ex.getMessage())) {
                MsgBox.showError((Component)owner, (String)ex.getMessage());
            }
            SysUtil.abort();
            throw ex;
        }
    }

    public static void pushElimToParentDataCenter_actionPerformed(CoreUI owner, List<String> idList) throws Exception {
        try {
            ArrayList<BillBaseInfo> InfoList = new ArrayList<BillBaseInfo>();
            EliminationCollection adjustColl = EliminationFactory.getRemoteInstance().getEliminationCollection("select id,number,checkedStatus where id in(" + CslRptUtil.list2String(idList, ",", true) + ")");
            EliminationInfo info = null;
            boolean existNotAudited = false;
            for (int i = 0; i < adjustColl.size(); ++i) {
                info = adjustColl.get(i);
                if (CheckedStatusEnum.AUDITED.equals((Object)info.getCheckedStatus())) {
                    InfoList.add(info);
                    continue;
                }
                existNotAudited = true;
            }
            if (existNotAudited) {
                MsgBox.showInfo((Component)owner, (String)(CoreUtils.getResourceStr(null, "OnlyCommitAuditStatus") + CoreUtils.getResourceStr(null, "Elimination")));
            }
            if (InfoList.size() > 0) {
                TaskExecutorUI.createTaskUI(owner, new SynAdjustElimTask(InfoList, CoreUtils.getResourceStr(null, "Elimination"), SynchronizeType.eliminationSyn)).show();
            }
        }
        catch (Exception ex) {
            if (!StringUtils.isEmpty((String)ex.getMessage())) {
                MsgBox.showError((Component)owner, (String)ex.getMessage());
            }
            SysUtil.abort();
            throw ex;
        }
    }

    public static void loadSubmitLog(KDTable tblMain, String fidField, int startRow, int endRow, boolean isCslRpt) {
        try {
            String submitUserKey = "submitUserKey";
            String submitTimeKey = "submitTimeKey";
            String submitStateKey = "submitStateKey";
            if (tblMain.getColumn(submitUserKey) == null) {
                HashMap<String, String> key_name = new HashMap<String, String>();
                key_name.put(submitUserKey, EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"submitUser"));
                key_name.put(submitTimeKey, EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"submitTime"));
                key_name.put(submitStateKey, EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"submitState"));
                IColumn iColumn = null;
                for (String key : key_name.keySet()) {
                    iColumn = tblMain.addColumn();
                    iColumn.setKey(key);
                    if (key.equals(submitTimeKey)) {
                        iColumn.setWidth(125);
                    }
                    tblMain.getHeadRow(0).getCell(iColumn.getColumnIndex()).setValue(key_name.get(key));
                }
                key_name.clear();
            }
            StringBuffer sqlIn = new StringBuffer();
            Object obj = null;
            HashMap<String, Integer> id_index = new HashMap<String, Integer>();
            for (int i = startRow; i <= endRow; ++i) {
                obj = tblMain.getRow(i).getCell(fidField).getValue();
                if (obj == null) continue;
                if (sqlIn.length() > 0) {
                    sqlIn.append(",");
                }
                sqlIn.append("'").append(obj.toString()).append("'");
                id_index.put(obj.toString(), i);
            }
            if (sqlIn.length() > 0) {
                SubmitLogCollection coll;
                HashMap<String, String> cslrpt_rpt = new HashMap<String, String>();
                if (!isCslRpt) {
                    ReportCollection rptCol = ReportFactory.getRemoteInstance().getReportCollection("select id,cslReport.id where id in(" + sqlIn + ") and cslReport.id is not null");
                    sqlIn.setLength(0);
                    for (int i = 0; i < rptCol.size(); ++i) {
                        cslrpt_rpt.put(rptCol.get(i).getCslReport().getId().toString(), rptCol.get(i).getId().toString());
                        if (sqlIn.length() > 0) {
                            sqlIn.append(",");
                        }
                        sqlIn.append("'").append(rptCol.get(i).getCslReport().getId().toString()).append("'");
                    }
                }
                if (sqlIn.length() > 0 && (coll = SubmitLogFactory.getRemoteInstance().getSubmitLogCollection("select lastUpdateUser.name,lastUpdateTime,reportId,submitState where reportId in(" + sqlIn + ")")) != null) {
                    int index = 0;
                    String id = null;
                    String format = CslRptUIUtil.getNationalTimeFormatString();
                    for (int i = 0; i < coll.size(); ++i) {
                        id = !isCslRpt ? (String)cslrpt_rpt.get(coll.get(i).getReportId()) : coll.get(i).getReportId();
                        index = (Integer)id_index.get(id);
                        tblMain.getCell(index, submitUserKey).setValue((Object)coll.get(i).getLastUpdateUser().getName());
                        tblMain.getCell(index, submitStateKey).setValue((Object)coll.get(i).getSubmitState().getAlias());
                        if (format != null) {
                            tblMain.getCell(index, submitTimeKey).setValue((Object)DateTimeUtils.format((Date)coll.get(i).getLastUpdateTime(), (String)format));
                            continue;
                        }
                        tblMain.getCell(index, submitTimeKey).setValue((Object)coll.get(i).getLastUpdateTime());
                    }
                }
                cslrpt_rpt.clear();
            }
            id_index.clear();
        }
        catch (Exception e) {
            logger.error((Object)"loadSubmitLog error", (Throwable)e);
        }
    }

    public static enum HandleType {
        report,
        cslRpt,
        adjust,
        elim;

    }
}

