/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client.itask;

import com.kingdee.eas.fi.gr.rptintegration.DataCenterInfo;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.TaskManager;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.push.TriggerSingleDownLoadPush;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import java.util.List;

public class SynAdjustElimTask
extends TaskManager {
    WebServiceClient webServiceClient;
    WebServiceInfo xbangServiceInfo;
    List<BillBaseInfo> InfoList;
    List<WebServiceInfo> webServiceList;
    DataCenterInfo curDataCenterInfo;
    String synType;
    String title;

    public SynAdjustElimTask(List<BillBaseInfo> billInfoList, String title, String synType) throws Exception {
        this.synType = synType;
        this.title = title;
        this.InfoList = billInfoList;
        this.webServiceList = DataCenterUtil.getParentServiceInfoCollection();
        this.webServiceClient = WebServiceClient.getInstance();
        this.curDataCenterInfo = DataCenterUtil.getCurrentDatacenter(null);
    }

    @Override
    public ResultInfo executeTask(int step) throws Exception {
        if (step == this.getTaskStepCount() - 1) {
            return null;
        }
        int mod = step % (this.InfoList.size() + 1);
        int count = step / (this.InfoList.size() + 1);
        if (mod == 0) {
            this.xbangServiceInfo = this.webServiceList.get(count);
            boolean islogin = this.webServiceClient.login(this.xbangServiceInfo);
            if (!islogin) {
                throw new NullPointerException(CoreUtils.getResourceStr(null, "DataCenter") + "[" + this.xbangServiceInfo.getDataCenterName() + "]" + CoreUtils.getResourceStr(null, "ConnectFail"));
            }
            return null;
        }
        if (mod > 0) {
            --mod;
        }
        BillBaseInfo info = this.InfoList.get(mod);
        String id = info.getId().toString();
        SynchronizeHandle triggerDownLoadObj = SynchronizeType.getSynType2HandleObject().get(SynchronizeType.triggerSingleDownLoadPush);
        this.result = ((TriggerSingleDownLoadPush)triggerDownLoadObj).triggerDownLoadHandle(null, this.synType, id, this.curDataCenterInfo.getId().toString(), this.webServiceClient, this.xbangServiceInfo);
        return this.result;
    }

    @Override
    public String getSubTaskTitle(int step) {
        if (step == this.getTaskStepCount() - 1) {
            return CoreUtils.getResourceStr(null, "taskEnd");
        }
        int mod = step % (this.InfoList.size() + 1);
        int count = step / (this.InfoList.size() + 1);
        if (mod == 0) {
            return CoreUtils.getResourceStr(null, "ConnectDataCenter") + "[" + this.webServiceList.get(count).getDataCenterName() + "]...";
        }
        if (mod > 0) {
            --mod;
        }
        BillBaseInfo curInfo = this.InfoList.get(mod);
        return "    " + CoreUtils.getResourceStr(null, "Commiting") + this.title + "[" + curInfo.getNumber() + "]...";
    }

    @Override
    public String getTaskName() {
        return CoreUtils.getResourceStr(null, "Commit") + this.title;
    }

    @Override
    public int getTaskStepCount() {
        return (this.InfoList.size() + 1) * this.webServiceList.size() + 1;
    }

    @Override
    public String getTaskContextString() {
        return null;
    }

    @Override
    public String getTaskNumber() {
        return this.synType;
    }
}

